// Container Lite (CL v 1.87)
// (C) Copyright John Webster Small 1994
// All rights reserved
// examp205.cpp -- link with cl.obj

// #define CL_NO_TEMPLATES

#include "cl.h"

class Employee  {
	char *name;
	unsigned salary;
	int cmp(const Employee& e) const;
	static	Employee * THIS;
	static	ostream& SHOW(ostream& os)
	{
	   return os << "Employee name: "
	      << setw(20)
	      << (THIS->name? THIS->name : "n/a")
	      << "\tsalary: " << THIS->salary;
	}
public:
	Employee(const char * name = 0,
		unsigned salary = 0)
	{
		this->name = (name? strdup(name) : 0);
		this->salary = salary;
	}
	Employee(const Employee& e)
	{
		name = (e.name? strdup(e.name) : 0);
		salary = e.salary;
	}
	Employee& operator=(const Employee& e)
	{
		delete name;
		name = (e.name? strdup(e.name) : 0);
		salary = e.salary;
		return *this;
	}
	int operator==(const Employee& e) const
		{ return !cmp(e); }
	int operator>(const Employee& e) const
		{ return (cmp(e) > 0); }
	~Employee() { delete name; }
	ostream& (*show())(ostream&)
		{ THIS = this; return SHOW; }
	friend ostream& operator<<
		(ostream& os, Employee& e)
	{ return os << &e.name << endm << e.salary; }
	friend istream& operator>>
		(istream& is, Employee& e)
	{ return is >> &e.name >> nextm >> e.salary; }
};

Employee * Employee::THIS;

int Employee::cmp(const Employee& e) const
{
	if (!name)
		if (!e.name)
			return 0;
		else
			return -1;
	else
		if (!e.name)
			return 1;
		else
		   return strcmp(name,e.name);
}


#include "cl.h"
#if defined(CL_NO_TEMPLATES)
	#define   ITEM      Employee
	#define   CL_WELL_ENDOWED
	#define   CL        CL_Employee
	#include "cl.hf"
#else
	CL_WELL_ENDOWED(Employee)
	#define   CL_Employee       CL<Employee>
#endif

#define EmployeeFile "employs.tmp"

main()
{
	CL_Employee cE(CL_ANDS);
	cE.ins(new Employee("Doe, John",1000));
	Employee E("Small, John",100);
	cE.insQNew(&E);
	cE.push(new Employee("Morgan, Maria",10000));
	cE.save(EmployeeFile);
	cE.allClr();
	cE.load(EmployeeFile);
	cE.sort();
	cout << "\nEmployees in alphabetical order: "
		<< endl;
	while (cE.nextAsg(&E))
		cout << E.show() << endl;
	return 0;
}
