/*
	flc2cl.h -- Container Lite v 1.87:
		FlexList II ANSI C wrapper.

	(C) Copyright 1994  John Webster Small
	All rights reserved
*/

/* LINTLIBRARY */

#ifdef  FLEXLIST_ANSI_C
#error  Include "flc2cl.h" instead of "flexlist.h"
#endif

#ifndef flc2cl_h
#define flc2cl_h

#include <stddef.h>	/*  size_t  */
#include <limits.h>	/*  UINT_MAX  */


/*  FlexNode declarations  */

typedef struct  {
	char data[1];
} FlexNode, * FlexN;

#define FlexN0  ((FlexN)0)

/*  Virtual functions for variant FlexNodes  */
/*  Virtual function tables are never dynamically allocated!  */

typedef struct  {
/*  friend: FlexList  */
	FlexN (*FNnew)(const void *D);
	int   (*FNwrite)(void *ND, const void *D);
	int   (*FNread)(const void *ND, void *D);
	int   (*FNdestruct)(void *ND, void *D);
} FlexNodeVFT, *FlexNVFT;

#define FlexNVFT0 ((FlexNVFT)0)
#define FNnew0 ((FlexN (*)(const void *D)) 0)
#define FNwrite0 ((int (*)(void *ND, const void *D)) 0)
#define FNread0 ((int (*)(const void *ND, void *D)) 0)
#define FNdestruct0 ((int (*)(void *ND, void *D)) 0)

/*  String variant FlexNode functions  */
extern  FlexNodeVFT FlexNodeStrVFT;

/*  FlexList header declaration  */

typedef struct  {
/*  private:  */
	void * L;
	int (*FLDdestruct)(void *LD);
	char data[1];
} FlexList, *FlexL;

#define FlexL0 ((FlexL)0)
#define FLcomparE(compare)  ((int (*)(const void *D1, \
		const void *D2)) compare)
#define FLcompare0  FLcomparE(0)
#define FLDdestruct0 ((int (*)(void *LD)) 0)


/*  FlexList constructors/destructor - static headers  */
extern  FlexL FLfixed(FlexL L, size_t sizeofNodeData);
extern  FlexL FLunpack(FlexL L, size_t sizeofCell, 
		unsigned cells, const void *array);
extern  FlexL FLvariant(FlexL L, FlexNVFT vft);
#define FLstr(L) FLvariant(L,&FlexNodeStrVFT)
extern  int   FLclear(FlexL L);

/*  FlexList constructors/destructor - dynamic headers  */
extern  FlexL FLfixedNew(size_t sizeofNodeData,
		size_t sizeofLocalData, 
		int (*FLDdestruct)(void *LD));
extern  FlexL FLunpackNew(size_t sizeofCell, 
		unsigned cells, const void *array,
		size_t sizeofLocalData,
		int (*FLDdestruct)(void *LD));
extern  FlexL FLvariantNew(FlexNVFT vft,
		size_t sizeofLocalData, 
		int (*FLDdestruct)(void *LD));
#define FLstrNew(sizeofLocalData, FLDdestruct)  \
		FLvariantNew(&FlexNodeStrVFT,  \
			sizeofLocalData,FLDdestruct)
extern  int   FLdelete(FlexL *Lptr);

/*  FlexList header functions  */
extern  void * FLfrontD(FlexL L);
extern  void * FLcurrentD(FlexL L);
extern  void * FLrearD(FlexL L);
extern  unsigned FLcurNum(FlexL L);
extern  unsigned FLnodes(FlexL L);
extern  unsigned FLmaxNodes(FlexL L);
extern  int   FLsetMaxNodes(FlexL L, unsigned maxNodes);
extern  unsigned FLnotFull(FlexL L);
extern  size_t FLsizeofNodeData(FlexL L);
extern  int FLisSorted(FlexL L);
extern  int FLunSort(FlexL L);
extern  int (*FLcompare(FlexL L))
		(const void *D1, const void *D2);
extern  int   FLsetCompare(FlexL L, int (*compare)
		(const void *D1, const void *D2));
#define FLisFixed(L)  FLsizeofNodeData(L)
#define FLisVariant(L) !FLisFixed(L)
#define FLData(L)  (void *)((L)? ((L)->FLDdestruct?  \
		(L)->data : 0) : 0)

/*  FlexList stack and queue functions  */
extern  void *FLpushN(FlexL L, FlexN N);
extern  void *FLpushD(FlexL L, const void *D);
extern  FlexN FLpopN(FlexL L);
extern  int   FLpopD(FlexL L, void *D);
extern  void *FLtopD(FlexL L, void *D);
extern  void *FLinsQN(FlexL L, FlexN N);
extern  void *FLinsQD(FlexL L, const void *D);

/*  FlexList list functions  */
extern  void *FLmkcur(FlexL L, unsigned n);
extern  void *FLinsN(FlexL L, FlexN N);
extern  void *FLinsD(FlexL L, const void *D);
extern  void *FLinsSortN(FlexL L, FlexN N);
extern  void *FLinsSortD(FlexL L, const void *D);
extern  FlexN FLdelN(FlexL L);
extern  int   FLdelD(FlexL L, void *D);
extern  void *FLnextD(FlexL L, void *D);
extern  void *FLprevD(FlexL L, void *D);


/*  FlexList search/sort functions  */
/*  See also FLinsSortN()/FLinsSortD() list functions  */
extern  void *FLfindFirstD(FlexL L, const void *D);
extern  void *FLfindNextD(FlexL L, const void *D);
extern  void *FLfindLastD(FlexL L, const void *D);
extern  void *FLfindPrevD(FlexL L, const void *D);
extern  int   FLsort(FlexL L, int (*compare)
		(const void *D1, const void *D2));

/*  FlexList array functions  */
/*  See also compaction functions */
extern  int   FLstoreD(FlexL L, const void *D, unsigned n);
extern  int   FLrecallD(FlexL L, void *D, unsigned n);

/*  FlexList compaction functions  */
/*  See also FLunpack()/FLunpackNew() constructors  */
extern  void *FLpack(FlexL L);
extern  void **FLpackPtrs(FlexL L);

/*  FlexList implementation constants  */
/*  Change as required by target machine  */
#define FLmaxMaxNodes  ((unsigned) \
	(UINT_MAX/sizeof(void *)))
#define FLmallocAlignLoss  16
#define FLmaxSizeofLocalData \
	((size_t)(UINT_MAX-FLmallocAlignLoss))
#define FLmaxSizeofNodeData  \
	((size_t)(UINT_MAX-FLmallocAlignLoss))
#define FLmaxSizeofArray \
	((long)(size_t)-FLmallocAlignLoss)

#endif
