/*
	flc2cl.cpp -- Container Lite v 1.87:
		FlexList II ANSI C wrapper.

	(C) Copyright 1994  John Webster Small
	All rights reserved
*/

#define CL_NO_TEMPLATES
#include "cl.h"
extern "C" {
#include "flc2cl.h"
};


static FlexN FNnewStr(const void *D)
{
	FlexN N;
	size_t i;

	for (i = 0; ((char *)D)[i++];);
	if ((N = (FlexN) new char[i]) != FlexN0)
		memcpy(N,D,i);
	return N;
}

static int FNwriteStr(void *ND, const void *D)
{
	char *nd, *d;
	
	nd = (char *) ND;
	d = (char *) D;
	while (*nd)
		if ((*nd++ = *d++) == '\0')
			break;
	return 1;
}

static int FNreadStr(const void *ND, void *D)
{
	char *nd, *d;
	
	nd = (char *) ND;
	d = (char *) D;
	while ((*d++ = *nd++) != '\0')
		/* null statement */;
	return 1;
}

static int FNdestructStr(void *, void *)
{ return 1; }

FlexNodeVFT FlexNodeStrVFT = {
	FNnewStr, FNwriteStr, FNreadStr, FNdestructStr };

static char nullD[1];


class fl : public cl {
	unsigned sizeofNodeData;
protected:
	FlexNVFT vft;
	virtual void * assignD
		(void * D, const void * S);
	virtual void * newD(const void * D);
	virtual void   deleteD(void * D);
public:

	fl(size_t sizeofNodeData = 0,
		FlexNVFT vft = FlexNVFT0)
		: cl(CL_ASG|CL_NEW|CL_DEL)
	{
		this->sizeofNodeData = sizeofNodeData;
		this->vft = vft;
	}
	unsigned SizeofNodeData()
		{ return sizeofNodeData; }
	~fl() { destruct(); }
};

#define flvf(vf,params) \
	((vft && vft->vf)? (*(vft->vf))params : 0)

void *  fl::assignD(void * D, const void * S)
{
	if (sizeofNodeData)
		return memcpy(D,S,sizeofNodeData);
	else if (Flags(CL_READ|CL_READ_DEL))  {
		if (flvf(FNread,(S,D)))
			return D;
	}
	else if (flvf(FNwrite,(D,S)))
		return D;
	return 0;
}

void *  fl::newD(const void * D)
{
	if (sizeofNodeData)  {
		void * N = (void *)
			new char[sizeofNodeData];
		if (N) if (D == nullD)
			memset(N,0,sizeofNodeData);
		else
			memcpy(N,D,sizeofNodeData);
		return N;
	}
	else if (D != nullD)
		return (void *) flvf(FNnew,(D));
	return (void *)0;
}

void  fl::deleteD(void * D)
{
	flvf(FNdestruct,(D,0));
	delete D;
}



/*  macros to help readibility  */
#define FL(L_,fnc,params) \
	((fl *)((L_)->L))->fnc params
#define ifFL(L_,fnc,params) \
	((L_ && L_->L)? FL(L_,fnc,params) : 0)
#define ifFLNew(L_,fnc,D) \
	ifFL(L_,fnc ## New,((void *)D?D:nullD))
#define ifFLDelAsg(L_,fnc,D) \
	((L_ && L_->L)? \
		(D? (int) FL(L_,fnc ## DelAsg,(D)) \
		: FL(L_,fnc ## Del,())) \
	: 0)
#define ifFLAsg(L_,fnc,D) \
	((L_ && L_->L)? \
		(D? FL(L_,fnc ## Asg,(D)) \
		: FL(L_,fnc,())) \
	: 0)
#define ifFLvoid(L_,fnc,params) \
	((L_ && L_->L)? FL(L_,fnc,params),1:0)



static int FLDmalloced(void *)
{ return 1; }

static FlexL FLconst(FlexL L,
	size_t sizeofNodeData,
	FlexNVFT vft,
	size_t sizeofLocalData,
	int (*FLDdestruct)(void *LD))
{
	if (sizeofLocalData > FLmaxSizeofLocalData)
		return FlexL0;
	if (!L)   {
		if ((L = (FlexL) new char
			[sizeof(FlexList)+
			sizeofLocalData-1])
			== FlexL0)
			return FlexL0;
		if ((L->L = (void *)
			new fl(sizeofNodeData,vft))
			== (void *)0)  {
			delete L;
			return FlexL0;
		}
		L->FLDdestruct = (FLDdestruct?
			 FLDdestruct : FLDmalloced);
	}
	else  {
		L->FLDdestruct = FLDdestruct0;
		if ((L->L = (void *)
			new fl(sizeofNodeData,vft))
			== (void *)0)
			return FlexL0;
	}
	return L;
}


/*  FlexList constructors/destructor - static headers  */

FlexL FLfixed(FlexL L, size_t sizeofNodeData)
{ return FLconst(L,sizeofNodeData,FlexNVFT0,0,FLDdestruct0); }

static FlexL FLunpack_(FlexL L, size_t sizeofCell,
	unsigned cells, const void *array,
	size_t sizeofLocalData,
	int (*FLDdestruct)(void *LD))
{
	if ((L = FLconst(L,sizeofCell,FlexNVFT0,
		sizeofLocalData,FLDdestruct))
		== FlexL0)
		return FlexL0;
	FL(L,setLimit,(cells));
	if (sizeofCell && cells && array)  {
	   for (unsigned i = 0; i < cells; i++)
              if (!FL(L,insQNew,
	         (&(((char *)array)[i*sizeofCell]))))
	         break;
	   return L;
	}
	return FlexL0;
}

FlexL FLunpack(FlexL L, size_t sizeofCell, 
	unsigned cells, const void *array)
{
	return FLunpack_(L,sizeofCell,cells,array,
		0,FLDdestruct0);
}

FlexL FLvariant(FlexL L, FlexNVFT vft)
{ return FLconst(L,0,vft,0,FLDdestruct0); }

int   FLclear(FlexL L)
{ return (L? FL(L,allDel,()):0); }


/*  FlexList constructors/destructor - dynamic headers  */

FlexL FLfixedNew(size_t sizeofNodeData,
	size_t sizeofLocalData,
	int (*FLDdestruct)(void *LD))
{
	return FLconst(FlexL0,sizeofNodeData,
		FlexNVFT0,sizeofLocalData,FLDdestruct);
}

FlexL FLunpackNew(size_t sizeofCell, 
	unsigned cells, const void *array,
	size_t sizeofLocalData,
	int (*FLDdestruct)(void *LD))
{
	return FLunpack_(FlexL0,sizeofCell,cells,array,
		sizeofLocalData,FLDdestruct);
}

FlexL FLvariantNew(FlexNVFT vft,
		size_t sizeofLocalData, 
		int (*FLDdestruct)(void *LD))
{
	return FLconst(FlexL0,0,vft,
		sizeofLocalData,FLDdestruct);
}

int   FLdelete(FlexL *Lptr)
{
	if (!Lptr) return 0;
	if (!(*Lptr)->FLDdestruct) return 0;
	if (!(*((*Lptr)->FLDdestruct))((*Lptr)->data))
		return 0;
	if ((*Lptr)->L)
		if (!FL(*Lptr,allDel,()))
			return 0;
	delete *Lptr;
	*Lptr = FlexL0;
	return 1;
}


/*  FlexList header functions  */
void * FLfrontD(FlexL L)  { return ifFL(L,top,()); }
void * FLcurrentD(FlexL L)  { return ifFL(L,get,()); }
void * FLrearD(FlexL L)  { return ifFL(L,rear,()); }
unsigned FLcurNum(FlexL L)
{
	if (L && L->L)
		if (FL(L,CurNode,()) < ifFL(L,Nodes,()))
			return FL(L,CurNode,())+1;
	return 0;
}
unsigned FLnodes(FlexL L)  { return ifFL(L,Nodes,()); }
unsigned FLmaxNodes(FlexL L)  { return ifFL(L,MaxNodes,()); }
int   FLsetMaxNodes(FlexL L, unsigned maxNodes)
  { return ifFL(L,setMaxNodes,(maxNodes)); }
unsigned FLnotFull(FlexL L)  { return ifFL(L,vacancy,()); }
size_t FLsizeofNodeData(FlexL L)
  { return ifFL(L,SizeofNodeData,()); }
int FLisSorted(FlexL L)
  { return (int) ifFL(L,Sorted,()); }
int FLunSort(FlexL L)
  { return ifFLvoid(L,unSort,()); }
int (*FLcompare(FlexL L))
  (const void *D1, const void *D2)
  { return ifFL(L,CmP,()); }
int   FLsetCompare(FlexL L, int (*compare)
  (const void *D1, const void *D2))
  { return ifFLvoid(L,setCmP,(compare)); }

/*  FlexList stack and queue functions  */
void *FLpushN(FlexL L, FlexN N)
  { return ifFL(L,push,(N)); }
void *FLpushD(FlexL L, const void *D)
  { return ifFLNew(L,push,D); }
FlexN FLpopN(FlexL L)
  { return (FlexN) ifFL(L,pop,()); }
int   FLpopD(FlexL L, void *D)
  { return ifFLDelAsg(L,pop,D); }
void *FLtopD(FlexL L, void *D)
  { return ifFLAsg(L,top,D); }
void *FLinsQN(FlexL L, FlexN N)
  { return ifFL(L,insQ,(N)); }
void *FLinsQD(FlexL L, const void *D)
  { return ifFLNew(L,insQ,D); }

/*  FlexList list functions  */
void *FLmkcur(FlexL L, unsigned n)
  { ifFL(L,setCurNode,(n?n-1:CL_MAXNODES));
  return ifFL(L,get,());}
void *FLinsN(FlexL L, FlexN N)
  { return ifFL(L,ins,(N)); }
void *FLinsD(FlexL L, const void *D)
  { return ifFLNew(L,ins,D); }
void *FLinsSortN(FlexL L, FlexN N)
  { return ifFL(L,insSort,(N)); }
void *FLinsSortD(FlexL L, const void *D)
  { return ifFLNew(L,insSort,D); }
FlexN FLdelN(FlexL L)
  { return (FlexN) ifFL(L,rmv,()); }
int   FLdelD(FlexL L, void *D)
{
	return ((L && L->L)?
		(D? (int) FL(L,delAsg,(D))
		: FL(L,del,()))
	: 0);
}
void *FLnextD(FlexL L, void *D)
  { return ifFLAsg(L,next,D); }
void *FLprevD(FlexL L, void *D)
  { return ifFLAsg(L,prev,D); }

/*  FlexList search/sort functions  */
/*  See also FLinsSortN()/FLinsSortD() list functions  */
void *FLfindFirstD(FlexL L, const void *D)
  { return ifFL(L,findFirst,(D)); }
void *FLfindNextD(FlexL L, const void *D)
  { return ifFL(L,findNext,(D)); }
void *FLfindLastD(FlexL L, const void *D)
  { return ifFL(L,findLast,(D)); }
void *FLfindPrevD(FlexL L, const void *D)
  { return ifFL(L,findPrev,(D)); }
int   FLsort(FlexL L, int (*compare)
		(const void *D1, const void *D2))
  { return ifFL(L,sort,(compare)); }

/*  FlexList array functions  */
/*  See also compaction functions */
int   FLstoreD(FlexL L, const void *D, unsigned n)
{
	if (!L || !L->L) return 0;
	if (n) FL(L,setCurNode,(n-1));
	return (int) FL(L,putAsg,(D));

}

int   FLrecallD(FlexL L, void *D, unsigned n)
{
	if (!L || !L->L) return 0;
	if (n) FL(L,setCurNode,(n-1));
	return (int) FL(L,getAsg,(D));
}

/*  FlexList compaction functions  */
/*  See also FLunpack()/FLunpackNew() constructors  */
void *FLpack(FlexL L)
{
	long sizeofArray, sizeofNodeData;
	char *A, *Ai;
	unsigned i, nodes;

	if (!L || !L->L) return (void *)0;
	sizeofNodeData = (long)FL(L,SizeofNodeData,());
	nodes = FL(L,Nodes,());
	sizeofArray = sizeofNodeData
		* ((long)nodes);
	if ((sizeofArray <= 0) || 
		(sizeofArray > FLmaxSizeofArray))
		return (void *) 0;
	if ((A = new char [(unsigned) sizeofArray]) 
		== (char *) 0)
		return (void *) 0;
	for (Ai = A, i = 0; i < nodes ; i++,
		Ai += sizeofNodeData)
		memcpy(Ai,FL(L,atGet,(i)),sizeofNodeData);
	return A;

}
void **FLpackPtrs(FlexL L)
  { return ifFL(L,vector,()); }
