/*

	pcframe.cpp
	7-30-91
	Text mode framing for the IBM PC.

	Copyright 1991
	John W. Small
	All right reserved
	Use freely but acknowledge authorship and copyright.

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA
	
	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/


#include <conio.h>
#include "pcframe.hpp"

unsigned char TextFraming::frame[] =
	"\263\304\332\302\277\264\331\301\300\303\305"
	"\272\315\311\313\273\271\274\312\310\314\316"
	"\263\315\325\321\270\265\276\317\324\306\330"
	"\272\304\326\322\267\266\275\320\323\307\327";

int TextFraming::buf[MAX_TF_BUF];
struct text_info TextFraming::ti;

TextFraming PCF;

int TextFraming::puttext(int l, int t, int r, int b,
	void *buf)
{
	if (validDimensions(l,t,r,b))
		return ::puttext(l,t,r,b,buf);
	return 0;
}

int TextFraming::validDimensions(int left, int top,
	int right, int bottom)
{
	if (left < 1 || left > right
		|| right > ti.screenwidth ||
		top < 1 || top > bottom
		|| bottom > ti.screenheight)
		return 0;
	return 1;
}

int TextFraming::validateDimensions(int& left, int& top,
	int& right, int& bottom, unsigned minWidth,
	unsigned minHeight)
{
	int l, t, r, b, tmp;

	if (minWidth < 1 || minWidth > ti.screenwidth
		|| minHeight < 1
		|| minHeight > ti.screenheight)
		return 0;
	l = left;
	if (l < 1)
		l = 1;
	else if (l > ti.screenwidth)
		l = ti.screenwidth;
	r = right;
	if (r < 1)
		r = 1;
	else if (r > ti.screenwidth)
		r = ti.screenwidth;
	if (l > r)  {
		tmp = l;
		l = r;
		r = tmp;
	}
	if ((tmp = l + minWidth - 1) > r)
		if (tmp > ti.screenwidth)
			r = ti.screenwidth;
		else
			r = tmp;
	if ((tmp = r - minWidth + 1) < l)
		if (tmp < 1)
			return 0;
		else
			l = tmp;
	t = top;
	if (t < 1)
		t = 1;
	else if (t > ti.screenheight)
		t = ti.screenheight;
	b = bottom;
	if (b < 1)
		b = 1;
	else if (b > ti.screenheight)
		b = ti.screenheight;
	if (t > b)  {
		tmp = t;
		t = b;
		b = tmp;
	}
	if ((tmp = t + minHeight - 1) > b)
		if (tmp > ti.screenheight)
			b = ti.screenheight;
		else
			b = tmp;
	if ((tmp = b - minHeight + 1) < t)
		if (tmp < 1)
			return 0;
		else
			t = tmp;
	left = l; top = t; right = r; bottom = b;
	return 1;
}


void TextFraming::vline(int x, int top, int bottom, int attr,
	enum LSTYLE ls)
{
	int i, len;

	attr <<= 8;
	attr |= lnChar(ls,VERTICAL);
	if ((len = (bottom - top + 1)) > MAX_TF_BUF)
		len = MAX_TF_BUF;
	for (i = 0; i < len; i++)
		buf[i] = attr;
	puttext(x,top,x,bottom,buf);
}

void TextFraming::hline(int y, int left, int right, int attr,
	enum LSTYLE ls)
{
	int i, len;

	attr <<= 8;
	attr |= lnChar(ls,HORIZONAL);
	if ((len = (right - left + 1)) > MAX_TF_BUF)
		len = MAX_TF_BUF;
	for (i = 0; i < len; i++)
		buf[i] = attr;
	puttext(left,y,right,y,buf);
}

void TextFraming::box(int left, int top, int right,
	int bottom, int attr, enum BSTYLE bs)
{
	enum LSTYLE ls = (enum LSTYLE) (bs % LSTYLES);
	vline(left,top,bottom,attr,ls);
	vline(right,top,bottom,attr,ls);
	ls = ((bs % 3)? DOUBLE : SINGLE);
	hline(top,left,right,attr,ls);
	hline(bottom,left,right,attr,ls);
	attr <<= 8;
	buf[0] = attr | bxChar(bs,UPPER_LEFT);
	puttext(left,top,left,top,buf);
	buf[0] = attr | bxChar(bs,UPPER_RIGHT);
	puttext(right,top,right,top,buf);
	buf[0] = attr | bxChar(bs,LOWER_RIGHT);
	puttext(right,bottom,right,bottom,buf);
	buf[0] = attr | bxChar(bs,LOWER_LEFT);
	puttext(left,bottom,left,bottom,buf);
}
