/*

	eb.cpp
	8-11-91
	Electronic Book


	Copyright 1991
	John W. Small
	All rights reserved

	Licensed users of FlexList may use and modify this
	tool for use in their programs.


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233


	Notes:  The Electronic Book was coded to demonstrate
	the various uses of FlexList.


*/

#include <conio.h>
#include "eb4.hpp"
#include "cmdln.hpp"
#include "pckey.hpp"


int origmode;
int origattr;

void EBfrontCover()
{
	struct text_info ti;

	gettextinfo(&ti);
	origmode = ti.currmode;
	origattr = ti.normattr;
}

void EBbackCover()
{
	struct text_info ti;

	gettextinfo(&ti);
	if (origmode != ti.currmode)  {
		textmode(C80);
		textattr(LIGHTGRAY+BLACK*16);
		clrscr();
	}
	else
		textattr(origattr);

cout

<< "\n\nCopyright 1991, John W. Small, All rights reserved"
<< "\nPSW / Power SoftWare,  P.O. Box 10072"
<< "\nMcLean, Virginia 22102 8072 USA"
<< "\n"
<< "\nEB.EXE is freeware, meaning that there is no fee for using"
<< "\nEB.EXE or redistributing it at a nominal cost reflecting your"
<< "\nreasonable distribution costs.  You are unauthorized to make"
<< "\nany changes to this program!  This program was written using"
<< "\nFlexList II for C++.\n";

}


main(int argc, char *argv[])
{
	CmdLn CL(argc,argv,"mMt:T:");
	char * fname = (char *) 0;
	char * topic = (char *) 0;
	int ok = 1;

	do  {
		while (CL.getOption() != -1 && ok)
			switch (CL.optCh)  {
			case '?':
				ok = 0;
				break;
			case 'm':
			case 'M':
				forcedmonochrome = 1;
				break;
			case 't':
			case 'T':
				topic = CL.optArg;
				break;
			}
		if (CL.Argi() < argc)
			fname =  argv[CL.Argi()];
		CL.lookForMoreOptions();
	} while (CL.Argi() < argc && ok);

	if (ok)  {
		HyperView EB;
		EBfrontCover();
		EB.viewFullScreen(fname,topic);
		EBbackCover();
	}
	else

cout
<< "\n\nusage: eb [-m] [[-ttopic] filename]"
<< "\n\n\t[-m]\t\t\toptionally force monochrome display"
<< "\n\t[[-ttopic] filename]\toptionally load hypertext file and topic"
<< "\n\n";


	PCK.fastTypeMaticOnExit();
	return 0;
}