/*
	inssort.cpp -- Container Lite v 1.87
	(C) Copyright 1994  John Webster Small
	All rights reserved
*/

#include "cl.h"

void * cl::insSort(void * D)
{
	unsigned low, mid, high;
	void * ok;

/*
	The current node is left undefined if
	anything fails, otherwise it is set to the
	newly inserted node.
*/

	curNode = nodes;
	if (!cmP) if ((cmP = cmPD(voidCmP0))
		== voidCmP0) return (void *)0;
	if (!D || nodes >= maxNodes)
		return (void *)0;
	if (!linkS)
	CL_TRY_NEW
		linkS = new void *[limit];
	CL_CATCH_XALLOC(linkS)
		if (!linkS)
			return (void *)0;
	if (!(flags & CL_SORTED))
		if (!sort())
			return (void *)0;
	low = 0U;
	high = nodes;
	while (low < high)  {
		mid = ((high + low) >> 1);
		if ((*cmP)(D,
			linkS[(first+mid)%limit]) <= 0)
			high = mid;
		else
			low = mid + 1;
	}
	if ((ok = atIns(high,D)) != (void *)0)
		curNode = high;
	/*  atIns() resets sorted to zero  */
	flags |= CL_SORTED;
	return ok;
}
