/*
	cl1.cpp -- Container Lite v 1.87
	(C) Copyright 1994  John Webster Small
	All rights reserved
*/

#include "cl.h"

void cl::init(unsigned flags, unsigned maxNodes,
	unsigned limit, unsigned delta)
{
	curNode = first = nodes = 0U;
	cmP = voidCmP0;

/*
	The following relationships are maintained
	during operation of a cl:

	1 <= delta <= lowLimit <= limit <= maxNodes
		<= CL_MAXNODES
	lowThreshold = lowLimit - delta;
*/

	if (maxNodes > CL_MAXNODES)
		maxNodes = CL_MAXNODES;
	if (limit > maxNodes)
		limit = maxNodes;
	if (delta > limit)
		delta = limit;
	if (!delta)  {
		delta = 1;
		if (limit < delta)
			limit = delta;
		if (maxNodes < limit)
			maxNodes = limit;
	}
	linkS = (void **)0;
	this->limit = limit;
	this->delta = delta;
	this->maxNodes = maxNodes;
	lowLimit = limit;
	lowThreshold = lowLimit - delta;
	this->flags = (flags | CL_SORTED);
}

void cl::destruct()
{
	if (flags & CL_DEL)
		allDel();
	else
		allRmv();
}

void * cl::atIns(unsigned n, void * D)
{
    void ** newLinkS;
    unsigned newLimit, i;

    if (!D)
        return (void *)0;
    if (nodes == limit)  { // no vacancy - expand
        if (limit == maxNodes)
            return (void *)0;
        newLimit = (maxNodes - delta > limit)?
            limit + delta : maxNodes;
    CL_TRY_NEW
	newLinkS = new void *[newLimit];
    CL_CATCH_XALLOC(newLinkS)
	if (!newLinkS)  // expansion unavailable
		return (void *)0;
        if (!attachD(D))  {// data refuses binding
            delete newLinkS;
            return (void *)0;
        }
        newLinkS[((n <= nodes)? n : (n = nodes))] = D;
        // calc headNodes
        if (n <= (i = limit - first))  {
            // insert in head section
            if (n)  {// postfix or split head
                memcpy(newLinkS,&linkS[first],
                    sizeof(linkS[0U])*n);
                if (n < i) // it's a split
                    memcpy(&newLinkS[n+1],
                        &linkS[first+n],
                        sizeof(linkS[0U])*(i-n));
            }
            else    // prefix head
                memcpy(&newLinkS[1],&linkS[first],
                    sizeof(linkS[0U])*i);
            if (i < nodes)  // copy tail
                memcpy(&newLinkS[1+i],linkS,
                    sizeof(linkS[0U])
                    *(nodes-i));
        }
        else  {    // insert in tail section
            // copy head first
            memcpy(newLinkS,&linkS[first],
                sizeof(linkS[0U])*i);
            if (i < nodes)  { // copy tail
                memcpy(&newLinkS[i],linkS,
                    sizeof(linkS[0U])*(n-i));
                if (n < nodes) // it's a tail split
                    memcpy(&newLinkS[n+1],
                        &linkS[n-i],
                        sizeof(linkS[0U])
                        *(nodes-n));
            }
        }
        // Compute next smaller linkS size
        // and threshold for shrinking.
        lowLimit = limit;
        lowThreshold = lowLimit - delta;
        // swap new for old
        delete linkS;
        linkS = newLinkS;
        limit = newLimit;
        first = 0U;
    }
    else  {  // vacancy
        if (!linkS)
	CL_TRY_NEW
	    linkS = new void *[limit];
	CL_CATCH_XALLOC(linkS)
	    if (!linkS)
		return (void *)0;
        if (!attachD(D))  {
            if (!nodes)  {
                delete linkS;
                linkS = (void **)0;
            }
            return (void *)0;
        }
        if (!n)  // push
            linkS[first? --first
                : (first = limit - 1)] = D;
        else if (n >= nodes) // insQ
            linkS[(first+(n=nodes))%limit] = D;
        else  { // insert interior
            i = (first + n) % limit;
            if (i < first || !first)
                // move rear rightward
                memmove(&linkS[i+1],&linkS[i],
                    sizeof(linkS[0U])
                    * (nodes-n));
            else  { // move front leftward
                memmove(&linkS[first-1],
                    &linkS[first],
                    sizeof(linkS[0U])
                    *(n));
                first--;
                i--;
            }
            linkS[i] = D;
        }
    }
    nodes++;
    if (n <= curNode)
        curNode++;
    flags &= ~CL_SORTED;
    return D;
}

void * cl::atRmv(unsigned n)
{
    void ** newLinkS = (void **)0;
    unsigned newLimit, i;
    void * D;

    if (!linkS || n >= nodes)
        return (void *)0;
    D = linkS[(((i=first+n) >=limit)? (i-=limit):i)];
    if (nodes <= lowThreshold) {
        // get ready to contract
        newLimit = lowLimit;
    CL_TRY_NEW
        newLinkS = new void *[newLimit];
    CL_CATCH_XALLOC(newLinkS)
        // Compute next smaller linkS
        // size and threshold for
        // shrinking.
	if (nodes < delta)
            lowThreshold = 0;
        else
            lowThreshold -= delta;
        lowLimit = lowThreshold + delta;
    }
    if (newLinkS)  {  // remove and contract
        // calc head nodes
	if ((i = limit - first) > nodes)
		i = nodes;
        if (n < i)  {
            // rmv from head section
            if (n)  { // rmv from head
                memcpy(newLinkS,&linkS[first],
                    sizeof(linkS[0U])*n);
		if (n < i - 1)
	                memcpy(&newLinkS[n],
        	                &linkS[first+n+1],
                	        sizeof(linkS[0U])*(i-n-1));
            }
            else    // pop head
                memcpy(newLinkS,&linkS[first+1],
                    sizeof(linkS[0U])*(i-1));
            if (i < nodes)  // copy tail
                memcpy(&newLinkS[i-1],linkS,
                    sizeof(linkS[0U])
                    *(nodes-i));
        }
        else  { // i <= n < nodes
            // rmv from tail section
            // copy head first
            memcpy(newLinkS,&linkS[first],
                sizeof(linkS[0U])*i);
            if (i == n)  { // pop tail
                if (n < nodes - 1)
                    // copy trailing tail
                    memcpy(&newLinkS[i],&linkS[1],
                        sizeof(linkS[0U])*(nodes-n-1));
            }
            else  {  // copy up to n in tail
                memcpy(&newLinkS[i],linkS,
                    sizeof(linkS[0U])*(n-i));
                // skip n'th node
                if (n < nodes - 1)
                    // copy anything trailing n'th node
                    memcpy(&newLinkS[n],linkS[n-i+1],
                        sizeof(linkS[0U])*(nodes-n-1));
            }
        }
        // swap new for old
        delete linkS;
        linkS = newLinkS;
        limit = newLimit;
        first = 0U;
    }
    else  { // simply remove
        if (!n)  {  // pop
            if (++first >= limit)
                first = 0U;
        }
        else if (n != nodes-1)  // del interior
            if (i < first) // move tail leftward
                memmove(&linkS[i],&linkS[i+1],
                    sizeof(linkS[0U])
                    *(nodes-n-1));
            else {  // move head rightward
                memmove(&linkS[first+1],
                    &linkS[first],
                    sizeof(linkS[0U])*n);
                first++;
            }
    }
    if (n < curNode)
        curNode--;
    else if (n == curNode)
        curNode = nodes-1;
    if (--nodes == 0U)  {
        flags |= CL_SORTED;
        delete linkS;
        linkS = (void **)0;
    }
    detachD(D);
    return D;
}

void cl::allRmv()
{
	flags &= ~CL_NEWED;
	while (atRmv(0U)) /* null stmt */ ;
}

int  cl::atDel(unsigned n)
{
	void * D;

	if (flags & CL_DEL)
		if ((D = atRmv(n)) != (void *)0)  {
			deleteD(D);
			return 1;
		}
	return 0;
}

int cl::allDel()
{
	void * D;

	flags &= ~CL_NEWED;
	if (flags & CL_DEL)  {
		while ((D = atRmv(0U)) != (void *)0)
			deleteD(D);
		return 1;
	}
	return 0;
}
