// Container Lite (CL v 1.87)
// (C) Copyright John Webster Small 1994
// All rights reserved
// examp301.cpp -- link with cl.obj

// #define CL_NO_TEMPLATES

#include "cl.h"


class String {

	char *str;
	size_t len;
	int cmp(const String& cs) const;

public:

	String(const char * s = (const char *)0)
	{
		str = (s? len = strlen(s), strdup(s)
			: (char *)(len = 0));
	}
	String(const String& s)
	{
		str = (((len = s.len) != 0)?
			strdup(s.str) : (char *)0);
	}
	~String() { delete str; }
	String& operator=(const String& s)
	{
		delete str;
		str = (((len = s.len) != 0)?
			strdup(s.str) : (char *)0);
		return *this;
	}
	inline int operator==(const String& cs) const
		{ return !cmp(cs); }
	inline int operator> (const String& cs) const
		{ return (cmp(cs) > 0); }
	operator const char *()  { return str; }
	friend ostream& operator<<
		(ostream& os, String& s)
	{ return os << &s.str; }
	friend istream& operator>>
		(istream& is, String& s)
	{
		is >> &s.str;
		s.len = (s.str? strlen(s.str) : 0);
		return is;
	}
};

int String::cmp(const String& cs) const
{
	if (!str)
		if (!cs.str)
			return 0;
		else
			return -1;
	else
		if (!cs.str)
			return 1;
		else
			return strcmp(str,cs.str);
}


#ifdef CL_NO_TEMPLATES
	#define    ITEM     String
	#define    CL_WELL_ENDOWED
	#define    CL       CL_String
	#include  "cl.hf"
#else
	CL_WELL_ENDOWED(String)
	#define    CL_String CL<String>
#endif

#define StrFile "strings.tmp"

main()
{
	CL_String cS(CL_ANDS);
	String s("can be");
	cS.insNew(&s);
	cS.ins(new String("tamed!"));
	cS.insQ(new String("Now strings"));
	cS.sort();
	cS.save(StrFile);
	cS.allClr();
	cS.load(StrFile);
	while (cS.popDelAsg(&s))
		cout << (const char *)s << endl;
	return 0;
}
