//  (C) Copyright John Webster Small 1994
//  All rights reserved
//  examp208.cpp -- link with cl.obj
//  Remake of examp207.cpp with ANSI strings
//  Template approach only is used

#include <ctype.h>
#include <cstring.h>
#include "cl.h"

CL_ASSIGN_OP(string)
CL_COPYINIT(string)
CL_STRM_INSERT_OP(string)
inline istream& CL_getD(istream& is, string *& D)
{
	if (D) delete D;
CL_TRY_NEW
	D = new string;
CL_CATCH_XALLOC(D)
	if (D)
		D->read_line(is);
	return is;
}

#define CL_string CL<string>

class StrReSrc : CL_string {
	static unsigned ridx;
	static int cmp
		(const string * S1, const string * S2);
protected:
	virtual voidCmP cmPD(voidCmP cmP)
	{
		return (cmP?cmP:CLcmPcast(cmp,void));
	}
public:
	StrReSrc() : CL_string(CL_ANDS) {}
	StrReSrc(const char * filename)
		: CL_string(defaultConstruct)
		{ (void)CL_string::load(filename); }
	int load(const char * filename)
		{ return CL_string::load(filename); }
	int save(const char * filename)
		{ return CL_string::save(filename); }
	int add(char * S)
	{
		string str(S);
		return (insUniqueNew
			((const string *)&str)? 1 : 0);
	}
	const char * operator[](const char * S)
	{
		string str(S);
		return (findFirst((const string *)&str)?
			&((get()->c_str())[ridx])
			:"notfound");
	}
	CL_string::allClr;
	~StrReSrc() { CL_string::destruct(); }
};

unsigned StrReSrc::ridx;

int StrReSrc::cmp(const string * S1, const string * S2)
{
	const char * s1 = S1->c_str(), * s2 = S2->c_str();
	for (ridx = 0; s1[ridx] && s2[ridx]; ridx++)
		if (s1[ridx] != s2[ridx])
			break;
		else if (isspace(s1[ridx]))
			// keys match
			return 0;
	if (!s1[ridx] && s2[ridx] == ' ')
			return 0;
	return s1[ridx] - s2[ridx];
}

#define StrReSrcFile "spanish.tmp"

main()
{
	StrReSrc sr;
	sr.add("one uno");
	sr.add("two dos");
	sr.add("three tres");
	sr.add("three wrong");
	sr.save(StrReSrcFile);
	sr.allClr();
	sr.load(StrReSrcFile);
	cout <<"\nCount to three in Spanish: "
		<< endl;
	cout << sr["one"] << endl;
	cout << sr["two"] << endl;
	cout << sr["three"] << endl;
	return 0;
}
