/*

	pickfile.cpp
	7-30-91
	Directory PickList

	Copyright 1991
	John W. Small
	All rights reserved

	Licensed users of FlexList are free to use and
	modify this tool for use in their programs.


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233

*/


#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <io.h>
#include <conio.h>
#include "pckey.hpp"
#include "pcled.hpp"
#include "pcdir.hpp"
#include "pickfile.hpp"

char PickFile::path[MAXPATH];
char PickFile::auxpath[MAXPATH];
char PickFile::drive[MAXDRIVE];
char PickFile::dir[MAXDIR];
char PickFile::file[MAXFILE];
char PickFile::ext[MAXEXT];


int PickFile::DEcompare(const DirE DE1, const DirE DE2)
{
	return strcmp(DE1->name,DE2->name);
}

int PickFile::DEload(const char *pathname, int fattrib)
{
	struct ffblk dta;
	char far *olddta;
	int done, attrib, flags;
	DirEntry de;
	int MM, DD, YY, hh, mm;
	char amPM;
	struct text_info ti;


	mattrib = fattrib;
	if (strlen(strcpy(mask,fnexpand(pathname)))
		 == 3)  /* root directory */
		strcat(mask,"*.*");
	else if (!(fnsplit(mask,drive,dir,0,0) & WILDCARDS))
		if ((attrib = _chmod(mask,0)) == -1)
			return 0;
		else if (attrib & FA_DIREC)
				strcat(mask,"\\*.*");
	olddta = getdta();
	done = findfirst(mask,&dta,fattrib);
	while (!done)  {
		de.tag = 0;
		de.attrib = dta.ff_attrib;
		(void) fattribStr(de.attribStr,de.attrib);
		de.ftime  = dta.ff_ftime;
		de.fdate  = dta.ff_fdate;
		de.fsize  = dta.ff_fsize;
		strcpy(de.name,dta.ff_name);

		DD = dta.ff_fdate & 0x001F;
		MM = (dta.ff_fdate >> 5) & 0x000F;
		YY = ((dta.ff_fdate >> 9) & 0x007F) + 80;
		mm = ((dta.ff_ftime >> 5) & 0x003F) >> 1;
		hh = (dta.ff_ftime >> 11) & 0x001F;
		if (hh == 0)  {
			hh = 12;
			amPM = mm? 'a' : 'p';
		}
		else if (hh == 12)
			amPM = mm? 'p' : 'a';
		else if (hh > 12)  {
			hh -= 12;
			amPM = 'p';
		}
		else
			amPM = 'a';
		if (!strcmp(dta.ff_name,"."))  {
			strcpy(file,".");
			ext[0] = '\0';
		}
		else if (!strcmp(dta.ff_name,".."))  {
			strcpy(file,"..");
			ext[0] = '\0';
		}
		else
			(void) fnsplit(dta.ff_name,drive,dir,file,ext);
		de.fnameLen = strlen(file);
		de.extLen = strlen(ext);
		if (dta.ff_attrib == FA_DIREC)
			sprintf(de.entry,"%-8s%c%-3s <DIR>    %2d-%02d-%2d  %2d:%02d%c ",
				file,de.extLen?'.':' ',(ext[0] == '.')?&ext[1]:ext,
				MM,DD,YY,hh,mm,amPM);
		else
			sprintf(de.entry,"%-8s%c%-3s %8ld %2d-%02d-%2d  %2d:%02d%c ",
				file,de.extLen?'.':' ',(ext[0] == '.')?&ext[1]:ext,
				dta.ff_fsize,MM,DD,YY,hh,mm,amPM);

		if (addD(&de))
			done = findnext(&dta);
		else
			done = 1;
	}
	setdta(olddta);
	if (!Nodes())
		return 0;
	return 1;
}

char * PickFile::DEpathname(const DirE DE)
{

	if (!DE)
		return (char *)0;
	strcpy(path,mask);
	if (fnsplit(path,drive,dir,file,ext) & WILDCARDS)  {
		fnmerge(path,drive,dir,(char *)0,(char *)0);
		strcat(path,DE->name);
	}
	return path;
}

char * PickFile::fattribStr(char *attribStr, char attrib)
{

	if (!attribStr)
		return (char *)0;
	attribStr[0] = (attrib & FA_RDONLY)? 'R' : ' ';
	attribStr[1] = (attrib & FA_HIDDEN)? 'H' : ' ';
	attribStr[2] = (attrib & FA_SYSTEM)? 'S' : ' ';
	attribStr[3] = (attrib & FA_LABEL)?  'L' : ' ';
	attribStr[4] = (attrib & FA_DIREC)?  'D' : ' ';
	attribStr[5] = (attrib & FA_ARCH)?   'A' : ' ';
	attribStr[6] = '\0';
	return attribStr;
}

int PickFile::idle(int c)
{
	FlexList tmp(sizeof(DirEntry));
	LineEditWindow LEW;

	if (c == -F3)  {
		while (tmp.insQN(popN()));
		strcpy(auxpath,mask);
		do {
			clear();
			if (!LEW.edit(path,MAXPATH,MAXPATH/2,0,0,
				auxpath,PF_MASK))  {
				while(insQN(tmp.popN()));
				strcpy(mask,auxpath);
				return 1;
				// redisplay to clear edit window
			}
		} while (!DEload(path,mattrib));
		putTitle(mask);
		return 1;
	}
	return 0;
}

#pragma argsused
int PickFile::xcursor(void * D, const char * prefix, int pfLen)
{
	if (pfLen > ((DirE)D)->fnameLen)
		return (9+pfLen-((DirE)D)->fnameLen);
	return (pfLen+1);
}


int PickFile::doIt(void * D)
{
	int done;
	FlexList tmp(sizeof(DirEntry));

	if (((DirE)D)->attrib & FA_DIREC)  {
		if (!strcmp(((DirE)D)->name,"."))
			return 1;
		if (!stricmp(mask,DEpathname((DirE)D)))
			return 1;  // same directory also
		while (tmp.insQN(popN()));
		if (DEload(DEpathname((DirE)D),mattrib))  {
			putTitle(mask);
			return -1;
		}
		clear();
		while(insQN(tmp.popN()));
		return 1;
	}
	return 0;
}

unsigned PickFile::choose(const char *pathname, int fattrib,
	const char *defaultExt)
{
	LineEditWindow LEW;
	char auxext[MAXEXT];

	if (defaultExt)
		if (strlen(defaultExt) < MAXEXT)
			strcpy(auxext,defaultExt);
		else
			strcpy(auxext,".*");
	else
		strcpy(auxext,".*");
	strcpy(auxpath,"*");
	strcat(auxpath,auxext);
	if (pathname)
		strcpy(path,pathname);
	else  {
		if (!LEW.edit(path,MAXPATH,MAXPATH/2,0,0,
			auxpath,PF_MASK))
			return 0;
	}
	clear();
	strcpy(path,fndefault(path,(char *)0,(char *)0,
		(char *)0,auxext));
	while (!DEload(path,fattrib))
		if (!LEW.edit(path,MAXPATH,MAXPATH/2,0,0,
			auxpath," File Mask Specification "))
			return 0;
		else
			strcpy(path,fndefault(path,
				(char *)0,(char *)0,
				(char *)0,auxext));

	return PickListWindow::choose();
}
