/*

	eb3.hpp
	8-10-91
	Electronic Book: header for eb3.cpp

	Copyright 1991
	John W. Small
	All rights reserved

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/


#ifndef EB3_HPP
#define EB3_HPP

#include <fstream.h>
#include <dir.h>

#ifndef EBDEF_HPP
#include "ebdef.hpp"
#endif

#ifndef EB1_HPP
#include "eb1.hpp"
#endif

#ifndef EB2_HPP
#include "eb2.hpp"
#endif

#ifndef PICKLIST_HPP
#include "picklist.hpp"
#endif

//#ifndef FLEXLIST_CPP
//#include <flexlist.hpp>
//#endif
#ifndef flcpp2cl_h
#include "flcpp2cl.h"
#endif



/*

	The HyperTopic class maintains a handle to the
	topics in the file.  It is used to construct the
	HyperContext class.  It's topic and clues can also
	be read.

*/

class HyperTopic {
	char * inlinks;
	long fpos;
	unsigned contextLength;
	char * outlinks;
	#pragma argsused
	void * operator new(size_t size)
		{ return (void *)0; }
public:
	HyperTopic(ifstream& f);
	#pragma argsused
	void * operator new(size_t size, void * ptr)
		{ return ptr; }
	int ConstructOK()  { return contextLength; }
	char * topic()  { return parseLinks(inlinks); }
	char * clue() { return parseLinks(); }
	int match(HyperTextTargeT HTT,
		unsigned topicNum);
	HyperContexT fetch(HyperTextTargeT HTT,
		unsigned topicNum);
	~HyperTopic() { delete inlinks; delete outlinks; }
};
typedef HyperTopic *HyperTopiC;
#define HyperTopiC0 ((HyperTopiC)0)



/*

	The PickTableOfContents class is used to build a
	sequential list on topic entries.

*/

class PickTableOfContents : PickListWindow  {
	virtual void dressWindow()
		{ putTitle(" Table of Contents "); }
public:
	PickTableOfContents() : PickListWindow(0,PalettE0,
		PalettE0,FLstrings,MAX_HYPER_TOC,FLcompare0)
		{}
	PickListWindow::choose;
	char *choice() { return (char *)
		PickListWindow::choice(); }
	char *addT(char *T)  { return (char *) addD(T); }
};
typedef PickTableOfContents * PickTOC;
#define PickTOC0 ((PickTOC)0)



/*

	The PickIndex class is used to build a sorted
	PickListWindow of index entries.

*/

class PickIndex : PickListWindow {
	char buf[MAX_HYPER_LINE];
	char * lastT;  // last topic added
	virtual void dressWindow()
		{ putTitle(" Index "); }
public:
	PickIndex() : PickListWindow(0,PalettE0,
		PalettE0,FLstrings,MAX_HYPER_IDX,
		FLcomparE(stricmp))
		{ lastT = (char *)0; }
	PickListWindow::choose;
	char * choice();
	// add topic
	char *addT(char *T)
		{ return (lastT = (char *) addD(T)); }
	// add clue for last topic added
	char *addC(char *C)  { return (char *)
		((C && lastT)? addD(strcat(strcat
			(strcpy(buf,C),
			HYPER_LINKS_DELIMIT_STR),lastT))
			:0); }
};
typedef PickIndex * PickIDX;
#define PickIDX0 ((PickIDX)0)




/*

	The HyperFile class is used to load a list of
	HyperTopic handles to the topics in the file.
	The context of a topic can be fetched.  The
	class also maintains a reference count to
	determine when it can be discarded.  A Table of
	Contents or Index can also be generated for
	the file.

*/


class HyperFile : FlexList /* of HyperTopics */  {
	char fname[MAXPATH];
	unsigned refs;
	// A variant FlexList is used so that the
	// HyperTopics class destructor can be called!
	#pragma argsused
	virtual FlexN FNnew(const void *D)  { return
		(FlexN) new char[sizeof(FlexNode)-1
		+sizeof(HyperTopic)]; }
	#pragma argsused
	virtual int   FNwrite(void *ND, const void *D)
		{ return 0; }
	#pragma argsused
	virtual int   FNread(const void *ND, void *D)
		{ return 0; }
	virtual int   FNdestruct(void *ND, void *D);
	#pragma argsused
	void * operator new(size_t size)
		{ return (void *)0; }
public:
	HyperFile(const char *fname);
	#pragma argsused
	void * operator new(size_t size, void * ptr)
		{ return ptr; }
	int ConstructOK() { return ((strlen(fname)
		&& Nodes())? 1 : 0); }
	int match(HyperTextTargeT HTT);
	HyperContexT fetch(HyperTextTargeT HTT,
		int backTrack);
	int discard(const char *fname);
	PickTOC TableOfContents(const char *fname);
	PickIDX Index(const char *fname);
	~HyperFile() {}
};
typedef HyperFile * HyperFilE;
#define HyperFilE0 ((HyperFilE)0)


/*

	The HyperServer is a FlexList of HyperFile
	FlexLists!  HyperTopics are loaded through
	this interface by the HyperView class.

*/

class HyperServer : FlexList /* of HyperFiles */ {
	// A variant FlexList is used so that the
	// HyperFile class destructor can be called!
	#pragma argsused
	virtual FlexN FNnew(const void *D)  { return
		(FlexN) new char[sizeof(FlexNode)-1
		+sizeof(HyperFile)]; }
	#pragma argsused
	virtual int   FNwrite(void *ND, const void *D)
		{ return 0; }
	#pragma argsused
	virtual int   FNread(const void *ND, void *D)
		{ return 0; }
	virtual int   FNdestruct(void *ND, void *D);
public:
	HyperServer() : FlexList(FLvariantData) {}
	HyperContexT fetch(HyperTextTargeT HTT,
		int backTrack);
	void discard(const char *fname);
	PickTOC TableOfContents(const char *fname);
	PickIDX Index(const char *fname);
};
typedef HyperServer * HyperServeR;
#define HyperServeR0 ((HyperServeR)0)


#endif

