/*
	findnext.cpp -- Container Lite v 1.87
	(C) Copyright 1994  John Webster Small
	All rights reserved
*/

#include "cl.h"

void * cl::findNext(const void * K, cl::RelCmp rc)
{

/*
	For sorted cls you must first call
	findFirst() to insure consistent results!
*/
	unsigned low, mid, high;
	void * D;

/*
	The current node is left undefined if
	anything fails, otherwise it is set to the
	newly found node.
*/

	if (!cmP)
		cmP = cmPD(voidCmP0);
	if (!linkS || !K || !cmP
		|| (++curNode >= nodes))  {
		curNode = nodes;
		return (void *)0;
	}
	if (!rcmp(K,D=linkS[(first+curNode)%limit],rc))
		return D;
	if (flags & CL_SORTED)  {
		if (rc != NE)
			return (void *) 0;
		/*  binary search for last match  */
		low  = curNode + 1;
		high = nodes - 1;
		while (low < high)  {
			mid = ((high + low + 1) >> 1);
			if ((*cmP)(K,linkS[(first+mid)
				%limit]) >= 0)
				low = mid;
			else
				high = mid - 1;
		}
		if ((*cmP)(K,linkS[(first+high)%limit]))
			curNode = high;
		else
			curNode = high + 1;
	}
	else while (++curNode < nodes)
		if (!rcmp(K,linkS[(first+curNode)
			%limit],rc))
			break;
	return ((curNode < nodes)?
			linkS[(first+curNode)%limit]
		: (void *)0);
}
