/*
	findfirs.cpp -- Container Lite v 1.87
	(C) Copyright 1994  John Webster Small
	All rights reserved
*/

#include "cl.h"

void * cl::findFirst(const void * K, cl::RelCmp rc)
{
	unsigned low, mid, high;

/*
	The current node is left undefined if
	anything fails, otherwise it is set to the
	newly found node.
*/

	curNode = nodes;
	if (!cmP) if ((cmP = cmPD(voidCmP0))
		== voidCmP0) return (void *) 0;
	if (!linkS || !K || !nodes)
		return (void *)0;
	if (flags & CL_SORTED)
	  switch (rc)  {
	    case EQ:
	    case GT:
	    case GE:
		/*  binary search for first match  */
		low = 0U;
		high = nodes - 1;
		while (low < high)  {
			mid = ((high + low) >> 1);
			if (rcmp(K,linkS[(first+mid)
				%limit],rc) <= 0)
				high = mid;
			else
				low = mid + 1;
		}
		if (!rcmp(K,linkS[(first+high)%limit],rc))
			curNode = high;
		break;
	    case LT:
	    case LE:
		if (!rcmp(K,linkS[first],rc))
			curNode = 0;
		break;
	    case NE:
		if ((*cmP)(K,linkS[first]))  {
			curNode = 0;
			break;
		}
		/*  binary search for last match  */
		low = 1U;
		high = nodes - 1;
		while (low < high)  {
			mid = ((high + low + 1) >> 1);
			if ((*cmP)(K,linkS
				[(first+mid)%limit])
				>= 0)
				low = mid;
			else
				high = mid - 1;
		}
		if ((*cmP)
			(K,linkS[(first+high)%limit]))
			curNode = high;
		else
			curNode = high + 1;
		break;
	  }
	else  {  /*  linear search!  */
		curNode = 0;
		do  {
			if (!rcmp(K,linkS
				[(first+curNode)
				%limit],rc))
				break;
		} while (++curNode < nodes);
	}
	return ((curNode < nodes)?
			linkS[(first+curNode)%limit]
		: (void *)0);
}
