# Use this make file to build a Container Lite library.
# Edit the macros below to suit your evironment.
# Change the DOS "\" to "/" for an Unix environment.

# Macros support specifications for:
#	1)  standard include directory $(incdir),
# 	2)  memory model $(mdl),
#	3)  MS Windows application $(win),
#	4)  C++ compiler directory $(CCdir),
#	5)  compile command $(CC),
#	6)  library directory $(libdir),
#	7)  library file name $(libname), and
#	8)  librarian command $(lb).

# Macros are shown for both MSVC 8.0 and BCC 3.1

# Macros are setup here for Borland C++ 4.0

incdir=\bc4\include
!if !$d(mdl)
mdl=s
!endif
!if !$d(win)
wc=
wl=
!else
wc=-W
wl=w
!endif
CCdir=\bc4\bin
CC=$(CCdir)\bcc $(wc) -c -m$(mdl) -I$(incdir)
libdir=\bc4\lib
libname=$(wl)cl$(mdl)
lb=$(CCdir)\tlib $(libdir)\$(libname).lib

.cpp.obj:
	$(CC) $&.cpp
	$(lb) -+$&



# Macros are setup here for Microsoft Visual C++ 8.0

#incdir=\msvc\include
#!ifndef mdl
#mdl=S
#!endif
#!ifndef win
#wc=
#wl=
#!else
#wc=-GW
#wl=w
#!endif
#CCdir=\msvc\bin
#CC=$(CCdir)\cl $(wc) -c -A$(mdl) -I$(incdir)
#libdir=\msvc\lib
#libname=$(wl)cl$(mdl)
#lb=$(CCdir)\lib $(libdir)\$(libname).lib

#.cpp.obj:
#	$(CC) $*.cpp
#	$(lb) +$*;




# Implicit target: Container Lite library

$(libdir)\$(libname):  cl.h pitem.h  \
	pitem.obj cl1.obj cl2.obj cl3.obj cmp.obj \
	assign.obj vector.obj atinsnew.obj  \
	atdelasg.obj atput.obj  \
	atputnew.obj atputasg.obj atgetasg.obj \
	atxchg.obj index.obj vforeach.obj  \
	detect1.obj detect2.obj \
	select.obj reject.obj collect.obj \
	curnode.obj ins.obj insnew.obj rmv.obj  \
	del.obj delasg.obj next.obj nextasg.obj \
	prev.obj prevasg.obj sort.obj inssort.obj \
	inssortn.obj insuniq.obj insuniqn.obj \
	rcmp.obj findfirs.obj findnext.obj \
	findlast.obj findprev.obj \
	findall.obj tallyall.obj
	del *.obj
	del $(libdir)\$(libname).bak

