/*
	cl.h -- Container Lite v 1.87
	(C) Copyright 1994  John Webster Small
	All rights reserved
*/

#ifndef cl_h
#define cl_h


///////////////////////////////////////////////////////
//                                                   //
//   If your compiler doesn't support templates      //
//   define CL_NO_TEMPLATES below.                   //
//                                                   //
///////////////////////////////////////////////////////


#ifndef CL_NO_TEMPLATES
	#ifdef _MSC_VER
	  #if  _MSC_VER <= 900
		//   Microsoft's C 7.0 and Visual C++
		//   8.0 do not support templates.
		//   Assume for now MS C++ 9.0 won't.
		#define CL_NO_TEMPLATES
	  #endif
	#endif
//	#if YOUR_NO_TEMPLATES_CC
//		#define CL_NO_TEMPLATES
//	#endif
#endif


///////////////////////////////////////////////////////
//                                                   //
//   If your compiler doesn't support exceptions     //
//   define CL_NO_EXCEPTIONS below.                  //
//                                                   //
///////////////////////////////////////////////////////


#if defined(_MSC_VER)
  #if _MSC_VER <= 900
	//   Microsoft's C 7.0 and Visual C++ 8.0 do
	//   not support exceptions.  Assume for now
	//   MS C++ 9.0 won't.
	#define CL_NO_EXCEPTIONS
  #endif
#elif defined(__BCPLUSPLUS)
  #if __BCPLUSPLUS__ < 0x320
	//   Borland C++ compilers prior to 4.0 did 
	//   not support exceptions.
	#define CL_NO_EXCEPTIONS
  #endif
//#elif YOUR_NO_EXCEPTIONS_CC
//	#define CL_NO_EXCEPTIONS
#endif


///////////////////////////////////////////////////////
//                                                   //
//   To enable Container Lite methods to             //
//   throw the xalloc exception comment              //
//   out the define CL_NO_THROW_XALLOC below.        //
//                                                   //
///////////////////////////////////////////////////////


#ifndef CL_NO_THROW_XALLOC
	#define CL_NO_THROW_XALLOC
#endif


#if defined(CL_NO_THROW_XALLOC)\
	&& !defined(CL_NO_EXCEPTIONS)
	#include <except.h>
	#define CL_TRY_NEW   try {
	// Flesh in catch (xalloc) {} as required.
	// CL primitives will return 0 on failures
	// as before unless you throw an additional
	// exception!
	#define CL_CATCH_XALLOC(NULLD) \
		} catch (xalloc) { NULLD = 0; }
	// CL will return 0 if the catch block doesn't
	// terminate the program, even with
	// set_new_handler(0)!
#else
	#define CL_TRY_NEW
	#define CL_CATCH_XALLOC(NULLD)
#endif


///////////////////////////////////////////////////////
//                                                   //
//   If your compiler doesn't support the            //
//   ANSI C header file "stdarg.h" define            //
//   CL_NO_STDARG_H below.                           //
//                                                   //
///////////////////////////////////////////////////////


#if defined(_MSC_VER)
  #if  _MSC_VER == 800
	//   Visual C++ 8.00 doesn't correctly support
	//   variable-length arguments when the first
	//   formal parameter is a function pointer.
	#define CL_NO_STDARG_H
  #endif
//#elif YOUR_UNIX_V_CC
//	#define CL_NO_STDARG_H
#endif


///////////////////////////////////////////////////////
//                                                   //
//   If you compiler allows for other than           //
//   the normal C calling convention, define         //
//   CL_CDECL below appropriately to force           //
//   a C call modifier where required by CL.         //
//                                                   //
///////////////////////////////////////////////////////


#if defined(__BORLANDC__) || defined(_MSC_VER)
	//   Borland and Microsoft use same modifier
	#define CL_CDECL __cdecl
//#elif YOUR_NON_C_CALL_CC
//	#define CL_CDECL ???
#else
	#define CL_CDECL
#endif


#ifndef  CL_NO_STDARG_H
	#include <stdarg.h>
	#define CL_vforEach_decl                    \
	void    vforEach(voidApplY B, va_list args);
	#define CL_vforEach_promote                 \
	cl::     vforEach;
	#define CL_forEach_def(ITEM)                \
	void CL_CDECL forEach(CLapplY(B,ITEM), ...) \
	{                                           \
		va_list args;                       \
		va_start(args,B);                   \
		vforEach((voidApplY)B,args);        \
		va_end(args);                       \
	};
#else
	#define CL_vforEach_decl
	#define CL_vforEach_promote
	#define CL_forEach_def(ITEM)
#endif


#include <limits.h>	// UINT_MAX
#include <iostream.h>
#include <iomanip.h>
#include <string.h>


/*  stream delimiters/manipulators  */

inline ostream& endm(ostream& os)
{ return os << endl; }

inline istream& nextm(istream& is)
{ is.get(); return is; }

/*  special functions for strings  */

extern ostream&  CL_fputCharArray(ostream& os, char * D);
extern istream&  CL_fgetCharArray(istream& is, char *& D);
inline ostream&  operator<<(ostream& os, char ** D)
	{ return CL_fputCharArray(os,*D); }
inline istream&  operator>>(istream& is, char ** D)
	{ return CL_fgetCharArray(is,*D); }

/*  cl pointer types  */

#define CLblank
#define CLcmP(ID,ITEM)  \
	int (*ID)(const ITEM * D1, const ITEM * D2)
typedef CLcmP(voidCmP,void);
#define CLcmPcast(ID,ITEM)  \
	(CLcmP(CLblank,ITEM)) ID
#define CLcmP0(ITEM)  CLcmPcast(0,ITEM)
#define voidCmP0 ((voidCmP)0)
#define CmPfnc CmP() const

#ifndef  CL_NO_STDARG_H
#define CLapplY(ID,ITEM)  \
	void (*ID)(ITEM * D, va_list args)
typedef CLapplY(voidApplY,void);
#define CLapplYcast(ID,ITEM)  \
	(CLapplY(CLblank,ITEM)) ID
#define CLapplY0(ITEM)  (CLapplYcast(0,ITEM))
#define voidApplY0 ((voidApplY)0)
#endif

#define CLdetecT(ID,ITEM)  \
	int (*ID)(ITEM * D, void * V)
typedef CLdetecT(voidDetecT,void);
#define CLdetecTcast(ID,ITEM)  \
	(CLdetecT(CLblank,ITEM)) ID
#define CLdetecT0(ITEM)  (CLdetecTcast(0,ITEM))
#define voidDetecT0 ((voidDetecT)0)

#define CLcollecT(ID,ITEM)  \
	void * (*ID)(ITEM * D, void * V)
typedef CLcollecT(voidCollecT,void);
#define CLcollecTcast(ID,ITEM)  \
	(CLcollecT(CLblank,ITEM)) ID
#define CLcollecT0(ITEM)  (CLcollecTcast(0,ITEM))
#define voidcollecT0 ((voidCollecT)0)

typedef struct uniquenessGimmick  { int x; }
	* defaultConstructor;
#define defaultConstruct    ((defaultConstructor)0)

/*  cl constants  */

#define CL_MAXNODES	((unsigned) \
			(UINT_MAX/sizeof(void *)))
#define CL_LIMIT	20U
#define CL_DELTA	10U
#define CL_NOTFOUND	CL_MAXNODES

#define CL_SORTED	0x0001U
#define CL_BIND_ONLY	0x0000U
#define CL_ASG		0x0002U
#define CL_READ		0x0004U
#define CL_READ_DEL	0x0008U
#define CL_NEW		0x0010U
#define CL_NEWED	0x0020U
#define CL_DEL		0x0040U
#define CL_SAVE		0x0080U
#define CL_ALL_FLAGS	0x00FFU
#define CL_ANDS		(CL_ASG|CL_NEW|CL_DEL|CL_SAVE)

#define CL_0U		-0	// avoid [0U] ambiguity


class cl {

public:

	enum RelCmp { EQ, NE, GT, GE, LT, LE };

private:

	unsigned lowLimit, lowThreshold, first;
	void **  linkS;
	unsigned limit,    delta,   nodes;
	unsigned maxNodes, curNode, flags;
	voidCmP  cmP;

	int  rcmp(const void * K, const void * D, 
		cl::RelCmp rc);
	void init(unsigned flags = CL_BIND_ONLY,
		unsigned maxNodes = CL_MAXNODES,
		unsigned limit = CL_LIMIT,
		unsigned delta = CL_DELTA);

protected:

	cl  (defaultConstructor)
			{ init(); }
	void    assign(const cl& b);
	void    destruct();
	virtual voidCmP cmPD(voidCmP cmP)
			{ return cmP; }
	virtual void * assignD(void *, const void *)
			{ return (void *)0; }
	virtual void * newD(const void *)
			{ return (void *)0; }
	virtual void   deleteD(void * D)
			{ delete D; }
	virtual int    attachD(void *)
			{ return 1; }
	virtual void   detachD(void *)
			{}
	virtual	int    putD(ostream&, void *)
			{ return 0; }
	virtual	void * getD(istream&)
			{ return (void *)0; }
	virtual int    put(ostream& os);
	virtual int    get(istream& is);
	int     load(const char * filename);
	int     save(const char * filename);
	friend  ostream& operator<<(ostream& os,
			cl&);
	friend  istream& operator>>(istream& is,
			cl&);
	CL_vforEach_decl

public:

/*  Constructors and destructor  */

	cl     (unsigned flags = CL_BIND_ONLY,
		unsigned maxNodes = CL_MAXNODES,
		unsigned limit = CL_LIMIT,
		unsigned delta = CL_DELTA)
		{ init(flags,maxNodes,limit,delta); }
	cl     (void ** argv, unsigned argc = 0U,
		unsigned flags = CL_BIND_ONLY);
	cl&     operator=(const cl& b)
		{ return *this; }
	int     operator==(const cl& b) const;
	int     operator> (const cl& b) const;
	void ** vector(void ** argv = (void **)0,
			unsigned argc = 0U) const;
	virtual ~cl()  { destruct(); }
/*
	You must override this destructor in any
	descendant that overrides deleteD() or
	detachD(), i.e.

	virtual ~DerivedFromCL()
		{ cl::destruct(); }

	This is because base destructors are called
	after vfts are reset to their default values
	for the base level.  This means that
	cl::~cl() calls cl::detachD()
	and perhaps cl::deleteD() instead of
	the intended DerivedFromCL::detachD()
	or DerivedFromCL::deleteD().
*/

/*  Housekeeping Primitives  */

	unsigned Limit() const { return limit; }
	unsigned setLimit(unsigned newLimit);
	unsigned pack()  { return setLimit(nodes); }
	unsigned Delta() const { return delta; }
	unsigned setDelta(unsigned newDelta
			= CL_DELTA);
	unsigned Nodes() const { return nodes; }
	unsigned MaxNodes() const { return maxNodes; }
	unsigned setMaxNodes(unsigned newMaxNodes
			= CL_MAXNODES);
	unsigned vacancy() const
			{ return maxNodes - nodes; }
	unsigned vacancyNonElastic() const
			{ return limit - nodes; }
	unsigned Flags(unsigned flags = CL_ALL_FLAGS)
			const
		    { return (this->flags & flags); }
	unsigned setFlags(unsigned flags)
		    { return (this->flags |= flags); }
	unsigned resetFlags(unsigned flags)
		    { return (this->flags &= ~flags); }
	cl&  operator<<(cl& (*manipulator)
			(cl&))
			{ return (manipulator?
				(*manipulator)(*this)
				: *this); }

/*  Elastic Array Primitives  */

	void *   atIns(unsigned n, void * D);
	void *   atInsNew(unsigned n, const void * D);
	void *   atRmv(unsigned n);
	void     allRmv();
	int      atDel(unsigned n);
	void *   atDelAsg(unsigned n, void * D);
	int      allDel();
	void     allClr()  { destruct(); }
	void *   atPut(unsigned n, void * D);
	void *   atPutNew(unsigned n, const void * D);
	void *   atPutAsg(unsigned n, const void * D);
	void *   atGet(unsigned n) const;
	void *   operator[](unsigned n) const
			{ return atGet(n); }
	void *   atGetAsg(unsigned n, void * D);
	void *   atXchg(unsigned n, void * D);
	unsigned index(const void * D) const;
	CL_forEach_def(void)
	int      detect(void *& D, 
			voidDetecT B,
			void * V = 0);
	int      detect(unsigned& i,
			voidDetecT B,
			void * V = 0);
	unsigned select(cl& c,
			voidDetecT B,
			void * V = 0);
	unsigned reject(cl& c,
			voidDetecT B,
			void * V = 0);
	unsigned collect(cl& c,
			voidCollecT B,
			void * V = 0);

/*  Stack - Deque - Queue Primitives  */

	void *   push(void * D)
			{ return atIns(0U,D); }
	void *   pushNew(const void * D)
			{ return atInsNew(0U,D); }
	void *   pop()  { return atRmv(0U); }
	cl&      operator>>(void *& D)
			{ D = atRmv(0U);
			return *this; }
	int      popDel()  { return atDel(0U); }
	void *   popDelAsg(void * D)
			{ return atDelAsg(0U,D); }
	void *   top() const { return atGet(0U); }
	void *   topAsg(void * D)
			{ return atGetAsg(0U,D); }
	void *   insQ(void * D)
			{ return atIns(nodes,D); }
	cl&      operator<<(void * D)
		    { atIns(nodes,D); return *this; }
	void *   insQNew(const void * D)
			{ return atInsNew(nodes,D); }
	void *   unQ()  { return atRmv(nodes-1); }
	int      unQDel()  { return atDel(nodes-1); }
	void *   unQDelAsg(void * D)
			{ return atDelAsg(nodes-1,D); }
	void *   rear() const
			{ return atGet(nodes-1); }
	void *   rearAsg(void * D)
			{ return atGetAsg(nodes-1,D); }

/*  List (single and double linked) Primitives  */

	unsigned CurNode() const;
	int      setCurNode(unsigned n = CL_NOTFOUND);
	void *   ins(void * D);
	void *   insNew(const void * D);
	void *   rmv();
	int      del();
	void *   delAsg(void * D);
	void *   put(void * D)
			{ return atPut(curNode,D); }
	void *   putNew(const void * D)
			{ return atPutNew(curNode,D); }
	void *   putAsg(const void * D)
			{ return atPutAsg(curNode,D); }
	void *   get() const { return atGet(curNode); }
	void *   getAsg(void * D)
			{ return atGetAsg(curNode,D); }
	void *   next();
	void *   operator++()  { return next(); }
	void *   nextAsg(void * D);
	void *   prev();
	void *   operator--()  { return prev(); }
	void *   prevAsg(void * D);

/* Priority Q, Set, Bag, Dictionary, Sort Primitives */

	unsigned Sorted() const
		    { return (flags & CL_SORTED); }
	void     unSort()  { flags &= ~CL_SORTED; }
	void     setCmP(voidCmP cmP = voidCmP0)
			{ this->cmP = cmPD(cmP);
			flags &= ~CL_SORTED; }
	voidCmP  CmP() const { return cmP; }
	int      sort(voidCmP cmP = voidCmP0);
	void *   insSort(void * D);
	void *   insSortNew(const void * D);
	void *   insUnique(void * D);
	void *   insUniqueNew(const void * D);
	void *   findFirst(const void * K,
			cl::RelCmp rc = EQ);
	void *   findNext(const void * K,
			cl::RelCmp rc = EQ);
	void *   findLast(const void * K,
			cl::RelCmp rc = EQ);
	void *   findPrev(const void * K,
			cl::RelCmp rc = EQ);
	unsigned findAll(cl& b,
			const void * K,
			cl::RelCmp rc = EQ);
	unsigned tallyAll(const void * K,
			cl::RelCmp rc = EQ);

};	/*  class cl  */


inline ostream& operator<<(ostream& os, cl& b)
{
	if (b.Flags(CL_SAVE))
		(void) b.put(os);
	return os;
}

inline istream& operator>>(istream& is, cl& b)
{
	(void) b.get(is);
	return is;
}

typedef void (*GenericFnC)();
#define GenericFnC0  ((GenericFnC)0)

class FunctionRegistry : cl  {

public:
	FunctionRegistry() : cl(CL_DEL) {}
	int regFnC(GenericFnC fnC, unsigned id);
	unsigned fnC_2_ID(GenericFnC fnC);
	GenericFnC ID_2_fnC(unsigned id);
	void forget() { allDel(); }
	~FunctionRegistry() {}
};

extern  FunctionRegistry fnCv;

#define Forget_Functions() fnCv.forget()
#define Register_Function(fnC,id)  \
		fnCv.regFnC((GenericFnC)fnC,id)
#define Register_CmP(cmP,id)  \
		Register_Function(cmP,id)
#define fnC2ID(fnC) fnCv.fnC_2_ID((GenericFnC)fnC)
#define ID2fnC(id)  fnCv.ID_2_fnC(id)
#define cmP2ID(cmP) fnC2ID(cmP)
#define ID2cmP(id) ((voidCmP)ID2fnC(id))


/*  CL's C++ TEMPLATES  */

#ifndef CL_NO_TEMPLATES

/*  ITEM descriptors  */

#define CL_ALL_DEF(ITEM)  CL_CMP_DEF(ITEM)
#define ITEM_char

#define CL_CMP_DEF(ITEM)                              \
	inline CLcmP(CL_cmPD(CLcmP(cmP,ITEM)),void)   \
	{ CLcmP(defaultCmP,ITEM) = CL_cmpD;           \
	return CLcmPcast((cmP? cmP :                  \
	defaultCmP),void); }
#define CL_CMP_CHAR
inline int CL_cmpD(const char * D1, const char * D2)
	{ return strcmp(D1,D2); }
	CL_CMP_DEF(char)
template <class ITEM>
	inline CLcmP(CL_cmPD(CLcmP(cmP,ITEM)),void)
	{ return CLcmPcast(cmP,void); }
#define CL_EQ_GT_OPS(ITEM) inline                     \
	int CL_cmpD(const ITEM * D1, const ITEM * D2) \
	{ return ((*D1 == *D2)? 0 :                   \
	((*D1 > *D2)? 1 : -1)); }                     \
    	CL_CMP_DEF(ITEM)
#define CL_CMP_BYTES(ITEM) inline                     \
	int CL_cmpD(const ITEM * D1, const ITEM * D2) \
	{ return memcmp(D1,D2,sizeof(ITEM)); }        \
    	CL_CMP_DEF(ITEM)

#define CL_ASSIGN_OP(ITEM)                       \
	inline void * CL_assignD(ITEM * D,       \
		const ITEM * S, unsigned)        \
	{ *D = *S; return (void *) D; }
#define CL_ASSIGN_BYTES(ITEM)                    \
	inline void * CL_assignD(ITEM * D,       \
		const ITEM * S, unsigned)        \
	{ return memcpy(D,S,sizeof(ITEM)); }
#define CL_ASSIGN_DEF(ITEM)
template <class ITEM>
	inline void * CL_assignD(ITEM *,
		const ITEM *, unsigned)
	{ return (void *) 0; }

#define CL_DUP_CHAR
#if defined(CL_NO_THROW_XALLOC)\
	&& !defined(CL_NO_EXCEPTIONS)
	extern char * CL_strdup(const char * D);
	inline void * CL_newD(const char * D)
	{ return (void *) CL_strdup(D); }
#else
	inline void * CL_newD(const char * D)
	{ return (void *) strdup(D); }
#endif
#define CL_COPYINIT(ITEM) inline                 \
	void * CL_newD(const ITEM * D)           \
	{                                        \
		void * newD;                     \
	CL_TRY_NEW                               \
		newD = (void *) new ITEM(*D);    \
	CL_CATCH_XALLOC(newD)                    \
		return newD;                     \
	}
#define CL_CLONE_BYTES(ITEM) inline              \
	void * CL_newD(const ITEM * D)           \
	{                                        \
		void * newD;                     \
	CL_TRY_NEW                               \
		newD = (void *)	                 \
			new char[sizeof(ITEM)];  \
	CL_CATCH_XALLOC(newD)                    \
		return memcpy(newD,D,sizeof(ITEM));\
	}
#define CL_NEW_DEF(ITEM)
template <class ITEM>
	inline void * CL_newD(const ITEM *)
	{ return (void *) 0; }

template <class ITEM>
	inline void CL_deleteD(ITEM * D)
	{ delete D; }
#define CL_DELETE_OFF(ITEM)                      \
	inline void CL_deleteD(ITEM *)           \
	{ return; }
#define CL_DELETE_DEF(ITEM)

template <class ITEM>
	inline int CL_attachD(ITEM *, const void *)
	{ return 1; }
#define CL_ATTACH_DEF(ITEM)

template <class ITEM>
	inline void CL_detachD(ITEM *, const void *)
	{}
#define CL_DETACH_DEF(ITEM)

#define CL_STRM_INSERT_CHAR
inline ostream&  CL_putD(ostream& os, char * D)
	{ return CL_fputCharArray(os,D); }
template <class ITEM>
	inline ostream& CL_putD(ostream& os,  ITEM *)
	{ return os; }
#define CL_STRM_INSERT_OP(ITEM)                       \
	inline ostream& CL_putD(ostream& os, ITEM * D)\
	{ return os << *D << endm; }
#define CL_STRM_INSERT_BYTES(ITEM)                    \
	inline ostream& CL_putD(ostream& os, ITEM * D)\
	{ return os.write((char *)D,sizeof(ITEM)); }
#define CL_STRM_INSERT_DEF(ITEM)

#define CL_STRM_EXTRACT_CHAR
inline istream&  CL_getD(istream& is, char *& D)
	{ return CL_fgetCharArray(is,D); }
template <class ITEM>
	inline istream& CL_getD(istream& is,
		ITEM *&) { return is; }
#define CL_STRM_EXTRACT_OP(ITEM)                 \
	inline istream& CL_getD                  \
		(istream& is, ITEM *& D)         \
	{                                        \
		if (D) delete D;                 \
	CL_TRY_NEW                               \
		D = new ITEM;                    \
	CL_CATCH_XALLOC(D)                       \
		if (D)                           \
			is >> *D >> nextm;       \
		return is;                       \
	}
#define CL_STRM_EXTRACT_BYTES(ITEM)              \
	inline istream& CL_getD(istream& is,     \
		ITEM *& D)                       \
	{                                        \
	 if (D) delete D;                        \
	CL_TRY_NEW                               \
	 D = new ITEM;                           \
	CL_CATCH_XALLOC(D)                       \
	 if (D)                                  \
	  return is.read((char *)D,sizeof(ITEM));\
	 return is;                              \
	}
#define CL_STRM_EXTRACT_DEF(ITEM)

#define CL_STRM_OPS(ITEM)                        \
	CL_STRM_INSERT_OP(ITEM)                  \
	CL_STRM_EXTRACT_OP(ITEM)
#define CL_STRM_BYTES(ITEM)                      \
	CL_STRM_INSERT_BYTES(ITEM)               \
	CL_STRM_EXTRACT_BYTES(ITEM)
#define CL_STRM_CHAR

#define CL_WELL_ENDOWED(ITEM)                    \
	CL_EQ_GT_OPS(ITEM)                       \
	CL_ASSIGN_OP(ITEM)                       \
	CL_COPYINIT(ITEM)                        \
	CL_STRM_OPS(ITEM)

#define CL_char CL<char>


template <class ITEM>

class CL : public cl {

protected:

	CL  (defaultConstructor)
			: cl(defaultConstruct) {}
	void	 assign(const CL<ITEM>& b)
			{ cl::assign(b); }
	cl::     destruct;
	virtual  voidCmP cmPD(voidCmP cmP)
			{ return CL_cmPD
			(CLcmPcast(cmP,ITEM)); }
	virtual  void * assignD(void * D,
			const void * S)
			{ return CL_assignD
			((ITEM *)D,(const ITEM *)S,
			cl::Flags()); }
	virtual  void * newD(const void * D)
			{ return  CL_newD
			((const ITEM *)D); }
	virtual  void   deleteD(void * D)
			{ CL_deleteD((ITEM *)D); }
	virtual  int    attachD(void * D)
			{ return CL_attachD((ITEM *)D,
			(const void *) this); }
	virtual  void   detachD(void * D)
			{ CL_detachD((ITEM *)D,
			(const void *) this); }
	virtual	 int    putD(ostream& os, void * D)
			{ return (CL_putD(os,(ITEM *)D)
			? 1 : 0); }
	virtual	 void * getD(istream& is)
			{ ITEM * D = 0; CL_getD(is,D);
			return (void *) D; }
	virtual  int    put(ostream& os)
			{ return cl::put(os); }
	virtual  int    get(istream& is)
			{ return cl::get(is); }
	friend   ostream& operator<<
			(ostream& os, CL<ITEM>& b);
	friend   istream& operator>>
			(istream& is, CL<ITEM>& b);
	CL_vforEach_promote

public:

/*  Constructors and destructor  */

	CL (unsigned flags = CL_BIND_ONLY,
		unsigned maxNodes = CL_MAXNODES,
		unsigned limit = CL_LIMIT,
		unsigned delta = CL_DELTA) :
		cl(flags,maxNodes,limit,delta)
		{}
	CL (ITEM * argv[],
		unsigned argc = 0U,
		unsigned flags = CL_BIND_ONLY)
		: cl((void **)argv,argc,flags)
		{}
	CL (CL<ITEM>& b)
		: cl(defaultConstruct)
		{ assign(b); }
	CL<ITEM>& operator=(CL<ITEM>& b)
		{ assign(b); return *this; }
	int     operator==(const CL<ITEM>& b) const
		{ return cl::operator==(b); }
	int     operator> (const CL<ITEM>& b) const
		{ return cl::operator>(b); }
	CL (const char * filename)
		: cl(defaultConstruct)
		{ (void) cl::load(filename); }
	int     load(const char * filename)
		{ return cl::load(filename); }
	int     save(const char * filename)
		{ return cl::save(filename); }
	ITEM ** vector(ITEM ** argv = (ITEM **)0,
		unsigned argc = 0U) const
		{ return (ITEM **)cl::
		vector((void **)argv,argc); }
	virtual ~CL() { destruct(); }

/*  Housekeeping Primitives  */

	cl::    Limit;
	cl::    setLimit;
	cl::    pack;
	cl::    Delta;
	cl::    setDelta;
	cl::    Nodes;
	cl::    MaxNodes;
	cl::    setMaxNodes;
	cl::    vacancy;
	cl::    vacancyNonElastic;
	cl::    Flags;
	cl::    setFlags;
	cl::    resetFlags;
	CL<ITEM>&  operator<<(CL<ITEM>&
			(*manipulator)(CL<ITEM>&))
			{ return (manipulator?
			(*manipulator)
			(*this)	: *this); }

/*  Elastic Array Primitives  */

	ITEM *   atIns(unsigned n, ITEM * D)
			{ return (ITEM *)cl::
			atIns(n,(void *)D); }
	ITEM *   atInsNew(unsigned n, const ITEM * D)
			{ return (ITEM *)cl::
			atInsNew(n,(const void *)D); }
	ITEM *   atRmv(unsigned n)
			{ return (ITEM *)cl::
			atRmv(n); }
	cl::     allRmv;
	cl::     atDel;
	ITEM *   atDelAsg(unsigned n, ITEM * D)
			{ return (ITEM *)cl::
			atDelAsg(n,(void *)D); }
	cl::     allDel;
	cl::     allClr;
	ITEM *   atPut(unsigned n, ITEM * D)
			{ return (ITEM *)cl::
			atPut(n,(void *)D); }
	ITEM *   atPutNew(unsigned n, const ITEM * D)
			{ return (ITEM *)cl::
			atPutNew(n,(const void *)D); }
	ITEM *   atPutAsg(unsigned n, const ITEM * D)
			{ return (ITEM *)cl::
			atPutAsg(n,(const void *)D); }
	ITEM *   atGet(unsigned n) const
			{ return (ITEM *)cl::
			atGet(n); }
	ITEM *   operator[](unsigned n) const
			{ return atGet(n); }
	ITEM *   atGetAsg(unsigned n, ITEM * D)
			{ return (ITEM *)cl::
			atGetAsg(n,(void *) D); }
	ITEM *   atXchg(unsigned n, ITEM * D)
			{ return (ITEM *)cl::
			atXchg(n,(void *) D); }
	unsigned index(const ITEM * D) const
			{ return cl::
			index((const void *)D); }
	CL_forEach_def(ITEM)
	int      detect(ITEM *& D,
			CLdetecT(B,ITEM),
			void * V = 0)
			{ return cl::detect
			((void *&)D,(voidDetecT)B,V); }
	int      detect(unsigned& i,
			CLdetecT(B,ITEM),
			void * V = 0)
			{ return cl::detect
			(i,(voidDetecT)B,V); }
	unsigned select(CL<ITEM>& c,
			CLdetecT(B,ITEM),
			void * V = 0)
			{ return cl::select
			((cl &)c,(voidDetecT)B,V); }
	unsigned reject(CL<ITEM>& c,
			CLdetecT(B,ITEM),
			void * V = 0)
			{ return cl::reject
			((cl &)c,(voidDetecT)B,V); }
	unsigned collect(cl & c,
			CLcollecT(B,ITEM),
			void * V = 0)
			{ return cl::collect
			(c,(voidCollecT)B,V); }

/*  Stack - Deque - Queue Primitives  */

	ITEM *   push(ITEM * D)
			{ return (ITEM *)cl::
			push((void *) D); }
	ITEM *   pushNew(const ITEM * D)
			{ return (ITEM *)cl::
			pushNew((const void *)D); }
	ITEM *   pop()
			{ return (ITEM *)cl::
			pop(); }
	CL<ITEM>&  operator>>(ITEM *& D)
			{ D = atRmv(0U);
			return *this; }
	cl::     popDel;
	ITEM *   popDelAsg(ITEM * D)
			{ return (ITEM *)cl::
			popDelAsg((void *)D); }
	ITEM *   top() const
			{ return (ITEM *)cl::
				top(); }
	ITEM *   topAsg(ITEM * D)
			{ return (ITEM *)cl::
			topAsg((void *)D); }
	ITEM *   insQ(ITEM * D)
			{ return (ITEM *)cl::
			insQ((void *)D); }
	CL<ITEM>&  operator<<(ITEM * D)
			{ atIns(Nodes(),D);
			return *this; }
	ITEM *   insQNew(const ITEM * D)
			{ return (ITEM *)cl::
			insQNew((const void *)D); }
	ITEM *   unQ()
			{ return (ITEM *)cl::
			unQ(); }
	cl::     unQDel;
	ITEM *   unQDelAsg(ITEM * D)
			{ return (ITEM *)cl::
			unQDelAsg((void *)D); }
	ITEM *   rear() const
			{ return (ITEM *)cl::
				rear(); }
	ITEM *   rearAsg(ITEM * D)
			{ return (ITEM *)cl::
			rearAsg((void *)D); }

/*  List (single and double linked) Primitives  */

	cl::     CurNode;
	cl::     setCurNode;
	ITEM *   ins(ITEM * D)
			{ return (ITEM *)cl::
			ins((void *)D); }
	ITEM *   insNew(const ITEM * D)
			{ return (ITEM *)cl::
			insNew((const void *)D); }
	ITEM *   rmv()
			{ return (ITEM *)cl::
			rmv(); }
	cl::     del;
	ITEM *   delAsg(ITEM * D)
			{ return (ITEM *)cl::
			delAsg((void *)D); }
	ITEM *   put(ITEM * D)
			{ return (ITEM *)cl::
			put((void *)D); }
	ITEM *   putNew(const ITEM * D)
			{ return (ITEM *)cl::
			putNew((const void *)D); }
	ITEM *   putAsg(const ITEM * D)
			{ return (ITEM *)cl::
			putAsg((const void *)D); }
	ITEM *   get() const
			{ return (ITEM *)cl::
			get(); }
	operator ITEM *() const { return get(); }
	ITEM *   getAsg(ITEM * D)
			{ return (ITEM *)cl::
			getAsg((void *)D); }
	ITEM *   next()
			{ return (ITEM *)cl::
			next(); }
	ITEM *   operator++()
			{ return next(); }
	ITEM *   nextAsg(ITEM * D)
			{ return (ITEM *)cl::
			nextAsg((void *)D); }
	ITEM *   prev()
			{ return (ITEM *)cl::
			prev(); }
	ITEM *   operator--()
			{ return prev(); }
	ITEM *   prevAsg(ITEM * D)
			{ return (ITEM *)cl::
			prevAsg((void *)D); }

/* Priority Q, Set, Bag, Dictionary, Sort Primitives */

	cl::     Sorted;
	cl::     unSort;
	void     setCmP(CLcmP(cmP,ITEM)
			= CLcmP0(ITEM))
			{ cl::setCmP
			((voidCmP)cmP); }
	CLcmP(CmPfnc,ITEM) { return CLcmPcast
			(cl::CmP(),ITEM); }
	int      sort(CLcmP(cmP,ITEM)
			= CLcmP0(ITEM))
			{ return cl::sort
			((voidCmP)cmP); }
	ITEM *   insSort(ITEM * D)
			{ return (ITEM *)cl::
			insSort((void *)D); }
	ITEM *   insSortNew(const ITEM * D)
			{ return (ITEM *)cl::
			insSortNew((const void *)D); }
	ITEM *   insUnique(ITEM * D)
			{ return (ITEM *)cl::
			insUnique((void *)D); }
	ITEM *   insUniqueNew(const ITEM * D)
			{ return (ITEM *)cl::
			insUniqueNew((const void *)D);}
	ITEM *   findFirst(const ITEM * K,
			cl::RelCmp rc = EQ)
			{ return (ITEM *)cl::
			findFirst((const void *)K,
			rc); }
	ITEM *   operator[](const ITEM * K)
			{ return (ITEM *)cl::
			findFirst((const void *)K); }
	ITEM *   findNext(const ITEM * K, 
			cl::RelCmp rc = EQ)
			{ return (ITEM *)cl::
			findNext((const void *)K,rc); }
	ITEM *   findLast (const ITEM * K,
			cl::RelCmp rc = EQ)
			{ return (ITEM *)cl::
			findLast((const void *)K,
			rc); }
	ITEM *   findPrev(const ITEM * K,
			cl::RelCmp rc = EQ)
			{ return (ITEM *)cl::
			findPrev((const void *)K,rc); }
	unsigned findAll(CL<ITEM>& b,
			const ITEM * K,
			cl::RelCmp rc = EQ)
			{ return cl::findAll
			((cl &)b,(const void *)K,
			rc); }
	unsigned tallyAll(const ITEM * K,
			cl::RelCmp rc = EQ)
			{ return cl::tallyAll
			((const void *)K,
			rc); }


};	/*  class CL  */


template <class ITEM>
inline ostream& operator<<(ostream& os, CL<ITEM>& b)
{ return os << *(cl *)&b; }

template <class ITEM>
inline istream& operator>>(istream& is, CL<ITEM>& b)
{ return is >> *(cl *)&b; }


#endif	/*  !CL_NO_TEMPLATES  */
#endif  /*  cl_h  */
