/*
	This example inspired by:
	
		Allen Mitchell, Moncton, New Brunswick, Canada

	winit.h  --  read/write Windows initialization files

	The file format is modeled after MS Windows  *.ini files:

		[first section]
		parameter=value or values

		[next section]
		parameter=value or values

		...

	Any text must begin in the first column of its line!  If any
	changes are made, the WINIT container is automatically saved
	prior to destruction provided of course the whole WINIT was
	loaded when constructed and not just a section.

*/

#ifndef winit_h
#define winit_h

#include "cl.h"
#ifdef CL_NO_TEMPLATES
	#define ITEM_char
	#include "cl.hf"
#else
	ITEM_char
#endif

#define MAX_SECTION_LENGTH 40
#define MAX_PARAMETER_VALUE_LENGTH 80

class WINIT : CL_char  {
	const char * fname;
	const char * sec;
	int dirty, sectionLength;
	char buf[MAX_SECTION_LENGTH+MAX_PARAMETER_VALUE_LENGTH];
	int setBuf(char * secAndOrParamEq);
	static int sectionParameterCompare(const char * S1, const char * S2);
protected:
	virtual int    put(ostream& os);
	virtual int    get(istream& is);
	char *  get()  { return CL_char::get(); }
public:
	WINIT(const char * fileName, const char * section = 0);
	char * getValue(char * secAndOrParamEq,
		char * defVal = 0);
	char * operator[](char * secAndOrParamEqOptDefVal);
	void setValue(char * secAndOrParamEq, char * value = 0);
	WINIT& operator<<(char * secAndOrParamEqOptAndOrVal);
	~WINIT();
};

#endif // #ifndef winit_h