#include "cl.h"

// Interface Dependencies ---------------------------------------------------

#ifndef __CLSTYPES_H
#include <clstypes.h>
#endif

#ifndef __OBJECT_H
#include <object.h>
#endif

#ifndef __CONTAIN_H
#include <contain.h>
#endif

#ifndef __ARRAY_H
#include <array.h>
#endif

// End Interface Dependencies ------------------------------------------------

// Implementation Dependencies ----------------------------------------------
// End Implementation Dependencies -------------------------------------------

// Member Function //

void Array::add (Object& toAdd)

// Summary -----------------------------------------------------------------
//
//      Adds the given object to the array.
//
// Parameters
//
//      toAdd
//
//      The object we are to add to the array.  Once the object is
//      added, it is owned by the array.
//
// End ---------------------------------------------------------------------
{

// Body Comment
//
//      We search for the first available space for an array element.
//      Since the user may have inserted an element with addAt or
//      with the subscript operator, we check first before overwriting
//      anything.
//
// End

// This one is down to Borland - unless they intended Arrays to be sparse
//
// Reset whereToAdd to zero else new items are only added at the end
// and free slots are not reused. OK until you detach items and then
// try to access what has become a sparse array assuming it to be dense !

	whereToAdd = 0;
	while (whereToAdd <= upperbound &&
			 theArray [whereToAdd] != ZERO) whereToAdd++;
	if (whereToAdd > upperbound) reallocate (whereToAdd - lowerbound + 1);
	theArray [whereToAdd] = &toAdd;
	itemsInContainer++;
}
// End Member Function Array::add //

static char *switches  = "/-";

void CmdLn::expand ()
{
  char drive [MAXDRIVE],
		 dir   [MAXDIR],
		 fname [MAXFILE],
		 ext   [MAXEXT],
		 fn    [MAXPATH],
		 path  [MAXPATH];

	fnsplit (opt,drive,dir,fname,ext);
	fnmerge (path,drive,dir,"","");
	struct ffblk fileBlock;
	int morefiles = !findfirst (opt,&fileBlock,0);
	while (morefiles)
	{
		sprintf (fn,"%s%s%s",drive,dir,fileBlock.ff_name);
		Names->add (*(new nclass (fn)));
		morefiles = !findnext (&fileBlock);
	} // end while more files.
}

void CmdLn::pName ()
{
	if (strchr (opt,'?') || strchr (opt,'*'))
		expand ();
	else
		Names->add (*(new nclass (opt)));
}

void CmdLn::reset ()
{
	clearAll ();
	for (int i = 0; i < _argc; i++)
	{
		opt = _argv [i];						//next possible option cluster
		if (strchr (switches,*opt))		//an option cluster ?
			pCluster ();
		else
			pName ();
	}
}

CmdLn::CmdLn (char *Aoptions)
{
	Options = new Array (10,0,10);
	Names   = new Array (10,0,10);
	Errors  = new Array (10,0,10);
	options = Aoptions;
	nameindex = optionindex = errorindex = 0;
	reset ();
}

CmdLn::~CmdLn ()
{
	clearAll ();
	delete Options;
	delete Names;
	delete Errors;
}

void CmdLn::add (char *Aopt)
{
	char *p1,*p0 = strdup (Aopt);
	p1 = strtok (p0,"\t ");
	while (p1)
	{
		opt = p1;
		if (strchr (switches,*opt))			//an option cluster ?
			pCluster ();
		else
			pName ();
		p1 = strtok(NULL,"\t ");
	}
	delete [strlen (Aopt) + 1] p0;
}

char *CmdLn::getName (int no)
{
	if (no >= 0 && no < Names->getItemsInContainer ())
		return ((nclass&)(*Names) [no]).getName ();
	else
		return NULL;
}

char CmdLn::gOpt (Array *p,int no,char *&optarg)
{
	if (no >= 0 && no < p->getItemsInContainer ())
		return ((oclass&) (*p) [no]).getOption (optarg);
	else
		return CL_ENDOFLIST;
}

char CmdLn::getOption (int no,char *&optarg)
{
	return gOpt (Options,no,optarg);
}

char CmdLn::getError (int no)
{
	char *optarg;
	return gOpt (Errors,no,optarg);
}

void CmdLn::pOption (char *lookup)
{
	coption = new oclass (*opt++);
	if (lookup)
	{
		if (opt && lookup [1] == ':')
		{
			coption->setOptionArg (opt);
			opt += strlen (opt);
		}
		Options->add (*coption);
	}
	else Errors->add (*coption);
}

void CmdLn::pCluster ()
{
	char *lookup;
	opt++;
	pOption (strchr (options,*opt));
	while (*opt && (lookup = strchr (options,*opt))) pOption (lookup);
}

void CmdLn::clearNames ()
{
	int n = Names->getItemsInContainer ();
	for (int i = 0; i < n; i++)
	{
		{	//inner scope forces nclass destructor call
			nclass nc = (nclass&)(*Names) [i];
			Names->detach (nc);
		}
	}
}

void CmdLn::clear (Array *p)
{
	int n = p->getItemsInContainer ();
	for (int i = 0; i < n; i++)
	{
		{	//inner scope forces oclass destructor call
			oclass oc = (oclass&)(*p) [i];
			p->detach (oc);
		}
	}
}

void CmdLn::clearOptions ()
{
	clear (Options);
}

void CmdLn::clearErrors ()
{
	clear (Errors);
}

void CmdLn::clearAll ()
{
	clearNames ();
	clear (Options);
	clear (Errors);
}

void CmdLn::printContentsOn (Rostream os)
{
	int i;
	os << "*** Contents ***" << endl;
	if (numNames ()) os << "*** Names ***" << endl;
	for (i = 0; i < numNames (); i++)
	{
		nclass *nc = &(nclass&)(*Names) [i];
		nc->printOn (os);
	}
	if (numOptions ()) os << "*** Options ***" << endl;
	for (i = 0; i < numOptions (); i++)
	{
		oclass *oc = &(oclass&)(*Options) [i];
		oc->printOn (os);
	}
	if (numErrors ()) os << "*** Errors ***" << endl;
	for (i = 0; i < numErrors (); i++)
	{
		oclass *oc = &(oclass&)(*Errors) [i];
		oc->printOn (os);
	}
	os << "*** End of Contents ***" << endl;
}

