/*  C K U U S 2  --  "User Interface" STRINGS module for Unix Kermit  */
 
/*
 Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET),
 Columbia University Center for Computing Activities.
 First released January 1985.
 Copyright (C) 1985, 1990, Trustees of Columbia University in the City of New 
 York.  Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as it is not sold for profit, provided this
 copyright notice is retained. 
*/
 
/*  This module separates long strings from the body of the ckuser module. */  
 
#include <stdio.h>
#include <ctype.h>
#include "ckcdeb.h"
#include "ckcasc.h"
#include "ckcker.h"
#include "ckuusr.h"
#include "ckcxla.h"
 
#ifndef NOICP
extern char cmdbuf[];
#endif

extern CHAR mystch, stchr, eol, seol, padch, mypadc, ctlq;
extern CHAR *data, *rdatap;
extern char line[], debfil[], pktfil[], sesfil[], trafil[], ttname[];
extern int nrmt, nprm, dfloc, deblog, seslog, local, parity, duplex;
extern int turn, turnch, pktlog, tralog, mdmtyp, flow, cmask, timef, spsizf;
extern int rtimo, timint, srvtim, npad, mypadn, bctr, delay;
extern int maxtry, spsiz, urpsiz, maxsps, maxrps, ebqflg, ebq;
extern int rptflg, rptq, fncnv, binary, pktlog, warn, quiet, fmask, keep;
extern int tsecs, bctu, atcapu, lpcapu, swcapu, sq, rpsiz;
extern int spackets, rpackets, timeouts, retrans, crunched, wmax;
extern int fcharset, tcharset, tslevel;
extern int success, language, nlng;
extern int xxstring();

extern long filcnt, tfc, tlci, tlco, ffc, flci, flco, speed;
extern char *dftty, *versio, *ckxsys;
extern struct langinfo langs[];
extern struct keytab prmtab[];
extern struct keytab remcmd[];
extern struct keytab lngtab[];
extern struct csinfo fcsinfo[], tcsinfo[];
 
/* Some help strings... */

#ifndef NOCMDL
static
char *hlp1[] = {
"\n",
#ifndef NOICP
"Usage: kermit [cmdfile] [-x arg [-x arg]...[-yyy]..] [ = words words ] ]\n",
#else
"Usage: kermit [-x arg [-x arg]...[-yyy]..] [ = words words ] ]\n",
#endif
"  -x is an option requiring an argument, -y an option with no argument:\n",
"     = means ignore following material",
#ifndef NOICP
", but place in array \\&a[]",
#endif
".\nactions:\n",
"  -s files  send files                    -r  receive files\n",
"  -s -      send files from stdin         -k  receive files to stdout\n",
"  -x        enter server mode             -f  finish remote server\n\n",
"  -g files  get remote files from server (quote wildcards)\n",
"  -a name   alternate file name, used with -s, -r, -g\n",
"  -c        connect (before file transfer), used with -l and -b\n",
"  -n        connect (after file transfer), used with -l and -b\n\n",
"settings:\n",
"  -l line   communication line device     -q   quiet during file transfer\n",
"  -j host   network host name             -i   binary file transfer\n",
"  -b bps    line speed, e.g. 1200         -t   half duplex, xon handshake\n",
"  -p x      parity, x = e,o,m,s, or n     -d   log debug info to debug.log\n",
"  -y name   alternate init file name      -w   write over files\n",
"  -e n      receive packet length         -v n window size\n",
"  -z        force foreground            ",
#ifdef SUNX25
"  -o index  X.25 closed user group call   -u  X.25 reverse charge call\n",
#endif /* SUNX25 */
#ifndef NODIAL
"  -m name   modem type\n\n",
#else
"\n\n",
#endif
#ifdef NOICP
"Interactive command parser disabled.\n",
#else
"If no action command is included, enter interactive dialog.\n",
#endif
""
};
 
/*  U S A G E */
 
usage() {
#ifndef MINIX
    conola(hlp1);
#else
    printf("Usage: kermit [-x arg [-x arg]...[-yyy]..] [ = words words ] ]\n");
#endif /* MINIX */
}
#endif /* NOCMDL */

#ifndef NOICP

/*  Help string definitions  */
 
static char *tophlp[] = { 
"Type ? for a list of commands, type HELP x for any command x.",
"While typing commands, you may use the following special characters:\n",
" DEL, RUBOUT, BACKSPACE, CTRL-H: Delete the most recent character typed.",
" CTRL-W:  Delete the most recent word typed.",
" CTRL-U:  Delete the current line.",
" CTRL-R:  Redisplay the current line.",
" ?        (question mark) Display a menu for the current command field.",
" ESC      (or TAB) Attempt to complete the current field.",
" \\        (backslash) include the following character literally",
"          or introduce a variable name or function.\n",
"Command words other than filenames can be abbreviated in most contexts.",
"Commands may be continued onto subsequent lines by ending them with - (dash)",
"and commands may have trailing comments introduced by ; (semicolon).\n",
"From system level, type 'kermit -h' to get help about command line options.",
"" };
 
#ifndef NOHELP

static char *hmxxbye = "Syntax: BYE\n\
Shut down and log out a remote Kermit server";
 
char *hmxxclo[] = {
"Syntax:  CLOSE name",
"Example: CLOSE SESSION\n",
"Close one of the following logs or files:",
"SESSION, TRANSACTION, PACKET, DEBUGGING, READ, WRITE",
"Type HELP LOG and HELP OPEN for further info.", "" };
 
static char *hmxxcon = "Syntax: CONNECT (or C)\n\n\
Connect to a remote computer via the tty device given in the most recent\n\
SET LINE command, or the network host named in the most recent SET HOST\n\
command.  Type Ctrl-\\ followed by C to get back, or followed by ? for help.";
 
static char *hmxxget = "Syntax: GET filespec\n\
Tell the remote Kermit server to send the named file or files.\n\
If theh filespec is omitted, then you are prompted for the remote and\n\
local filenames separately.";
 
static char *hmxxlg[] = { "Syntax: LOG name",
"Record information in a log file:\n",
"DEBUGGING     Debugging information, to help track down bugs in the C-Kermit",
"              program (default log name is debug.log).\n",
"PACKETS       Kermit packets, to help with protocol problems (packet.log)",
"SESSION       Terminal session, during CONNECT command (session.log)",
"TRANSACTIONS  Names and statistics about files transferred (transact.log)",
"" } ;
 
#ifndef NOSCRIPT
static char *hmxxlogi[] = { "\
Syntax: SCRIPT text\n",
"Login to a remote system using the text provided.  The login script",
"is intended to operate similarly to uucp \"L.sys\" entries.",
"A login script is a sequence of the form:\n",
"  expect send [expect send] . . .\n",
"where 'expect' is a prompt or message to be issued by the remote site, and",
"'send' is the names, numbers, etc, to return.  The send may also be the",
"keyword EOT, to send control-d, or BREAK (or \\\\b), to send a break signal.",
"Letters in send may be prefixed by ~ to send special characters.  These are:",
"~b backspace, ~s space, ~q '?', ~n linefeed, ~r return, ~c don\'t",
"append a return, and ~o[o[o]] for octal of a character.  As with some",
"uucp systems, sent strings are followed by ~r unless they end with ~c.\n",
"Only the last 7 characters in each expect are matched.  A null expect,",
"e.g. ~0 or two adjacent dashes, causes a short delay.  If you expect",
"that a sequence might not arrive, as with uucp, conditional sequences",
"may be expressed in the form:\n",
"  -send-expect[-send-expect[...]]\n",
"where dashed sequences are followed as long as previous expects fail.",
"" };
#endif
 
static char *hmxxrc[] = { "Syntax: RECEIVE (or R) [filespec]\n",
"Wait for a file to arrive from the other Kermit, which must be given a",
"SEND command.  If the optional filespec is given, the (first) incoming",
"file will be stored under that name, otherwise it will be stored under",
"the name it arrives with.",
"" } ;
 
static char *hmxxsen = "\
Syntax: SEND filespec [name]\n\n\
Send the file or files specified by filespec.\n\
filespec may contain wildcard characters '*' or '?'.  If no wildcards,\n\
then 'name' may be used to specify the name 'filespec' is sent under; if\n\
'name' is omitted, the file is sent under its own name.";
 
static char *hmssmse = "\
Syntax: MSEND filespec [ filespec [ ... ] ]\n\n\
Send the files specified by the filespecs.  One or more filespecs may be\n\
listed, separated by spaces.  Any or all filespecs may contain wildcards\n\
and they may be in different directories.  An alternate name cannot be given.";

static char *hmxxser = "Syntax: SERVER\n\n\
Enter server mode on the currently selected line.  All further commands\n\
will be taken in packet form from the other Kermit program.  Use FINISH\n\
or BYE to get C-Kermit out of server mode.";
 
static char *hmhset[] = { "\
The SET command is used to establish various communication or file",
"parameters.  The SHOW command can be used to display the values of",
"SET parameters.  Help is available for each individual parameter;",
"type HELP SET ? to see what's available.",
"" } ;
 
static char *hmxychkt[] = { "Syntax: SET BLOCK-CHECK n\n",
"Type of packet block check to be used for error detection, 1, 2, or 3.",
"Type 1 is standard, and catches most errors.  Types 2 and 3 specify more",
"rigorous checking at the cost of higher overhead.",
"" } ;
 
static char *hmxyf[] = { "Syntax: SET FILE parameter value",
"Parameters are:\n",

"TYPE is normally TEXT, with conversion of record format and character set.",
"BINARY means to do no conversion.  Use BINARY for executable programs or",
"binary data.  Example: SET FILE TYPE BINARY.\n",

#ifdef VMS
"For VAX/VMS, two additional types are supported: IMAGE and LABELED.  IMAGE",
"means raw block i/o, no interference from RMS.  LABELED means to send or",
"interpret RMS attributes with the file.\n",
#endif

#ifndef NOCSETS
"CHARACTER-SET: tells the encoding of the local file, ASCII by default.",
"The names DUTCH, GERMAN, FRENCH, etc, refer to 7-bit ASCII-based",
"national replacement character (NRC) sets.  Latin-1 is the 8-bit ISO 8859",
"Latin Alphabet 1.  Type SET FILE CHAR ? for a complete list.\n",
#endif

"BYTESIZE { 7, 8 }: normally 8.  If 7, truncate the 8th bit of all file \
bytes.",

"NAMES are normally CONVERTED to 'common form' during transmission; LITERAL",
"means use filenames literally (useful between like systems).\n",

"COLLISION tells what to do when a file arrives that has the same name as",
"an existing file.  The options are:\n",
"  BACKUP (default) - Rename the old file to a new, unique name and store",
"    the incoming file under its own name.",
"  OVERWRITE - Overwrite (replace) the existing file.",
"  APPEND - Append the incoming file to the end of the existing file.",
"  DISCARD - Refuse and/or discard the incoming file.",
"  RENAME - Give the incoming file a unique name.",
"  UPDATE - Accept the incoming file only if it is newer than the existing",
"    file",
"Example: SET FILE COLLISION UPDATE\n",

#ifdef VMS
"RECORD-LENGTH tells the record length for fixed-format files, or the",
"maximum record length for variable-format files, on systems like VAX/VMS",
"where record-length is a meaningful concept.  Example: SET FILE REC 80\n",
#endif

"DISPLAY is normally ON, causing file transfer progress to be displayed",
"on your screen when in local mode.  SET DISPLAY OFF is useful for",
"allowing local-mode file transfers to proceed in the background.\n",

"WARNING.  SET FILE WARNING is superseded by the newer command, SET FILE",
"COLLISION.  SET FILE WARNING ON is equivalent to SET FILE COLLISION RENAME",
"and SET FILE WARNING OFF is equivalent to SET FILE COLLISION OVERWRITE.\n",

"" };
 
static char *hmxyhsh[] = { "Syntax: SET HANDSHAKE value\n",
"Character to use for half duplex line turnaround handshake during file",
"transfer.  C-Kermit waits for this character from the other computer before",
"sending its next packet.  Default is NONE, others are XON, LF, BELL, ESC,",
"etc.  SET HANDSHAKE CODE <n> lets you specify the numeric ASCII value of the",
"handshake character.  Type SET HANDSH ? for a list.",
"" };



static char *hmhrmt[] = { "\
The REMOTE command is used to send file management instructions to a",
"remote Kermit server.  There should already be a Kermit running in server",
"mode on the other end of the currently selected line.  Type REMOTE ? to",
"see a list of available remote commands.  Type HELP REMOTE x to get",
"further information about a particular remote command 'x'.",
"" } ;

    char *ifhlp[] = { "Syntax: IF [NOT] condition command\n",
"If the condition is (is not) true, do the command.  Only one command may",
"be given, and it must appear on the same line as the IF.  Conditions are:\n",
"  SUCCESS - the previous command succeeded",
"  FAILURE - the previous command failed",
"  DEFINED variablename or macroname - The named variable or macro is defined",
"  COUNT   - subtract one from COUNT, execute the command if the result is",
"            greater than zero (see SET COUNT)",
"  EXIST filename - the named file exists",
"  EQUAL s1 s2 - s1 and s2 (character strings or variables) are equal",
"  LLT s1 s2   - s1 is lexically (alphabetically) less than s2",
"  LGT s1 s1   - s1 is lexically (alphabetically) greater than s2",
"  = n1 n1 - n1 and n2 (numbers or variables containing numbers) are equal",
"  < n1 n2 - n1 is arithmetically less than n2",
"  > n1 n2 - n1 is arithmetically greater than n2\n",
"The IF command may be followed on the next line by an ELSE command. Example:",
"\n  IF < \\%x 10 ECHO It's less",
"  ELSE echo It's not less",
"" };

char *ifxhlp[] = { "\
Syntax: XIF condition { commandlist } [ ELSE { commandlist } ]\n",
"Extended IF command.  The conditions are the same as for IF (type HELP IF)",
"but multiple comma-separated commands may be grouped within braces in both", 
"the IF and ELSE parts.  The ELSE part, if any, must be on the same line as",
"the XIF (or use dash for line continuation).  Example:\n",
"  XIF equal \\%a YES { echo OK, goto begin } ELSE { echo Not OK, stop }",
"" };

char *forhlp[] = { "\
Syntax: FOR variablename initial-value final-value increment { commandlist }",
"\nFOR loop.  Execute the comma-separated commands in the commandlist the",
"number of times given by the initial value, final value and increment.",
"Example:  FOR \\%i 10 1 -1 { pause 1, echo \\%i }", "" };

char *openhlp[] = {
"Syntax:  OPEN mode filename\n",
"For use with READ and WRITE commands.  Open the local file in the specified",
"mode: READ, WRITE, or APPEND.  !READ and !WRITE mean to read from or write",
"to a system command rather than a file.  Examples:\n",
"  OPEN READ oofa.txt",
"  OPEN !READ sort foo.bar",
"" };

char *hxxaskq[] = {
"Syntax:  ASKQ variablename prompt",
"Example: ASKQ %p Password:\n",
"Issues the prompt and defines the variable to be whatever you type in.",
"The characters that you type do not echo on the screen.", "" };

char *hxxdef[] = {
"Syntax: DEFINE name [ definition ]\n",
"Defines a macro or variable.  Its value is the definition, taken literally.",
"No expansion or evaluation of the definition is done.  Thus if the", 
"definition includes any variable or function references, their names are",
"included, rather than their values (compare with ASSIGN).  If the definition",
"is omitted, then the named variable or macro is undefined.\n",
"A typical macro definition looks like this:\n",
"  DEFINE name command, command, command, ...\n",
"for example:\n",
"  DEFINE vax set parity even, set duplex full, set flow xon/xoff\n",
"which defines a Kermit command macro called 'vax'.  The definition is a",
"comma-separated list of Kermit commands.  Use the DO command to execute",
"the macro, or just type its name, followed optionally by arguments.\n",
"The definition of a variable can be anything at all, for example:\n",
"  DEFINE \\%a Monday",
"  DEFINE \\%b 3\n",
"These variables can be used almost anywhere, for example:\n",
"  ECHO Today is \\%a",
"  SET BLOCK-CHECK \\%b",
"" };

char *hxxass[] = {
"Syntax:  ASSIGN variablename string.",
"Example: ASSIGN \\%a My name is \\%b.\n",
"Assigns the current value of the string to the variable (or macro).",
"The definition string is fully evaluated before it is assigned, so that",
"the values of any variables are contained are used, rather than their",
"names.  Compare with DEFINE.  To illustrate the difference, try this:\n",
"  DEFINE \\%a hello",
"  DEFINE \\%x \\%a",
"  ASSIGN \\%y \\%a",
"  DEFINE \\%a goodbye",
"  ECHO \\%x \\%y\n",
"This will print 'goodbye hello'.", "" };

char *hxxdec[] = {
"Syntax: DECREMENT variablename [ number ]\n",
"Decrement (subtract one from) the value of a variable if the current value",
"is numeric.  If the number argument is given, subtract that number instead.",
"\nExamples: DECR \\%a, DECR \\%a 7, DECR \\%a \\%n", "" };

char *hxxinc[] = {
"Syntax: INCREMENT variablename [ number ]\n",
"Increment (add one to) the value of a variable if the current value is",
"numeric.  If the number argument is given, add that number instead.\n",
"Examples: INCR \\%a, INCR \\%a 7, INCR \\%a \\%n", "" };

#ifdef SUNX25
char *hxxpad[] = {
"Syntax: PAD command",
"Execute a PAD command. Examples:\n",
"    PAD clear - clear the virtual call",
"    PAD status - return the status of virtual call",
"    PAD reset - send a reset packet",
"    PAD interrupt - send an interrupt packet", ""};
#endif /* SUNX25 */

char *hxxpau[] = {
"Syntax:  PAUSE [ number ]",
"Example: PAUSE 3\n",
"Do nothing for the specified number of seconds; if no number given, one",
"second.  If interrupted from the keyboard, set FAILURE, otherwise SUCCESS.",
"" };

char *hxxshe[] = {
"Syntax: ! [ command ] or RUN [ command ] or PUSH [ command ]\n",
"Give a command to the local operating system's command processor, and",
"display the results on the screen.\n",
"If the command is omitted, enter interactive mode; return to Kermit",
"by exiting from the system's command parser.  The command is usually",
"EXIT or QUIT or LOGOUT.",  "" };

char *hxxxmit[] = {
"Syntax: TRANSMIT file number\n",
"The TRANSMIT command is used for sending single files to other computers",
"that don't have Kermit.  Text files are sent a line at a time; binary files",
"are sent a character at a time.  There is no guarantee that the other",
"computer will receive the file correctly and completely.  Before you start",
"the TRANSMIT command, you must put the other computer in data collection",
"mode, for example by starting a text editor.  The number parameter specifies",
"the ASCII value of the character to wait for from the other computer before",
"sending the next line; it is linefeed (10) by default when FILE TYPE is",
"TEXT.  Specify 0 for no waiting.  TRANSMIT may be interrupted by Ctrl-C.",
"" };

#ifndef NOCSETS
char *hxxxla[] = {
"Syntax: TRANSLATE file1 file2\n",
"Translates file1 from the character set named in the most recent",
"SET FILE CHARACTER-SET command into the character set named in the most",
"recent SET TRANSFER CHARACTER-SET command, storing the result in file2.",
"" };
#endif

char *hxxwai[] = {
"Syntax:  WAIT number [modem-signal(s)]",
"Example: WAIT 5 \\cd\\cts\n",
"Waits up to the given number of seconds for all of the specified signals.",
"Sets FAILURE if signals do not appear in given time or if interrupted by",
"typing anything at the keyboard during the waiting period.\n",
"Signals: \\cd = Carrier Detect, \\dsr = Dataset Ready, \\cts = Clear To Send",
"Warning: This command does not work yet, signals are ignored.", "" };

char *hxxwri[] = {
"Syntax: WRITE name text\n",
"Writes the given text to the named log or file.  The text text may include",
"backslash codes, and is not terminated by a newline unless you include the",
"appropriate code.  The name parameter can be any of the following:\n",
"  DEBUG-LOG",
"  FILE (the OPEN WRITE, OPEN !WRITE, or OPEN APPEND file, see HELP OPEN)",
"  PACKET-LOG",
"  SCREEN (compare with ECHO)",
"  SESSION-LOG",
"  TRANSACTION-LOG", "" };

#ifndef NODIAL
char *hxxdial[] = { "Syntax:  DIAL phonenumber",
"Example: DIAL 7654321\n",
"Dial a number using a modem autodialer.  First you must SET MODEM, then",
"SET LINE and SET SPEED.  Then give the DIAL command, including the phone",
"number.  See also SET MODEM, SET LINE, SET SPEED.", "" };
#endif /* NODIAL */

#endif /* NOHELP */

/*  D O H L P  --  Give a help message  */
 
dohlp(xx) int xx; {
    int x,y;
 
    if (xx < 0) return(xx);
    switch (xx) {
 
#ifdef NOHELP

case XXHLP:
    return(hmsga(tophlp));
 
#else /* help is available */

case XXASS:				/* assign */
    return(hmsga(hxxass));

case XXASK:				/* ask */
    return(hmsg("\
Syntax:  ASK variablename prompt\n\
Example: ASK \\%n What is your name\\63\\32\n\n\
Issues the prompt and defines the variable to be whatever you type in."));

case XXASKQ:
    return(hmsga(hxxaskq));

case XXBUG:
    return(hmsg("Describe how to report C-Kermit bugs."));

case XXBYE:				/* bye */
    return(hmsg(hmxxbye));
 
case XXCLE:				/* clear */
    return(hmsg("\
Syntax: CLEAR\n\
Clear the serial port input buffer."));

case XXCLO:				/* close */
    return(hmsga(hmxxclo));
 
case XXCOM:				/* comment */
    return(hmsg("\
Syntax: COMMENT text\n\
Example: COMMENT - this is a comment.\n\n\
Introduce a comment.  Beginning of command line only.  Commands may also\n\
have trailing comments, introduced by ; (semicolon)."));

case XXCON:				/* connect */
    return(hmsg(hmxxcon));
 
case XXCWD:				/* cd / cwd */
#ifdef vms
    return(hmsg("Syntax: CD [ directory or device:directory ]\n\
Change Working Directory, equivalent to VMS SET DEFAULT command"));
#else
#ifdef datageneral
    return(hmsg("Change Working Directory, equivalent to DG 'dir' command"));
#else
#ifdef OS2
   return(hmsg("Change Working Directory, equivalent to OS2 'chdir' command"));
#else
    return(hmsg("Syntax: CD [ directoryname ]\n\n\
Change Working Directory, equivalent to UNIX cd command."));
#endif
#endif
#endif
 
case XXDCL:
    return(hmsg("Syntax:  DECLARE arrayname[size]\n\
Example: DECLARE \\&a[20]\n\n\
Declares an array of the given size.  Array elements can be used just like\n\
any other variables."));

case XXDEF:				/* define */
    return(hmsga(hxxdef));

case XXDEL:				/* delete */
    return(hmsg("Syntax: DELETE filespec\n\n\
Delete a local file or files.  RM is a synonym for DELETE."));
 
#ifndef NODIAL
case XXDIAL:				/* dial */
    return(hmsga(hxxdial));
#endif
 
case XXDIR:				/* directory */
    return(hmsg("Syntax: DIRECTORY [ filespec ]\n\
Display a directory listing of local files."));
 
case XXDIS:
    return(hmsg("Syntax: DISABLE command\n\n\
Security for the C-Kermit server.  Prevent the client Kermit program from\n\
executing the named REMOTE command, such as CD, DELETE, RECEIVE, etc."));

case XXDO:				/* do */
    return(hmsg("Syntax: [ DO ] macroname [ arguments ]\n\n\
Execute a macro that was defined by the DEFINE command.  The word DO\n\
can be omitted.  Trailing argument words, if any, are automatically\n\
assigned to the macro argument variables \\%1, \\%2, etc."));

case XXDEC:
    return(hmsga(hxxdec));

case XXECH:				/* echo */
    return(hmsg("Syntax: ECHO text\n\
Display the text on the screen, followed by a newline.  The ECHO text may\n\
contain backslash codes.  Example: ECHO \\7Wake up!\\7")); 
 
case XXENA:
    return(hmsg("Syntax: ENABLE capability\n\n\
For use with server mode.  Allow the client Kermit program access to the\n\
named capability, such as CD, DELETE, RECEIVE, etc.  Opposite of DISABLE."));

case XXEND:				/* end */
    return(hmsg("Syntax: END\n\
Exit from the current macro or TAKE file, back to wherever invoked from."));

case XXERR:				/* error */
    return(hmsg("Syntax: ERROR\n\
Send an Error packet to the other Kermit."));

case XXEXI:				/* exit */
case XXQUI:
    return(hmsg("Syntax: QUIT (or EXIT)\n\
Exit from the Kermit program, closing all open files and devices."));
 
case XXFIN:
    return(hmsg("Syntax: FINISH\n\
Tell the remote Kermit server to shut down without logging out."));
 
case XXFOR:
    return(hmsga(forhlp));

case XXGET:
    return(hmsg(hmxxget));
 
case XXGOTO:
    return(hmsg("Syntax: GOTO label\n\
In a TAKE file or macro, go to the given label.  A label is a word on the\n\
left margin that starts with a colon (:).  Example:\n\n\
:oofa\n\
echo Hello!\n\
goto oofa"));

case XXHAN:
    return(hmsg("Syntax: HANGUP\n\
Hang up the phone or network connection."));    

case XXHLP:
    return(hmsga(tophlp));

case XXIF:
    return(hmsga(ifhlp));

case XXINC:
    return(hmsga(hxxinc));

case XXINP:
   return(hmsg("\
Syntax:  INPUT n text\n\
Example: INPUT 5 Login:\n\n\
Wait up to n seconds for the given text to arrive on the communication line.\n\
For use in script programs with IF FAILURE and IF SUCCESS."));

case XXREI:
    return(hmsg("Syntax: REINPUT n string\n\n\
Look for the string in the text that has recently been INPUT, set SUCCESS\n\
or FAILURE accordingly.  Timeout, n, must be specified but is ignored."));

case XXREN:
    return(hmsg("Syntax: RENAME oldname newname\n\n\
Change the name of file 'oldname' to 'newname'."));

case XXLBL:
    return(hmsg("\
Introduce a label, like :loop, for use with GOTO in TAKE files or macros.\n\
See GOTO."));

case XXLOG:
    return(hmsga(hmxxlg));
 
#ifndef NOSCRIPT
case XXLOGI:
    return(hmsga(hmxxlogi));
#endif
 
case XXMAI:
    return(hmsg("Syntax: MAIL filename address\n\n\
Send the file to the remote Kermit, which must be in RECEIVE or SERVER mode,\n\
and request that the remote host deliver the file as electronic mail to the\n\
given address.  Example: MAIL BUG.TXT KERMIT@CUVMA"));

case XXMSE:
    return(hmsg(hmssmse));

case XXOPE:
    return(hmsga(openhlp));

case XXOUT:
    return(hmsg("Syntax: OUTPUT text\n\n\
Send the text out the currently selected line, as if you had typed it\n\
during CONNECT mode.  The text may contain backslash codes.  Example:\n\n\
  OUTPUT help\\13"));

#ifdef SUNX25
case XXPAD:
    return(hmsga(hxxpad));
#endif /* SUNX25 */

case XXPAU:
    return(hmsga(hxxpau));

case XXPWD:
    return(hmsg("Syntax: PWD\n\
Print the name of the current working directory."));

case XXREA:
    return(hmsg("Syntax: READ variablename\n\
Read a line from the currently open READ or !READ file into the variable\n\
(see OPEN)."));

case XXREC:
    return(hmsga(hmxxrc));
 
case XXREM:
    if ((y = cmkey(remcmd,nrmt,"Remote command","",xxstring)) == -2) return(y);
    if (y == -1) return(y);
    if ((x = cmcfm()) < 0) return(x);
    return(dohrmt(y));
 
case XXRET:
    return(hmsg("Syntax: RETURN [ value ]\n\
Return from a macro.  An optional return value can be given for use with\n\
with \\fexecute(macro), which allows macros to be used like functions."));
case XXSEN:
    return(hmsg(hmxxsen));
 
case XXSER:
    return(hmsg(hmxxser));
 
case XXSET:
    y = cmkey(prmtab,nprm,"Parameter","",xxstring);
    if (y == -3) return(dohset(y));
    if (y < 0) return(y);
    if ((x = cmcfm()) < 0) return(x);
    return(dohset(y));
 
case XXSHE:
    return(hmsga(hxxshe));
 
case XXSHO:
    return(hmsg("\
Display current values of various items (SET parameters, variables, etc).\n\
Type SHOW ? for a list of categories."));
 
case XXSPA:
#ifdef datageneral
    return(hmsg("\
Display disk usage in current device, directory,\n\
or return space for a specified device, directory."));
#else
    return(hmsg("Syntax: SPACE\n\
Display disk usage in current device and/or directory"));
#endif
 
case XXSTA:
    return(hmsg("Syntax: STATISTICS\n\
Display statistics about most recent file transfer"));
 
case XXSTO:
    return(hmsg("Syntax: STOP\n\
Stop executing the current macro or TAKE file and return immediately\n\
to the C-Kermit prompt."));

case XXTAK:
    return(hmsg("Syntax: TAKE filename\n\
Take Kermit commands from the named file.  Kermit command files may\n\
themselves contain TAKE commands, up to a reasonable depth of nesting."));
 
case XXTRA:
    return(hmsga(hxxxmit));

case XXTYP:
    return(hmsg("Syntax: TYPE file\n\
Display a file on the screen.  Pauses if you type Ctrl-S, resumes if you\n\
type Ctrl-Q, returns immediately to C-Kermit prompt if you type Ctrl-C."
));

#ifndef NOCSETS
case XXXLA:
    return(hmsga(hxxxla));
#endif

case XXVER:
    return(hmsg("Syntax: VERSION\nDisplays the program version number."));

case XXWAI:
    return(hmsga(hxxwai));

case XXWRI:
    return(hmsga(hxxwri));

case XXIFX:
    return(hmsga(ifxhlp));

#endif

default:
    if ((x = cmcfm()) < 0) return(x);
    printf("Help not available - %s\n",cmdbuf);
    break;
    }
    return(success = 0);
}

 
/*  H M S G  --  Get confirmation, then print the given message  */
 
hmsg(s) char *s; {
    int x;
    if ((x = cmcfm()) < 0) return(x);
    printf("\n%s\n\n",s);
    return(0);
}
 
hmsga(s) char *s[]; {			/* Same function, but for arrays */
    int c, x, y, i, j, k, n;
    if ((x = cmcfm()) < 0) return(x);

    printf("\n");			/* Start off with a blank line */
    n = 1;				/* Line counter */
    for ( i = 0; *s[i] ; i++ ) {
	printf("%s\n",s[i]);		/* Print a line. */
        y = strlen(s[i]);
        k = 1;
        for (j = 0; j < y; j++)		/* See how many newlines were */
          if (s[i][j] == '\n') k++;	/* in the string... */
        n += k;
	if (n > 21) {			/* After a screenful, give them */
askagain:				/* a chance to read it */
	    printf("more? ");		/* or quit */
	    c = getchar();	
	    switch (c) {
	      case 'n':
	      case 'N':
		putchar(NL);
		return(-1);
	      case SP:
	      case CR:
	      case 'y':
	      case 'Y':
                printf("\r      \r");
	      case NL:
		n = 0;
		break;
	      case 077:
		printf("Y or space-bar for yes, N for no\n");
		goto askagain;
	      default:
		putchar(NL);
		return(0);
	    }
	}
    }
    printf("\n");
    return(0);
}

#ifndef NOHELP

char *hsetxmit[] = {
"Syntax: SET TRANSMIT parameter value\n",
"Controls the behavior of the TRANSMIT command, used for uploading files",
"to computers that don't have Kermit programs.  Parameters are:\n",
"EOF text:        Text to send after end of file is reached.",
"FILL number:     ASCII value of character to insert into blank lines.",
"LINEFEED ON/OFF: Transmit LF as well as CR at the end of each line.",
"                 Normally, only CR is sent.",
"PROMPT number:   ASCII value of character to look for from host before",
"                 sending next line, normally LF (10).",
"" };

char *hsetbkg[] = {
"Syntax: SET BACKGROUND { OFF, ON }\n",
"SET BACKGROUND OFF forces prompts and messages to appear on your screen",
"even though Kermit thinks it is running in the background.", "" };

char *hsetbuf[] = {
"Syntax: SET BUFFERS n1 n2\n",
"Change the overall amount of memory allocated for SEND and RECEIVE packet",
"buffers, respectively.  Bigger numbers let you have longer packets and more",
"window slots", "" };

char *hsetcmd[] = {
"Syntax: SET COMMAND BYTESIZE { 7, 8 }\n",
"SET COMMAND BYTE 8 allows you to use an 8-bit (international) character set",
"in the commands you type at the C-Kermit> prompt.  7 is the default.", "" };

char *hsetcar[] = {
"Syntax: SET CARRIER ON, AUTO, or OFF\n",
"Attempts to control treatment of carrier on the communication device.",
"ON means that carrier is required at all times except during the DIAL",
"command.  OFF means that carrier is never required.  AUTO (the default)",
"means that carrier is required only during CONNECT.", "" };

char *hsetat[] = {
"Syntax: SET ATTRIBUTES name ON or OFF\n",
"Use this command to enable (ON) or disable (OFF) the transmission of",
"selected file attributes along with each file, and to handle or ignore",
"selected incoming file attributes, including:\n",
"  CHARACTER-SET:  The transfer character set for text files",
"  DATE:           The file's creation date",
"  DISPOSITION:    Unusual things to do with the file, like MAIL or PRINT",
"  LENGTH:         The file's length",
"  SYSTEM-ID:      Machine/Operating system of origin",
"  TYPE:           The file's type (text or binary)\n",
"You can also specify ALL to select all of them.  Examples:\n",
"  SET ATTR DATE OFF\n  SET ATTR SIZE ON\n  SET ATTR ALL OFF", ""
};

char *hxxinp[] = {
"Syntax: SET INPUT parameter value\n",
"The SET INPUT command controls the behavior of the INPUT command:\n",
"SET INPUT CASE { IGNORE, OBSERVE }",
"Tells whether alphabetic case is to be significant in string comparisons.\n",
"SET INPUT DEFAULT-TIMEOUT secs",
"Establishes default timeout for INPUT commands.  Currently has no effect.\n",
"SET INPUT ECHO { ON, OFF }",
"Tells whether to display arriving characters read by INPUT on the screen.\n",
"SET INPUT TIMEOUT-ACTION { PROCEED, QUIT }",
"Tells whether to proceed or quit from a script program if an INPUT command",
"fails.  PROCEED (default) allows use of IF SUCCESS and IF FAILURE commands.",
"" };

char *hxytak[] = {
"Syntax: SET TAKE parameter value\n",
"Controls behavior of TAKE command.\n",
"SET TAKE ECHO { ON, OFF } tells whether commands read from a TAKE file",
"should be displayed on the screen.\n",
"SET TAKE ERROR { ON, OFF } tells whether a TAKE command file should be",
"automatically terminated when a command fails.", "" };

char *hxyhost[] = {
"Syntax:  SET HOST hostname-or-number\n",
"Select a network host.  Use this command instead of SET LINE.",
"After SET HOST give the host name or number.  TCP/IP Examples:\n",
"  SET HOST watsun.cc.columbia.edu",
"  SET HOST 128.59.39.2",
"" };

char *hxynet[] = {
"Syntax: SET NETWORK network-type\n",
#ifdef SUNX25
"Select TCP/IP or X.25 network communication.",
#else
"Select TCP/IP network communication.",
#endif
"After SET NETWORK give the type of network to use. Examples:\n",
"  SET NETWORK tcp/ip",
#ifdef SUNX25
"  SET NETWORK x.25",
#endif
""};
 
char *hxymacr[] = {
"Syntax: SET MACRO parameter value\n",
"Controls the behavior of macros.\n",
"SET MACRO ECHO { ON, OFF } tells whether commands executed from a macro",
"definition should be displayed on the screen.\n",
"SET MACRO ERROR { ON, OFF } tells whether a macro should be automatically",
"terminated upon a command error.", "" };

char *hxymodm[] = {
"Syntax: SET MODEM-DIALER name [ { CHANGES-SPEED, MATCHES-SPEED } ]\n",
"Type of modem for dialing remote connections.  Indicates that modem can",
"be commanded to dial without Carrier Detect signal from modem, and selects",
"the appropriate dialing protocol to be used by the DIAL command.  Many modem",
"models are supported.  Type SET MODEM ? for a list.  DIRECT or NONE means",
"a direct connection, with no modem at all.  The field after the modem name",
"tells whether the modem does speed matching.  Kermit assumes it does not.",
"If it does, include MATCHES-SPEED after the modem name.", "" };

char *hmxyprm[] = {
"Syntax: SET PROMPT [ text ]\n",
"Prompt text for this program, normally 'C-Kermit>'.  May contain backslash",
"codes for special effects.  Surround by { } to preserve leading or trailing",
"spaces.  If text omitted, prompt reverts to C-Kermit>.",
"" };

char *hxywind[] = {
"Syntax: SET WINDOW number\n",
"Specify number of window slots for sliding windows, the number of packets",
"that can be transmitted before pausing for acknowledgement.  The default",
"is one, the maximum is 31.  Increased window size may result in reduced",
"maximum packet length.  Use sliding windows for improved efficiency on",
"connections with long delays.  Give the SET WINDOW command to both Kermits.",
"" };

char *hxysr[] = {
"END-OF-PACKET number",
"ASCII value of control character, normally 13 (carriage return).\n",
"PACKET-LENGTH number",
"2000 or less.\n",
"PADDING number",
"number of prepacket padding characters, 94 or less (rarely used).\n",
"PAD-CHARACTER number",
"ASCII value of control character to use for padding (typically 0).\n",
"START-OF-PACKET number",
"ASCII value of control character to mark start of packet (normally 1).\n",
"TIMEOUT number",
"Number of seconds to wait for a packet before sending NAK or retransmitting",
"(94 seconds or less)", "" };

#ifndef NOCSETS
char *hxyxfer[] = {
"Syntax: SET TRANSFER CHARACTER-SET name\n",
"Select the character set used to represent textual data in Kermit packets.",
"Text characters are translated to/from the FILE CHARACTER-SET.",
"The choices are TRANSPARENT (no translation, the default), ASCII,",
"LATIN1 (ISO Latin Alphabet 1), and CYRILLIC (ISO Latin/Cyrillic).", "" };
#endif

/*  D O H S E T  --  Give help for SET command  */
 
dohset(xx) int xx; {
    
    if (xx == -3) return(hmsga(hmhset));
    if (xx < 0) return(xx);
    switch (xx) {
 
case XYATTR:
    return(hmsga(hsetat));

case XYBACK:
    return(hmsga(hsetbkg));

case XYBUF:
    return(hmsga(hsetbuf));

case XYCARR:
    return(hmsga(hsetcar));

case XYCMD:
    return(hmsga(hsetcmd));

case XYIFD:
    return(hmsg("Syntax: SET INCOMPLETE { DISCARD, KEEP }\n\
Discard or Keep incompletely received files, default is DISCARD."));

case XYINPU:
    return(hmsga(hxxinp));

case XYCHKT:
    return(hmsga(hmxychkt));
 
case XYCOUN:
    return(hmsg("Syntax:  SET COUNT number\n\
Example: SET COUNT 5\n\
Set up a loop counter, for use with IF COUNT."));

case XYDFLT:
    return(hmsg("Syntax: SET DEFAULT directory\n\
Change directory.  Equivalent to CD command."));

case XYDELA: 
    return(hmsg("Syntax: SET DELAY number\n\
Number of seconds to wait before sending first packet after SEND command."));
 
case XYDIAL:
    return(hmsg("Syntax: SET DIAL HANGUP {ON, OFF}\n\
Whether the DIAL command should hang up the phone before dialing."));

case XYTAKE:
    return(hmsga(hxytak));

case XYTERM:
#ifdef OS2
    return(hmsg("\
SET TERMINAL BYTESIZE 7 or 8, to use 7- or 8-bit terminal characters\n\
during CONNECT.\n\
SET TERMINAL VT100 or TEK4014, to set terminal emulation mode.\n"));
#else
    return(hmsg("\
SET TERMINAL BYTESIZE 7 or 8, to use 7- or 8-bit terminal characters\n\
during CONNECT."));
#endif /* OS2 */

case XYDUPL:
    return(hmsg("Syntax: SET DUPLEX { FULL, HALF }\n\n\
During CONNECT: FULL means remote host echoes, HALF means C-Kermit\n\
does its own echoing."));
 
case XYESC:
    return(hmsg("Syntax: SET ESCAPE number\n\n\
Decimal ASCII value for escape character during CONNECT, normally 28\n\
(Control-\\).  Type the escape character followed by C to get back to the\n\
C-Kermit prompt."));
 
case XYFILE:
    return(hmsga(hmxyf));
 
case XYFLOW:
    return(hmsg("Syntax: SET FLOW value\n\
Type of flow control to be used during file transfer.\n\
The choices are XON/XOFF (default) and NONE."));
 
case XYHAND:
   return(hmsga(hmxyhsh));

#ifdef NETCONN
case XYHOST:
return(hmsga(hxyhost));
#ifdef SUNX25
case XYNET:
return(hmsga(hxynet));
case XYX25:
    return(hmsg("Syntax: SET X.25 call-option on index/off\n\
Set X.25 call option. Options are :\n\
   closed-user-group on index/off - to enable/disable closed user group call\n\
      where index is the group index and can range from 0 to 99\n\
   reverse-charge on/off - to enable/disable reverse charge call."));
case XYPAD:
    return(hmsg("Syntax: SET PAD name value\n\
Set a PAD X.3 parameter with a desired value."));
#endif /* SUNX25 */ 
#endif /* NETCONN */

#ifndef NOCSETS
case XYLANG:
    return(hmsg("Syntax: SET LANGUAGE name\n\
Selects language-specific translation rules for text-mode file transfers.\n\
Used with SET FILE CHARACTER-SET and SET TRANSFER CHARACTER-SET."));
#endif

case XYLINE:
    printf("\nSyntax: SET LINE devicename\n\n\
Select communication device to use.  Normally %s.\n",dftty);
    if (!dfloc) {
	printf("\
If you SET LINE to other than %s, then Kermit\n",dftty);
	printf("\
will be in 'local' mode; SET LINE alone will reset Kermit to remote mode.\n\
To use the modem to dial out, first SET MODEM-DIALER (e.g., to HAYES), then");
puts("\nSET LINE xxx, next issue the DIAL command, and finally CONNECT.\n");
    }
    return(0);
 
case XYMACR:
    return(hmsga(hxymacr));

case XYMODM:
    return(hmsga(hxymodm));
 
case XYPARI:
    return(hmsg("Syntax: SET PARITY name\n\n\
Parity to use during terminal connection and file transfer: EVEN, ODD, MARK,\n\
SPACE, or NONE.  Normally NONE."));
 
case XYPROM:
    return(hmsga(hmxyprm));
 
case XYRETR:
    return(hmsg("Syntax: SET RETRY number\n\n\
How many times to retransmit a particular packet before giving up."));

#ifdef UNIX
case XYSESS:
    return(hmsg("Syntax: SET SESSION-LOG { BINARY, TEXT }\n\n\
If BINARY, record all CONNECT characters in session log.  If TEXT, strip\n\
out carriage returns."));
#endif /* UNIX */

case XYSPEE:
    return(hmsg("Syntax: SET SPEED number\n\n\
Communication line speed for external tty line specified in most recent\n\
SET LINE command, in bits per second.  Type SET SPEED ? for a list of\n\
possible speeds."));

case XYRECV:
case XYSEND:
    if (xx == XYRECV)
      puts("\nSyntax: SET RECEIVE parameter value\n\n\
Specify parameters for inbound packets:");
    else puts("\nSyntax: SET SEND parameter value\n\n\
Specify parameters for outbound packets.  This command should be used only\n\
to override the normal negotiated parameters.");
    return(hmsga(hxysr));
 
case XYSERV:
    return(hmsg("Syntax: SET SERVER TIMEOUT number\n\
Server command wait timeout interval, how often the C-Kermit server issues\n\
a NAK while waiting for a command packet.  Specify 0 for no NAKs at all."));

case XYXMIT:
    return(hmsga(hsetxmit));

#ifndef NOCSETS
case XYUNCS:
    return(hmsg("Syntax: SET UNKNOWN-CHARACTER-SET action\n\n\
DISCARD (default) means reject any arriving files encoded in unknown\n\
character sets.  KEEP means to accept them anyway."));
#endif

#ifdef UNIX
case XYWILD:
    return(hmsg("Syntax: SET WILDCARD-EXPANSION { KERMIT, SHELL }\n\n\
KERMIT (the default) means C-Kermit expands filename wildcards in SEND\n\
and MSEND commands and incoming GET commands.  SHELL means your shell does \
it."));
#endif

case XYWIND:
    return(hmsga(hxywind));

#ifndef NOCSETS
case XYXFER:
    return(hmsga(hxyxfer));
#endif

default:
    printf("Not available yet - %s\n",cmdbuf);
    return(0);
    }
}

 
/*  D O H R M T  --  Give help about REMOTE command  */
 
char *hrset[] = {
"Syntax:  REMOTE SET parameter value",
"Example: REMOTE SET FILE TYPE BINARY\n",
"Ask the remote Kermit server to set the named parameter to the given value.",
"Equivalent to typing the corresponding SET command directly to the other",
"Kermit if it were in interactive mode.", "" };

dohrmt(xx) int xx; {
    int x;
    if (xx == -3) return(hmsga(hmhrmt));
    if (xx < 0) return(xx);
    switch (xx) {
 
case XZCWD:
    return(hmsg("Syntax: REMOTE CD [ name ]\n\n\
Ask remote Kermit server to change its working directory or device.\n\
If the device or directory name is omitted, restore the default."));
 
case XZDEL:
    return(hmsg("Syntax: REMOTE DELETE filespec\n\n\
Ask the remote Kermit server to delete the named file(s)."));
 
case XZDIR:
    return(hmsg("Syntax: REMOTE DIRECTORY [ filespec ]\n\n\
Ask the remote Kermit server to provide a directory listing of the named\n\
file(s) or if no file specification is given, of all files in the current\n\
directory."));
 
case XZHLP:
    return(hmsg("Syntax: REMOTE HELP\n\n\
Ask the remote Kermit server to list the services it provides."));
 
case XZHOS:
    return(hmsg("Syntax: REMOTE HOST command\n\n\
Send a command to the remote host computer in its own command language\n\
through the remote Kermit server."));
 
case XZPRI:
    return(hmsg("Syntax: REMOTE PRINT filespec [ options ]\n\n\
Send the specified file(s) to the remote Kermit and ask it to have the\n\
file printed on the remote system's printer, using any specified options."));

case XZSET:
    return(hmsga(hrset));

case XZSPA:
    return(hmsg("Syntax: REMOTE SPACE [ name ]\n\n\
Ask the remote Kermit server to tell you about its disk space on the current\n\
disk or directory, or in the one that you name."));
 
case XZTYP:
    return(hmsg("Syntax: REMOTE TYPE file\n\n\
Ask the remote Kermit server to type the named file(s) on your screen."));
 
case XZWHO:
    return(hmsg("Syntax: REMOTE WHO [ name ]\n\n\
Ask the remote Kermit server to list who's logged in, or to give information\n\
about the named user."));
 
default:
    if ((x = cmcfm()) < 0) return(x);
    printf("not working yet - %s\n",cmdbuf);
    return(-2);
    }
}

#endif /* NOHELP */
#endif /* NOICP */
