/* Network types */

#define NET_TCPB 1			/* TCP/IP Berkeley (socket) */
#define NET_TCPA 2			/* TCP/IP AT&T (streams) */
#define NET_DEC  3			/* DECnet */
#define NET_SX25 4			/* SUNOS SunLink X.25 */

/* Network virtual terminal protocols */

#define NP_NONE 0			/* None (async) */
#define NP_TELNET 1			/* TCP/IP telnet */
#define NP_VTP 2			/* ISO Virtual Terminal Protocol */
#define NP_X3 3				/* CCITT X.3 */
#define NP_X28 4			/* CCITT X.28 */
#define NP_X29 5			/* CCITT X.28 */
#define NP_CTERM 20			/* DEC CTERM */
#define NP_LAT 21			/* DEC LAT */

/* others here... */

#ifdef SUNX25
#define MAXPADPARMS                18        /* Number of PAD parameters */

#define X29_SET_PARMS               2
#define X29_READ_PARMS              4
#define X29_SET_AND_READ_PARMS      6
#define X29_INVITATION_TO_CLEAR     1
#define X29_PARAMETER_INDICATION    0
#define X29_INDICATION_OF_BREAK     3
#define X29_ERROR                   5

#define INVALID_PAD_PARM            1

#define PAD_BREAK_CHARACTER         0

#define PAD_ESCAPE                  1
#define PAD_ECHO                    2
#define PAD_DATA_FORWARD_CHAR       3
#define PAD_DATA_FORWARD_TIMEOUT    4
#define PAD_FLOW_CONTROL_BY_PAD     5
#define PAD_SUPPRESSION_OF_SIGNALS  6
#define PAD_BREAK_ACTION            7
#define PAD_SUPPRESSION_OF_DATA     8
#define PAD_PADDING_AFTER_CR        9
#define PAD_LINE_FOLDING           10
#define PAD_LINE_SPEED             11
#define PAD_FLOW_CONTROL_BY_USER   12
#define PAD_LF_AFTER_CR            13
#define PAD_PADDING_AFTER_LF       14
#define PAD_EDITING                15
#define PAD_CHAR_DELETE_CHAR       16
#define PAD_BUFFER_DELETE_CHAR     17
#define PAD_BUFFER_DISPLAY_CHAR    18
#endif /* SUNX25 */
