/*  C K C D E B . H  */
/*
 This file is included by all C-Kermit modules, including the modules
 that aren't specific to Kermit (like the command parser and the ck?tio and
 ck?fio modules.  It specifies format codes for debug(), tlog(), and similar
 functions, and includes any necessary definitions to be used by all C-Kermit
 modules, and also includes some feature selection compile-time switches, and
 also system- or compiler-dependent definitions.
*/
/*
 Copyright (C) 1985, 1990, Trustees of Columbia University in the City of New 
 York. Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as it is not sold for profit, provided this
 copyright notice is retained.
*/

/*
 Debug and transaction logging is included automatically unless you define
 NODEBUG or NOTLOG.  Do this if you want to save the space
 and overhead.  (Note, in version 4F these definitions changed from "{}"
 to the null string to avoid problems with semicolons after braces, as in:
 "if (x) tlog(this); else tlog(that);"
*/
#ifndef NODEBUG
#define DEBUG
#endif

#ifndef NOTLOG
#define TLOG
#endif

#ifndef DEBUG
#define debug(a,b,c,d)
#endif

#ifndef TLOG
#define tlog(a,b,c,d)
#endif

/* Formats for debug() and tlog() */

#define F000 0
#define F001 1
#define F010 2
#define F011 3
#define F100 4
#define F101 5
#define F110 6
#define F111 7

/* System-type compilation switches */

#ifdef AIXPS2				/* AIXPS2 implies AIX370 */
#ifndef AIX370
#define AIX370
#endif
#endif

#ifdef AIX370				/* AIX PS/2 or 370 implies BSD4 */
#ifndef BSD4
#define BSD4
#endif
#endif

#ifdef SUN4S5				/* Sun-4 System V environment */
#ifndef SVR3				/* implies System V R3 or later */
#define SVR3
#endif
#endif /* SUN4S5 */

#ifdef MIPS				/* MIPS System V environment */
#ifndef SVR3				/* implies System V R3 or later */
#define SVR3
#endif
#endif /* MIPS */

#ifdef SVR3				/* SVR3 implies UXIII */
#ifndef UXIII
#define UXIII
#endif
#endif /* SVR3 */

#ifdef XENIX				/* XENIX implies UXIII */
#ifndef UXIII
#define UXIII
#endif
#endif /* XENIX */

#ifdef AUX				/* AUX implies UXIII */
#ifndef UXIII
#define UXIII
#endif
#endif /* AUX */

#ifdef ATT7300				/* ATT7300 implies UXIII */
#ifndef UXIII
#define UXIII
#endif
#endif /* ATT7300 */

#ifdef ATT6300				/* ATT6300 implies UXIII */
#ifndef UXIII
#define UXIII
#endif
#endif /* ATT6300 */

#ifdef HPUX				/* HPUX implies UXIII */
#ifndef UXIII
#define UXIII
#endif
#endif /* HPUX */

#ifdef ISIII				/* ISIII implies UXIII */
#ifndef UXIII
#define UXIII
#endif
#endif /* ISIII */

#ifdef NEXT				/* NEXT implies BSD4 */
#ifndef BSD4
#define BSD4
#endif
#endif /* NEXT */

#ifdef SUNOS4				/* SUNOS4 implies BSD4 */
#ifndef BSD4
#define BSD4
#endif
#endif /* SUNOS4 */

#ifdef BSD41				/* BSD41 implies BSD4 */
#ifndef BSD4
#define BSD4
#endif
#endif /* BSD41 */

#ifdef BSD43				/* BSD43 implies BSD4 */
#ifndef BSD4
#define BSD4
#endif
#endif /* BSD43 */

#ifdef BSD4				/* BSD4 implies ANYBSD */
#ifndef ANYBSD
#define ANYBSD
#endif /* ANYBSD */
#endif /* BSD4 */

#ifdef BSD29				/* BSD29 implies ANYBSD */
#ifndef ANYBSD
#define ANYBSD
#endif /* ANYBSD */
#endif /* BSD29 */

#ifdef UXIII				/* UXIII implies UNIX */
#ifndef UNIX
#define UNIX
#endif /* UNIX */
#endif /* UXIII */

#ifdef ANYBSD				/* ANYBSD implies UNIX */
#ifndef UNIX
#define UNIX
#endif /* UNIX */
#endif /* ANYBSD */

/* Kermit feature selection */

#ifdef UNIX
#define PARSENSE			/* Automatic parity detection */
#endif					/* for Unix */

#ifdef VMS				/* ... and VMS */
#define PARSENSE
#endif

#ifdef VMS				/* Use dynamic memory allocation */
#define DYNAMIC				/* in VMS version. */
#endif

#ifndef SUNOS4				/* Only use the SUNX25 option */
#ifdef SUNX25				/* on SUNs. */
#undef SUNX25
#endif
#else					/* It is a SUN */
#ifdef SUNX25				/* SUNX25 implies NETCONN */
#ifndef NETCONN
#define NETCONN
#endif /* NETCONN */
#endif /* SUNX25 */
#endif /* SUNOS4 */

/* Carrier treatment */
/* These are defined here because they are shared by the system dependent */
/* and the system independent modules. */

#define  CAR_OFF 0	/* On: heed carrier always, except during DIAL. */
#define  CAR_ON  1      /* Off: ignore carrier always. */
#define  CAR_AUT 2      /* Auto: heed carrier, but only if line is declared */
			/* to be a modem line, and only during CONNECT. */

/*
 Systems where we can expand tilde at the beginning of file or directory names
*/
#ifdef BSD4
#define DTILDE
#endif
#ifdef UXIII
#define DTILDE
#endif
#ifdef OSK
#define DTILDE
#endif

/* C Compiler Dependencies */

#ifndef SIGTYP				/* signal() type, void or int? */
#ifdef SVR3				/* System V R3 and later */
#define SIGTYP void
#else
#ifdef SUNOS4				/* SUNOS V 4.0 and later */
#define SIGTYP void 
#else
#ifdef NEXT				/* NeXT */
#define SIGTYP void
#else
#ifdef AIX370
#define SIGTYP __SIGVOID		/* AIX370 */
#else
#define SIGTYP int
#endif
#endif
#endif
#endif
#endif /* SIGTYP */

#ifdef ZILOG
#define setjmp setret
#define longjmp longret
#define jmp_buf ret_buf
#define getcwd curdir
/* typedef int ret_buf[10]; (apparently duplicated in setret.h) */
#endif /* zilog */

#ifdef PROVX1
typedef char CHAR;
typedef long LONG;
typedef int void;
#else
#ifdef V7
typedef char CHAR;
typedef long LONG;
#else
#ifdef C70
typedef char CHAR;
typedef long LONG;
#else
#ifdef BSD29
typedef char CHAR;
typedef long LONG;
#else
#ifndef CHAR
typedef unsigned char CHAR;
#endif
#ifndef LONG
typedef long LONG;
#endif
#endif
#endif
#endif
#endif

#ifdef TOWER1
typedef int void;
#endif

/* Line delimiter for text files */

/*
 If the system uses a single character for text file line delimitation,
 define NLCHAR to the value of that character.  For text files, that
 character will be converted to CRLF upon output, and CRLF will be converted
 to that character on input during text-mode (default) packet operations.
*/
#ifdef MAC                              /* Macintosh */
#define NLCHAR 015
#else
#ifdef OSK				/* OS-9/68K */
#define NLCHAR 015
#else                                   /* All Unix-like systems */
#define NLCHAR 012
#endif
#endif

/*
 At this point, if there's a system that uses ordinary CRLF line
 delimitation AND the C compiler actually returns both the CR and
 the LF when doing input from a file, then #undef NLCHAR.
*/
#ifdef OS2
#undef NLCHAR
#endif

/*
  VMS file formats are so complicated we need to do all the conversion 
  work in the CKVFIO module, so we tell the rest of C-Kermit not to fiddle
  with the bytes.
*/

#ifdef vms
#undef NLCHAR
#endif

/* The device name of a job's controlling terminal */
/* Special for VMS, same for all Unixes (?), not used by Macintosh */

#ifdef vms
#define CTTNAM "TT:"
#else
#ifdef datageneral
#define CTTNAM "@output"
#else
#ifdef OSK
extern char myttystr[];
#define CTTNAM myttystr
#else
#define CTTNAM "/dev/tty"
#endif
#endif
#endif

#ifdef SUNS4S5
#define tolower _tolower
#define toupper _toupper
#endif

/* Some special includes for VAX/VMS */

#ifndef vms
/* The following #includes cause problems for some preprocessors. */
/*
#endif
#ifdef vms
#include ssdef
#include stsdef
#endif
#ifndef vms
*/
#endif

/* File System Defaults */

#ifdef VMS
#define DBLKSIZ 512
#define DLRECL 132
#else
#define DBLKSIZ 0
#define DLRECL 0
#endif

/* Program return codes for VMS, DECUS C, and Unix */

#ifdef vms
#define GOOD_EXIT   (SS$_NORMAL | STS$M_INHIB_MSG)
#define BAD_EXIT    SS$_ABORT
#else
#ifdef decus
#define GOOD_EXIT   IO_NORMAL
#define BAD_EXIT    IO_ERROR
#else
#define GOOD_EXIT   0
#define BAD_EXIT    1
#endif
#endif

/* Special hack for Fortune, which doesn't have <sys/file.h>... */

#ifdef FT18
#define FREAD 0x01
#define FWRITE 0x10
#endif

/* special hack for os9/68k */
#ifdef OSK
#define SIGARB	5342			/* arbitrary user signal */
#define SIGALRM 5343			/* and another */
#endif

#ifdef OS2
#ifdef putchar                  /* MSC 5.1 simply uses a macro which causes */
#undef putchar                  /* no problems. */
#endif
#ifdef _MT                      /* MSC 6.0 goes and uses a function which */
int _putchar(int);              /* causes a linker error when fputchar is */
#define putchar _putchar        /* used as well. */
#endif                          /* I don't support fputchar()!! */
#endif

/* Escape/quote character used by the command parser */

#define CMDQ '\\'

/* Symbols for RS-232 modem signals */

#define KM_FG    1			/* Frame ground */
#define KM_TXD   2			/* Transmit */
#define KM_RXD   3			/* Receive */
#define KM_RTS   4			/* Request to Send */
#define KM_CTS   5			/* Clear to Send */
#define KM_DSR   6			/* Data Set Ready */
#define KM_SG    7			/* Signal ground */
#define KM_DCD   8			/* Carrier Detect */
#define KM_DTR  20			/* Data Terminal Ready */
#define KM_RI   22			/* Ring Indication */

/* Bit mask values for modem signals */

#define BM_CTS   0001			/* Clear to send       (From DCE) */
#define BM_DSR   0002			/* Dataset ready       (From DCE) */
#define BM_DCD   0004			/* Carrier             (From DCE) */
#define BM_RNG   0010			/* Ring Indicator      (From DCE) */
#define BM_DTR   0020			/* Data Terminal Ready (From DTE) */
#define BM_RTS   0040			/* Request to Send     (From DTE) */

