#ifndef NOICP

/*  C K U U S 5 --  "User Interface" for Unix Kermit, part 5  */
 
/*
 Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET),
 Columbia University Center for Computing Activities.
 First released January 1985.
 Copyright (C) 1985, 1990, Trustees of Columbia University in the City of New 
 York.  Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as it is not sold for profit, provided this
 copyright notice is retained.
*/

/* Includes */

#include <stdio.h>
#include <ctype.h>
#include <signal.h>

#include "ckcdeb.h"
#include "ckcasc.h"
#include "ckcker.h"
#include "ckuusr.h"

/* External variables */

extern int size, rpsiz, urpsiz, local, backgrd, bgset, tvtflg,
  server, displa, binary, parity, deblog, escape, xargc, xargs, flow,
  turn, duplex, nfils, ckxech, pktlog, seslog, tralog, stdouf, stdinf,
  turnch, dfloc, keep, maxrps, warn, quiet, cnflg, tlevel, cwdf, nfuncs,
  mdmtyp, zincnt, cmask, rcflag, success, xmitf, xmitl, xmitp, xitsta, pflag;

extern int atcapr,
  atenci, atenco, atdati, atdato, atleni, atleno, atblki, atblko,
  attypi, attypo, atsidi, atsido, atsysi, atsyso, atdisi, atdiso; 

extern long speed, ttgspd();

extern char *DIRCMD, *PWDCMD, *DELCMD, cmerrp[], xmitbuf[];
extern char *zhome(), *malloc();
extern char **xargv, *versio, *ckxsys, *dftty, *cmarg, *homdir, *lp;
extern char cmdbuf[], atmbuf[], savbuf[], toktab[], ttname[], psave[];
extern CHAR sstate, dopar();
extern struct mtab mactab[];
extern struct keytab cmdtab[], vartab[], fnctab[];
extern int cmdlvl, maclvl, tlevel, rmailf, rprintf, cmflgs;
extern int nmac, mecho, merror, techo, terror, repars, ncmd;
extern int xxstring();

#ifdef OS2
extern char far * zfindfile(char far *);
#endif

extern SIGTYP trap(), stptrap();

/* Local declarations */

int nulcmd = 0;			/* Flag for next cmd to be ignored */

/* Definitions for built-in macros */

/* IBM-LINEMODE macro */
char *m_ibm = "set parity mark, set dupl half, set handsh xon, set flow none";

/* FATAL */
char *m_fat = "if def \\%1 echo \\%1, stop";

/* FOR-loop macro, handles both ascending and descending loops. */
/* The "<" or ">" is passed as macro parameter %5. */
char *m_forx = "if def _floop ass \\%9 \\fdef(_floop),else def \\%9,\
ass _floop { define \\\\\\%1 \\%2,:top,if \\%5 \\\\\\%1 \\%3 goto bot,\
\\%6,:inc, incr \\\\\\%1 \\%4,goto top,:bot, return },\
def break goto bot, def continue goto inc,\
do _floop \\%1 \\%2 \\%3 \\%4 { \\%5 },assign _floop \\fcont(\\%9)";

/* WHILE macro */
char *m_while = "if def _wloop ass \\%9 \\fdef(_wloop),\
ass _wloop {:wtest,\\%1,\\%2,goto wtest,:wbot,return},\
def break goto wbot, def continue goto wtest,\
do _wloop,assign _wloop \\fcont(\\%9)";

/* XIF macro */
char *m_xif = "ass \\%9 \\fdef(_ify),ass _ify { \\%1 },do _ify,\
ass _ify \\fcont(\\%9)";

/* Variables declared here for use by other ckuus*.c modules */
/* Space is allocated here to save room in ckuusr.c */

FILE *tfile[MAXTAKE];
struct cmdptr cmdstk[CMDSTKL];
int ifcmd[CMDSTKL], count[CMDSTKL], iftest[CMDSTKL];
char *m_arg[MACLEVEL][NARGS];
char *g_var[GVARS], *macp[MACLEVEL], *mrval[MACLEVEL];
int macargc[MACLEVEL];
char *macx[MACLEVEL];
extern char varnam[];

char **a_ptr[27];			/* Array pointers, for arrays a-z */
int a_dim[27];				/* Dimensions for each array */

extern char debfil[], pktfil[], sesfil[], trafil[], cmdbuf[], cmdstr[],
  optbuf[];

char line[LINBUFSIZ];			/* Character buffer for anything */
char inpbuf[INPBUFSIZ];			/* Buffer for INPUT and REINPUT */
char vnambuf[VNAML];			/* Buffer for variable names */
char *vnp;				/* Pointer to same */
char lblbuf[50];			/* Buffer for labels */
char tmpbuf[50];			/* Temporary buffer */
char numbuf[20];			/* Buffer for numeric strings. */
char kermrc[100];			/* Name of initialization file */

/*  C M D I N I  --  Initialize the interactive command parser  */
 
cmdini() {
    int i, x, y, z;

#ifdef AMIGA
    congm();
    if (tlevel < 0)    
      concb(escape);
#endif
    cmdlvl = 0;				/* Start at command level 0 */
    cmdstk[cmdlvl].src = CMD_KB;
    cmdstk[cmdlvl].val = 0;
    tlevel = -1;			/* Take file level = keyboard */
    cmsetp("C-Kermit>");		/* Set default prompt */
    initmac();				/* Initialize macro table */
    addmac("ibm-linemode",m_ibm);	/* Add built-in macros. */
    addmac("fatal",m_fat);		/* FATAL macro. */
    addmac("_forx",m_forx);		/* FOR macro. */
    addmac("_xif",m_xif);		/* XIF macro. */
    addmac("_while",m_while);		/* WHILE macro. */
    sprintf(vnambuf,"\\&a[%d]",xargs); 	/* Command line argument vector */
    y = arraynam(vnambuf,&x,&z);	/* goes in array \&a[] */
    if (y > -1) {
	dclarray(x,z);			/* Declare the array */
	for (i = 0; i < xargs; i++) {	/* Fill it */
	    sprintf(vnambuf,"\\&a[%d]",i);
	    addmac(vnambuf,xargv[i]);
	}
    }
    *vnambuf = NUL;

/* Look for init file in home or current directory. */
/* (NOTE - should really use zkermini for this!)    */
#ifdef OS2
    if (rcflag)
      lp = kermrc;
    else
      lp = zfindfile(kermrc);
    strcpy(line,lp);
    if ((tfile[0] = fopen(line,"r")) != NULL) {
        tlevel = 0;
	cmdlvl++;
	cmdstk[cmdlvl].src = CMD_TF;
	cmdstk[cmdlvl].val = tlevel;
	ifcmd[cmdlvl] = 0;
	iftest[cmdlvl] = 0;
	count[cmdlvl] = 0;
        debug(F110,"init file",line,0);
    } else {
        debug(F100,"no init file","",0);
    }
#else 
    homdir = zhome();
    lp = line;
    lp[0] = '\0';
#ifdef vms
    zkermini(line,sizeof(line),kermrc);
#else
    if (rcflag) {			/* If init file name from cmd line */
	strcpy(lp,kermrc);		/* use it */
    } else {				/* otherwise */
	if (homdir) {			/* look in home directory for it */
	    strcpy(lp,homdir);
	    if (lp[0] == '/') strcat(lp,"/");
	}
	strcat(lp,kermrc);		/* and use the default name */
    }
#endif
#ifdef AMIGA
    reqoff();				/* disable requestors */
#endif
    debug(F110,"ini file is",line,0);
    if ((tfile[0] = fopen(line,"r")) != NULL) {
	tlevel = 0;
	cmdlvl++;
	ifcmd[cmdlvl] = 0;
	iftest[cmdlvl] = 0;
	count[cmdlvl] = 0;
	debug(F101,"open ok","",cmdlvl);
	cmdstk[cmdlvl].src = CMD_TF;
	cmdstk[cmdlvl].val = tlevel;
	debug(F110,"init file",line,0);
    }
    if (homdir && (tlevel < 0)) {
    	strcpy(lp,kermrc);
	if ((tfile[0] = fopen(line,"r")) != NULL) {
	    tlevel = 0;
	    cmdlvl++;
	    cmdstk[cmdlvl].src = CMD_TF;
	    cmdstk[cmdlvl].val = tlevel;
	    ifcmd[cmdlvl] = 0;
	    iftest[cmdlvl] = 0;
	    count[cmdlvl] = 0;
	}
    }
#endif
#ifdef AMIGA
    reqpop();				/* restore requestors */
#else
    congm();				/* Get console tty modes */
#endif
}

/*  P A R S E R  --  Top-level interactive command parser.  */
 
/*
  Call with:
    m = 0 for normal behavior: keep parsing and executing commands
          until an action command is parsed, then return with a
          Kermit start-state as the value of this function.
    m = 1 to parse only one command, use when calling parser() recursively.
    m = 2 to read but do not execute one command.
  In both cases, returns:
    0     if no Kermit action required
    > 0   with a Kermit start-state.
    < 0   upon error.
*/
parser(m) int m; {
    int y, xx, yy, zz;			/* Workers */
    char ic;				/* Interruption character */
    int icn;				/* Interruption character counter */
    int inlevel;			/* Level we were called at */
    int pp;				/* Paren nesting level */
    int kp;				/* Bracket nesting level */
    char *cbp;				/* Command buffer pointer */
    int cbn;				/* Command buffer length */

#ifdef AMIGA
    reqres();			/* restore AmigaDOS requestors */
#endif /* AMIGA */

    if (cmdlvl == 0)		/* If at top (interactive) level, */
      concb(escape);		/* put console in cbreak mode. */

    ifcmd[0] = 0;		/* Command-level related variables */
    iftest[0] = 0;		/* initialize variables at top level */
    count[0] = 0;		/* of stack... */
    inlevel = maclvl;		/* Current macro level */
    debug(F101,"&parser entry maclvl","",maclvl);
    debug(F101,"&parser entry inlevel","",inlevel);
/*
 sstate becomes nonzero when a command has been parsed that requires some
 action from the protocol module.  Any non-protocol actions, such as local
 directory listing or terminal emulation, are invoked directly from below.
*/
    if (local && pflag)			/* Just returned from connect? */
      printf("\n");
    sstate = 0;				/* Start with no start state. */
    rmailf = rprintf = 0;		/* MAIL and PRINT modifiers for SEND */
    *optbuf = NUL;			/* MAIL and PRINT options */
    while (sstate == 0) {		/* Parse cmds until action requested */

    /* Take requested action if there was an error in the previous command */

#ifdef VMS
	if (cmdlvl == 0) concb(escape);
#endif
	conint(trap,stptrap);		/* In case we were just fg'd */
	bgchk();			/* Check background status */
	if (success == 0) {
	    if (cmdstk[cmdlvl].src == CMD_TF && terror) {
		ermsg("Command error: take file terminated.");
		popclvl();
		if (cmdlvl == 0) {
		    conint(trap,stptrap);
		    bgchk();		/* Check background status */
		    return(0);
		}
	    }
	    if (cmdstk[cmdlvl].src == CMD_MD && merror) {
		ermsg("Command error: macro terminated.");
		popclvl();
		if (m && (maclvl < inlevel))
		  return((int) sstate);
	    }
	}

	nulcmd = (m == 2);

        /* If in TAKE file, check for EOF */

	while ((cmdstk[cmdlvl].src == CMD_TF)  /* If end of take file */
	       && (tlevel > -1)
	       && feof(tfile[tlevel])) {
	    popclvl();			/* pop command level */
	    cmini(ckxech);		/* and clear the cmd buffer. */
	    if (cmdlvl == 0) {		/* Just popped out of all cmd files? */
		conint(trap,stptrap);	/* Check background stuff again. */
		bgchk();
		return(0);		/* End of init file or whatever. */
	    }
 	}

        /* If macro, check for interruption and then get next command */

        if (cmdstk[cmdlvl].src == CMD_MD) { /* Executing a macro? */
	    if (icn = conchk()) {	/* Yes */
		while (icn--) {		/* User typed something */
		    ic = coninc(0);
		    if (ic == CR) {	/* Carriage return? */
			printf(" Interrupted...\n");
			dostop();
		    } else {
			putchar(BEL);
		    }
		}		
	    }
	    maclvl = cmdstk[cmdlvl].val; /* No interrupt, get current level */
	    cbp = cmdbuf;		/* Copy next cmd to command buffer. */
	    *cbp = NUL;
	    if (*savbuf) {		/* In case then-part of 'if' command */
		strcpy(cbp,savbuf);	/* was saved, restore it. */
		*savbuf = '\0';
	    } else {			/* Else get next cmd from macro def */
		debug(F111,"macro",macp,maclvl);
		kp = pp = 0;
		
		for (y = 0;		/* copy next macro part */
		     *macp[maclvl] && y < CMDBL;
		     y++, cbp++, macp[maclvl]++) {

		    /* Allow braces around macro def to prevent */
                    /* commas from being turned to end-of-lines */
                    /* and also treat any commas within parens  */
                    /* as text so that multiple-argument functions */
                    /* won't cause the command to break prematurely. */

		    *cbp = *macp[maclvl];  /* Get next character */

		    if (*cbp == '{') kp++; /* Count braces */
		    if (*cbp == '}') kp--;
		    if (*cbp == '(') pp++; /* Count parentheses. */
		    if (*cbp == ')') pp--;
		    if (*cbp == ',' && pp <= 0 && kp <= 0) {
			macp[maclvl]++;
			kp = pp = 0;
			break;
		    }
		}			/* Reached end. */
		if (*cmdbuf == NUL) {	/* If nothing was copied, */
		    popclvl();		/* pop command level. */
		    debug(F101,"macro level popped","",maclvl);
		    if (m && (maclvl < inlevel))
		      return((int) sstate);
		    else if (!m) continue;
		} else {		/* otherwise, tack CR onto end */
		    *cbp++ = '\r';
		    *cbp = '\0';
		    if (mecho && pflag)
		      printf("%s\n",cmdbuf);
		    debug(F110,"cmdbuf",cmdbuf,0);
		}
	    }

        /* If TAKE file, get next line */    

	} else if (cmdstk[cmdlvl].src == CMD_TF) { /* Reading TAKE file? */
	    debug(F101,"tlevel","",tlevel);
	    cbp = cmdbuf;		/* Get the next line. */
	    cbn = CMDBL;
 
/* Loop to get next command line and all continuation lines from take file. */
 
again:	    if (*savbuf) {		/* In case then-part of 'if' command */
		strcpy(line,savbuf);	/* was saved, restore it. */
		*savbuf = '\0';
	    } else {
		if (fgets(line,cbn,tfile[tlevel]) == NULL) continue;
	    }
	    if (icn = conchk()) {
		while (icn--) {		/* User typed something... */
		    ic = coninc(0);	/* Look for carriage return */
		    if (ic == CR) {
			printf(" Interrupted...\n");
			dostop();
		    } else putchar(BEL); /* Ignore anything else */
		}		
	    }
	    lp = line;			/* Got a line, copy it. */
	    debug(F110,"from TAKE file",line,0);
#define TRIM
#ifdef TRIM
	    {				/* Trim trailing whitespace */
		char c; int i, j;
		j = strlen(line) - 1;	/* Position of line terminator */
		c = line[j];		/* Value of line terminator */
		for (i = j - 1; i > -1; i--)
		  if (line[i] != SP && line[i] != HT) break;
		line[i+1] = c;		/* Move after last nonblank char */
		line[i+2] = NUL;	/* Terminate */
	    }
#endif
	    while (*cbp++ = *lp++)
	      if (--cbn < 1) fatal("Command too long for internal buffer");
	    if (*(cbp - 3) == CMDQ || *(cbp - 3) == '-') { /* Continued? */
		cbp -= 3;		/* If so, back up pointer, */
		goto again;		/* go back, get next line. */
	    }
	    untab(cmdbuf);		/* Convert tabs to spaces */
	    if (techo && pflag)		/* "take echo on" */
	      printf("%s",cmdbuf);

        /* If interactive, get next command from user. */

	} else {			/* User types it in. */
	    if (pflag) prompt();
	    cmini(ckxech);
    	}

        /* Now know where next command is coming from. Parse and execute it. */

	repars = 1;			/* 1 = command needs parsing */
	displa = 0;			/* Assume no file transfer display */

	while (repars) {		/* Parse this cmd until entered. */
	    cmres();			/* Reset buffer pointers. */
	    xx = cmkey2(cmdtab,ncmd,"Command","",toktab,xxstring);
	    debug(F101,"top-level cmkey2","",xx);
	    if (xx == -5) {
		yy = chktok(toktab);
		debug(F101,"top-level cmkey token","",yy);
		ungword();
		switch (yy) {
		  case '!': xx = XXSHE; break;
		  case '#': xx = XXCOM; break;
		  case ';': xx = XXCOM; break;
		  case ':': xx = XXLBL; break;
                  case '@': xx = XXSHE; break;
		  default: 
		    printf("\n?Invalid - %s\n",cmdbuf);
		    xx = -2;
		}
	    }

            /* Special handling for IF..ELSE */

	    if (ifcmd[cmdlvl])		/* Count stmts after IF */
	      ifcmd[cmdlvl]++;
	    if (ifcmd[cmdlvl] > 2 && xx != XXELS && xx != XXCOM)
	      ifcmd[cmdlvl] = 0;

	    /* Execute the command and take action based on return code. */

	    if (nulcmd) {		/* Ignoring this command? */
		xx = XXCOM;		/* Make this command a comment. */
	    }

	    switch (zz = docmd(xx)) {	/* Parse rest of command & execute. */
		case -4:		/* EOF (e.g. on redirected stdin) */
		    doexit(GOOD_EXIT);	/* ...exit successfully */
	        case -1:		/* Reparse needed */
		    repars = 1;		/* Just set reparse flag and  */
		    continue;
		case -6:		/* Invalid command given w/no args */
	    	case -2:		/* Invalid command given w/args */
		    /* This is going to be really ugly... */
		    yy = mlook(mactab,atmbuf,nmac); /* Look in macro table */
		    if (yy > -1) {	            /* If it's there */
			if (zz == -2) {	            /* insert "do" */
			    char *mp;
			    mp = malloc(strlen(cmdbuf) + 5);
			    if (!mp) {
				printf("?malloc error 1\n");
				return(-2);
			    }
			    sprintf(mp,"do %s ",cmdbuf);
			    strcpy(cmdbuf,mp);
			    free(mp);
			} else sprintf(cmdbuf,"do %s \r",atmbuf);
			if (ifcmd[cmdlvl] == 2)	/* This one doesn't count! */
			  ifcmd[cmdlvl]--;
			debug(F111,"stuff cmdbuf",cmdbuf,zz);
			repars = 1;	/* go for reparse */
			continue;
		    } else {
			char *p;
			p = cmdbuf;
			lp = line;     
			if (cmflgs == 0) printf("\n");
			if (xxstring(p,&lp,&p) > -1) 
			  printf("?Invalid: %s\n",line);
			else
			  printf("?Invalid: %s\n",cmdbuf);
		    } /* (fall thru...) */

		case -9:		/* Bad, error message already done */
		    success = 0;
		    debug(F110,"top-level cmkey failed",cmdbuf,0);
		    if (pflag == 0)	/* if background, terminate */
		      fatal("Kermit command error in background execution");
		    cmini(ckxech);	/* (fall thru) */

 	    	case -3:		/* Empty command OK at top level */
		    repars = 0;		/* Don't need to reparse. */
		    continue;		/* Go back and get another command. */

		default:		/* Command was successful. */
		    repars = 0;		/* Don't need to reparse. */
		    continue;		/* Go back and get another command. */
		}
	}
	if (m && (maclvl < inlevel))  return((int) sstate);
    }

/* Got an action command, return start state. */
 
#ifdef COMMENT
    /* This is done in ckcpro.w instead, no need to do it twice. */
    /* Interrupts off only if remote */
    if (!local) connoi();
#endif
    return((int) sstate);
}

/* OUTPUT command */

xxout(c) char c; {			/* Function to output a character. */
    debug(F101,"xxout","",c);
    if (local)				/* If in local mode */
      return(ttoc(c));			/* then to the external line */
    else return(conoc(c));		/* otherwise to the console. */
}

/* Returns 0 on failure, 1 on success */

dooutput(s) char *s; {
    int x, y, quote;

    if (local) {			/* Condition external line */
	y = ttvt(speed,flow);
	if (y < 0) return(0);
    }
    quote = 0;				/* Initialize backslash (\) quote */

    while (x = *s++) {			/* Loop through the string */
	y = 0;				/* Error code, 0 = no error. */
	if (x == CMDQ) {		/* Look for \b or \B in string */
            quote = 1;			/* Got \ */
	    continue;			/* Get next character */
	} else if (quote) {		/* This character is quoted */
	    quote = 0;			/* Turn off quote flag */
	    if (x == 'b' || x == 'B') {	/* If \b or \B */
		debug(F101,"output BREAK","",0);
		ttsndb();		/* send BREAK signal */
		continue;		/* and not the b or B */
	    } else {			/* if \ not followed by b or B */
		y = xxout(dopar(CMDQ));	/* output the backslash. */
	    }
	}
	y = xxout(dopar(x));		/* Output this character */
	if (y < 0) {
	    printf("output error.\n");
	    return(0);
	}
	if (seslog)
	  if (zchout(ZSFILE,x) < 0) seslog = 0;
    }
    return(1);
}

/* Display version herald and initial prompt */

herald() {
    int x = 0;
    if (bgset > 0 || (bgset != 0 && backgrd != 0)) x = 1;
    debug(F101,"herald","",backgrd);
    if (x == 0)
      printf("%s,%s\nType ? or 'help' for help\n",versio,ckxsys);
}

/*  M L O O K  --  Lookup the macro name in the macro table  */
 
/*
 Call this way:  v = mlook(table,word,n);
 
   table - a 'struct mtab' table.
   word  - the target string to look up in the table.
   n     - the number of elements in the table.
 
 The keyword table must be arranged in ascending alphabetical order, and
 all letters must be lowercase.
 
 Returns the table index, 0 or greater, if the name was found, or:
 
  -3 if nothing to look up (target was null),
  -2 if ambiguous,
  -1 if not found.
 
 A match is successful if the target matches a keyword exactly, or if
 the target is a prefix of exactly one keyword.  It is ambiguous if the
 target matches two or more keywords from the table.
*/
mlook(table,cmd,n) char *cmd; struct mtab table[]; int n; {
 
    int i, v, cmdlen;
 
/* Lowercase & get length of target, if it's null return code -3. */
 
    if ((((cmdlen = lower(cmd))) == 0) || (n < 1)) return(-3);
 
/* Not null, look it up */
 
    for (i = 0; i < n-1; i++) {
        if (!strcmp(table[i].kwd,cmd) ||
           ((v = !strncmp(table[i].kwd,cmd,cmdlen)) &&
             strncmp(table[i+1].kwd,cmd,cmdlen))) {
                return(i);
             }
        if (v) return(-2);
    }   
 
/* Last (or only) element */
 
    if (!strncmp(table[n-1].kwd,cmd,cmdlen)) {
        return(n-1);
    } else return(-1);
}

/* mxlook is like mlook, but an exact full-length match is required */

mxlook(table,cmd,n) char *cmd; struct mtab table[]; int n; {
    int i, cmdlen;
    if ((((cmdlen = lower(cmd))) == 0) || (n < 1)) return(-3);
    for (i = 0; i < n; i++)
      if ((strlen(table[i].kwd) == cmdlen) &&
	  (!strncmp(table[i].kwd,cmd,cmdlen))) return(i);
    return(-1);
}

addmac(nam,def) char *nam, *def; {	/* Add a macro to the macro table */
    int i, x, y, z;
    char *p, c;

    debug(F110,"addmac",nam,0);
    debug(F110,"addmac",def,0);

    if (*nam == CMDQ) nam++;
    if (*nam == '%') {			/* If it's a variable name */
	delmac(nam);			/* Delete any old value */
	p = malloc(strlen(def) + 1);	/* Allocate space for its definition */
	if (!p) {
	    printf("?malloc error 2\n");
	    return(-1);
	}
	strcpy(p,def);			/* Copy definition into new space */
	c = *(nam + 1);			/* Variable name letter or digit */
	if (c >= '0' && c <= '9') {	/* Digit? */
	    if (maclvl < 0) {		/* Yes, calling or in a macro? */
		g_var[c] = p;		/* No, so make it global. */
		debug(F111,"addmac numeric glob",p,maclvl);
	    } else {
		m_arg[maclvl][c - '0'] = p; /* Put ptr in macro-arg table */
		debug(F111,"addmac arg",p,maclvl);
	    }
	} else {			/* It's a global variable */
	    if (c < 33 || c > GVARS) return(-1);
	    if (isupper(c)) c = tolower(c);
	    g_var[c] = p;		/* Put pointer in global-var table */
	    debug(F110,"addmac glob",p,0);
	}
	return(0);
    }
	    
    if (*nam == '&') {			/* An array reference? */
	char **q;
	if ((y = arraynam(nam,&x,&z)) < 0) /* If syntax is bad */
	  return(-1);			/* return -1. */
	if (chkarray(x,z) < 0)		/* If array not declared or */
	  return(-2);			/* subscript out of range, ret -2 */
	delmac(nam);			/* Delete any current definition. */
	x -= 'a';			/* Convert name letter to index. */
	if ((q = a_ptr[x]) == NULL)	/* If array not declared, */
	  return(-3);			/* return -3. */
	if ((p = (char *) malloc(strlen(def)+1)) == NULL) /* Allocate space */
	  return(-4);			/* for new def, return -4 on fail. */
	q[z] = p;			/* Store pointer to it. */
	strcpy(p,def);			/* Copy definition into new space. */
	return(0);			/* Done. */
    }

/* Not a macro argument or a variable, so it's a macro definition */

    if (mxlook(mactab,nam,nmac) >= 0)	/* Look it up */
      delmac(nam);			/* if it's already there, delete it. */

    lower(nam);				/* Lowercase the name */
    p = malloc(strlen(nam) + 1);	/* Allocate space for name */
    if (!p) fatal("?malloc error 3");
    for (y = 0;				/* Find the alphabetical slot */
	 y < MAC_MAX && mactab[y].kwd != NULL && strcmp(nam,mactab[y].kwd) > 0;
	 y++) ;
    if (y == MAC_MAX)			/* No more room. */
      return(-1);
    if (mactab[y].kwd != NULL) {	/* Must insert */
	for (i = nmac; i > y; i--) {	/* Move the rest down one slot */
	    mactab[i].kwd = mactab[i-1].kwd;
	    mactab[i].val = mactab[i-1].val;
	    mactab[i].flgs = mactab[i-1].flgs;
	}
    }
    p = malloc(strlen(nam) + 1);	/* Allocate space for name */
    if (!p) {
	printf("?malloc error 4\n");
	return(-1);
    }
    strcpy(p,nam);			/* Copy name into new space */
    mactab[y].kwd = p;			/* Add pointer to table */

    p = malloc(strlen(def) + 1);	/* Same deal for definition */
    if (p == NULL) {
	printf("?malloc error 5\n");
	free(mactab[y].kwd);
	mactab[y].kwd = NULL;
	return(-1);
    }
    strcpy(p,def);
    mactab[y].val = p;
    mactab[y].flgs = 0;
    nmac++;				/* Count this macro */
    return(y);
}

delmac(nam) char *nam; {		/* Delete the named macro */
    int i, x, z;
    char *p, c;

    if (*nam == CMDQ) nam++;
    if (*nam == '%') {			/* If it's a variable name */
	c = *(nam + 1);			/* Variable name letter or digit */
	if (maclvl > -1 && c >= '0' && c <= '9') { /* Digit? */
	    p = m_arg[maclvl][c - '0'];	/* Get pointer from macro-arg table */
	    m_arg[maclvl][c - '0'] = NULL; /* Zero the table entry */
	} else {			/* It's a global variable */
	    if (c < 33 || c > GVARS) return(0);
	    p = g_var[c];		/* Get pointer from global-var table */
	    g_var[c] = NULL;		/* Zero the table entry */
	}
	if (p) free(p);			/* Free the storage */
	return(0);
    }
	    
    if (*nam == '&') {			/* An array reference? */
	char **q;
	if (arraynam(nam,&x,&z) < 0)	/* If syntax is bad */
	  return(-1);			/* return -1. */
	x -= 'a';			/* Convert name to number. */
	if ((q = a_ptr[x]) == NULL)	/* If array not declared, */
	  return(-2);			/* return -2. */
	if (z > a_dim[x])		/* If subscript out of range, */
	  return(-3);			/* return -3. */
	if (q[z]) {			/* If there is an old value, */
	    free(q[z]);			/* delete it. */
	    q[z] = NULL;
	}
    }

   /* Not a variable or an array, so it must be a macro. */

    if ((x = mlook(mactab,nam,nmac)) < 0) return(x); /* Look it up */

    for (i = x; i < nmac; i++) {
	mactab[i].kwd = mactab[i+1].kwd;
	mactab[i].val = mactab[i+1].val;
	mactab[i].flgs = mactab[i+1].flgs;
    }

    nmac--;				/* One less macro */
    if (mactab[nmac].kwd)		/* Free the storage for the name */
      free(mactab[nmac].kwd);
    mactab[nmac].kwd = NULL;		/* Delete it from the table */
    if (mactab[nmac].val)		/* Ditto for the definition */
      free(mactab[nmac].val);
    mactab[nmac].val = NULL;
    mactab[nmac].flgs = 0;
    return(0);
}

initmac() {				/* Init macro & variable tables */
    int i, j;

    nmac = 0;				/* No macros */
    for (i = 0; i < MAC_MAX; i++) {	/* Initialize the macro table */
	mactab[i].kwd = NULL;
	mactab[i].val = NULL;
	mactab[i].flgs = 0;
    }
    for (i = 0; i < MACLEVEL; i++) {	/* Init the macro argument tables */
	mrval[i] = NULL;
	for (j = 0; j < 10; j++) {
	    m_arg[i][j] = NULL;
	}
    }
    for (i = 0; i < GVARS; i++) {	/* And the global variables table */
	g_var[i] = NULL;
    }
    for (i = 0; i < 26; i++) {		/* And the table of arrays */
	a_ptr[i] = (char **) NULL;	/* Null pointer for each */
	a_dim[i] = 0;			/* and a dimension of zero */
    }
}

/* Look up a % variable, return pointer to its value, else NULL */

popclvl() {				/* Pop command level, return cmdlvl */
    if (cmdlvl < 1) {			/* If we're already at top level */
	cmdlvl = 0;			/* just make sure all the */
	tlevel = -1;			/* stack pointers are set right */
	maclvl = -1;			/* and return */
	return(0);
    } else if (cmdstk[cmdlvl].src == CMD_TF) { /* Reading from TAKE file? */
	if (tlevel > -1) {		/* Yes, */
	    fclose(tfile[tlevel--]);	/* close it and pop take level */
	    cmdlvl--;			/* pop command level */
	} else tlevel = -1;
    } else if (cmdstk[cmdlvl].src == CMD_MD) { /* In a macro? */
	if (maclvl > -1) {		/* Yes, */
	    macp[maclvl] = "";		/* set macro pointer to null string */
	    *cmdbuf = '\0';		/* clear the command buffer */
	    if (mrval[maclvl+1]) {	/* Free any deeper return values. */
		free(mrval[maclvl+1]);
		mrval[maclvl+1] = NULL;
	    }
	    maclvl--;			/* pop macro level */
	    cmdlvl--;			/* and command level */
	} else maclvl = -1;
    }
    return(cmdlvl < 1 ? 0 : cmdlvl);	/* Return command level */
}

/* STOP - get back to C-Kermit prompt, no matter where from. */

dostop() {
    while ( popclvl() )  ;	/* Pop all macros & take files */
    while (cmpop() > -1) ;	/* And all recursive cmd pkg invocations */
    cmini(ckxech);		/* Clear the command buffer. */
    conint(trap,stptrap);	/* Check background stuff again. */
    return(0);
}

/* Close the given log */

doclslog(x) int x; {
    int y;
    switch (x) {
	case LOGD:
	    if (deblog == 0) {
		printf("?Debugging log wasn't open\n");
		return(0);
	    }
	    *debfil = '\0';
	    deblog = 0;
	    return(zclose(ZDFILE));
 
	case LOGP:
	    if (pktlog == 0) {
		printf("?Packet log wasn't open\n");
		return(0);
	    }
	    *pktfil = '\0';
	    pktlog = 0;
	    return(zclose(ZPFILE));
 
	case LOGS:
	    if (seslog == 0) {
		printf("?Session log wasn't open\n");
		return(0);
	    }
	    *sesfil = '\0';
	    seslog = 0;
	    return(zclose(ZSFILE));
 
    	case LOGT:
	    if (tralog == 0) {
		printf("?Transaction log wasn't open\n");
		return(0);
	    }
	    *trafil = '\0';
	    tralog = 0;
	    return(zclose(ZTFILE));
 
          case LOGW:
	  case LOGR:
	    y = (x == LOGR) ? ZRFILE : ZWFILE;
	    if (chkfn(y) < 1) {
		if (x == LOGW)
		  printf("?No file to close\n");
		return(0);
	    }
	    y = zclose(y);
	    return((x == LOGR) ? 1 : y);

	default:
	    printf("\n?Unexpected log designator - %ld\n", x);
	    return(0);
	}
}

static char *nm[] = { "disabled", "enabled" };

doshow(x) int x; {
    int y;
    char *s;
    extern int en_cwd, en_del, en_dir, en_fin, en_bye,
      en_get, en_hos, en_sen, en_set, en_spa, en_typ, en_who;
    extern long vernum;
    extern int srvtim, incase, inecho, intime, nvars, verwho;
    extern char *protv, *fnsv, *cmdv, *userv, *ckxv, *ckzv, *ckzsys, *xlav;
    extern char *connv, *dialv, *loginv, *nvlook();

    switch (x) {

#ifdef SUNX25
        case SHPAD:
            if ((y = cmcfm()) < 0) return(y);
            shopad();
            break;
#endif /* SUNX25 */

	case SHPAR:
	    if ((y = cmcfm()) < 0) return(y);
	    shopar();
	    break;
 
        case SHATT:
	    if ((y = cmcfm()) < 0) return(y);
	    shoatt();
	    break;
 
	case SHCOU:
	    if ((y = cmcfm()) < 0) return(y);
	    printf(" %d\n",count[cmdlvl]);
	    break;

        case SHSER:			/* Show Server */
	    if ((y = cmcfm()) < 0) return(y);
	    printf("Function           Status:\n");
	    printf(" GET                %s\n",nm[en_get]);
	    printf(" SEND               %s\n",nm[en_sen]);	    
	    printf(" REMOTE CD/CWD      %s\n",nm[en_cwd]);
	    printf(" REMOTE DELETE      %s\n",nm[en_del]);
	    printf(" REMOTE DIRECTORY   %s\n",nm[en_dir]);
	    printf(" REMOTE HOST        %s\n",nm[en_hos]);	    
	    printf(" REMOTE SET         %s\n",nm[en_set]);	    
	    printf(" REMOTE SPACE       %s\n",nm[en_spa]);	    
	    printf(" REMOTE TYPE        %s\n",nm[en_typ]);	    
	    printf(" REMOTE WHO         %s\n",nm[en_who]);
	    printf(" BYE                %s\n",nm[en_bye]);
            printf(" FINISH             %s\n",nm[en_fin]);
	    printf("Server Timeout: %d\n\n",srvtim);
	    break;

        case SHSTA:			/* Status of last command */
	    if ((y = cmcfm()) < 0) return(y);
	    if (success) printf(" SUCCESS\n"); else printf(" FAILURE\n");
	    break;

	case SHVER:
	    if ((y = cmcfm()) < 0) return(y);
	    printf("\nVersions:\n %s\n Numeric: %ld",versio,vernum);
	    if (verwho) printf("-%d",verwho);
	    printf("\n %s\n",protv);
	    printf(" %s\n",fnsv);
	    printf(" %s\n %s\n",cmdv,userv);
#ifndef NOCSETS
	    printf(" %s\n",xlav);
#endif
	    printf(" %s for%s\n",ckxv,ckxsys);
	    printf(" %s for%s\n",ckzv,ckzsys);
	    printf(" %s\n",connv);
	    printf(" %s\n %s\n\n",dialv,loginv);
	    break;
 
	case SHMAC:			/* Macro definitions */
	    x = cmfld("Macro name, variable name, or carriage return","",&s,
		      NULL);
	    if (x == -3)
	      *line = '\0';
	    else if (x < 0)
	      return(x);
	    else
	      strcpy(line,s);
	    if ((y = cmcfm()) < 0) return(y);	    
	    if (*line != '\0' && *line != CMDQ && *line != '%') {
		x = mlook(mactab,s,nmac);
		switch (x) {
		  case -3:
		    return(0);
		  case -1:
		    printf("%s - not found\n",s);
		    return(0);
		  case -2:
		    y = strlen(line);
		    for (x = 0; x < nmac; x++)
		    if (!strncmp(mactab[x].kwd,line,y))
		      shomac(mactab[x].kwd,mactab[x].val);
		    return(1);
		  default:
		    shomac(mactab[x].kwd,mactab[x].val);
		    return(1);
		}
	    }
	    printf("Macros:\n");
	    for (y = 0; y < nmac; y++) {
		if (shomac(mactab[y].kwd,mactab[y].val) < 0) break;
	    }
	    break;

	case SHBUI:			/* Built-in variables */
	    if ((y = cmcfm()) < 0) return(y);
	    for (y = 0; y < nvars; y++)
	      printf(" \\v(%s) = %s\n",vartab[y].kwd,nvlook(vartab[y].kwd));
            break;

	case SHFUN:			/* Functions */
	    if ((y = cmcfm()) < 0) return(y);
	    for (y = 0; y < nfuncs; y++)
	      printf(" \\f%s()\n",fnctab[y].kwd);
	    break;

        case SHVAR:			/* Variables */
	    if ((y = cmcfm()) < 0) return(y);	    
	    x = 0;
	    for (y = 33; y < GVARS; y++)
	      if (g_var[y]) {
		  if (x == 0) printf("Global variables:\n");
		  x = 1;
		  printf(" \\%%%c = %s\n",y,g_var[y]);
	      }
	    if (!x) printf(" No variables defined\n");
	    break;

        case SHARG:			/* Args */
	    if ((y = cmcfm()) < 0) return(y);	    
	    if (maclvl > -1) {
		printf("Macro arguments at level %d\n",maclvl);
		for (y = 0; y < 10; y++)
		  if (m_arg[maclvl][y])
		    printf(" \\%%%d = %s\n",y,m_arg[maclvl][y]);
	    } else {
		printf(" No macro arguments at top level\n");
	    }
	    break;

        case SHARR:			/* Arrays */
	    if ((y = cmcfm()) < 0) return(y);	    
	    x = 0;
	    for (y = 0; y < 26; y++)
	      if (a_ptr[y]) {
		  if (x == 0) printf("Declared arrays:\n");
		  x = 1;
		  printf(" \\&%c[%d]\n",y+97,a_dim[y]);
	      }
	    if (!x) printf(" No arrays declared\n");
	    break;

	case SHPRO:			/* Protocol parameters */
	    if ((y = cmcfm()) < 0) return(y);
	    shoparp();
	    printf("\n");
	    break;

	case SHCOM:			/* Communication parameters */
	    if ((y = cmcfm()) < 0) return(y);
	    printf("\n");
	    shoparc();
	    printf("\n");
	    shomdm();
	    printf("\n");
	    break;

	case SHFIL:			/* File parameters */
	    if ((y = cmcfm()) < 0) return(y);
	    shoparf();
	    printf("\n");
	    break;

	case SHKEY: {			/* Key */
	    CHAR c;
	    if ((y = cmcfm()) < 0) return(y);	    
	    printf(" Press key: ");
	    c = coninc(0);		/* For some reason this doesn't */
	    printf("\\%d\n",c);		/* return the 8th bit... */
	    break;
	    }

#ifndef NOCSETS
	case SHLNG:			/* Languages */
	    if ((y = cmcfm()) < 0) return(y);
	    shoparl();
	    break;
#endif /* NOCSETS */

	case SHSCR:			/* Scripts */
	    if ((y = cmcfm()) < 0) return(y);	    
	    printf(" Take  Echo:     %s\n", techo  ? "On" : "Off");
	    printf(" Take  Error:    %s\n", terror ? "On" : "Off");
	    printf(" Macro Echo:     %s\n", mecho  ? "On" : "Off");
	    printf(" Macro Error:    %s\n", merror ? "On" : "Off");
	    printf(" Input Case:     %s\n", incase ? "Observe" : "Ignore");
	    printf(" Input Echo:     %s\n", inecho ? "On" : "Off");
	    printf(" Input Timeout:  %s\n", intime ? "Quit" : "Proceed");
	    break;

	  case SHXMI:
	    if ((y = cmcfm()) < 0) return(y);
            printf(" Transmit EOF: ");
	    if (*xmitbuf == NUL) {
		printf("none\n");
	    } else {
		char *p;
		p = xmitbuf;
		while (*p) {
		    if (*p < SP)
		      printf("^%c",ctl(*p));
		    else
		      printf("%c",*p);
		    p++;
		}
		printf("\n");
	    }
	    if (xmitf)
	      printf(" Transmit Fill: %d (fill character for blank lines)\n",
		   xmitf);
	    else printf(" Transmit Fill: none\n");
	    printf(" Transmit Linefeed: %s (send linefeeds too)\n",
		   xmitl ? "on" : "off");
	    if (xmitp) 
	      printf(" Transmit Prompt: %d (host line end character)\n",xmitp);
	    else printf(" Transmit Prompt: none\n");
	    break;

	  case SHMOD:			/* SHOW MODEM */
	    if ((y = cmcfm()) < 0) return(y);
	    shomdm();
	    break;

          case SHDFLT:
	    if ((y = cmcfm()) < 0) return(y);            
	    zsyscmd(PWDCMD);
            break;

	default:
	    printf("\nNothing to show...\n");
	    return(-2);
    }
    return(success = 1);
}

/* poor person's "more" for displaying macros */
/* note - doesn't account for line wrap */

shomac(s1, s2) char *s1, *s2; {
    int x, c, n, pp;
    pp = 0;

    n = 2;				/* Line counter, assume 24 */
    printf("%s = ",s1);			/* Print macro name */
    while (x = *s2++) {			/* Loop thru definition */
	if (x == '(') pp++;		/* Treat commas within parens */
	if (x == ')') pp--;		/* as ordinary text */
	if (pp < 0) pp = 0;		/* Outside parens, */
	if (x == ',' && pp == 0) {	/* comma becomes comma-dash-NL. */
	    printf(",-\n");
	    if (++n > 22) {		/* After a screenful, give them */
		printf("more? ");	/* a chance to read it */
		c = getchar();		/* or quit */
		switch (c) {
		  case 'n':
		  case 'N':
		    putchar(NL);
		    return(-1);
		  case SP:
		  case CR:
		  case 'y':
		  case 'Y':
		    putchar(NL);
		  case NL:
		    n = 0;
		    break;
		  default:
		    putchar(NL);
		    return(-1);
		}
	    }
	} else {
	    if (x == '\n') n++;
	    putchar(x);
	}
    }
    putchar(NL);
    return(0);
}

shoatt() {
    printf("Attributes: %s\n", atcapr ? "On" : "Off");
    if (!atcapr) return(0);
    printf(" Blocksize: %s\n", atblki ? "On" : "Off");
    printf(" Date: %s\n", atdati ? "On" : "Off");
    printf(" Disposition: %s\n", atdisi ? "On" : "Off");
    printf(" Encoding (Character Set): %s\n", atenci ? "On" : "Off");
    printf(" Length: %s\n", atleni ? "On" : "Off");
    printf(" Type (text/binary): %s\n", attypi ? "On" : "Off");
    printf(" System ID: %s\n", atsidi ? "On" : "Off");
    printf(" System Info: %s\n", atsysi ? "On" : "Off");
    return(0);
}

/* Evaluate an arithmetic expression. */
/* Code adapted from ev, by Howie Kaye of Columbia U & others. */

long xparse();			/* Fwd declaration of parse function */
long tokval;			/* current token value */
char *cp;			/* input expression pointer */
int xerror;			/* Parse error indicator */

char *
evala(s) char *s; {
    char *p;				/* Return pointer */
    long v;				/* Numeric value */

    xerror = 0;				/* Start out with no error */
    cp = s;				/* Make the argument global */
    v = xparse();			/* Parse the string */
    p = numbuf;				/* Convert long number to string */
    sprintf(p,"%ld",v);
    return(xerror ? "" : p);		/* Return empty string on error */
}

#define LONGBITS (8*sizeof (long))
#define NUMBER 'N'
#define EOT 'E'

/*
 g e t t o k

 Returns the next token.  If token is a NUMBER, sets tokval appropriately
*/

char
gettok() {
    while (isspace(*cp)) cp++ ;
    switch(*cp) {
      case '$':				/* ??? */
      case '+':				/* Add */
      case '-':				/* Subtract or Negate */
      case '@':				/* Greatest Common Divisor */
      case '*':				/* Multiply */
      case '/':				/* Divide */
      case '%':				/* Modulus */
      case '<':				/* Left shift */
      case '>':				/* Right shift */
      case '&':				/* And */
      case '|':				/* Or */
      case '#':				/* Exclusive Or */
      case '~':				/* Not */
      case '^':				/* Exponent */
      case '!':				/* Factorial */
      case '(':				/* Parens for grouping */
      case ')': return(*cp++);		/* operator, just return it */
      case '\n':
      case '\0': return(EOT);		/* end of line, return that */
    }
    if (isxdigit(*cp)) {		/* digit, must be a number */
	char tbuf[80],*tp;		/* buffer to accumulate number */
	int radix = 10;			/* default radix */
	for (tp=tbuf; isxdigit(*cp); cp++)
	  *tp++ = isupper(*cp) ? tolower(*cp) : *cp;
	*tp = '\0';			/* end number */
	switch(isupper(*cp) ? tolower(*cp) : *cp) { /* examine break char */
	  case 'h':
	  case 'x': radix = 16; cp++; break; /* if radix signifier... */
	  case 'o':
	  case 'q': radix = 8; cp++; break;
	  case 't': radix = 2; cp++; break;
	}
	for (tp=tbuf,tokval=0; *tp != '\0'; tp++)  {
	    int dig;
	    dig = *tp - '0';		/* convert number */
	    if (dig > 10) dig -= 'a'-'0'-10;
	    if (dig >= radix) {
		xerror = 1;
		if (cmdlvl == 0)
		  printf("invalid digit '%c' in number\n",*tp);
		return(NUMBER);
	    }
	    tokval = radix*tokval + dig;
	}
	return(NUMBER);
    }
    if (cmdlvl == 0)
      printf("Invalid character '%c' in input\n",*cp);
    xerror = 1;
    cp++;
    return(gettok());
}

char curtok;
long expval;

long
xparse() {
    curtok = gettok();
    expr();
#ifdef COMMENT
    if (curtok == '$') {
	curtok = gettok();
	if (curtok != NUMBER) {
	    if (cmdlvl == 0) printf("illegal radix\n");
	    return(0);
	}
	curtok = gettok();
    }
#endif
    if (curtok != EOT) {
	if (cmdlvl == 0)
	  printf("extra characters after expression\n");
	xerror = 1;
    }
    return(expval);
}

/*
 * expr ::= term exprp
 *
 */

expr() {
    term();
    exprp();
}

/*
 * exprp ::= NULL | {+,-,|,...} term exprp
 *
 */

/*
 Replacement for strchr() and index(), neither of which seem to be universal.
*/

static char *
windex(s,c) char *s, c; {
    while (*s != NUL && *s != c) s++;
    if (*s == c) return(s); else return(NULL);
}

exprp() {
    while (windex("+-|<>#@",curtok) != NULL) {
	long oldval, gcd();
	char op;
	op = curtok;
	curtok = gettok();		/* skip past operator */
	oldval = expval;
	term();
	switch(op) {
	  case '+' : expval = oldval + expval; break;
	  case '-' : expval = oldval - expval; break;
	  case '|' : expval = oldval | expval; break;
	  case '#' : expval = oldval ^ expval; break;
	  case '@' : expval = gcd(oldval,expval); break;
	  case '<' : expval = oldval << expval; break;
	  case '>' : expval = oldval >> expval; break;
  }
 }
}

/*
 * term ::= factor termp
 *
 */

term() {
    factor();
    termp();
}

/*
 * termp ::= NULL | {*,/,%,&} factor termp
 *
 */

termp() {
    while (curtok == '*' || curtok == '/' || curtok == '%' || curtok == '&') {
	long oldval;
	char op;
	op = curtok;
	curtok = gettok();		/* skip past operator */
	oldval = expval;
	factor();
	switch(op) {
	  case '*': expval = oldval * expval; break;
	  case '/': expval = oldval / expval; break;
	  case '%': expval = oldval % expval; break;
	  case '&': expval = oldval & expval; break;
	}
    }
}

/*
 * factor ::= simple | simple ^ factor
 *
 */

factor() {
    long oldval,expon();
    simple();
    if (curtok == '^') {
	oldval = expval;
	curtok = gettok();
	factor();
	expval = expon(oldval,expval);
    }
}

/*
 * simple ::= {-,~} simpler | simpler
 *
 */

simple() {
    if (curtok == '-' || curtok == '~') {
	int op = curtok;
	curtok = gettok();		/* skip over - sign */
	simpler();			/* parse the factor again */
	expval = op == '-' ? -expval : ~expval;
    } else simpler();
}

/*
 * simpler ::= simplest | simplest !
 *
 */

simpler() {
    long fact();
    simplest();
    if (curtok == '!') {
	curtok = gettok();
	expval = fact(expval);
    }
}

/*
 * simplest ::= NUMBER | ( expr )
 *
 */

simplest() {
    if (curtok == NUMBER) expval = tokval;
    else if (curtok == '(') {
	curtok = gettok();		/* skip over paren */
	expr();
	if (curtok != ')') {
	    if (cmdlvl == 0) printf("missing right parenthesis\n");
	    xerror = 1;
	}
    }
    else {
	if (cmdlvl == 0) printf("operator unexpected\n");
	xerror = 1;
    }
    curtok = gettok();
}

long
expon(x,y) long x,y; {
    long result = 1;
    int sign = 1;
    if (y < 0) return(0);
    if (x < 0) {
	x = -x;
	if (y & 1) sign = -1;
    }
    while (y != 0) {
	if (y & 1) result *= x;
	y >>= 1;
	if (y != 0) x *= x;
  }
  return(result * sign);
}

long gcd(x,y) long x,y; {
    int nshift = 0;
    if (x < 0) x = -x;
    if (y < 0) y = -y;			/* validate arguments */
    if (x == 0 || y == 0) return(x + y);    /* this is bogus */
    
    while (!((x & 1) | (y & 1))) {	/* get rid of powers of 2 */
	nshift++;
	x >>= 1;
	y >>= 1;
    }
    while (x != 1 && y != 1 && x != 0 && y != 0) {
	while (!(x & 1)) x >>= 1;	/* eliminate unnecessary */
	while (!(y & 1)) y >>= 1;	/* powers of 2 */
	if (x < y) {			/* force x to be larger */
	    long t;
	    t = x;
	    x = y;
	    y = t;
	}
	x -= y;
    }
    if (x == 0 || y == 0) return((x + y) << nshift); /* gcd is non-zero one */
    else return((long) 1 << nshift);	/* else gcd is 1 */
}

long fact(x) long x; {			/* factorial */
    long result = 1;
    while (x > 1)
      result *= x--;
    return(result);
}

/*  D C L A R R A Y  --  Declare an array  */

dclarray(a,n) char a; int n; {		/* Declare an array of size n */
    char **p; int i, n2;

    if ((a < 'a') || (a > 'z')) return(-1); /* Verify name */
    a -= 'a';				/* Convert name to number */
    if ((p = a_ptr[a]) != NULL) {	/* Delete old array of same name */
	n2 = a_dim[a];
	for (i = 0; i <= n2; i++)	/* First delete its elements */
	  if (p[i]) free(p[i]);
	free(a_ptr[a]);			/* Then the element list */
	a_ptr[a] = (char **) NULL;	/* Remove pointer to element list */
	a_dim[a] = 0;			/* Set dimension at zero. */
    }
    if (n == 0) return(0);		/* If dimension 0, just deallocate. */

    p = (char **) malloc((n+1) * sizeof(char *)); /* Allocate for new array */
    if (p == NULL) return(-1);		/* Check */
    a_ptr[a] = p;			/* Save pointer to member list */
    a_dim[a] = n;			/* Save dimension */
    for (i = 0; i <= n; i++)		/* Initialize members to null */
      p[i] = NULL;
    return(0);
}

/*  A R R A Y N A M  --  Parse an array name  */

/*  Call with pointer to string that starts with the array reference  */
/*  String may begin with either \& or just &. */

/*  On success,
    Returns letter ID (always lowercase) in argument c,
    Dimension or subscript in argument n.
    IMPORTANT: These arguments must be provided by the caller as addresses
    of ints (not chars), for example:
      char *s; int x, y;
      arraynam(s,&x,&y);
    On failure, returns a negative number, with args n and c set to zero.
*/

arraynam(ss,c,n) char *ss; int *c; int *n; {
    int i, y, pp;
    char *s, *p, *sx, *vnp;
    char vnbuf[VNAML+1];		/* On stack to allow for */
    char ssbuf[VNAML+1];		/* recursive calls... */
    char sxbuf[VNAML+1];

    *c = *n = 0;			/* Initialize return values */
    strncpy(vnbuf,ss,VNAML);
    vnp = vnbuf;
    if (vnbuf[0] == CMDQ && vnbuf[1] == '&') vnp++;
    if (*vnp != '&') {
	printf("?Not an array - %s\n",vnbuf);
	return(-9);
    }
    if (!isalpha(*(vnp+1)) || (*(vnp+2) != '[')) {
	printf("?Invalid format for array name - %s\n",vnbuf);
	return(-9);
    }
    y = *(vnp + 1);			/* Fold case of array name */
    if (isupper(y)) y = *(vnp + 1) = tolower(y);
    *c = y;				/* Return the array name */
    s = vnp+3;				/* Get dimension */
    p = ssbuf;    
    pp = 1;				/* Bracket counter */
    for (i = 0; i < VNAML && *s != NUL; i++) { /* Copy up to ] */
	if (*s == '[') pp++;
	if (*s == ']' && --pp == 0) break;
	*p++ = *s++;
    }
    if (*s != ']') {
	printf("?No closing bracket on array dimension - %s\n",vnbuf);
	return(-9);
    }
    *p = NUL;				/* Terminate subscript with null */
    p = ssbuf;				/* Point to beginning of subscript */
    sx = sxbuf;				/* Where to put expanded subscript */
    y = VNAML-1;
    xxstring(p,&sx,&y);			/* Convert variables, etc. */
    if (!chknum(sxbuf)) {		/* Make sure it's all digits */
	printf("?Array dimension or subscript must be numeric - %s\n",sxbuf);
	return(-9);
    }
    if ((y = atoi(sxbuf)) < 0) {
        if (cmflgs == 0) printf("\n");
        printf("?Array dimension or subscript must be positive or zero - %s\n",
	       sxbuf);
	return(-9);
    }
    *n = y;				/* Return the subscript or dimension */
    return(0);
}

chkarray(a,i) int a, i; {		/* Check if array is declared */
    int x;				/* and if subscript is in range */
    x = a - 'a';
    if (a_ptr[x] == NULL) return(-1);	/* Not declared */
    if (i > a_dim[x]) return(-2);	/* Subscript out of range. */
    return(a_dim[x]);			/* All ok, return dimension */
}

char *
arrayval(a,i) int a, i; {		/* Return value of \&a[i] */
    int x; char **p;			/* (possibly NULL) */

    x = a - 'a';
    if ((p = a_ptr[x]) == NULL)		/* Array not declared */
      return(NULL);
    if (i > a_dim[x])			/* Subscript out of range. */
      return(NULL);
    return(p[i]);			/* All ok, return pointer to value. */
}

/*  P A R S E V A R  --  Parse a variable name or array reference.  */
/*
 Call with:
   s  = pointer to candidate variable name or array reference.
   *c = address of integer in which to return variable ID.
   *i = address of integer in which to return array subscript.
 Returns:
   -2:  syntax error in variable name or array reference.
    1:  successful parse of a simple variable, with ID in c.
    2:  successful parse of an array reference, w/ID in c and subscript in i.
*/
parsevar(s,c,i) char *s; int *c, *i; {
    char *p;
    int x,y,z;

    p = s;
    if (*s == CMDQ) s++;		/* Point after backslash */

    if (*s != '%' && *s != '&') {	/* Make sure it's % or & */
	printf("?Not a variable name - %s\n",p);
	return(-9);
    }
    if (strlen(s) < 2) {
	printf("?Incomplete variable name - %s\n",p);
	return(-9);
    }
    if (*s == '%' && *(s+2) != '\0') {
	printf("?Only one character after '%%' in variable name, please\n");
	return(-9);
    }
    if (*s == '&' && *(s+2) != '[') {
	printf("?Array subscript expected - %s\n",p);
	return(-9);
    }
    if (*s == '%') {			/* Simple variable. */
	y = *(s+1);			/* Get variable ID letter/char */
	if (isupper(y)) y -= ('a'-'A');	/* Convert upper to lower case */
	*c = y;				/* Set the return values. */
	*i = -1;			/* No array subscript. */
	return(1);			/* Return 1 = simple variable */
    }
    if (*s == '&') {			/* Array reference. */
	if (arraynam(s,&x,&z) < 0) { /* Go parse it. */
	    printf("?Invalid array reference - %s\n",p);
	    return(-9);
	}
	if (chkarray(x,z) < 0) {	/* Check if declared, etc. */
	    printf("?Array not declared or subscript out of range\n");
	    return(-9);
	}
	*c = x;				/* Return array letter */
	*i = z;				/* and subscript. */
	return(2);
    }    
    return(-2);				/* None of the above. */
}

#define VALN 20

/* Get the numeric value of a variable */
/*
  Call with pointer to variable name, pointer to int for return value.
  Returns:
    0 on success with second arg containing the value.
   -1 on failure (bad variable syntax, variable not defined or not numeric).
*/
varval(s,v) char *s; int *v; {
    char valbuf[VALN+1];		/* s is pointer to variable name */
    char *p;
    int y;

    p = valbuf;				/* Expand variable into valbuf. */
    y = VALN;
    if (xxstring(s,&p,&y) < 0) return(-1);
    p = valbuf;				/* Make sure value is numeric */
    if (!chknum(p)) return(-1);
    *v = atoi(p);			/* Convert numeric string to int */
    return(0);    
}

/* Increment or decrement a variable */
/* Returns -1 on failure, 0 on success, with 4th argument set to result */

incvar(s,x,z,r) char *s; int x, z, *r; { /* Increment a numeric variable */
    char valbuf[VALN+1];		/* s is pointer to variable name */
					/* x is amount to increment by */
    int n;				/* z != 0 means add */
					/* z = 0 means subtract */

    if (varval(s,&n) < 0)		/* Convert numeric string to int */
      return(-1);
    if (z)				/* Increment it by the given amount */
      n += x;
    else				/* or decrement as requested. */
      n -= x;
    sprintf(valbuf,"%d",n);		/* Convert back to numeric string */
    addmac(s,valbuf);			/* Replace old variable */
    *r = n;				/* Return the integer value */
    return(0);
}

/* Functions moved here from ckuusr.c to even out the module sizes... */

/* D O D O  --  Do a macro */

/*
  Call with x = macro table index, s = pointer to arguments.
  Returns 0 on failure, 1 on success.
*/

dodo(x,s) int x; char *s; {
    char *p;
    int b, y, z;

    debug(F101,"dodo maclvl","",maclvl);
    if (++maclvl > MACLEVEL) {		/* Make sure we have storage */
        debug(F101,"dodo maclvl too deep","",maclvl);
	--maclvl;
	printf("Macros nested too deeply\n");
	return(0);
    }
    macp[maclvl] = mactab[x].val;	/* Point to the macro body */ 
    macx[maclvl] = mactab[x].val;	/* Remember where the beginning is */
    debug(F111,"do macro",macp[maclvl],maclvl);

    cmdlvl++;				/* Entering a new command level */
    if (cmdlvl > CMDSTKL) {		/* Too many macros + TAKE files? */
        debug(F101,"dodo cmdlvl too deep","",cmdlvl);
	cmdlvl--;
	printf("?TAKE files and DO commands nested too deeply\n");
	return(0);
    }
#ifdef VMS
    conres();				/* So Ctrl-C, etc, will work. */
#endif
    ifcmd[cmdlvl] = 0;
    iftest[cmdlvl] = 0;
    count[cmdlvl] = 0;
    cmdstk[cmdlvl].src = CMD_MD;	/* Say we're in a macro */
    cmdstk[cmdlvl].val = maclvl;	/* and remember the macro level */
    mrval[maclvl] = NULL;		/* Initialize return value */

    debug(F110,"do macro",mactab[x].kwd,0);

/* Clear old %0..%9 arguments */

    addmac("%0",mactab[x].kwd);		/* Define %0 = name of macro */
    varnam[0] = '%';
    varnam[2] = '\0';
    for (y = 1; y < 10; y++) {		/* Clear args %1..%9 */
	varnam[1] = y + '0';
	delmac(varnam);
    }	

/* Assign the new args one word per arg, allowing braces to group words */

    p = s;				/* Pointer to beginning of arg */
    b = 0;				/* Flag for outer brace removal */
    x = 0;				/* Flag for in-word */
    y = 0;				/* Brace nesting level */
    z = 0;				/* Argument counter, 0 thru 9 */

    while (1) {				/* Go thru argument list */
	if (*s == '\0') {		/* No more characters? */
	    if (x != 0) {
		if (z == 9) break;	/* Only go up to 9. */
		z++;			/* Count it. */
		varnam[1] = z + '0';	/* Assign last argument */
		addmac(varnam,p);
		break;			/* And get out. */
	    } else break;
	} 
	if (x == 0 && *s == ' ') {	/* Eat leading blanks */
	    s++;
	    continue;
	} else if (*s == '{') {		/* An opening brace */
	    if (x == 0 && y == 0) {	/* If leading brace */
		p = s+1;		/* point past it */
		b = 1;			/* and flag that we did this */
	    }
	    x = 1;			/* Flag that we're in a word */
	    y++;			/* Count the brace. */
	} else if (*s == '}') {		/* A closing brace. */
	    y--;			/* Count it. */
	    if (y == 0 && b != 0) {	/* If it matches the leading brace */
		*s = ' ';		/* change it to a space */
		b = 0;			/* and we're not in braces any more */
	    } else if (y < 0) x = 1;	/* otherwise just start a new word. */
	} else if (*s != ' ') {		/* Nonspace means we're in a word */
	    if (x == 0) p = s;		/* Mark the beginning */
	    x = 1;			/* Set in-word flag */
	}
	/* If we're not inside a braced quantity, and we are in a word, and */
	/* we have hit a space, then we have an argument to assign. */
	if ((y < 1) && (x != 0) && (*s == ' ')) { 
	    *s = '\0';			/* terminate the arg with null */
	    x = 0;			/* say we're not in a word any more */
	    y = 0;			/* start braces off clean again */
	    if (z == 9) break;		/* Only go up to 9. */
	    z++;			/* count this arg */
	    varnam[1] = z + '0';	/* compute its name */
	    addmac(varnam,p);		/* add it to the macro table */
	    p = s+1;
	}
	s++;				/* Point past this character */
    }
    if ((z == 0) && (y > 1)) {		/* Extra closing brace(s) at end */
	z++;
	varnam[1] = z + '0';		/* compute its name */
	addmac(varnam,p);		/* Add rest of line to last arg */
    }
    macargc[maclvl] = z + 1;		/* For ARGC variable */
    return(1);				/* DO command succeeded */
}

/* Insert "literal" quote around each comma-separated command to prevent */
/* its premature expansion.  Only do this if object command is surrounded */
/* by braces. */

static char* flit = "\\flit(";

litcmd(src,dest) char **src, **dest; {
    int bc = 0, pp = 0;
    char *s, *lp, *ss;

    s = *src;
    lp = *dest;

    while (*s == SP) s++;		/* strip extra leading spaces */
    if (*s == '{') {

        pp = 0;				/* paren counter */
	bc = 1;				/* count leading brace */
	*lp++ = *s++;			/* copy it */
	while (*s == SP) s++;		/* strip interior leading spaces */
	ss = flit;			/* point to "\flit(" */
	while (*lp++ = *ss++) ;		/* copy it */
	lp--;				/* back up over null */
	while (*s) {			/* go thru rest of text */
	    ss = flit;			/* point back to start of "\flit(" */
	    if (*s == '{') bc++;	/* count brackets */
	    if (*s == '(') pp++;	/* and parens */
	    if (*s == ')') pp--;
	    if (*s == '}') {		/* Closing brace. */
		if (--bc == 0) {	/* Final one? */
		    *lp++ = ')';	/* Add closing paren for "\flit()" */
		    *lp++ = *s++;
		    break;
		}
	    }
	    if (*s == ',' && pp == 0) {	/* comma not inside of parens */
		*lp++ = ')';		/* closing ) of \flit( */
		*lp++ = ',';		/* insert the comma */
		while (*lp++ = *ss++) ;	/* start new "\flit(" */
		lp--;			/* back up over null */
		s++;			/* skip over comma in source string */
		while (*s++ == SP);	/* eat leading spaces again. */
		s--;			/* back up over nonspace */
		continue;
	    }
            *lp++ = *s++;		/* Copy anything but comma here. */
        }
	*lp = NUL;
    } else {				/* No brackets around, */
	while (*lp++ = *s++) ;		/* just copy. */
	lp--;
    }
    *src = s;
    *dest = lp;
    if (bc) return(-1);
    else return(0);
}

docd() {				/* Do the CD command */
    int x;
    char *s;

#ifdef AMIGA
    if ((x = cmtxt("Name of local directory, or carriage return","",&s,
		   xxstring)) < 0)
    	return(x);
    /* if no name, just print directory name */
    if (*s) {
	if (chdir(s)) {
	    cwdf = success = 0;
	    perror(s);
	}
	success = cwdf = 1;
    }
    if (getcwd(line, LINBUFSIZ) == NULL)
      printf("Current directory name not available.\n");
    else
      if (pflag && cmdlvl == 0) printf("%s\n", line);
#else
    if ((x = cmdir("Name of local directory, or carriage return",homdir,&s,
		   xxstring)) < 0 )
      return(x);
    if (x == 2) {
	printf("?Wildcards not allowed in directory name\n");
	return(-9);
    }
#ifdef OS2
    if ( s!=NUL ) {
	if (strlen(s)>=2 && s[1]==':') {	/* Disk specifier */
	    if (zchdsk(*s)) {			/* Change disk successful */
	    	if ( strlen(s)>=3 & ( s[2]==CMDQ || isalnum(s[2]) ) ) {
	    	    if (chdir(s)) perror(s);
	    	}
	    } else {
		cwdf = success = 0;
		perror(s);
	    }
	} else if (chdir(s)) {
	    cwdf = success = 0;
	    perror(s);
	}
    }
    success = cwdf = 1;
    concooked();
    xsystem(PWDCMD);
    conraw();
#else
    if (! zchdir(s)) {
	cwdf = 0;
	perror(s);
    }
    zsyscmd(PWDCMD);			/* assume this works... */
    cwdf = 1;				/* system() doesn't tell */
#endif
#endif
    return(cwdf);
}

fixcmd() {			/* Fix command parser after interruption */
    dostop();			/* Back to top level (also calls conint()). */
    bgchk();			/* Check background status */
    if (*psave) {		/* If old prompt saved, */
	cmsetp(psave);		/* restore it. */
	*psave = NUL;
    }
    success = 0;		/* Tell parser last command failed */
}
#endif /* NOICP */

