char *ckxv = "Unix tty I/O, 5A(074), 26 Nov 90";

/*  C K U T I O  */

/* C-Kermit interrupt, terminal control & i/o functions for Unix systems */

/*
 Author: Frank da Cruz (fdc@cunixc.cc.columbia.edu, FDCCU@CUVMA.BITNET),
 Columbia University Center for Computing Activities.  Many other contributors.
 First released January 1985.
 Copyright (C) 1985, 1990, Trustees of Columbia University in the City of New
 York.  Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as it is not sold for profit, provided this
 copyright notice is retained.
*/

/* Includes for all Unixes (conditional includes come later) */

#include "ckcdeb.h"			/* This moved to here. */
#include "ckcnet.h"			/* Symbols for network types. */

#include <sys/types.h>                  /* Data types */
#include <errno.h>			/* System error numbers */

#ifdef SDIRENT				/* Directory bits... */
#define DIRENT
#endif

#ifdef XNDIR
#include <sys/ndir.h>
#else /* !XNDIR */
#ifdef NDIR
#include <ndir.h>
#else /* !NDIR, !XNDIR */
#ifdef RTU
#include "/usr/lib/ndir.h"
#else /* !RTU, !NDIR, !XNDIR */
#ifdef DIRENT
#ifdef SDIRENT
#include <sys/dirent.h>
#else
#include <dirent.h>
#endif /* SDIRENT */
#else /* !RTU, !NDIR, !XNDIR, !DIRENT, i.e. all others */
#include <sys/dir.h>
#endif /* DIRENT */
#endif /* RTU */
#endif /* NDIR */
#endif /* XNDIR */

/* Definition of HZ, used in msleep() */

#ifdef MIPS
#define HZ ( 1000 / CLOCK_TICK )
#else
#ifdef UXIII
#ifndef NAP
#ifndef TRS16
#include <sys/param.h>
#else
#define HZ ( 1000 / CLOCK_TICK )
#endif /* TRS16 */
#endif /* NAP */
#endif /* UXIII */
#endif /* MIPS */

#ifdef M_UNIX
#undef NGROUPS_MAX		/* Prevent multiple definition warnings */
#endif

#include <ctype.h>                      /* Character types */

#ifdef NULL				/* To avoid complaints from stdio.h */
#undef NULL
#endif /* NULL */

#include <stdio.h>                      /* Unix Standard i/o */
#include <signal.h>                     /* Interrupts */

#ifndef NULL				/* In case NULL not defined in stdio */
#define NULL 0L
/* or #define NULL ((char *) 0)  */
#endif

/* For setjmp and longjmp */

#ifndef ZILOG
#include <setjmp.h>
#else
#include <setret.h>
#endif /* ZILOG */

/* from here... #include "ckcdeb.h"     /* Typedefs, formats for debug() */

/* Maximum length for the name of a tty device */

#ifndef DEVNAMLEN
#define DEVNAMLEN 25
#endif

#ifdef	NETCONN
#undef DEVNAMLEN
#define DEVNAMLEN 50			/* longer field for host:service */
#endif  /* NETCONN */

#ifdef BSD4
#ifdef MAXNAMLEN
#define BSD42
#endif
#endif

/*
 Minix support added by Charles Hedrick,
 Rutgers University:  hedrick@aramis.rutgers.edu
 Minix also has V7 enabled.
*/

#ifdef MINIX
#define TANDEM 0
#define MYREAD
#include <limits.h>
#endif

#include "ckuver.h"			/* Version herald */
char *ckxsys = HERALD;

/* UUCP lock file name definition */

#ifndef NOUUCP

/* Name of UUCP tty device lock file */

#ifdef ACUCNTRL
#define LCKDIR
#endif

/* (PWP) if LOCK_DIR is already defined, we don't change it */
#ifndef LOCK_DIR
#ifdef RTAIX				/* IBM RT PC AIX 2.2.1 */
#define PIDSTRING
#define LOCK_DIR "/etc/locks";
#else
#ifdef AIXRS
#define PIDSTRING
#define LOCK_DIR "/etc/locks";
#else
#ifdef ISIII
#define LOCK_DIR "/etc/locks";
#else
#ifdef HDBUUCP
#define PIDSTRING
#ifdef M_SYS5  /* wht@n4hgf - SCO */
#define LOCK_DIR "/usr/spool/uucp";
#else
#define LOCK_DIR "/usr/spool/locks";
#endif
#else
#ifdef LCKDIR
#define LOCK_DIR "/usr/spool/uucp/LCK";
#else
#define LOCK_DIR "/usr/spool/uucp";
#endif /* LCKDIR */
#endif /* HDBUUCP */
#endif /* ISIII */
#endif /* AIXRS */
#endif /* RTAIX */
#endif /* !LOCK_DIR (outside ifndef) */
   
#endif /* !NOUUCP */

#ifdef UXIII
#define MYREAD
#endif /* uxiii */

#ifdef ATT7300
/* bits for attmodem: internal modem in use, restart getty */
#define MYREAD
#define ISMODEM 1
#define DOGETY 512
#endif  /* att7300 */

#ifdef BSD42
#define MYREAD
#endif /* bsd42 */

#ifdef NETCONN				/* Sunlink X.25 support added by */
#ifdef SUNX25				/* Marcello Frutig, */
#ifdef MYREAD				/* Catholic University, */
#undef MYREAD				/* Rio de Janeiro, Brazil. */
#endif 
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/mbuf.h>
#include <sys/socket.h>
#include <sys/protosw.h>
#include <sys/domain.h>
#include <sys/socketvar.h>
#include <net/if.h>
#include <sundev/syncstat.h>
#include <netx25/x25_pk.h>
#include <netx25/x25_ctl.h>
#include <netx25/x25_ioctl.h>
#endif /* SUNX25 */
#endif /* NETCONN */ 

/*
 Variables available to outside world:

   dftty  -- Pointer to default tty name string, like "/dev/tty".
   dfloc  -- 0 if dftty is console, 1 if external line.
   dfprty -- Default parity
   dfflow -- Default flow control
   ckxech -- Flag for who echoes console typein:
     1 - The program (system echo is turned off)
     0 - The system (or front end, or terminal).
   functions that want to do their own echoing should check this flag
   before doing so.

   flfnam  -- Name of lock file, including its path, e.g.,
                "/usr/spool/uucp/LCK..cul0" or "/etc/locks/tty77"
   lkflfn  -- Name of link to lock file, including its paths
   haslock -- Flag set if this kermit established a uucp lock.
   backgrd -- Flag indicating program executing in background ( & on
                end of shell command). Used to ignore INT and QUIT signals.
   rtu_bug -- Set by stptrap().  RTU treats ^Z as EOF (but only when we handle
                SIGTSTP)

 Functions for assigned communication line (either external or console tty):

   sysinit()               -- System dependent program initialization
   syscleanup()            -- System dependent program shutdown
   ttopen(ttname,local,mdmtyp,timo) -- Open the named tty for exclusive access.
   ttclos()                -- Close & reset the tty, releasing any access lock.
   ttsspd(cps)             -- Set the transmission speed of the tty.
   ttgspd()                -- Get (read) the the transmission speed of the tty.
   ttpkt(speed,flow,parity -- Put the tty in packet mode and set the speed.
   ttvt(speed,flow)        -- Put the tty in virtual terminal mode.
                                or in DIALING or CONNECTED modem control state.
   ttres()                 -- Restore original tty modes.
   ttscarr(carrier)        -- Set carrier control mode, on/off/auto.
   ttinl(dest,max,timo)    -- Timed read line from the tty.
   ttinc(timo)             -- Timed read character from tty.
   myread()                -- Raw mode bulk buffer read, gives subsequent
                                chars one at a time and simulates FIONREAD.
   myunrd(c)               -- Places c back in buffer to be read (one only)
   ttchk()                 -- See how many characters in tty input buffer.
   ttxin(n,buf)            -- Read n characters from tty (untimed).
   ttol(string,length)     -- Write a string to the tty.
   ttoc(c)                 -- Write a character to the tty.
   ttflui()                -- Flush tty input buffer.
   ttsndb()                -- Send BREAK signal.

   ttlock(ttname)          -- "Lock" tty device against uucp collisions.
   ttunlck()               -- Unlock tty device.

                              For ATT7300/Unix PC, System V:
   attdial(ttname,speed,telnbr) -- dials ATT7300/Unix PC internal modem
   offgetty(ttname)        -- Turns off getty(1m) for comms line
   ongetty(ttname)         -- Restores getty() to comms line
*/

/*
Functions for console terminal:

   congm()   -- Get console terminal modes.
   concb(esc) -- Put the console in single-character wakeup mode with no echo.
   conbin(esc) -- Put the console in binary (raw) mode.
   conres()  -- Restore the console to mode obtained by congm().
   conoc(c)  -- Unbuffered output, one character to console.
   conol(s)  -- Unbuffered output, null-terminated string to the console.
   conola(s) -- Unbuffered output, array of strings to the console.
   conxo(n,s) -- Unbuffered output, n characters to the console.
   conchk()  -- Check if characters available at console (bsd 4.2).
                Check if escape char (^\) typed at console (System III/V).
   coninc(timo)  -- Timed get a character from the console.
   conint()  -- Enable terminal interrupts on the console if not background.
   connoi()  -- Disable terminal interrupts on the console if not background.

Time functions

   msleep(m) -- Millisecond sleep
   ztime(&s) -- Return pointer to date/time string
   rtimer() --  Reset timer
   gtimer()  -- Get elapsed time since last call to rtimer()
*/

/* Conditional Includes */

/* Whether to include <sys/file.h> */

#ifdef RTU				/* RTU doesn't */
#define NOFILEH
#endif

#ifdef CIE				/* CIE does. */
#undef NOFILEH
#endif

#ifdef BSD41				/* 4.1 BSD doesn't */
#define NOFILEH
#endif

#ifdef is68k				/* is68k (whatever that is)  */
#define NOFILEH
#endif

#ifdef MINIX				/* MINIX */
#define NOFILEH
#endif

#ifndef NOFILEH				/* Now include if selected. */
#include <sys/file.h>
#endif

/* Whether to include <fcntl.h> */

#ifdef aegis
#include <fcntl.h>
#endif /* aegis */

/* #ifndef RTU -- Farrel Woods says we *should* include this for RTU */
#ifndef is68k
#ifdef BSD4
#ifndef BSD41
#include <fcntl.h>
#endif /* BSD41 */
#endif /* BSD4 */
#endif /* not is68k */
/* #endif /* not RTU */

/* System III, System V */

#ifdef UXIII
#include <termio.h>

#ifndef NOSYSIOCTLH
#include <sys/ioctl.h>
#endif /* NOSYSIOCTLH */

#include <fcntl.h>                      /* directory reading for locking */
#ifdef ATT7300
#include <sys/phone.h>                  /* Unix PC, internal modem dialer */
#endif /* ATT7300 */
#endif /* UXIII */

#ifdef HPUX
#ifdef hp9000s500
#undef HPUXnot500
#else
#define HPUXnot500
#endif
#else
#undef HPUXnot500
#endif

#ifdef HPUX
#include <sys/modem.h>
#ifndef hp9000s500
#include <sys/bsdtty.h>
#endif
#endif

/* Not Sys III/V */

#ifndef UXIII
#include <sgtty.h>                      /* Set/Get tty modes */
#ifndef PROVX1
#ifndef V7
#ifndef BSD41
#include <sys/time.h>                   /* Clock info (for break generation) */
#endif /* not bsd41 */
#endif /* not v7 */
#endif /* not provx1 */
#endif /* not uxiii */

#ifdef BSD41
#include <sys/timeb.h>                  /* BSD 4.1 ... ceb */
#endif /* bsd41 */

#ifdef BSD29
#include <sys/timeb.h>                  /* BSD 2.9 (Vic Abell, Purdue) */
#endif /* bsd29 */

#ifdef TOWER1
#include <sys/timeb.h>                  /* Clock info for NCR Tower */
#endif /* tower1 */

#ifdef ultrix
#include <sys/ioctl.h>
#endif

#ifdef aegis
#include "/sys/ins/base.ins.c"
#include "/sys/ins/error.ins.c"
#include "/sys/ins/ios.ins.c"
#include "/sys/ins/sio.ins.c"
#include "/sys/ins/pad.ins.c"
#include "/sys/ins/time.ins.c"
#include "/sys/ins/pfm.ins.c"
#include "/sys/ins/pgm.ins.c"
#include "/sys/ins/ec2.ins.c"
#include "/sys/ins/type_uids.ins.c"
#include <default_acl.h>
#undef TIOCEXCL
#undef FIONREAD
#endif

#ifdef sxaE50				/* PFU Compact A SX/A TISP V10/L50 */
#undef FIONREAD
#endif

/* The following two conditional #defines are catch-alls for those systems */
/* that didn't have or couldn't find <file.h>... */

#ifndef FREAD
#define FREAD 0x01
#endif

#ifndef FWRITE
#define FWRITE 0x10
#endif

#ifndef O_RDONLY
#define O_RDONLY 000
#endif

/* Declarations */

long time();                            /* All Unixes should have this... */
extern char *malloc(), *getenv();	/* and these. */
extern int errno;                       /* System call error code. */
long ttgspd();				/* Declared below. */

/* Special stuff for V7 input buffer peeking */

#ifdef  V7
int kmem[2] = { -1, -1};
char *initrawq(), *qaddr[2]={0,0};
#define CON 0
#define TTY 1
#endif /* v7 */

/* dftty is the device name of the default device for file transfer */
/* dfloc is 0 if dftty is the user's console terminal, 1 if an external line */

#ifndef DFTTY
#ifdef PROVX1
    char *dftty = "/dev/com1.dout"; /* Only example so far of a system */
    char *dfmdm = "none";
    int dfloc = 1;                  /* that goes in local mode by default */
#else
#ifdef COHERENT
    char *dftty = "/dev/modem";
    char *dfmdm = "none";
    int dfloc = 1;
#else
    char *dftty = CTTNAM;               /* Remote by default, use normal */
    char *dfmdm = "none";
    int dfloc = 0;                      /* controlling terminal name. */
#endif /* COHERENT */
#endif /* PROVX1 */
#else
    char *dftty = DFTTY;		/* Default location specified on */
    char *dfmdm = "none";		/* command line. */
    int dfloc = 1;                      /* controlling terminal name. */
#endif

#ifdef RTU
    int rtu_bug = 0;		    /* set to 1 when returning from SIGTSTP */
#endif

    int dfprty = 0;                     /* Default parity (0 = none) */
    int ttprty = 0;                     /* Parity in use. */
    int ttmdm = 0;                      /* Modem in use. */
    int ttcarr = CAR_AUT;		/* Carrier handling mode. */
    int dfflow = 1;                     /* Xon/Xoff flow control */
    int backgrd = 0;                    /* Assume in foreground (no '&' ) */
#ifdef ultrix
    int iniflags = 0;			/* fcntl flags for ttyfd */
#endif
    int fdflag = 0;			/* Flag for redirected stdio */
    int tvtflg = 0;			/* Flag that ttvt has been called */
    long ttspeed = -1;			/* For saving speed */
    int ttflow = -9;			/* For saving flow */
    int ttnproto = 0;			/* Network protocol, 0 = none. */

int ckxech = 0; /* 0 if system normally echoes console characters, else 1 */

/* Declarations of variables global within this module */

static time_t tcount;			/* Elapsed time counter */
static SIGTYP (*saval)() = NULL;	/* for saving alarm handler */

static char *brnuls = "\0\0\0\0\0\0\0"; /* A string of nulls */

static jmp_buf sjbuf;			/* Longjump buffers */
#ifdef V7
static jmp_buf jjbuf;
#endif

static
int ttyfd = -1;				/* TTY file descriptor */

static int lkf = 0,                     /* Line lock flag */
    cgmf = 0,                           /* Flag that console modes saved */
    xlocal = 0,                         /* Flag for tty local or remote */
    curcarr = 0;			/* Carrier mode: require/ignore. */

/* Network support */
#ifdef NETCONN
#ifdef SUNX25
extern qbitpk();
#endif /* SUNX25 */
#include "ckcnet.h"			/* Network type symbols */
static int ttnet = 0;			/* Network type */
#ifdef EXCELAN
#include <ex_errno.h>			/* Excelan network error constants */
#endif /* EXCELAN */
#endif /* NETCONN */
static int netconn = 0;			/* 1 if network socket */

static char escchr;                     /* Escape or attn character */

#ifdef BSD42
    static struct timeval tv;           /* For getting time, from sys/time.h */
    static struct timezone tz;
#endif /* bsd42 */

#ifdef BSD29
    static long clock;                  /* For getting time from sys/time.h */
    static struct timeb ftp;            /* And from sys/timeb.h */
#endif /* bsd29 */

#ifdef BSD41
    static long clock;                  /* For getting time from sys/time.h */
    static struct timeb ftp;            /* And from sys/timeb.h */
#endif /* bsd41 */

#ifdef TOWER1
static long clock;                      /* For getting time from sys/time.h */
static struct timeb ftp;                /* And from sys/timeb.h */
#endif /* tower1 */

#ifdef V7
static long clock;
#endif /* v7 */

/* sgtty/termio information... */

#ifdef UXIII

  static struct termio ttold = {0};     /* Init'd for word alignment, */
  static struct termio ttraw = {0};     /* which is important for some */
  static struct termio tttvt = {0};     /* systems, like Zilog... */
  static struct termio ttcur = {0};
  static struct termio ccold = {0};
  static struct termio ccraw = {0};
  static struct termio cccbrk = {0};
#else					/* BSD case */
  static struct sgttyb                  /* sgtty info... */
    ttold, ttraw, tttvt, ttcur, 	/* for communication line */
    ccold, ccraw, cccbrk;		/* and for console */
#ifdef TIOCGETC
  static struct tchars tchold, tchnoi;
  static int tcharf;
#endif /* TIOCGETC */
#ifdef TIOCGLTC
  static struct ltchars ltchold, ltchnoi;
  static int ltcharf;
#endif /* TIOCGLTC */
  int lmodef = 0;			/* Local modes */
  int lmode = 0;
#endif /* uxiii */

#ifdef PROVX1
  static struct sgttyb ttbuf;
#endif

#ifdef ultrix
  static struct sgttyb vanilla;
#endif

#ifdef ATT7300
static int attmodem = 0;                /* ATT7300 internal-modem status */
struct updata dialer = {0};		/* Condition dialer for data call */
#endif  /* att7300 */

char flfnam[80];			/* uucp lock file path name */
#ifdef RTAIX
char lkflfn[80];			/* and possible link to it */
#endif
int haslock = 0;			/* =1 if this kermit locked uucp */
static int conesc = 0;                  /* set to 1 if esc char (^\) typed */

static int ttlock();                    /* definition of ttlock subprocedure */
static int ttunlck();                   /* and unlock subprocedure */

static char ttnmsv[DEVNAMLEN];          /* copy of open path for tthang */

#ifdef aegis
static status_$t st;                    /* error status return value */
static short concrp = 0;                /* true if console is CRP pad */
#define CONBUFSIZ 10
static char conbuf[CONBUFSIZ];          /* console readahead buffer */
static int  conbufn = 0;                /* # chars in readahead buffer */
static char *conbufp;                   /* next char in readahead buffer */
static uid_$t ttyuid;                   /* tty type uid */
static uid_$t conuid;                   /* stdout type uid */

/* APOLLO Aegis main()
 * establish acl usage and cleanup handling
 *    this makes sure that CRP pads
 *    get restored to a usable mode
 */
main(argc,argv) int argc; char **argv; {
        status_$t status;
        pfm_$cleanup_rec dirty;

        int pid = getpid();

        /* acl usage according to invoking environment */
        default_acl(USE_DEFENV);

        /* establish a cleanup continuation */
        status = pfm_$cleanup(dirty);
        if (status.all != pfm_$cleanup_set) {
                /* only handle faults for the original process */
                if (pid == getpid() && status.all > pgm_$max_severity) {
		    /* blew up in main process */
		    status_$t quo;
		    pfm_$cleanup_rec clean;

		    /* restore the console in any case */
		    conres();

		    /* attempt a clean exit */
		    debug(F101, "cleanup fault status", "", status.all);

		    /* doexit(), then send status to continuation */
		    quo = pfm_$cleanup(clean);
		    if (quo.all == pfm_$cleanup_set)
		      doexit(pgm_$program_faulted);
		    else if (quo.all > pgm_$max_severity)
		      pfm_$signal(quo); /* blew up in doexit() */
                }
                /* send to the original continuation */
                pfm_$signal(status);
                /*NOTREACHED*/
	    }
        return(ckcmai(argc, argv));
}
#endif /* aegis */

/*
 Replacement for strchr() and index(), neither of which seem to be universal.
*/

char *
yindex(s,c) char *s, c; {
    while (*s != '\0' && *s != c) s++;
    if (*s == c) return(s); else return(NULL);
}


/* Timeout handler for communication line input functions */

SIGTYP
timerh(foo) int foo; {
    ttimoff();
    longjmp(sjbuf,1);
}

/* Control-C trap for communication line input functions */

int cc_int;
SIGTYP (* occt)();

SIGTYP
cctrap(foo) int foo; {			/* Need arg for ANSI C */
  cc_int = 1;				/* signal() prototype. */
  return;
}

/*  S Y S I N I T  --  System-dependent program initialization.  */

sysinit() {
    int x;

#ifdef ultrix
    gtty(0,&vanilla);                 /* Get sgtty info */
    iniflags = fcntl(0,F_GETFL,0);    /* Get flags */
#else
#ifdef AUX
    set42sig();			      /* Don't ask! (hakanson@cs.orst.edu) */
#endif /* aux */
#endif

/* Initialize the setuid package. */
/* Change to the user's real user and group id. */
/* If this can't be done, don't run at all. */

    if (x = priv_ini()) {
	if (x | 1) fprintf(stderr,"Fatal: setuid failure.\n");
	if (x | 2) fprintf(stderr,"Fatal: setgid failure.\n");
	if (x | 4) fprintf(stderr,"Fatal: C-Kermit setuid to root!\n");
	exit(1);
    }
    return(0);
}

/*  S Y S C L E A N U P  --  System-dependent program cleanup.  */

syscleanup() {
#ifdef ultrix
    stty(0,&vanilla);                   /* Get sgtty info */
    fcntl(0,F_SETFL,iniflags);		/* Restore flags */
#endif
    /* No need to call anything in the suid package here, right? */
    return(0);
}

/*  T T O P E N  --  Open a tty for exclusive access.  */

/*
  Call with:
    ttname: character string - device name or network host name.
    lcl:
  If called with lcl < 0, sets value of lcl as follows:
  0: the terminal named by ttname is the job's controlling terminal.
  1: the terminal named by ttname is not the job's controlling terminal.
  But watch out: if a line is already open, or if requested line can't
  be opened, then lcl remains (and is returned as) -1.
    modem:
  Less than zero: ttname is a network host name.
  Zero or greater: ttname is a terminal device name.    
  Zero means a local connection (don't use modem signals).
  Positive means use modem signals.  
   timo:
  0 = no timer.
  nonzero = number of seconds to wait for open() to return before timing out.

  Returns:
    0 on success
   -5 if device is in use
   -4 if access to device is denied
   -3 if access to lock directory denied
   -2 upon timeout waiting for device to open
   -1 on other error
*/
ttopen(ttname,lcl,modem,timo) char *ttname; int *lcl, modem, timo; {

#ifdef UXIII
#ifndef CIE
    char *ctermid();                    /* Wish they all had this! */
#endif /* not cie */
#endif /* uxiii */

#ifdef CIE                              /* CIE Regulus doesn't... */
#define ctermid(x) strcpy(x,"")
#endif

    char *x;
#ifndef MINIX
    extern char* ttyname();
#endif
    char cname[DEVNAMLEN+4];
    int timeout = 0;			/* Timeout flag */

    debug(F111,"ttopen entry modem",ttname,modem);
    debug(F101," ttyfd","",ttyfd);
    debug(F101," lcl","",*lcl);

#ifdef	NETCONN
    if (ttyfd < 0 && modem < 0) {	/* modem < 0 = special code for net */
	int x;
	ttmdm = modem;
	modem = -modem;			/* Positive network type number */
	debug(F111,"ttopen net",ttname,modem);
	x = netopen(ttname, lcl, modem); /* (see ckunet.h) */	
	if (x > -1)
	  strncpy(ttnmsv,ttname,DEVNAMLEN);
        return(x);
    }
#endif	/* NETCONN */

    if (ttyfd > -1) {			/* if device already opened */
        if (strncmp(ttname,ttnmsv,DEVNAMLEN)) /* are new & old names equal? */
          ttclos();                     /* no, close old ttname, open new */
        else 				/* else same, ignore this call, */
	  return(0);			/* and return. */
    }

    occt = signal(SIGINT, cctrap);	/* Set Control-C trap, save old one */

    tvtflg = 0;			/* Flag for use by ttvt(). */
				/* 0 = ttvt not called yet for this device */

    fdflag = (!isatty(0) || !isatty(1)); /* Flag for stdio redirected */
    debug(F101,"ttopen fdflag","",fdflag);

    ttmdm = modem;                      /* Make this available to other fns */
    xlocal = *lcl;                      /* Make this available to other fns */

/* Code for handling bidirectional tty lines goes here. */
/* Use specified method for turning off logins and suppressing getty. */

#ifdef ACUCNTRL
    acucntrl("disable",ttname);         /* acucntrl() program. */
#else
#ifdef ATT7300
    if ((attmodem & DOGETY) == 0)       /* offgetty() program. */
      attmodem |= offgetty(ttname);	/* Remember response.  */
#endif
#endif

/*
 In the following section, we open the tty device for read/write.
 If a modem has been specified via "set modem" prior to "set line"
 then the O_NDELAY parameter is used in the open, provided this symbol
 is defined (e.g. in fcntl.h), so that the program does not hang waiting
 for carrier (which in most cases won't be present because a connection
 has not been dialed yet).  O_NDELAY is removed later on in ttopen().  It
 would make more sense to first determine if the line is local before
 doing this, but because ttyname() requires a file descriptor, we have
 to open it first.  See do_open().
*/

/* Now open the device using the desired treatment of carrier. */
/* If carrier is REQUIRED, then open could hang forever, so an optional */
/* timer is provided.  If carrier is not required, the timer should never */
/* go off, and should do no harm... */

    timeout = 0;			/* Flag no timeout */
    saval = signal(SIGALRM,timerh);	/* Timed, set up timer. */
    if (timo > 0) {
	alarm(timo);			/* Timed open() */
	if (setjmp(sjbuf)) {
	    timeout = 1;		/* Flag timeout. */
	} else ttyfd = do_open(ttname);
	ttimoff();
	debug(F111,"ttopen","modem",modem);
	debug(F101," ttyfd","",ttyfd);
	debug(F101," alarm return","",timeout);
    } else ttyfd = do_open(ttname);
    debug(F111,"ttopen ttyfd",ttname,ttyfd);
    if (ttyfd < 0) {			/* If couldn't open, fail. */
#ifdef ATT7300
	if (attmodem & DOGETY)		/* was getty(1m) running before us? */
	  ongetty(ttnmsv);		/* yes, restart on tty line */
	attmodem &= ~DOGETY;		/* no phone in use, getty restored */
#else
#if ACUCNTRL
	acucntrl("enable",ttname);	/* acucntrl() program. */	
#endif
#endif
	signal(SIGINT,occt);		/* Put old Ctrl-C trap back. */
	if (errno == EACCES) {		/* Device is protected against user */
	    perror(ttname);		/* Print message */
	    debug(F111,"ttopen tty access denied",ttname,errno);
	    return(-4);
	} else return(timeout ? -2 : -1);
    }

    /* Make sure it's a real tty. */
    if (!isatty(ttyfd)) {
	fprintf(stderr,"%s is not a tty!\n",ttname);
	debug(F110,"ttopen not a tty",ttname,0);
	close(ttyfd);
	ttyfd = -1;
	signal(SIGINT,occt);
	return(-1);
    }

#ifdef aegis
	/* Apollo C runtime claims that console pads are tty devices, which
	 * is reasonable, but they aren't any good for packet transfer. */
	ios_$inq_type_uid((short)ttyfd, ttyuid, st);
	if (st.all != status_$ok) {
	    fprintf(stderr, "problem getting tty object type: ");
	    error_$print(st);
	} else if (ttyuid != sio_$uid) { /* reject non-SIO lines */
	    close(ttyfd); ttyfd = -1;
	    errno = ENOTTY; perror(ttname);
	    signal(SIGINT,occt);
	    return(-1);
	}
#endif /* aegis */
    strncpy(ttnmsv,ttname,DEVNAMLEN);   /* Open, keep copy of name locally. */

/* Caller wants us to figure out if line is controlling tty */

    if (*lcl < 0) {
	int x0 = 0, x1 = 0;
        if (strcmp(ttname,CTTNAM) == 0) {   /* "/dev/tty" always remote */
            xlocal = 0;
	    debug(F111," ttname=CTTNAM",ttname,xlocal);

    /* If any of 0, 1, or 2 not redirected, we can use ttyname() to get */
    /* the name of the controlling terminal... */

        } else if ((x0 = isatty(0)) || (x1 = isatty(1)) || isatty(2)) {
#ifndef MINIX
	    if (x0)
	      x = ttyname(0);		/* and compare it with the */
	    else if (x1)		/* tty device name. */
	      x = ttyname(1);
	    else x = ttyname(2);
            strncpy(cname,x,DEVNAMLEN); /* (copy from internal static buf) */
	    debug(F110," cname",x,0);
            x = ttyname(ttyfd);         /* Gat real name of ttname. */
            xlocal = (strncmp(x,cname,DEVNAMLEN) == 0) ? 0 : 1;	/* Compare. */
	    debug(F111," ttyname",x,xlocal);
#else
	    xlocal = 1;			/* Can't do this test in MINIX */
#endif /* MINIX */
        } else {                        /* Else, if stdin redirected... */
#ifdef UXIII
/* Sys III/V provides nice ctermid() function to get name of controlling tty */
            ctermid(cname);             /* Get name of controlling terminal */
            debug(F110," ctermid",cname,0);
            x = ttyname(ttyfd);         /* Compare with name of comm line. */
            xlocal = (strncmp(x,cname,DEVNAMLEN) == 0) ? 0 : 1;
            debug(F111," ttyname",x,xlocal);
#else
/* Just assume local */
            xlocal = 1;
#endif /* uxiii */
            debug(F101," redirected stdin","",xlocal);
        }
    }

/* Note, the following code was added so that Unix "idle-line" snoopers */
/* would not think Kermit was idle when it was transferring files, and */
/* maybe log people out. */
    if (xlocal == 0) {			/* Remote mode */
	if (fdflag == 0) {		/* Standard i/o is not redirected */
	    debug(F100,"ttopen setting ttyfd = 0","",0);
	    close(ttyfd);		/* Use file descriptor 0 */
	    ttyfd = 0;
	} else {			/* Standard i/o is redirected */
	    debug(F101,"ttopen stdio redirected","",ttyfd);
	}
    }

/* Now check if line is locked -- if so fail, else lock for ourselves */
/* Note: After having done this, don't forget to delete the lock if you */
/* leave ttopen() with an error condition. */

    lkf = 0;                            /* Check lock */
    if (xlocal > 0) {
	int xx, xpid;
        if ((xx = ttlock(ttname)) < 0) { /* Can't lock it. */
            debug(F111,"ttopen ttlock fails",ttname,xx);
            close(ttyfd);		/* Close the device. */
	    ttyfd = -1;			/* Erase its file descriptor. */
	    signal(SIGINT,occt);	/* Put old SIGINT back. */
	    if (xx == -2) {		/* If lockfile says tty is in use, */
		char *p = malloc(200);	/* print an ls -l listing */
		if (p) {		/* if we can get space... */
		    sprintf(p,"/bin/ls -l %s",flfnam);
		    zsyscmd(p);		/* Get listing. */
		    free(p);		/* free the space */
		    xpid = ttrpid(flfnam); /* Try to read pid from lockfile */
		    priv_off();		/* Turn privs back off. */
		    if (xpid > -1) printf("pid = %d\n",xpid); /* show pid */
		}
		return(-5);		/* Code for device in use */
	    } else return(-3);		/* Access denied */
        } else lkf = 1;
    }

/* Got the line, now set the desired value for local. */

    if (*lcl != 0) *lcl = xlocal;

/* Some special stuff for v7... */

#ifdef  V7
#ifndef MINIX
    if (kmem[TTY] < 0) {		/*  If open, then skip this.  */
	qaddr[TTY] = initrawq(ttyfd);   /* Init the queue. */
	if ((kmem[TTY] = open("/dev/kmem", 0)) < 0) {
	    fprintf(stderr, "Can't read /dev/kmem in ttopen.\n");
	    perror("/dev/kmem");
	    exit(1);
	}
    }
#endif /* !MINIX */
#endif /* v7 */

/* No failure returns after this point */

#ifdef ultrix
#ifdef TIOCSINUSE
    if (xlocal && ioctl(ttyfd, TIOCSINUSE, NULL) < 0) {
	fprintf(stderr, "Can't set in-use flag on modem.\n");
	perror("TIOCSINUSE");
    }
#endif /* TIOCSINUSE */
#endif /* ultrix */

/* Get tty device settings */

#ifndef UXIII
    gtty(ttyfd,&ttold);			/* For BSD, V7, etc, sgtty info. */
    debug(F101,"ttopen gtty ttold.sg_flags","",ttold.sg_flags);

#ifdef TIOCGETC
    tcharf = 0;				/* In remote mode, also get */
    if (xlocal == 0) {			/* special characters */
	if (ioctl(ttyfd,TIOCGETC,&tchold) < 0) {
	    debug(F100,"ttopen TIOCGETC failed","",0);
	} else {
	    tcharf = 1;			/* It worked. */
	    ioctl(ttyfd,TIOCGETC,&tchnoi); /* Get another copy */
	    debug(F100,"ttopen TIOCGETC ok","",0);
	}
    }	
#else
    debug(F100,"ttopen TIOCGETC not defined","",0);
#endif

#ifdef TIOCGLTC
    ltcharf = 0;			/* In remote mode, also get */
    if (xlocal == 0) {			/* local special characters */
	if (ioctl(ttyfd,TIOCGLTC,&ltchold) < 0) {
	    debug(F100,"ttopen TIOCGLTC failed","",0);
	} else {
	    ltcharf = 1;		/* It worked. */
	    ioctl(ttyfd,TIOCGLTC,&ltchnoi); /* Get another copy */
	    debug(F100,"ttopen TIOCGLTC ok","",0);
	}
    }	
#else
    debug(F100,"ttopen TIOCGLTC not defined","",0);
#endif

#ifdef TIOCLGET
    lmodef = 0;
    if (ioctl(ttyfd,TIOCLGET,&lmode) < 0) {
	debug(F100,"ttopen TIOCLGET failed","",0);
    } else {
	lmodef = 1;
	debug(F100,"ttopen TIOCLGET ok","",0);
    }
#endif /* TIOCLGET */

    gtty(ttyfd,&ttraw);                 /* And a copy of it for packets*/
    gtty(ttyfd,&tttvt);                 /* And one for virtual tty service */
#else /* UXIII */
    ioctl(ttyfd,TCGETA,&ttold);         /* Same deal for Sys III, Sys V */
    debug(F101,"ttopen ioctl TCGETA ttold.c_lflag","",ttold.c_lflag);
    ioctl(ttyfd,TCGETA,&ttraw);
    ioctl(ttyfd,TCGETA,&tttvt);
#endif /* !UXIII */

#ifdef aegis
    /* This was previously done before the last two TCGETA or gtty above,
     * in both the UXIII and not-UXIII case.  If it is not okay to have only
     * one copy if it here instead, give us a shout!
     */
    sio_$control((short)ttyfd, sio_$raw_nl, false, st);
    if (xlocal) {       /* ignore breaks from local line */
        sio_$control((short)ttyfd, sio_$int_enable, false, st);
        sio_$control((short)ttyfd, sio_$quit_enable, false, st);
    }
#endif /* aegis */

#ifdef VXVE
    ttraw.c_line = 0;                   /* STTY line 0 for VX/VE */
    tttvt.c_line = 0;                   /* STTY line 0 for VX/VE */
    ioctl(ttyfd,TCSETA,&ttraw);
#endif /* vxve */

/* If O_NDELAY was used during open(), then remove it now. */

#ifdef O_NDELAY
    if (fcntl(ttyfd, F_GETFL, 0) & O_NDELAY) {

#ifndef aegis
	if (fcntl(ttyfd,F_SETFL, fcntl(ttyfd, F_GETFL, 0) & ~O_NDELAY) < 0 )
	    perror("Can't unset O_NDELAY");
#endif
	/* Some systems, notably Xenix (don't know how common this is in
	 * other systems), need special treatment to get rid of the O_NDELAY
	 * behaviour on read() with respect to carrier presence (i.e. read()
	 * returning 0 when carrier absent), even though the above fcntl()
	 * is enough to make read() wait for input when carrier is present.
	 * This magic, in turn, requires CLOCAL for working when the carrier
	 * is absent. But if xlocal == 0, presumably you already have CLOCAL
	 * or you have a carrier, otherwise you wouldn't be running this.
	 */
#ifdef UXIII
	if (xlocal) {
	    ttraw.c_cflag |= CLOCAL;
	    ioctl(ttyfd, TCSETA, &ttraw);
	}
#endif
	close( priv_opn(ttname, O_RDWR) ); /* Magic to force change. */
    }
#endif /* O_NDELAY */

/* Instruct the system how to treat the carrier, and set a few other tty
 * parameters.
 *
 * This also undoes the temporary setting of CLOCAL that may have been done
 * for the close(open()) above (except in Xenix).  Also throw in ~ECHO, to
 * prevent the other end of the line from sitting there talking to itself,
 * producing garbage when the user performs a connect.
 *
 * SCO Xenix unfortunately seems to ignore the actual state of CLOCAL.
 * Now it thinks CLOCAL is always on. It seems the only real solution for
 * Xenix is to switch between the lower and upper case device names.
 *
 * This section may at some future time expand into setting a complete
 * collection of tty parameters, or call a function shared with ttpkt()/
 * ttvt() that does so.  On the other hand, the initial parameters are not
 * that important, since ttpkt() or ttvt() should always fix that before
 * any communication is done.  Well, we'll see...
 */
    if (xlocal) {
    	curcarr = -2;
	carrctl(&ttraw, ttcarr == CAR_ON);
#ifdef UXIII
	ttraw.c_lflag &= ~ECHO;
	ttold.c_lflag &= ~ECHO;
	ioctl(ttyfd, TCSETA, &ttraw);
#else /* !UXIII */
	ttraw.sg_flags &= ~ECHO;
	ttold.sg_flags &= ~ECHO;
	stty(ttyfd,&ttraw);
#endif /* !UXIII */
/*	ttflui();  This fails some reason  */
    }
    
    /* Get current speed */

    ttspeed = ttgspd();
    debug(F101,"ttopen ttspeed","",ttspeed);

    /* Done, make entries in debug log, restore Ctrl-C trap, and return. */

    debug(F101,"ttopen, ttyfd","",ttyfd);
    debug(F101," lcl","",*lcl);
    debug(F111," lock file",flfnam,lkf);
    signal(SIGINT,occt);
    return(0);
}


/*  D O _ O P E N  --  Do the right kind of open() call for the tty. */

do_open(ttname) char *ttname; {

#ifndef	O_NDELAY			/* O_NDELAY not defined */
    return(priv_opn(ttname,2));
#else					/* O_NDELAY defined */

#ifdef ATT7300
/*
 Open comms line without waiting for carrier so initial call does not hang
 because state of "modem" is likely unknown at the initial call  -jrd.
 If this is needed for the getty stuff to work, and the open would not work
 without O_NDELAY when getty is still on, then this special case is ok.
 Otherwise, get rid of it. -ske
*/
    return(priv_opn(ttname, O_RDWR | O_NDELAY));

#else	/* !ATT7300 */

    /* Normal case. Use O_NDELAY according to SET CARRIER. See ttscarr(). */
  
    return(priv_opn(ttname, O_RDWR | ((ttcarr != CAR_ON) ? O_NDELAY : 0) ));

#endif	/* !ATT7300 */
#endif	/* O_NDELAY */
}

/*  T T C L O S  --  Close the TTY, releasing any lock.  */

ttclos(foo) int foo; {			/* Arg req'd for signal() prototype */
    debug(F101,"ttclos ttyfd","",ttyfd);
    if (ttyfd < 0) return(0);           /* Wasn't open. */
    tvtflg = 0;
#ifdef	NETCONN
    if (netconn) {			/* Network connection. */
	debug(F100,"ttclos closing net","",0);
	netclos();			/* Close it. */
	return (0);
    }
#endif	/* NETCONN */
#ifdef ultrix
    if (xlocal) ioctl(ttyfd, TIOCNCAR, NULL);
#endif
    if (xlocal) {
	debug(F100,"ttclos about to call ttunlck","",0);
        if (ttunlck())                  /* Release uucp-style lock */
	  fprintf(stderr,"Warning, problem releasing lock\r\n");
    }
    debug(F100,"ttclos about to call ttres","",0);
    ttres();                            /* Reset device modes. */
    tthang();

    if (ttyfd > 0) {
	debug(F101,"ttclos about to call close","",ttyfd);
	close(ttyfd);			/* Close the device. */
    }
    ttyfd = -1;                         /* Invalidate the file descriptor. */

/* For bidirectional lines, restore getty if it was there before. */

#ifdef ACUCNTRL				/* 4.3BSD acucntrl() method. */
    acucntrl("enable",ttnmsv);		/* Enable getty on the device. */
#else
#ifdef ATT7300				/* ATT UNIX PC (3B1, 7300) method. */
    if (attmodem & DOGETY)              /* Was getty(1m) running before us? */
      ongetty(ttnmsv);			/* Yes, restart getty on tty line */
    attmodem &= ~DOGETY;                /* No phone in use, getty restored */
#endif /* ATT7300 */
#endif /* System-dependent getty-restoring methods */

    debug(F100,"ttclos done","",0);
    return(0);
}

/*  T T H A N G  --  Hangup phone line or network connection.  */

tthang() {
    int x = 0;				/* Sometimes used as return code. */
    int z;				/* worker */

#ifdef UXIII				/* AT&T and HPUX declarations. */
    int spdsav;				/* for saving speed */
    int flags;				/* fcntl flags */
#ifdef HPUX
    unsigned long dtr_down = 00000000000,
    modem_rtn;
#else /* not HPUX */
    unsigned short ttc_save;
#endif /* HPUX */
#endif /* UXIII */

    if (ttyfd < 0) return(0);           /* Don't do this if not open  */
    if (xlocal < 1) return(0);		/* Don't do this if not local */

#ifdef NETCONN
    if (netconn) {			/* Network connection. */
	if (netclos() < 0) return(-1);
        tvtflg = 0;
        x = 1;
        return(netopen(ttnmsv, &x, ttmdm));
    }
#endif /* NETCONN */

/* From here down, we handle real tty devices. */

#ifdef aegis				/* Apollo Aegis */
    sio_$control((short)ttyfd, sio_$dtr, false, st);    /* DTR down */
    msleep(500);                                        /* pause */
    sio_$control((short)ttyfd, sio_$dtr, true,  st);    /* DTR up */
    return(0);
#endif /* aegis */

#ifdef ANYBSD				/* Any BSD version. */
    debug(F100,"tthang BSD style","",0);
    if (ioctl(ttyfd,TIOCCDTR,0) < 0) return(-1);	/* Clear DTR. */
    msleep(500);			                /* For about 1/2 sec */
    x = (ioctl(ttyfd,TIOCSDTR,0) < 0) ? -1 : 0;	        /* Restore DTR */
#ifdef COMMENT
    return(x);
#else
    close(do_open(ttnmsv));		/* Clear i/o error condition */
    z = ttvt(ttspeed,ttflow);		/* Restore modes. */
    if (z < 0) return(-1); else return(x);
#endif
    /* Wasn't that easy? */
#endif /* ANYBSD */

#ifdef UXIII				
/* AT&T UNIX section, includes HP-UX and generic AT&T System III/V... */

#ifdef HPUX 
/* Hewlett Packard allows explicit manipulation of modem signals. */

    debug(F100,"tthang HP-UX style","",0);
    if (ioctl(ttyfd,MCSETAF,&dtr_down) < 0)        /* lower DTR */
      return(-1);		    	           /* oops, can't. */
    msleep(500);			           /* Pause half a second. */
    x = 0;				           /* Set return code */
    if (ioctl(ttyfd,MCGETA,&modem_rtn) > -1) {     /* Get line status. */
	if ((modem_rtn & MDCD) != 0)      	   /* Check if CD is low. */
	  x = -1;                                  /* CD didn't drop, fail. */
    } else x = -1;

    /* Even if above calls fail, RTS & DTR should be turned back on. */
    modem_rtn = MRTS | MDTR;
    if (ioctl(ttyfd,MCSETAF,&modem_rtn) < 0) x = -1;
    return(x);

#else

/* SVID for AT&T System V R3 defines ioctl's for handling modem signals. */
/* It is not known how many, if any, systems actually implement them, */
/* so we include them here in ifdef's. */

#ifdef TIOCMBIS				/* Bit Set */
#ifdef TIOCMBIC				/* Bit Clear */
#ifdef TIOCM_DTR			/* DTR */

/* Clear DTR, sleep 300 msec, turn it back on. */
/* If any of the ioctl's return failure, go on to the next section. */

    z = TIOCM_DTR;			/* Code for DTR. */
#ifdef TIOC_RTS
    z |= TIOC_RTS;			/* Lower RTS too if symbol is known. */
#endif

    debug(F101,"tthang TIOCM signal mask","",z);
    if (ioctl(ttyfd,TIOCMBIC,&z) > -1) { /* Try to lower DTR. */
	debug(F100,"tthang TIOCMBIC ok","",0);
	msleep(500);			/* Pause half a second. */
	if (ioctl(ttyfd,TIOCMBIS,&z) > -1) { /* Try to turn it back on. */
	    debug(F100,"tthang TIOCMBIS ok","",0);
	    return(0);			/* Success, done. */
	} else {			/* Couldn't raise, continue. */
	    debug(F101,"tthang TIOCMBIS errno","",errno);
	}
    } else {				/* Couldn't lower, continue. */
 	debug(F101,"tthang TIOCMBIC errno","",errno);
    }
#endif /* TIOCM_DTR */
#endif /* TIOCMBIC */
#endif /* TIOCMBIS */

/*
  General AT&T UNIX case, not HPUX.  The following code is highly suspect.  No
  two AT&T-based systems seem to do this the same way.  The object is simply
  to turn off DTR and then turn it back on.  SVID says the universal method
  for turning off DTR is to set the speed to zero, and this does seem to do
  the trick in all cases.  But neither SVID nor any known man pages say how to
  turn DTR back on again.  Some variants, like most Xenix implementations,
  raise DTR again when the speed is restored to a nonzero value.  Others
  require the device to be closed and opened again, but this is risky because
  getty could seize the device during the instant it is closed.
*/

/* Return code for ioctl failures... */
#ifdef ATT6300
    x = 0;				/* ATT6300 doesn't want to fail... */
#else
    x = -1;
#endif

    debug(F100,"tthang get settings","",0);
    if (ioctl(ttyfd,TCGETA,&ttcur) < 0) /* Get current settings. */
      return(x);			/* Fail if this doesn't work. */
    if ((flags = fcntl(ttyfd,F_GETFL,0)) < 0) /* Get device flags. */
      return(x);
    ttc_save = ttcur.c_cflag;		/* Remember current speed. */
    spdsav = ttc_save & CBAUD;
    debug(F101,"tthang speed","",spdsav);

#ifdef O_NDELAY
    debug(F100,"tthang O_NDELAY on","",0);
    fcntl(ttyfd, F_SETFL, flags | O_NDELAY); /* Activate O_NDELAY */
#endif

#ifdef ATT7300 /* This is the way it is SUPPOSED to work */
    ttcur.c_cflag &= ~CBAUD;		/* Change the speed to zero.  */
#else          /* This way really works but may be dangerous */
#ifdef u3b2
    ttcur.c_cflag = ~(CBAUD|CLOCAL);	/* Special for AT&T 3B2s */
					/* (CLOCAL must be OFF) */
#else
    ttcur.c_cflag = CLOCAL;		/* Change all but CLOCAL to zero */
					/* (CLOCAL must be ON) */
#endif
#endif

#ifdef COMMENT
    /* and if none of those work, try one of these... */
    ttcur.c_cflag = 0;
    ttcur.c_cflag &= ~(CBAUD|HUPCL);
    ttcur.c_cflag &= ~(CBAUD|CREAD);
    ttcur.c_cflag &= ~(CBAUD|CREAD|HUPCL);
    /* or other combinations */
#endif

    if (ioctl(ttyfd,TCSETAF,&ttcur) < 0) { /* Fail if we can't. */
	fcntl(ttyfd, F_SETFL, flags);	/* Restore flags */
	return(x);			/* before returning. */
    }
    msleep(300);			/* Give modem time to notice. */

/* Now, even though it doesn't say this in SVID or any man page, we have */
/* to close and reopen the device.  This is not necessary for all systems, */
/* but it's impossible to predict which ones need it and which ones don't. */

#ifdef ATT7300
/*
  Special handling for ATT 7300 UNIX PC and 3B1, which have "phone"
  related ioctl's for their internal modems.  attmodem has getty status and 
  modem-in-use bit.  Reportedly the ATT7300/3B1 PIOCDISC call is necessary, 
  but also ruins the file descriptor, and no other phone(7) ioctl call can fix 
  it.  Whateverit does, it seems to escape detection with PIOCGETA and TCGETA.
  The only way to undo the damage is to close the fd and then reopen it.
*/
    if (attmodem & ISMODEM) {
	debug(F100,"tthang attmodem close/open","",0);
	ioctl(ttyfd,PIOCUNHOLD,&dialer); /* Return call to handset. */
	ioctl(ttyfd,PIOCDISC,&dialer);	/* Disconnect phone. */
	close(ttyfd);			/* Close and reopen the fd. */
	ttyfd = priv_opn(ttnmsv, O_RDWR | O_NDELAY);
	attmodem &= ~ISMODEM;		/* Phone no longer in use. */
    }
#else /* !ATT7300 */
/* It seems we have to close and open the device for other AT&T systems */
/* too, and this is the place to do it.  The following code does the */
/* famous close(open(...)) magic by default.  If that doesn't work for you, */
/* then try uncommenting the following statement or putting -DCLSOPN in */
/* the makefile CFLAGS. */

/* #define CLSOPN */

#ifdef O_NDELAY
#define OPENFLGS O_RDWR | O_NDELAY
#else
#define OPENFLGS O_RDWR
#endif

#ifndef CLSOPN
/* This method is used by default. */
/* It is thought to be safer because there is no window where getty */
/* can seize control of the device.  The drawback is that it might not work. */

    debug(F101,"tthang close(open()), OPENFLGS","",OPENFLGS);
    close(priv_opn(ttnmsv, OPENFLGS));

#else
/* This method is used if you #define CLSOPN.  It is more likely to work */
/* than the previous method, but it's also more dangerous. */

    debug(F101,"tthang close/open, OPENFLGS","",OPENFLGS);
    close(ttyfd);
    msleep(10);
    if (ttyfd = priv_opn(ttnmsv, OPENFLGS)) return(x);

#endif /* CLSOPN */
#undef OPENFLGS

#endif /* ATT7300 */

/* Now put all flags & modes back the way we found them. */
/* (Does the order of ioctl & fcntl matter???) */

    debug(F100,"tthang restore settings","",0);
    ttcur.c_cflag = ttc_save;		/* Get old speed back. */
    if (ioctl(ttyfd,TCSETAF,&ttcur) < 0) /* ioctl parameters. */
      return(x); 
    if (fcntl(ttyfd,F_SETFL,flags) < 0)	/* fcntl parameters */
      return(x);

    return(0);
#endif /* not HPUX */
#endif /* UXIII */
}

/*  T T R E S  --  Restore terminal to "normal" mode.  */

/* ske@pkmab.se: There are two choices for what this function should do.
 * (1) Restore the tty to current "normal" mode, with carrier treatment
 * according to ttcarr, to be used after every kermit command. (2) Restore
 * the tty to the state it was in before kermit opened it. These choices
 * conflict, since ttold can't hold both choices of tty parameters.  ttres()
 * is currently being called as in choice (1), but ttold basically holds
 * the initial parameters, as in (2), and the description at the beginning
 * of this file says (2).
 *
 * I don't think restoring tty parameters after all kermit commands makes
 * much of a difference.  Restoring them upon exit from kermit may be of
 * some use in some cases (when the line is not restored automatically on
 * close, by the operating system).
 *
 * I can't choose which one it should be, so I haven't changed it. It
 * probably works as it is, too. It would probably even work even with
 * ttres() entirely deleted...
 *
 * (from fdc: Actually, this function operates in remote mode too, so
 * it restores the console (command) terminal to whatever mode it was
 * in before packet operations began, so that commands work right again.
 * I think...)
 */
ttres() {                               /* Restore the tty to normal. */
    int x;

    if (ttyfd < 0) return(-1);          /* Not open. */

#ifdef	NETCONN
    if (netconn) return (0);		/* Network connection, do nothing */
#endif	/* NETCONN */

/* Real terminal device, so restore its original modes */

#ifndef UXIII                           /* For BSD versions... */

    msleep(500);			/* This replaces sleep(1)... */
					/* Put back sleep(1) if tty is */
					/* messed up after close. */

/* Here we restore the modes for BSD */

/* #undef LPASS8 */       /* <-- Uncomment this if LPASS8 makes trouble */
/*
  For example, Annex terminal servers, commonly used with Encore computers,
  do not support LPASS8 even though the Encore itself does.
*/
#ifdef ENCORE
#undef LPASS8
#endif /* ENCORE */

#ifdef LPASS8				/* Undo "pass8" if it were done */
    if (lmodef) {
	if (ioctl(ttyfd,TIOCLSET,&lmode) < 0)
	  debug(F100,"ttres TIOCLSET failed","",0);
	else
	  debug(F100,"ttres TIOCLSET ok","",0);
    }
#endif

#ifdef TIOCGETC				/* Put back special characters */
    if (tcharf && (xlocal == 0)) {
	if (ioctl(ttyfd,TIOCSETC,&tchold) < 0)
	  debug(F100,"ttres TIOCSETC failed","",0);
	else
	  debug(F100,"ttres TIOCSETC ok","",0);
    }
#endif

#ifdef TIOCGLTC				/* Put back local special characters */
    if (ltcharf && (xlocal == 0)) {
	if (ioctl(ttyfd,TIOCSLTC,&ltchold) < 0)
	  debug(F100,"ttres TIOCSLTC failed","",0);
	else
	  debug(F100,"ttres TIOCSLTC ok","",0);
    }
#endif

    x = stty(ttyfd,&ttold);             /* restore tty modes the BSD way. */

/* And here we restore them for AT&T */

#else
    x = ioctl(ttyfd,TCSETAW,&ttold);	/* Restore tty modes the AT&T way. */

#endif

    debug(F101,"ttres tty modes restore","",x);
    if (x < 0) debug(F101,"ttres errno","",errno);
    tvtflg = 0;
    return(x);
}

static char *
xxlast(s,c) char *s; char c; {          /* Equivalent to strrchr() */
    int i;
    for (i = strlen(s); i > 0; i--)
        if ( s[i-1] == c ) return( s + (i - 1) );
    return(NULL);
}

/*  T T R P I D  --  Read pid from lockfile "name" (used by ttlock) */

ttrpid(name) char *name; {
    int x, fd, pid;

    fd = open(name,O_RDONLY);		/* Try to open lockfile. */
    if (fd > 0) {

#ifdef PIDSTRING
	char buf[12];
	x = read(fd, buf, 11);		/* For HDP UUCP, read pid string */
	if (x < 0) return(-1);
	buf[11] = '\0';
	if (x == 11)
	  x = sscanf(buf,"%d",&pid);	/* Get the integer pid from it. */
#else
	x = read(fd, &pid, sizeof(pid)); /* Else read integer pid directly */
#endif /* PIDSTRING */

	if (x < 0) pid = -1;		/* Return any errors. */
	close(fd);			/* Close the lockfile. */
    } else pid = -1;
    return(pid);
}

/*  T T L O C K  */

/*
  This function attempts to coordinate use of the communication device with
  other copies of Kermit and any other program that follows the UUCP
  device-locking conventions, which, unfortunately, vary among different UNIX
  implementations.  The idea is to look for a file of a certain name, the
  "lockfile", in a certain directory.  If such a file is found, then the line
  is presumed to be in use, and Kermit should not use it.  If no such file is
  found, Kermit attempts to create one so that other programs will not use the
  same line at the same time.  Because the lockfile and/or the directory it's
  in might lack write permission for the person running Kermit, Kermit could
  find itself running setuid to uucp or other user that does have the
  necessary permissions.  At startup, Kermit has changed its effective uid to
  the user's real uid, and so ttlock() must switch back to the original
  effective uid in order to create the lockfile, and then back again to the
  real uid to prevent unauthorized access to other directories or files owned
  by the user the program is setuid to.

  Totally rewritten for C-Kermit 5A to eliminate windows of vulnerability,
  based on suggestions from Warren Tucker.  Call with pointer to name of 
  tty device.  Returns:

   0 on success
  -1 on failure

  Note: Once privileges are turned on using priv_on(), it is essential that
  they are turned off again before this function returns.
*/
static
ttlock(ttdev) char *ttdev; {

#ifdef NOUUCP
    strcpy(flfnam,"NOLOCK");
    haslock = 1;
    return(0);
#else /* !NOUUCP */
    int lockfd;				/* File descriptor for lock file. */
    int pid;				/* Process id of this process. */
    int fpid;				/* pid found in existing lockfile. */
    int tries;				/* How many times we've tried... */
    int x;				/* Worker int */
    char c;				/* Worker char */

#ifdef PIDSTRING
    char pid_str[12];			/* My pid in string format. */
#endif /* PIDSTRING */

    extern char *strcat(), *strcpy();	/* String functions */
    char *device, *devname;

#define LFNAML 50			/* Max length for lock file name. */
    char lockfil[LFNAML];		/* Lock file name */
#ifdef RTAIX
    char lklockf[LFNAML];		/* Name for link to lock file  */
#endif
    char tmpnam[LFNAML+30];		/* Temporary lockfile name. */
    char *lockdir = LOCK_DIR;		/* Defined near top of this file, */
					/* or on cc command line. */

    haslock = 0;                        /* Not locked yet. */
    *flfnam = '\0';			/* Lockfile name is empty. */
    pid = getpid();			/* Get id of this process. */

/*  Construct name of lockfile and temporary file */

/*  device  = name of tty device without the path, e.g. "ttyh8" */
/*  lockfil = name of lock file, without path, e.g. "LCK..ttyh8" */

    device = ((devname=xxlast(ttdev,'/')) != NULL ? devname+1 : ttdev);

#ifdef ISIII				/* Interactive System III, PC/IX */
    strcpy(lockfil, device);
#else					/* Others... */
    sprintf(lockfil,"LCK..%s", device);
#ifdef M_XENIX				/* SCO Xenix */
    x = strlen(lockfil) - 1;		/* Get last letter of device name. */
    if (x > 0) {			/* If it's uppercase, lower it. */
	c = lockfil[x];
	if (c >= 'A' && c <= 'Z') lockfil[x] += ('a' - 'A');
    }
#endif /* M_XENIX */
#ifdef RTAIX
    strcpy(lklockf,device);
#endif
#endif /* isiii */

/*  flfnam = full lockfile pathname, e.g. "/usr/spool/uucp/LCK..ttyh8" */
/*  tmpnam = temporary unique, e.g. "/usr/spool/uucp/LTMP..pid" */

    sprintf(flfnam,"%s/%s",lockdir,lockfil);
#ifdef RTAIX
    sprintf(lkflfn,"%s/%s",lockdir,lklockf);
#endif
    sprintf(tmpnam,"%s/LTMP.%05d",lockdir,pid);
    debug(F110,"ttlock flfnam",flfnam,0);
    debug(F110,"ttlock tmpnam",tmpnam,0);

    priv_on();				/* Turn on privileges if possible. */
    lockfd = creat(tmpnam, 0444);	/* Try to create temp lock file. */
    if (lockfd < 0) {			/* Create failed. */
	debug(F111,"ttlock creat failed",tmpnam,errno);
	if (errno == ENOENT) {
	    perror(lockdir);	    
	    printf("UUCP not installed or Kermit misconfigured\n");
	} else {
	    perror(lockdir);
	    unlink(tmpnam);		/* Get rid of the temporary file. */
	}
	priv_off();			/* Turn off privileges!!! */
	return(-1);			/* Return failure code. */
    }
/* Now write the pid into the temp lockfile in the appropriate format */

#ifdef PIDSTRING			/* For Honey DanBer UUCP, */
    sprintf(pid_str,"%10d\n", pid);	/* write pid as decimal string. */
    write(lockfd, pid_str, 11);
    debug(F111,"ttlock hdb pid string",pid_str,pid);
#else					/* Others use integer pid */
    write(lockfd, &pid, sizeof(pid) );
    debug(F111,"ttlock pid","",pid);
#endif /* PIDSTRING */

/* Now try to rename the temp file to the real lock file name. */
/* This will fail if a lock file of that name already exists.  */

    close(lockfd);			/* Close the temp lockfile. */
    chmod(tmpnam,0444);			/* Permission for a valid lock. */    
    tries = 0;
    while (!haslock && tries++ < 2) {
	haslock = (link(tmpnam,flfnam) == 0); /* Create a link to it. */
	if (haslock) {			      /* If we got the lockfile */
#ifdef RTAIX
	    link(flfnam,lkflfn);
#endif	    
	    break;		  	      /* we're done. */
	} else {			      /* Otherwise, */
	    if ((fpid = ttrpid(flfnam)) > -1) {	/* Read pid from lockfile */
		if (fpid > 0) {
		    debug(F101,"ttlock fpid","",fpid);
		    errno = 0;
		    if (kill(fpid,0) < 0) { /* See if process still exists. */
			if (errno == ESRCH) { /* If pid is invalid. */
			    debug(F110,"ttlock removing stale lock",flfnam,0);
			    printf("Removing stale lock %s\n",flfnam);
			    unlink(flfnam); /* remove the lockfile. */
			    continue;	/* and go back and try again. */
			}
		    } else {
			unlink(tmpnam);	/* Delete the tempfile */
			priv_off();	/* Turn off privs */
			return(-2);	/* Code for device is in use. */
		    }
		} else {
		    debug(F101,"ttlock can't get fpid","",fpid);
		    break;
		}
	    } else break;
	}
    }
    unlink(tmpnam);			/* Unlink (remove) the temp file. */
    priv_off();				/* Turn off privs */
    return(haslock ? 0 : -1);		/* Return link's return code. */
#endif /* !NOUUCP */
}

/*  T T U N L O C K  */

static
ttunlck() {                             /* Remove UUCP lockfile. */
#ifndef NOUUCP
    if (haslock && *flfnam) {
	priv_on();			/* Turn privileges on.  */
	unlink(flfnam);			/* Remove the lockfile. */
#ifdef RTAIX
	unlink(lkflfn);
#endif
	*flfnam = '\0';			/* Erase the name. */
	priv_off();			/* Turn privileges off. */
    }
#endif /* !NOUUCP */
    return(0);
}

/* New-style (4.3BSD) UUCP line direction control (Stan Barber, Rice U) */

#ifdef ACUCNTRL
acucntrl(flag,ttname) char *flag, *ttname; {
    char x[DEVNAMLEN+32], *device, *devname;

    if (strcmp(ttname,CTTNAM) == 0 || xlocal == 0) /* If not local, */
      return;				/* just return. */
    device = ((devname = xxlast(ttname,'/')) != NULL ? devname+1 : ttname);
    if (strncmp(device,"LCK..",4) == 0) device += 5;
    sprintf(x,"/usr/lib/uucp/acucntrl %s %s",flag,device);
    debug(F110,"called ",x,0);
    zsyscmd(x);
}
#endif /* ACUCNTRL */

/*  T T P K T  --  Condition the communication line for packets. */
/*              or for modem dialing */

#define DIALING 4               /* flags (via flow) for modem handling */
#define CONNECT 5

/*  If called with speed > -1, also set the speed.  */

/*  Returns 0 on success, -1 on failure.  */

ttpkt(speed,flow,parity) long speed; int flow, parity; {
    int s2;
    int s = -1;
    int x;

    if (ttyfd < 0) return(-1);          /* Not open. */
    ttprty = parity;                    /* Let other tt functions see these. */
    ttflow = flow;
    ttspeed = speed;
    debug(F101,"ttpkt setting ttprty","",ttprty);

#ifdef	NETCONN				/* Nothing to do for telnet */
    if (netconn) return (0);
#endif	/* NETCONN */

    if (xlocal) {
	s2 = (int) (speed / 10L);	/* Convert bps to cps */
	ttsspd(s2);			/* Check and set the speed */
	debug(F101,"ttpkt carrier","",flow);
 	carrctl(&ttraw, flow != DIALING	/* Carrier control */
		&& (ttcarr == CAR_ON));
	tvtflg = 0;			/* So ttvt() will work next time */
    }

#ifndef UXIII				/* BSD section */

    if (flow == 0)			/* No Xon/Xoff flow control */
      ttraw.sg_flags &= ~TANDEM;	/* Don't ask for it */
    else
      ttraw.sg_flags |= TANDEM;		/* Ask for it. */

#ifdef LPASS8				/* Can pass 8-bit data through? */
/* If the LPASS8 local mode is available, then flow control can always  */
/* be used, even if parity is none and we are transferring 8-bit data.  */
    x = LPASS8;				/* If LPASS8 defined, then */
    if (lmodef) {			/* TIOCLBIS must be too. */
	x = ioctl(ttyfd,TIOCLBIS,&x);	/* Try to set LPASS8. */
	if (x < 0) {
	    debug(F100,"ttpkt TIOCLBIS error","",0);
	} else {
	    lmodef++;
	    debug(F100,"ttpkt TIOCLBIS ok","",0);
	}
    }
/*
 But if we use LPASS8 mode, we must explicitly turn off
 terminal interrupts of all kinds.
*/
#ifdef TIOCGETC				/* Not rawmode, */
    if (tcharf && (xlocal == 0)) {	/* must turn off */
	tchnoi.t_intrc = -1;		/* interrupt character */
	tchnoi.t_quitc = -1;		/* and quit character */
	if (ioctl(ttyfd,TIOCSETC,&tchnoi) < 0) {
	    debug(F100,"ttpkt TIOCSETC failed","",0);
	} else {
	    tcharf = 1;
	    debug(F100,"ttpkt TIOCSETC ok","",0);
	}
#ifdef COMMENT
/* only for paranoid debugging */
	if (tcharf) {
	    struct tchars foo;
	    char tchbuf[100];
	    ioctl(0,TIOCGETC,&foo);
	    sprintf(tchbuf,
		    "intr=%d,quit=%d, start=%d, stop=%d, eof=%d, brk=%d",
		    foo.t_intrc, foo.t_quitc, foo.t_startc,
		    foo.t_stopc, foo.t_eofc,  foo.t_brkc);
	    debug(F110,"ttpkt chars",tchbuf,0);
	}
#endif
    }
    ttraw.sg_flags |= CBREAK;		/* Needed for unknown reason */
#endif /* TIOCGETC */

/* Prevent suspend during packet mode */
#ifdef TIOCGLTC				/* Not rawmode, */
    if (ltcharf && (xlocal == 0)) {	/* must turn off */
	ltchnoi.t_suspc = -1;		/* suspend character */
	ltchnoi.t_dsuspc = -1;		/* and delayed suspend character */
	if (ioctl(ttyfd,TIOCSLTC,&tchnoi) < 0) {
	    debug(F100,"ttpkt TIOCSLTC failed","",0);
	} else {
	    ltcharf = 1;
	    debug(F100,"ttpkt TIOCSLTC ok","",0);
	}
    }
#endif /* TIOCGLTC */

#else /* LPASS not defined */

/* Previously, BSD-based implementations always */
/* used rawmode for packets.  Now, we use rawmode only if parity is NONE. */
/* This allows the flow control requested above to actually work, but only */
/* if the user asks for parity (which also means they get 8th-bit quoting), */
/* and only in remote mode (because for some reason it doesn't work in */
/* local mode!) */

    if (flow) {
	if (parity) {			/* If parity, */
	    ttraw.sg_flags &= ~RAW;	/* use cooked mode */
	    if (xlocal) ttraw.sg_flags |= CBREAK;
	    debug(F101,"ttpkt cooked, cbreak","",parity);
	} else {				/* If no parity, */
	    ttraw.sg_flags |= RAW;		/* must use 8-bit raw mode. */
	    debug(F101,"ttpkt setting rawmode","",parity);
	}
    } else {				/* No Xon/Xoff */
	ttraw.sg_flags |= RAW;		/* Can use 8-bit raw mode. */
    }
#endif

    /* Don't echo, don't map CR to CRLF on output, don't fool with case */
#ifdef LCASE
    ttraw.sg_flags &= ~(ECHO|CRMOD|LCASE);
#else
    ttraw.sg_flags &= ~(ECHO|CRMOD);
#endif

#ifdef TOWER1
    ttraw.sg_flags &= ~ANYP;            /* Must tell Tower no parity */
#endif /* tower1 */

#ifdef BSD41
    { /*
	For 4.1BSD only, force "old" tty driver, new one botches TANDEM.
	Note, should really use TIOCGETD in ttopen to get current discipline,
	and restore it in ttres().
      */
	int ldisc = OTTYDISC;
	ioctl(ttyfd, TIOCSETD, &ldisc);
    }
#endif /* bsd41 */

    if (stty(ttyfd,&ttraw) < 0) return(-1); /* Set the new modes. */

    if (xlocal == 0)			/* Turn this off so we can read */
      signal(SIGINT,SIG_IGN);		/* Ctrl-C chars typed at console */

    tvtflg = 0;				/* So ttvt() will work next time */
    return(0);

#endif /* not uxiii */

/* System III / System V section... */

#ifdef UXIII
    if (flow == 1) ttraw.c_iflag |= (IXON|IXOFF);
    if (flow == 0) ttraw.c_iflag &= ~(IXON|IXOFF);

    ttraw.c_lflag &= ~(ICANON|ECHO);
    ttraw.c_lflag |= (ISIG|NOFLSH);  /* do check for interrupt, don't flush */
    ttraw.c_iflag |= (BRKINT|IGNPAR);
    ttraw.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|IUCLC|INPCK|ISTRIP|IXANY);
    ttraw.c_oflag &= ~OPOST;
    ttraw.c_cflag &= ~(CSIZE|PARENB);
    ttraw.c_cflag |= (CS8|CREAD|HUPCL);
#ifdef IX370
    ttraw.c_cc[4] = 48;  /* So Series/1 doesn't interrupt on every char */
    ttraw.c_cc[5] = 1;
#else
    ttraw.c_cc[4] = 1;   /* [VMIN]  return max of this many characters or */
    ttraw.c_cc[5] = 0;	 /* [VTIME] when this many secs/10 expire w/no input */
#endif /* ix370 */

#ifdef VINTR				/* Turn off interrupt character */
    if (xlocal == 0)			/* so ^C^C can break us out of */
      ttraw.c_cc[VINTR] = 0;		/* packet mode. */
#endif

    if (xlocal && (s > 0)) {		/* set speed */
        ttraw.c_cflag &= ~CBAUD;
        ttraw.c_cflag |= s;
    }
    if (ioctl(ttyfd,TCSETAW,&ttraw) < 0) return(-1);  /* set new modes . */
    tvtflg = 0;
    return(0);
#endif /* uxiii */
}

/*  T T V T -- Condition communication line for use as virtual terminal  */

ttvt(speed,flow) long speed; int flow; {
    int s, s2;

    debug(F101,"ttvt ttyfd","",ttyfd);
    debug(F101,"ttvt tvtflg","",tvtflg);
    if (ttyfd < 0) return(-1);          /* Not open. */
#ifdef	NETCONN
    if (netconn) {
	tvtflg = 1;			/* Network connections */
	return(0);			/* require no special setup */
    }
#endif	/* NETCONN */

    if (tvtflg != 0 && speed == ttspeed && flow == ttflow && ttcarr == curcarr)
      return(0);			/* Already been called. */

    if (xlocal) {			/* For external lines... */
	s2 = (int) (speed / 10L);
	s = ttsspd(s2);			/* Check/set the speed */
	carrctl(&tttvt, flow != DIALING	/* Do carrier control */
		&& (ttcarr == CAR_ON || ttcarr == CAR_AUT && ttmdm != 0));
    } else s = s2 = -1;

#ifndef UXIII
    if (flow == 1) tttvt.sg_flags |= TANDEM; /* XON/XOFF if selected */
    if (flow == 0) tttvt.sg_flags &= ~TANDEM;
    tttvt.sg_flags |= RAW;              /* Raw mode */
#ifdef TOWER1
    tttvt.sg_flags &= ~(ECHO|ANYP);     /* No echo or system III ??? parity */
#else
    tttvt.sg_flags &= ~ECHO;            /* No echo */
#endif /* tower1 */

    if (stty(ttyfd,&tttvt) < 0) return(-1);

#else /* It is UXIII */
    if (flow == 1) tttvt.c_iflag |= (IXON|IXOFF);
    if (flow == 0) tttvt.c_iflag &= ~(IXON|IXOFF);

    tttvt.c_lflag &= ~(ISIG|ICANON|ECHO);
    tttvt.c_iflag |= (IGNBRK|IGNPAR);
    tttvt.c_iflag &= ~(INLCR|IGNCR|ICRNL|IUCLC|BRKINT|INPCK|ISTRIP|IXANY);
    tttvt.c_oflag &= ~OPOST;
    tttvt.c_cflag &= ~(CSIZE|PARENB);
    tttvt.c_cflag |= (CS8|CREAD|HUPCL);
    tttvt.c_cc[4] = 1;
    tttvt.c_cc[5] = 0;

    if (s > 0) {			/* Set speed */
        tttvt.c_cflag &= ~CBAUD;
        tttvt.c_cflag |= s;
    }
    if (ioctl(ttyfd,TCSETAW,&tttvt) < 0) return(-1);  /* set new modes . */
#endif /* UXIII */

    ttspeed = speed;			/* Done, remember how we were */
    ttflow = flow;			/* called, so we can decide how to */
    tvtflg = 1;				/* respond next time. */

    debug(F101,"ttvt done","",tvtflg);
    return(0);
}

/*  T T S S P D  --  Checks and sets transmission rate.  */

/*  Call with speed in characters (not bits!) per second. */
/*  Returns internal speed code if successful, -1 otherwise. */

ttsspd(cps) int cps; {
    int s, s2;

    debug(F101,"ttsspd","",cps);

#ifdef	NETCONN
    if (netconn) return (0);
#endif	/* NETCONN */

    if (cps < 0) return(-1);
    s = s2 = -1;

    /* First check that the given speed is valid. */

    switch (cps) {
#ifndef MINIX
      case 0:   s = B0;    break;
      case 5:   s = B50;   break;
      case 7:   s = B75;   break;
#endif
      case 11:  s = B110;  break;
#ifndef MINIX
      case 15:  s = B150;  break;
      case 20:  s = B200;  break;
#endif
      case 30:  s = B300;  break;
#ifndef MINIX
      case 60:  s = B600;  break;
#endif
      case 120: s = B1200; break;
#ifndef MINIX
      case 180: s = B1800; break;
#endif
      case 240: s = B2400; break;
      case 480: s = B4800; break;
#ifndef MINIX
      case 888: s = B75; s2 = B1200; break; /* 888 = 75/1200 split speed */
#endif
      case 960: s = B9600; break;
#ifdef B19200
      case 1920: s = B19200; break;
#else
#ifdef EXTA
      case 1920: s = EXTA; break;
#endif
#endif
#ifdef B38400
      case 3840: s = B38400; break;
#else
#ifdef EXTB
      case 3840:   s = EXTB; break;
#endif
#endif
      default:
	return(-1);
    }
    if (ttyfd > -1 && s > -1 && xlocal != 0) { /* Actually set the speed */
	if (s2 == -1) s2 = s;
#ifndef UXIII
	if (gtty(ttyfd,&ttcur) < 0) return(-1);
	ttcur.sg_ospeed = s; ttcur.sg_ispeed = s2;
	tttvt.sg_ospeed = s; tttvt.sg_ispeed = s2;
	ttraw.sg_ospeed = s; ttraw.sg_ispeed = s2;
	ttold.sg_ospeed = s; ttold.sg_ispeed = s2;
	if (stty(ttyfd,&ttcur) < 0) return(-1);
#else /* UXIII */
	/* I don't know if it is possible to have split speeds in Sys III/V */
	if (cps == 888) return(-1);
	if (ioctl(ttyfd,TCGETA,&ttcur) < 0) return(-1);
	ttcur.c_cflag &= ~CBAUD;
	ttcur.c_cflag |= s;
	tttvt.c_cflag &= ~CBAUD;
	tttvt.c_cflag |= s;
	ttraw.c_cflag &= ~CBAUD;
	ttraw.c_cflag |= s;
	ttold.c_cflag &= ~CBAUD;
	ttold.c_cflag |= s;
	if (ioctl(ttyfd,TCSETAW,&ttcur) < 0) return(-1);
#endif /* ~UXIII */
    }
    return(s);
}

/* T T G S P D  -  Get speed of currently selected tty line  */

/*
  Unreliable.  After SET LINE, it returns an actual speed, but not the real
  speed.  Apparently it always returns the line's nominal speed, from
  /etc/ttytab.  Even if you SET SPEED to something else, this function might
  not notice.
*/
long
ttgspd() {				/* Get current tty speed */
    int s; long ss;
    char temp[12];

#ifdef NETCONN
    if (netconn) return(-1);		/* -1 if network connection */
#endif /* NETCONN */

    if (ttyfd < 0) {
#ifndef UXIII
	s = ccold.sg_ospeed;		/* (obtained by congm()) */
#else
	s = ccold.c_cflag & CBAUD;
#endif
    } else {
#ifndef UXIII
	if (gtty(ttyfd,&ttcur) < 0) return(-1);
	s = ttcur.sg_ospeed;
#else
	if (ioctl(ttyfd,TCGETA,&ttcur) < 0) return(-1);
	s = ttcur.c_cflag & CBAUD;
#endif
    }
    debug(F101,"ttgspd ttyfd","",ttyfd);
    debug(F101,"ttgspd code","",s);
    switch (s) {
#ifdef B0
      case B0:    ss = 0L; break;
#endif

#ifndef MINIX
/*
 MINIX defines the Bxx symbols to be bps/100, so B50==B75, B110==B134==B150,
 etc, making for many "duplicate case in switch" errors, which are fatal.
*/
#ifdef B50
      case B50:   ss = 50L; break;
#endif
#ifdef B75
      case B75:   ss = 75L; break;
#endif
#endif /* MINIX */

#ifdef B110
      case B110:  ss = 110L; break;
#endif

#ifndef MINIX
#ifdef B134
      case B134:  ss = 134L; break;
#endif
#ifdef B150
      case B150:  ss = 150L; break;
#endif
#endif /* MINIX */

#ifdef B200
      case B200:  ss = 200L; break;
#endif

#ifdef B300
      case B300:  ss = 300L; break;
#endif
#ifdef B600
      case B600:  ss = 600L; break;
#endif
#ifdef B1200
      case B1200: ss = 1200L; break;
#endif
#ifdef B1800
      case B1800: ss = 1800L; break;
#endif
#ifdef B2400
      case B2400: ss = 2400L; break;
#endif
#ifdef B4800
      case B4800: ss = 4800L; break;
#endif
#ifdef B9600
      case B9600: ss = 9600L; break;
#endif
#ifdef B19200
      case B19200: ss = 19200L; break;
#else
#ifdef EXTA
      case EXTA: ss = 19200L; break;
#endif
#endif

#ifndef MINIX
#ifdef B38400
      case B38400: ss = 38400L; break;
#else
#ifdef EXTB
      case EXTB: ss = 38400L; break;
#endif
#endif
#endif /* MINIX */

      default:
	ss = -1; break;
    }
    sprintf(temp,"%l",ss);
    debug(F110,"speed",temp,0);
    return(ss);
}

/* ckumyr.c by Kristoffer Eriksson, ske@pkmab.se, 15 Mar 1990. */

#ifdef MYREAD

/* Private buffer for myread() and its companions.  Not for use by anything
 * else.  ttflui() is allowed to reset them to initial values.  ttchk() is
 * allowed to read my_count.
 *
 * my_item is an index into mybuf[].  Increment it *before* reading mybuf[].
 *
 * A global parity mask variable could be useful too.  We could use it to
 * let myread() strip the parity on its own, instead of stripping sign
 * bits as it does now.
 */

#define MYBUFLEN 256
static CHAR mybuf[MYBUFLEN];		/* Buffer, including push back */
static int my_count = 0;		/* Number of chars still in mybuf */
static int my_item = -1;		/* Last index read from mybuf[] */

/* myread() -- Efficient read of one character from communications line.
 *
 * Uses a private buffer to minimize the number of expensive read() system
 * calls.  Essentially performs the equivalent of read() of 1 character, which
 * is then returned.  By reading all available input from the system buffers
 * to the private buffer in one chunk, and then working from this buffer, the
 * number of system calls is reduced in any case where more than one character
 * arrives during the processing of the previous chunk, for instance high
 * baud rates or network type connections where input arrives in packets.
 * If the time needed for a read() system call approaches the time for more
 * than one character to arrive, then this mechanism automatically compensates
 * for that by performing bigger read()s less frequently.  If the system load
 * is high, the same mechanism compensates for that too.
 *
 * myread() is a macro that returns the next character from the buffer.  If the
 * buffer is empty, mygetbuf() is called.  See mygetbuf() for possible error
 * returns.
 *
 * This should be efficient enough for any one-character-at-a-time loops.
 * For even better efficiency you might use memcpy()/bcopy() or such between
 * buffers (since they are often better optimized for copying), but it may not
 * be worth it if you have to take an extra pass over the buffer to strip
 * parity and check for CTRL-C anyway.
 *
 * Note that if you have been using myread() from another program module, you
 * may have some trouble accessing this macro version and the private variables
 * it uses.  In that case, just add a function in this module, that invokes the
 * macro.
 */
#define myread()  (--my_count < 0 ? mygetbuf() : 255 & (int)mybuf[++my_item])

/* Specification: Push back up to one character onto myread()'s queue.
 *
 * This implementation: Push back characters into mybuf. At least one character
 * must have been read through myread() before myunrd() may be used.  After
 * EOF or read error, again, myunrd() can not be used.  Sometimes more than
 * one character can be pushed back, but only one character is guaranteed.
 * Since a previous myread() must have read its character out of mybuf[],
 * that guarantees that there is space for at least one character.  If push
 * back was really needed after EOF, a small addition could provide that.
 *
 * myunrd() is currently not called from anywhere inside kermit...
 */
#ifdef NOTUSED
myunrd(ch) CHAR ch; {
    if (my_item >= 0) {
	mybuf[my_item--] = ch;
	++my_count;
    }
}
#endif

/* mygetbuf() -- Fill buffer for myread() and return first character.
 *
 * This function is what myread() uses when it can't get the next character
 * directly from its buffer.  First, it calls a system dependent myfillbuf()
 * to read at least one new character into the buffer, and then it returns
 * the first character just as myread() would have done.  This function also
 * is responsible for all error conditions that myread() can indicate.
 *
 * Returns: When OK	=> a positive character, 0 or greater.
 *	    When EOF	=> -2.
 *	    When error	=> -3, error code in errno.
 *
 * Older myread()s additionally returned -1 to indicate that there was nothing
 * to read, upon which the caller would call myread() again until it got
 * something.  The new myread()/mygetbuf() always gets something.  If it 
 * doesn't, then make it do so!  Any program that actually depends on the old
 * behaviour will break.
 *
 * The older version also used to return -2 both for EOF and other errors,
 * and used to set errno to 9999 on EOF.  The errno stuff is gone, EOF and
 * other errors now return different results, although Kermit currently never
 * checks to see which it was.  It just disconnects in both cases.
 *
 * Kermit lets the user use the quit key to perform some special commands
 * during file transfer.  This causes read(), and thus also mygetbuf(), to
 * finish without reading anything and return the EINTR error.  This should
 * be checked by the caller.  Mygetbuf() could retry the read() on EINTR,
 * but if there is nothing to read, this could delay Kermit's reaction to
 * the command, and make Kermit appear unresponsive.
 *
 * The debug() call should be removed for optimum performance.
 */
mygetbuf() {
    my_count = myfillbuf();
    /* debug(F101, "myfillbuf read", "", my_count); */
    if (my_count <= 0)
      return(my_count < 0 ? -3 : -2);
    --my_count;
    return(255 & (int)mybuf[my_item = 0]);
}


/* myfillbuf():
 * System-dependent read() into mybuf[], as many characters as possible.
 *
 * Returns: OK => number of characters read, always more than zero.
 *          EOF => 0
 *          Error => -1, error code in errno.
 *
 * If there is input available in the system's buffers, all of it should be
 * read into mybuf[] and the function return immediately.  If no input is
 * available, it should wait for a character to arrive, and return with that
 * one in mybuf[] as soon as possible.  It may wait somewhat past the first
 * character, but be aware that any such delay lengthens the packet turnaround
 * time during kermit file transfers.  Should never return with zero characters
 * unless EOF or irrecoverable read error.
 *
 * Correct functioning depends on the correct tty parameters being used.
 * Better control of current parameters is required than may have been the
 * case in older Kermit releases.  For instance, O_NDELAY (or equivalent) can 
 * no longer be sometimes off and sometimes on like it used to, unless a 
 * special myfillbuf() is written to handle that.  Otherwise the ordinary 
 * myfillbuf()s may think they have come to EOF.
 *
 * If your system has a facility to directly perform the functioning of
 * myfillbuf(), then use it.  If the system can tell you how many characters
 * are available in its buffers, then read that amount (but not less than 1).
 * If the system can return a special indication when you try to read without
 * anything to read, while allowing you to read all there is when there is
 * something, you may loop until there is something to read, but probably that
 * is not good for the system load.
 */

#ifdef COHERENT
#ifdef FIONREAD
#undef FIONREAD
#endif
#define FIONREAD TIOCQUERY
#define PEEKTYPE int
#else
#define PEEKTYPE long
#endif /* COHERENT */

#ifdef UXIII
	/* This is for System III/V with VMIN>0, VTIME=0 and O_NDELAY off,
	 * and CLOCAL set any way you like.  This way, read() will do exactly
	 * what is required by myfillbuf(): If there is data in the buffers
	 * of the O.S., all available data is read into mybuf, up to the size
	 * of mybuf.  If there is none, the first character to arrive is
	 * awaited and returned.
	 */
myfillbuf() {
    return read(ttyfd, mybuf, sizeof(mybuf));
}

#else /* !UXIII */

#ifdef aegis
	/* This is quoted from the old myread().  The semantics seem to be
	 * alright, but maybe errno would not need to be set even when
	 * there is no error?  I don't know aegis.
	 */
myfillbuf() {
    int count;

    count = ios_$get((short)ttyfd, ios_$cond_opt, mybuf, 256L, st);
    errno = EIO;
    if (st.all == ios_$get_conditional_failed) /* get at least one */
      inbufc = ios_$get((short)ttyfd, 0, mybuf, 1L, st);
    if (st.all == ios_$end_of_file)
      return(0);
    else if (st.all != status_$ok) {
	errno = EIO;
	return(-1);
    }
    return(count);
}
#else /* !aegis */

#ifdef FIONREAD
	/* This is for systems with FIONREAD.  FIONREAD returns the number
	 * of characters available for reading. If none are available, wait
	 * until something arrives, otherwise return all there is.
	 */
myfillbuf() {
    PEEKTYPE avail;

    if ((ioctl(ttyfd, FIONREAD, &avail) < 0) || (avail == 0))
      avail = 1;

    if (avail > MYBUFLEN)
      avail = MYBUFLEN;

    return(read(ttyfd, mybuf, avail));
}

#else /* !FIONREAD */
/* Add other systems here, between #ifdef and #else, e.g. NETCON. */

/* When there is no other possibility, read 1 character at a time. */
myfillbuf() {
    return read(ttyfd, mybuf, 1);
}

#endif /* !FIONREAD */
#endif /* !aegis */
#endif /* !UXIII */

#endif /* MYREAD */

/*  T T F L U I  --  Flush tty input buffer */

ttflui() {
    int ffd;

#ifndef UXIII
    long n;
#endif
    ffd = xlocal ? ttyfd : 0;		/* If not local, use stdin */
    debug(F101,"ttflui xlocal","",xlocal);
    debug(F101,"ttflui ttyfd","",ttyfd);
    debug(F101,"ttflui ffd","",ffd);
    if (ffd < 0) return(-1);
#ifdef	NETCONN
    if (netconn) return (0);		/* Should do better than this... */
#endif	/* NETCONN */

#ifdef MYREAD
    my_count = 0;			/* Initialize myread() stuff */
    my_item = -1;
#endif /* myread */

#ifdef aegis
    sio_$control((short)ffd, sio_$flush_in, true, st);
    if (st.all != status_$ok) {
	fprintf(stderr, "flush failed: "); error_$print(st);
    } else {      /* sometimes the flush doesn't work */
        for (;;) {
	    char buf[256];
            /* eat all the characters that shouldn't be available */
            ios_$get((short)ffd, ios_$cond_opt, buf, 256L, st); /* (void) */
            if (st.all == ios_$get_conditional_failed) break;
            fprintf(stderr, "flush failed(2): "); error_$print(st);
        }
    }
#else
#ifdef UXIII
#ifndef VXVE
    if (ioctl(ffd,TCFLSH,0) < 0) perror("flush failed");
#endif /* vxve */
#else
#ifdef TIOCFLUSH
#ifdef ANYBSD
    n = FREAD;                          /* Specify read queue */
    debug(F101,"ttflui anybsd flush","",ffd);
    if (ioctl(ffd,TIOCFLUSH,&n) < 0) {
	perror("flush failed");
    }
#else
    if (ioctl(ffd,TIOCFLUSH,0) < 0) {
	perror("flush failed");
    }
#endif
#endif
#endif
#endif
    return(0);
}

ttfluo() {				/* Flush output buffer */
    return(0);				/* (dummy for now) */
}

/* Interrupt Functions */

/* Set up terminal interrupts on console terminal */

#ifdef UXIII
esctrp(foo) int foo; {			/* trap console escapes (^\) */
    conesc = 1;
    signal(SIGQUIT,SIG_IGN);            /* ignore until trapped */
}
#endif

#ifdef V7
esctrp() {                              /* trap console escapes (^\) */
    conesc = 1;
    signal(SIGQUIT,SIG_IGN);            /* ignore until trapped */
}
#endif

#ifdef C70
esctrp() {                              /* trap console escapes (^\) */
    conesc = 1;
    signal(SIGQUIT,SIG_IGN);            /* ignore until trapped */
}
#endif

/*  C O N I N T  --  Console Interrupt setter  */

/*
  First arg is pointer to function to handle SIGTERM & SIGINT (like Ctrl-C).
  Second arg is pointer to function to handle SIGTSTP (suspend).
*/

conint(f,s) SIGTYP (*f)(), (*s)(); {	/* Set interrupt traps. */
    int x, y, jc = 0;			/* jc = job control. */

/* Check for background operation, even if not running on real tty, so that */
/* background flag can be set correctly.  If background status is detected, */
/* then Kermit will not issue its interactive prompt or most messages. */
/* If your prompt goes away, you can blame this function. */

/* Use process-group test if possible. */

#ifdef BSD4				/* We can in BSD 4.x. */
#define PGROUP_T
#else
#ifdef HPUXnot500			/* and in most HP-UX's. */
#define PGROUP_T
#else
#ifdef TIOCGPGRP			/* General case. */
#define PGROUP_T
#endif
#endif
#endif

#ifdef MIPS
#undef PGROUP_T
#endif

#ifdef PGROUP_T
/* Reliable process-group test.  Check whether this process's group is the */
/* same as the controlling terminal's process group. */

#ifdef AIX370				/* In AIX 3.0, pids are long */
    pid_t mypgrp;
    pid_t ctpgrp;
    extern pid_t getpgrp();
#else
    int mypgrp;
    int ctpgrp;
    extern int getpgrp();
#endif

    mypgrp = getpgrp(0);		/* Get my process group. */
    debug(F101,"conint proccess group","",mypgrp);
    ioctl(1, TIOCGPGRP, &ctpgrp);	/* Get controlling tty's process grp */
    debug(F101,"conint ctty group","",ctpgrp);
    x = (mypgrp != ctpgrp);             /* If they differ, then background. */
    debug(F101,"conint process group test","",x);
    jc = 1;				/* Have job control. */

#else /* !PGROUP_T */

/* This is the general (unreliable) AT&T case. */
/* Test if SIGINT (terminal interrupt) is set to SIG_IGN (ignore), */
/* which is done by the shell (sh) if the program is started with '&'.  */
/* Unfortunately, this is NOT done by csh or ksh so watch out! */
/* Note, it's safe to set SIGINT to SIG_IGN here, because further down */
/* we always set it to something else. */

    SIGTYP (*osigint)();

    osigint = signal(SIGINT,SIG_IGN);	/* What is SIGINT set to? */
    x = (osigint == SIG_IGN);		/* SIG_IGN? */
    debug(F101,"conint osigint","",(int) osigint);
    debug(F101,"conint signal test","",x);

#endif /* PGROUP_T */

/* Also check to see if we're running with redirected stdio. */
/* This is not really background operation, but we want to act as though */
/* it were. */

    y = isatty(0) && isatty(1);
    debug(F101,"conint isatty test","",y);

#ifdef BSD29
/* The process group and/or signal test doesn't work under these... */
    backgrd = !y;
#else
#ifdef sxaE50
    backgrd = !y;
#else
#ifdef MINIX
    backgrd = !y;
#else
    backgrd = (x || !y);
#endif /* BSD29 */
#endif /* sxaE50 */
#endif /* MINIX */
    debug(F101,"conint backgrd","",backgrd);

/* Now set the desired handlers for hangup and software termination. */

    signal(SIGHUP,f);                   /* Hangup */
    signal(SIGTERM,f);                  /* Software termination */

/* Now handle keyboard stop, quit, and interrupt signals. */
/* Check if invoked in background -- if so signals set to be ignored. */
/* However, if running under a job control shell, don't ignore them. */
/* We won't be getting any, as we aren't in the terminal's process group. */

    if (backgrd && !jc) {		/* In background, ignore signals */
	debug(F101,"conint background ignoring signals, jc","",jc);
#ifdef SIGTSTP
        signal(SIGTSTP,SIG_IGN);        /* Keyboard stop */
#endif
        signal(SIGQUIT,SIG_IGN);        /* Keyboard quit */
        signal(SIGINT,SIG_IGN);         /* Keyboard interrupt */

    } else {				/* Else in foreground or suspended */
	char *sp;
	debug(F101,"conint foreground catching signals, jc","",jc);
        signal(SIGINT,f);               /* Catch terminal interrupt */

#ifdef SIGTSTP				/* Keyboard stop (suspend) */
	debug(F101,"conint SIGSTSTP","",(int) s);
	if (s == NULL) s = SIG_DFL;
#ifdef COMMENT
/*
  This is no good.  /bin/sh is not the only shell that doesn't support
  job control, and Kermit can't be certain that /bin/sh does *not* support
  job control.  In fact, there's no way in the world Kermit can tell if the
  shell supports job control.  If the user types Ctrl-Z and the shell does
  not support job control, the user's session hangs.  Such users should
  "stty susp undef".
*/
	sp = getenv("SHELL");		/* Not allowed if shell is "sh" */
	if (sp) {
	    debug(F110,"conint shell",sp,0);
	    if (!strcmp(sp,"/bin/sh")) s = SIG_IGN;
	} else s = SIG_DFL;
	debug(F110,"conint suspend",
	      (s == SIG_DFL || s == SIG_IGN) ? "off" : "on", 0);
#endif
	signal(SIGTSTP,s);
#endif /* SIGTSTP */

#ifdef UXIII
        signal(SIGQUIT,esctrp);         /* Quit signal, Sys III/V. */
        if (conesc) conesc = 0;         /* Clear out pending escapes */
#else
#ifdef V7
        signal(SIGQUIT,esctrp);         /* V7 like Sys III/V */
        if (conesc) conesc = 0;
#else
#ifdef aegis
        signal(SIGQUIT,f);              /* Apollo, catch it like others. */
#else
        signal(SIGQUIT,SIG_IGN);        /* Others, ignore like 4D & earlier. */
#endif
#endif
#endif
    }
    return;
}


/*  C O N N O I  --  Reset console terminal interrupts */

SIGTYP					/* Dummy function to ignore signals */
sig_ign(foo) int foo; {			/* Just like the real one, but has  */
}					/* different address. */

connoi() {                              /* Console-no-interrupts */

    debug(F100,"connoi","",0);
#ifdef SIGTSTP
    signal(SIGTSTP,SIG_DFL);
#endif
    /* Note the locally defined replacement for SIG_IGN that is used here */
    /* for the SIGINT setting.  This is done so that the Sys V background */
    /* test -- (signal(SIGINT,SIG_IGN) == SIG_IGN) -- can work.  If we use */
    /* the real SIG_IGN here, then conint will always decide that this */ 
    /* program is running in the background! */

    signal(SIGINT,sig_ign);		/* <--- note! */

    signal(SIGHUP,SIG_DFL);
    signal(SIGQUIT,SIG_IGN);
    signal(SIGTERM,SIG_IGN);
}

/*  I N I T R A W Q  --  Set up to read /dev/kmem for character count.  */

#ifdef  V7
/*
 Used in Version 7 to simulate Berkeley's FIONREAD ioctl call.  This
 eliminates blocking on a read, because we can read /dev/kmem to get the
 number of characters available for raw input.  If your system can't
 or you won't let the world read /dev/kmem then you must figure out a
 different way to do the counting of characters available, or else replace
 this by a dummy function that always returns 0.
*/
/*
 * Call this routine as: initrawq(tty)
 * where tty is the file descriptor of a terminal.  It will return
 * (as a char *) the kernel-mode memory address of the rawq character
 * count, which may then be read.  It has the side-effect of flushing
 * input on the terminal.
 */
/*
 * John Mackin, Physiology Dept., University of Sydney (Australia)
 * ...!decvax!mulga!physiol.su.oz!john
 *
 * Permission is hereby granted to do anything with this code, as
 * long as this comment is retained unmodified and no commercial
 * advantage is gained.
 */
#ifndef MINIX
#include <a.out.h>
#include <sys/proc.h>
#endif

char *
initrawq(tty) int tty; {
#ifdef MINIX
    return(0);
#else
#ifdef UTS24
    return(0);
#else
#ifdef BSD29
    return(0);
#else
    long lseek();
    static struct nlist nl[] = {
        {PROCNAME},
        {NPROCNAME},
        {""}
    };
    static struct proc *pp;
    char *qaddr, *p, c;
    int m, pid, me;
    NPTYPE xproc;                       /* Its type is defined in makefile. */
    int catch();

    me = getpid();
    if ((m = open("/dev/kmem", 0)) < 0) err("kmem");
    nlist(BOOTNAME, nl);
    if (nl[0].n_type == 0) err("proc array");

    if (nl[1].n_type == 0) err("nproc");

    lseek(m, (long)(nl[1].n_value), 0);
    read (m, &xproc, sizeof(xproc));
    saval = signal(SIGALRM, catch);
    if ((pid = fork()) == 0) {
        while(1)
            read(tty, &c, 1);
    }
    alarm(2);

    if(setjmp(jjbuf) == 0) {
        while(1)
            read(tty, &c, 1);
    }
    signal(SIGALRM, SIG_DFL);

#ifdef DIRECT
    pp = (struct proc *) nl[0].n_value;
#else
    if (lseek(m, (long)(nl[0].n_value), 0) < 0L) err("seek");
    if (read(m, &pp, sizeof(pp)) != sizeof(pp))  err("no read of proc ptr");
#endif
    lseek(m, (long)(nl[1].n_value), 0);
    read(m, &xproc, sizeof(xproc));

    if (lseek(m, (long)pp, 0) < 0L) err("Can't seek to proc");
    if ((p = malloc(xproc * sizeof(struct proc))) == NULL) err("malloc");
    if (read(m,p,xproc * sizeof(struct proc)) != xproc*sizeof(struct proc))
        err("read proc table");
    for (pp = (struct proc *)p; xproc > 0; --xproc, ++pp) {
        if (pp -> p_pid == (short) pid) goto iout;
    }
    err("no such proc");

iout:
    close(m);
    qaddr = (char *)(pp -> p_wchan);
    free (p);
    kill(pid, SIGKILL);
    wait((int *)0);             /* Destroy the ZOMBIEs! */
    return (qaddr);
#endif
#endif
#endif
}

/*  More V7-support functions...  */

static
err(s) char *s; {
    char buf[200];

    sprintf(buf, "fatal error in initrawq: %s", s);
    perror(buf);
    doexit(1);
}

static
catch(foo) int foo; {
    longjmp(jjbuf, -1);
}


/*  G E N B R K  --  Simulate a modem break.  */

#ifdef MINIX
#define BSPEED B110
#else
#define BSPEED B150
#endif

genbrk(fn) int fn; {
    struct sgttyb ttbuf;
    int ret, sospeed;

    ret = ioctl(fn, TIOCGETP, &ttbuf);
    sospeed = ttbuf.sg_ospeed;
    ttbuf.sg_ospeed = BSPEED;
    ret = ioctl(fn, TIOCSETP, &ttbuf);
    ret = write(fn, "\0\0\0\0\0\0\0\0\0\0\0\0", 8);
    ttbuf.sg_ospeed = sospeed;
    ret = ioctl(fn, TIOCSETP, &ttbuf);
    ret = write(fn, "@", 1);
    return;
}
#endif

/*  T T C H K  --  Tell how many characters are waiting in tty input buffer  */

/*  Some callers of this want to know whether there is something to read
 *  either in the system buffers or in our private buffers (and mostly don't
 *  care how many characters, just whether it's more than zero or not), while
 *  some others would be better off with the number of characters in our
 *  private buffers only.
 *
 *  Some systems can say how many characters there are in the system buffers.
 *  Others can not. For those that can't, the number in the private buffers
 *  will have to do (or should we put the tty into O_NDELAY-mode and try to
 *  read one character?). If the system can tell whether there is zero or
 *  more than zero characters, we can return 1 in the latter case even if the
 *  private buffer is empty. (That is good for sliding windows.)
 */
ttchk() {
    int x; PEEKTYPE n = 0;
#ifdef NETCONN
    if (netconn) return(0);
#endif
#ifdef FIONREAD
    x = ioctl(ttyfd, FIONREAD, &n);     /* Berkeley and maybe some others */
    debug(F101,"ttchk","",n);
    if (x < 0) n = 0;
#else
#ifdef  V7
#ifdef MINIX
    return(0);
#else
    lseek(kmem[TTY], (long) qaddr[TTY], 0); /* 7th Edition Unix */
    x = read(kmem[TTY], &n, sizeof(int));
    if (x != sizeof(int)) n = 0;
#endif /* MINIX */
#else
#ifdef PROVX1
    x = ioctl(ttyfd, TIOCQCNT, &ttbuf); /* Pro/3xx Venix V.1 */
    n = ttbuf.sg_ispeed & 0377;
    if (x < 0) n = 0;
#else
#ifdef RDCHK
    /* Last resort for systems without FIONREAD or equivalent, but with
     * something like rdchk(), like XENIX.
     */
    if (my_count == 0 && rdchk(ttyfd) > 0) n = 1;
#endif /* RDCHK */
#endif /* PROVX1 */
#endif /* V7 */
#endif /* FIONREAD */
#ifdef MYREAD
    /* For myread() users, add the contents of myread()'s private buffer.
     * Sometimes, this is all there is to construct a result of ttchk() on.
     */
    if (my_count > 0)		    /* Sys III, Sys V, Apollo Aegis, etc */
	n += my_count;
#endif
    debug(F101,"ttchk","",n);
    return(n);
}

/*  T T X I N  --  Get n characters from tty input buffer  */

/*  Returns number of characters actually gotten, or -1 on failure  */

/*  Intended for use only when it is known that n characters are actually */
/*  Available in the input buffer.  */

ttxin(n,buf) int n; CHAR *buf; {
    register int x, c, m;
#ifdef SUNX25
    int qpkt;
#endif /* SUNX25 */
  
    m = (ttprty) ? 0177 : 0377;         /* Parity stripping mask. */
    debug(F101,"ttxin n","",n);

#ifdef SUNX25
    if (netconn && (ttnet == NET_SX25)) { /* X.25 connection */
	do {
	    x = read(ttyfd,buf,n);
	    if (buf[0] & (1 << Q_BIT)) { /* If Q_BIT packet, process it */
		/* If return -1 : invitation to clear; -2 : PAD changes */
		if ((c=qbitpkt (buf+1,x-2)) < 0) return (c);
		qpkt = 1;
	    } else qpkt = 0;
	} while (qpkt);
	debug(F101," x","",x);
    } else {
#endif /* SUNX25 */

#ifdef MYREAD
	for( x = 0; (x > -1) && (x < n) && (c = myread()) >= 0; )
	  buf[x++] = c & m;
#else
	x = read(ttyfd,buf,n);
	for (c = 0; c < n; c++) buf[c] &= m;
	debug(F101," x","",x);
#endif
#ifdef SUNX25
    }
#endif /* SUNX25 */
    if (x > 0) buf[x] = '\0';
    if (x < 0) x = -1;
    return(x);
}

/*  T T O L  --  Write string s, length n, to communication device.  */
/*
  Returns:
   >= 0 on success, number of characters actually written.
   -1 on failure.
*/
#define TTOLMAXT 5
ttol(s,n) int n; char *s; {
    int x, len, tries;

    if (ttyfd < 0) return(-1);          /* Not open? */
    debug(F101,"ttol n","",n);
    tries = TTOLMAXT;			/* Allow up to this many tries */
    len = n;				/* Remember original length */

    while (n > 0 && tries-- > 0) {	/* Be persistent */
	debug(F101,"ttol try","",TTOLMAXT - tries);
	x = write(ttyfd,s,n);		/* Write string to device */
	if (x == n) {			/* Worked? */
	    debug(F101,"ttol ok","",x);	/* OK */
	    return(len);		/* Done */
	} else if (x < 0) {		/* No, got error? */
	    debug(F101,"ttol failed","",errno);
	    return(-1);
	} else {			/* No error, so partial success */
	    debug(F101,"ttol partial","",x);
	    s += x;			/* Point to part not written yet */
	    n -= x;			/* Adjust length */
	    if (x > 0) msleep(100);	/* Wait 100 msec */
	}				/* Go back and try again */
    }	
    return(n < 1 ? len : -1);		/* Too many tries */
}



/*  T T O C  --  Output a character to the communication line  */

/*
 This function should only used for interactive, character-mode operations,
 like terminal connection, script execution, dialer i/o, where the overhead
 of the signals and alarms does not create a bottleneck.
*/

ttoc(c) char c; {
    int x;
    c &= 0xff;
    /* debug(F101,"ttoc","",(CHAR) c); */
    if (ttyfd < 0) return(-1);          /* Check for not open. */
    saval = signal(SIGALRM,timerh);	/* Enable timer interrupt */
    alarm(2);				/* for 2 seconds. */
    x = write(ttyfd,&c,1);		/* Try to write the character. */
    if (x < 1) {
	debug(F101,"ttoc write","",x);
	debug(F101,"ttoc errno","",errno);
    }
    if (setjmp(sjbuf)) {		/* Timer went off? */
	x = -1;				/* Yes, set return code for failure */
        debug(F100,"ttoc timed out","",0);
    }
    ttimoff();
    return(x);
}

/*  T T I N L  --  Read a record (up to break character) from comm line.  */
/*
  Reads up to "max" characters from the communication line, terminating on
  the packet-end character (eol), or timing out and returning -1 if the eol
  character not encountered within "timo" seconds.  The characters that were
  input are copied into "dest" with their parity bits stripped if parity was
  selected.  Returns the number of characters read.  Characters after the
  eol are available upon the next call to this function.

  The idea is to minimize the number of system calls per packet, and also to
  minimize timeouts.  This function is the inner loop of the program and must
  be as efficient as possible.  The current strategy is to use myread().
*/
#define CTRLC '\03'

#ifdef PARSENSE
ttinl(dest,max,timo,eol,start) int max,timo; CHAR *dest, eol, start; {
    int flag;
#else
ttinl(dest,max,timo,eol) int max,timo; CHAR *dest, eol; {
#endif
    register int i, m, n;		/* local variables */
    int x, ccn;
#ifndef MYREAD
    CHAR ch;
#endif
    if (ttyfd < 0) return(-1);          /* Not open. */

    debug(F101,"ttinl max","",max);
    debug(F101,"ttinl timo","",timo);

#ifdef PARSENSE
    debug(F000,"ttinl start","",start);
    flag = 0;				/* Start of packet flag */
#endif
    ccn = 0;				/* Control-C counter */
    x = 0;				/* Return code */
    m = (ttprty) ? 0177 : 0377;         /* Parity stripping mask. */
    *dest = '\0';                       /* Clear destination buffer */
    if (timo < 0) timo = 0;		/* Safety */
    if (timo) {				/* Don't time out if timo == 0 */
	saval = signal(SIGALRM,timerh);	/* Enable timer interrupt */
	alarm(timo);			/* Set it. */
    }
    if (setjmp(sjbuf)) {                /* Timer went off? */
        x = -1;				/* Yes, return -1. */
    } else {
#ifdef SUNX25
        if (netconn && (ttnet == NET_SX25)) {
            CHAR *pdest;
            int pktype, goteol, rest;
        
            debug(F101,"ttinl X.25","",max);
            debug(F101,"ttinl X.25 eol","",eol);
            pdest  = dest;
            rest   = max;
            goteol = 0;
            do {
                n = read(ttyfd,pdest,rest); 
                n--;
                pktype = *pdest & 0x7f;
                switch (pktype) {
		  case 1 << Q_BIT:
		    if (qbitpkt (pdest+1,--n) < 0) return (-2);
		    break;
		  default:
		    if (flag == 0) { /* if not in packet, search start */
			for (i = 1; (i < n) &&
			     !(flag = ((dest[i] & 0x7f) == start));
			     i++);
			if (flag == 0) { /* not found, discard junk */
			    debug(F101,"ttinl skipping","",n);
			    continue;
			} else {	/* found, discard junk before start */
			    int k;
			    n = n - i + 1;
			    for (k = 1; k <= n; k++, i++) dest[k] = dest[i];
			}
		    }
		    for (i = 0; (i < n) && /* search eol */
			 !(goteol=(((*pdest = *(pdest+1) & m) & 0x7f)== eol));
			 i++,pdest++);
		    *pdest = '\0';
		    rest -= n;
                }
            } while ( (rest > 0) && (!goteol) );
            if (goteol) {
                n = max - rest;
                debug (F111,"ttinl X.25 got",dest,n);
                if (timo) ttimoff();
		if (ttprty == 0) {
		    if ((ttprty = parchk(dest,start,n)) > 0) {
			int j;
			debug(F101,"ttinl senses parity","",ttprty);
			debug(F110,"ttinl packet before",dest,0);
			for (j = 0; j < n; j++)
			  dest[j] &= 0x7f; /* Strip parity from packet */
			debug(F110,"ttinl packet after ",dest,0);
		    } else debug(F101,"parchk","",ttprty);
		}
                return (n);
            }
        } else {
#endif /* SUNX25 */
        i = 0;                          /* Destination index */
	/* Now read into destination, stripping parity and looking for the */
	/* the packet terminator, and also for two Ctrl-C's typed in a row. */
	debug(F101,"ttinl eol","",eol);
#ifdef MYREAD
	while (i < max-1) {
	    debug(F101,"ttinl i","",i);
	    if ((n = myread()) < 0) {
		debug(F101,"ttinl myread failure, n","",n);
	    	/* Don't let EINTR break packets. */
		if (n == -3 && errno == EINTR && i > 0) continue;
		x = -1; break;
	    }
#else
	while ((i < max-1)  &&  (n = read(ttyfd, &ch, 1)) > 0) {
	    n = ch;
#endif /* MYREAD */

	    debug(F101,"ttinl char","",n&m);

#ifdef PARSENSE
	    if ((flag == 0) && ((n & 0x7f) == start)) flag = 1;
	    if (flag) dest[i++] = n & m;
#else
	    dest[i++] = n & m;
#endif
	    if ((n & 0x7f) == CTRLC) {	/* Check for ^C^C */
		if (++ccn > 1) {	/* If we got 2 in a row, bail out. */
		    if (timo) {		/* Clear timer. */
			ttimoff();
		    }
		    fprintf(stderr,"^C...\r\n"); /* Echo Ctrl-C */
#ifdef COMMENT
/* No, this breaks DISABLE FINISH... */
		    ttres();			/* Restore the terminal */
#endif
		    return(-2);
		}
	    } else ccn = 0;		/* Not ^C, so reset ^C counter, */

#ifdef PARSENSE
	    if (flag == 0) {
		debug(F101,"ttinl skipping","",n);
		continue;
	    }
#endif

    /* Check for end of packet */

	    if ((n & 0x7f) == eol) {
		debug(F101,"ttinl got eol","",eol);
		dest[i] = '\0';		/* Yes, terminate the string, */
		debug(F101,"ttinl i","",i);
#ifdef PARSENSE
/* Here's where we actually check and adjust the parity. */
/* The major flaw here is if parity is NONE (ttprty = 0) and the packets */
/* really do have no parity, then parchk() is called for every packet. */
/* In practice, this doesn't really harm efficiency noticably, but it would */
/* be better if ttinl() had a way of knowing to stop doing this once a */
/* particular file transfer had been started and checked. */
		if (ttprty == 0) {
		    if ((ttprty = parchk(dest,start,i)) > 0) {
			int j;
			debug(F101,"ttinl senses parity","",ttprty);
			debug(F110,"ttinl packet before",dest,0);
			for (j = 0; j < i; j++)
			  dest[j] &= 0x7f; /* Strip parity from packet */
			debug(F110,"ttinl packet after ",dest,0);
		    } else debug(F101,"parchk","",ttprty);
		}
#endif
		if (timo) {		/* Turn off timer. */
		    ttimoff();
		}
		debug(F111,"ttinl got", dest,i);
		return(i);
	    }
	}
#ifdef SUNX25
      }
#endif /* SUNX25 */
    }
    debug(F100,"ttinl timout","",0);    /* Get here on timeout. */
    debug(F111," with",dest,i);
    ttimoff();				/* Turn off timer */
    return(x);                          /* and return error code. */
}

/*  T T I N C --  Read a character from the communication line  */
/*
 On success, returns the character that was read, >= 0.
 On failure, returns -1 or other negative myread error code.
*/
ttinc(timo) int timo; {
    register int m, n = 0;
#ifndef MYREAD
    CHAR ch = 0;
#endif

    m = (ttprty) ? 0177 : 0377;         /* Parity stripping mask. */
    if (ttyfd < 0) return(-1);          /* Not open. */
    if (timo <= 0) {                    /* Untimed. */
#ifdef MYREAD
        /* comm line failure returns -1 thru myread, so no &= 0377 */
	n = myread();			/* Wait for a character... */
	/* debug(F101,"ttinc n","",n); */
	return(n < 0 ? n : n & m);
#else
        while ((n = read(ttyfd,&ch,1)) == 0) /* Wait for a character. */
        /* Shouldn't have to loop in ver 5A. */
#ifdef NETCONN	  
	  if (netconn) {		/* Special handling for net */
	      netclos();
	      errno = ENOTCONN;
	      return(-2);
	  }
#endif /* NETCONN */
	  ;
	/* debug(F000,"ttinc","",ch); */
        return( (n < 1) ? -3 : (ch & m) );
#endif
    }

    saval = signal(SIGALRM,timerh);	/* Timed, set up timer. */
    alarm(timo);
    if (setjmp(sjbuf)) {
        n = -1;
    } else {
#ifdef MYREAD
	n = myread();			/* If managing own buffer... */
	debug(F101,"ttinc myread","",n);
#else
        n = read(ttyfd,&ch,1);          /* Otherwise call the system. */
        if (n > 0)
	  n = ch & 255;
	else
	  n = (n < 0) ? -3 : -2;
#endif
    }
    ttimoff();				/* Turn off timer */
#ifdef	NETCONN
    if (netconn) {
	if (n == -2) {			/* read() apparently returns 0 */
	    netclos();			/* on network read failure? */
	    errno = ENOTCONN;
	}
    }
#endif	/* NETCONN */
    return( (n < 0) ? n : (n & m) );  /* Return masked char or negative. */
}

/*  T T S N D B  --  Send a BREAK signal  */

ttsndb() {
    int x; long n;

#ifdef PROVX1
    char spd;
#endif

    debug(F101,"ttsndb ttyfd","",ttyfd);
    if (ttyfd < 0) return(-1);          /* Not open. */

#ifdef NETCONN
    if (netconn) {			/* If we have a network connection, */
        if (ttnet == NET_TCPB && ttnproto == NP_TELNET)
	  return(tnsndbrk());		/* send BREAK via telnet protocol */
	else return(0);			/* For X.25 do nothing */
    }
#endif /* NETCONN */

#ifdef PROVX1
    gtty(ttyfd,&ttbuf);                 /* Get current tty flags */
    spd = ttbuf.sg_ospeed;              /* Save speed */
    ttbuf.sg_ospeed = B50;              /* Change to 50 baud */
    stty(ttyfd,&ttbuf);                 /*  ... */
    write(ttyfd,brnuls,3);              /* Send 3 nulls */
    ttbuf.sg_ospeed = spd;              /* Restore speed */
    stty(ttyfd,&ttbuf);                 /*  ... */
    return(0);
#else
#ifdef aegis
    sio_$control((short)ttyfd, sio_$send_break, 250, st);
    return(0);
#else
#ifdef UXIII
    if (ioctl(ttyfd,TCSBRK,(char *)0) < 0) {    /* Send a BREAK */
        perror("Can't send BREAK");
        return(-1);
    }
    return(0);
#else
#ifdef ANYBSD
    n = FWRITE;                         /* Flush output queue. */
    ioctl(ttyfd,TIOCFLUSH,&n);          /* Ignore any errors.. */
    if (ioctl(ttyfd,TIOCSBRK,(char *)0) < 0) {  /* Turn on BREAK */
        perror("Can't send BREAK");
        return(-1);
    }
    x = msleep(275);                    /* Sleep for so many milliseconds */
    if (ioctl(ttyfd,TIOCCBRK,(char *)0) < 0) {  /* Turn off BREAK */
        perror("BREAK stuck!!!");
        doexit(1);                      /* Get out, closing the line. */
                                        /*   with exit status = 1 */
    }
    return(x);
#else
#ifdef  V7
    genbrk(ttyfd);                      /* Simulate a BREAK */
    return(x);
#endif
#endif
#endif
#endif
#endif
}

/*  M S L E E P  --  Millisecond version of sleep().  */

/*
 Intended only for small intervals.  For big ones, just use sleep().
*/

msleep(m) int m; {

#ifdef aegis
    time_$clock_t dur;

    dur.c2.high16 = 0;
    dur.c2.low32  = 250 * m; /* one millisecond = 250 four microsecond ticks */
    time_$wait(time_$relative, dur, st);
    return(0);
#else
#ifdef PROVX1
    if (m <= 0) return(0);
    sleep(-((m * 60 + 500) / 1000));
    return(0);
#endif

#ifdef NAP
    return(nap((long)m));
#else
#ifdef ANYBSD
    int t1, t3;
    t3 = 0;
    if (m <= 0) return(0);
#ifndef BSD42
/* 2.9 and 4.1 BSD do it this way */
    if (ftime(&ftp) < 0) return(-1);    /* Get current time. */
    t1 = ((ftp.time & 0xff) * 1000) + ftp.millitm;
    while (1) {
        ftime(&ftp);                    /* new time */
        t3 = (((ftp.time & 0xff) * 1000) + ftp.millitm) - t1;
        if (t3 > m) return(t3);
    }
#else /* BSD42 */
/* 4.2 & above can do it with select()... */
    if (gettimeofday(&tv, &tz) < 0) return(-1); /* Get current time. */
    t1 = tv.tv_sec;                     /* Seconds */

    tv.tv_sec = 0;                      /* Use select() */
    tv.tv_usec = m * 1000L;
    return(select( 0, (int *)0, (int *)0, (int *)0, &tv) );
#endif
#endif /* ANYBSD */

#ifdef UXIII

#ifdef SUN4S5
    /* Sys V msleep code hangs forever in SUN-4 System V environment */
    { int i; for (i = 0; i < m*10; i++) ; }
#else
    extern long times();
    long t1, t2, tarray[4];
    int t3;

    char *getenv(); /* this should work for any SysV Rel 2 or 3 */
    char *cp = getenv("HZ");
    int CLOCK_TICK;
    int hertz;
    if(cp && (hertz = atoi(cp))) {
        CLOCK_TICK  = 1000 / hertz;
    } else {				/* probably single user mode */
#ifdef HZ
        CLOCK_TICK  = 1000 / HZ;	
#else
	static warned = 0;
	/* HZ always exists in, for instance, SCO Xenix, so you don't have to
	 * make special #ifdefs for XENIX here, like in ver 4F. Also, if you
	 * have Xenix, you have should have nap(), so the best is to use -DNAP
	 * in the makefile. Most systems have HZ.
	 */
	CLOCK_TICK = 17;		/* 1/60 sec */
	if (!warned) {
          printf("warning: environment variable HZ bad... using HZ=%d\r\n",
		 1000 / CLOCK_TICK);
          warned = 1;
	}
#endif /* !HZ */
    }

    if (m <= 0) return(0);
    if ((t1 = times(tarray)) < 0) return(-1);
    while (1) {
        if ((t2 = times(tarray)) < 0) return(-1);
        t3 = ((int)(t2 - t1)) * CLOCK_TICK;
        if (t3 > m) return(t3);
    }
#endif /* SUN4S5 */
#endif /* UXIII */

#ifdef TOWER1
    int t1, t3;
    if (m <= 0) return(0);
    if (ftime(&ftp) < 0) return(-1);            /* Get current time. */
    t1 = ((ftp.time & 0xff) * 1000) + ftp.millitm;
    while (1) {
        ftime(&ftp);                            /* new time */
        t3 = (((ftp.time & 0xff) * 1000) + ftp.millitm) - t1;
        if (t3 > m) return (t3);
    }
#endif /* TOWER1 */
#endif /* !NAP */
#endif /* !aegis */
}

/*  R T I M E R --  Reset elapsed time counter  */

rtimer() {
    tcount = time( (time_t *) 0 );
}


/*  G T I M E R --  Get current value of elapsed time counter in seconds  */


gtimer() {
    int x;
    x = (int) (time( (time_t *) 0 ) - tcount);
    return( (x < 0) ? 0 : x );
}


/*  Z T I M E  --  Return date/time string  */

ztime(s) char **s; {

#ifdef UXIII
    extern long time();                 /* Sys III/V way to do it */
    char *ctime();
    long clock_storage;

    clock_storage = time( (long *) 0 );
    *s = ctime( &clock_storage );
#endif

#ifdef PROVX1
    int utime[2];                       /* Venix way */
    time(utime);
    *s = ctime(utime);
#endif

#ifdef ANYBSD
    char *asctime();                    /* Berkeley way */
    struct tm *localtime();
    struct tm *tp;
#ifdef BSD42
    gettimeofday(&tv, &tz);             /* BSD 4.2 */
    time(&tv.tv_sec);
    tp = localtime(&tv.tv_sec);
#else
    time(&clock);                       /* BSD 4.1, 2.9 ... ceb */
    tp = localtime(&clock);
#endif
    *s = asctime(tp);
#endif

#ifdef TOWER1
    char *asctime();                    /* Tower way */
    struct tm *localtime();
    struct tm *tp;

    time(&clock);
    tp = localtime(&clock);
    *s = asctime(tp);
#endif /* TOWER */

#ifdef V7
#ifdef MINIX
    extern long time();
    extern char *ctime();
    int utime[2];
    time(utime);
    *s = ctime(utime);
#else
    char *asctime();                    /* V7 way */
    struct tm *localtime();
    struct tm *tp;

    time(&clock);
    tp = localtime(&clock);
    *s = asctime(tp);
#endif
#endif
}

/*  C O N G M  --  Get console terminal modes.  */

/*
 Saves current console mode, and establishes variables for switching between
 current (presumably normal) mode and other modes.
*/
congm() {
    int fd;
    if (cgmf) return(0);		/* Already did this. */
    debug(F100,"congm","",0);
#ifdef aegis
    ios_$inq_type_uid(ios_$stdin, conuid, st);
    if (st.all != status_$ok) {
	fprintf(stderr, "problem getting stdin objtype: ");
	error_$print(st);
    }
    concrp = (conuid == mbx_$uid);
    conbufn = 0;
#endif
/* Here we open the controlling terminal so we can get its bits. */
/* It has been pointed out that this might be dangerous in case the process */
/* is not connected to any terminal, or is connected to a hung-up terminal. */

    fd = open(CTTNAM,2);		/* Open controlling terminal */

#ifndef UXIII
    gtty(fd,&ccold);                    /* Structure for restoring */
    gtty(fd,&cccbrk);                   /* For setting CBREAK mode */
    gtty(fd,&ccraw);                    /* For setting RAW mode */
#else
    ioctl(fd,TCGETA,&ccold);
    ioctl(fd,TCGETA,&cccbrk);
    ioctl(fd,TCGETA,&ccraw);
/** ccold.c_cc[1] = 034;       *** these changes were suggested **/
/** ioctl(fd,TCSETAW,&ccold);   *** but may be dangerous **/
#endif
#ifdef VXVE
    cccbrk.c_line = 0;			/* STTY line 0 for CDC VX/VE */
    ioctl(fd,TCSETA,&cccbrk);
    ccraw.c_line = 0;			/* STTY line 0 for CDC VX/VE */
    ioctl(fd,TCSETA,&ccraw);
#endif /* vxve */
    close(fd);
    cgmf = 1;				/* Flag that we got them. */
    return(0);
}


/*  C O N C B --  Put console in cbreak mode.  */

/*  Returns 0 if ok, -1 if not  */

concb(esc) char esc; {
    int x;
    if (!isatty(0)) return(0);          /* only for real ttys */
    if (cgmf == 0) congm();             /* Get modes if necessary. */
    escchr = esc;                       /* Make this available to other fns */
    ckxech = 1;                         /* Program can echo characters */
#ifdef aegis
    conbufn = 0;
    if (concrp) return(write(1, "\035\002", 2));
    if (conuid == input_pad_$uid) {pad_$raw(ios_$stdin, st); return(0);}
#endif
#ifndef UXIII
    cccbrk.sg_flags |= CBREAK;          /* Set to character wakeup, */
    cccbrk.sg_flags &= ~ECHO;           /* no echo. */
    x = stty(0,&cccbrk);
#else
    cccbrk.c_lflag &= ~(ICANON|ECHO);
    cccbrk.c_cc[0] = 003;               /* interrupt char is control-c */
    cccbrk.c_cc[1] = escchr;            /* escape during packet modes */
    cccbrk.c_cc[4] = 1;
#ifdef ZILOG
    cccbrk.c_cc[5] = 0;
#else
    cccbrk.c_cc[5] = 1;
#endif /* zilog */
    x = ioctl(0,TCSETAW,&cccbrk);       /* set new modes . */
#endif

#ifndef aegis
    if (x > -1) setbuf(stdout,NULL);    /* Make console unbuffered. */
#endif
#ifdef  V7
#ifndef MINIX
    if (kmem[CON] < 0) {
        qaddr[CON] = initrawq(0);
        if((kmem[CON] = open("/dev/kmem", 0)) < 0) {
            fprintf(stderr, "Can't read /dev/kmem in concb.\n");
            perror("/dev/kmem");
            exit(1);
        }
    }
#endif
#endif
    return(x);
}

/*  C O N B I N  --  Put console in binary mode  */

/*  Returns 0 if ok, -1 if not  */

conbin(esc) char esc; {
    if (!isatty(0)) return(0);          /* only for real ttys */
    if (cgmf == 0) congm();             /* Get modes if necessary. */
    debug(F100,"conbin","",0);
    escchr = esc;                       /* Make this available to other fns */
    ckxech = 1;                         /* Program can echo characters */
#ifdef aegis
    conbufn = 0; if (concrp) return(write(1, "\035\002", 2));
    if (conuid == input_pad_$uid) {pad_$raw(ios_$stdin, st); return(0);}
#endif
#ifndef UXIII
    ccraw.sg_flags |= (RAW|TANDEM);     /* Set rawmode, XON/XOFF */
    ccraw.sg_flags &= ~(ECHO|CRMOD);    /* Set char wakeup, no echo */
    return(stty(0,&ccraw));
#else
    ccraw.c_lflag &= ~(ISIG|ICANON|ECHO);
    ccraw.c_iflag |= (BRKINT|IGNPAR);
    ccraw.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|IUCLC|IXON|IXANY|IXOFF
                        |INPCK|ISTRIP);
    ccraw.c_oflag &= ~OPOST;
#ifdef ATT7300
    ccraw.c_cflag = CLOCAL | B9600 | CS8 | CREAD | HUPCL; /* c_cflag */
#endif
/*** Kermit used to put the console in 8-bit raw mode, but some users have
 *** pointed out that this should not be done, since some sites actually
 *** use terminals with parity settings on their Unix systems, and if we
 *** override the current settings and stop doing parity, then their terminals
 *** will display blotches for characters whose parity is wrong.  Therefore,
 *** the following two lines are commented out (Larry Afrin, Clemson U):
 ***
 ***   ccraw.c_cflag &= ~(PARENB|CSIZE);
 ***   ccraw.c_cflag |= (CS8|CREAD);
 ***
 *** Sys III/V sites that have trouble with this can restore these lines.
 ***/
    ccraw.c_cc[0] = 003;		/* Interrupt char is Ctrl-C */
    ccraw.c_cc[1] = escchr;		/* Escape during packet mode */
    ccraw.c_cc[4] = 1;
#ifdef ZILOG
    ccraw.c_cc[5] = 0;
#else
    ccraw.c_cc[5] = 1;
#endif /* zilog */
    return(ioctl(0,TCSETAW,&ccraw) );   /* set new modes . */
#endif
}


/*  C O N R E S  --  Restore the console terminal  */

conres() {
    debug(F100,"entering conres","",0);
    if (cgmf == 0) return(0);           /* Do nothing if modes unchanged */
    if (!isatty(0)) return(0);          /* only for real ttys */
#ifndef UXIII                           /* In BSD, must sleep for a sec */
    msleep(300);			/* before restoring modes */
					/* (this replaces "sleep(1)" */
#endif                                  /* (AT&T UNIX does wait in ioctls) */
    ckxech = 0;                         /* System should echo chars */
#ifdef aegis
    conbufn = 0; if (concrp) return(write(1, "\035\001", 2));
    if (conuid == input_pad_$uid) {pad_$cooked(ios_$stdin, st); return(0);}
#endif
#ifndef UXIII
    debug(F100,"conres restoring stty","",0);
    return(stty(0,&ccold));             /* Restore controlling tty */
#else
    return(ioctl(0,TCSETAW,&ccold));
#endif
}

/*  C O N O C  --  Output a character to the console terminal  */

conoc(c) char c; {
    return(write(1,&c,1));
}

/*  C O N X O  --  Write x characters to the console terminal  */

conxo(x,s) char *s; int x; {
    write(1,s,x);
}

/*  C O N O L  --  Write a line to the console terminal  */

conol(s) char *s; {
    int len;
    len = strlen(s);
    write(1,s,len);
}

/*  C O N O L A  --  Write an array of lines to the console terminal */

conola(s) char *s[]; {
    int i;
    for (i=0 ; *s[i] ; i++) conol(s[i]);
}

/*  C O N O L L  --  Output a string followed by CRLF  */

conoll(s) char *s; {
    conol(s);
    write(1,"\r\n",2);
}

/*  C O N C H K  --  Return how many characters available at console  */

conchk() {
    int x; PEEKTYPE n;

    if (!isatty(0)) return(0);
#ifdef PROVX1
    x = ioctl(0, TIOCQCNT, &ttbuf);
    n = ttbuf.sg_ispeed & 0377;
    return((x < 0) ? 0 : n);
#else
#ifdef aegis
    if (conbufn > 0) return(conbufn);   /* use old count if nonzero */

    /* read in more characters */
    conbufn = ios_$get(ios_$stdin,
              ios_$cond_opt, conbuf, (long)sizeof(conbuf), st);
    if (st.all != status_$ok) conbufn = 0;
    conbufp = conbuf;
    return(conbufn);
#else
#ifdef V7
#ifdef MINIX
    return(0);
#else
    lseek(kmem[CON], (long) qaddr[CON], 0);
    x = read(kmem[CON], &n, sizeof(int));
    return((x == sizeof(int))? n: 0);
#endif /* MINIX */
#else
#ifdef UXIII
    if (conesc) {                       /* Escape typed */
        conesc = 0;
        signal(SIGQUIT,esctrp);         /* Restore escape */
        return(1);
    }
    return(0);
#else
#ifdef C70
    if (conesc) {                       /* Escape typed */
        conesc = 0;
        signal(SIGQUIT,esctrp);         /* Restore escape */
        return(1);
    }
    return(0);
#else
#ifdef FIONREAD
    x = ioctl(0, FIONREAD, &n);         /* BSD and maybe some others */
    debug(F101,"conchk","",n);
    return((x < 0) ? 0 : n);
#else
    return(0);                          /* Others can't do. */
#endif
#endif
#endif
#endif
#endif
#endif
}

/*  C O N I N C  --  Get a character from the console  */

coninc(timo) int timo; {
    int n = 0; CHAR ch;
#ifdef aegis
    fflush(stdout);
    if (conchk() > 0) {
	--conbufn;
	return(*conbufp++ & 0377);
    }
#endif
    if (timo <= 0 ) {                   /* untimed */
        n = read(0, &ch, 1);            /* Read a character. */
        ch &= 0377;
        if (n > 0) return(ch);          /* Return the char if read */
        else
#ifdef UXIII
#ifndef CIE                             /* CIE Regulus has no such symbol */
            if (n < 0 && errno == EINTR) /* if read was interrupted by QUIT */
                return(escchr);          /* user entered escape character */
            else                    /* couldnt be ^c, sigint never returns */
#endif
#endif
                return(-1);             /* Return the char, or -1. */
        }
    saval = signal(SIGALRM,timerh);	/* Timed read, so set up timer */
    alarm(timo);
    if (setjmp(sjbuf)) n = -2;
    else {
        n = read(0, &ch, 1);
        ch &= 0377;
    }
    ttimoff();				/* Turn off timer */
    if (n > 0) return(ch);
    else
#ifdef UXIII
#ifndef CIE                             /* CIE Regulus has no such symbol */
        if (n == -1 && errno == EINTR)  /* If read interrupted by QUIT, */
            return(escchr);             /* user entered escape character, */
        else                            /* can't be ^c, sigint never returns */
#endif
#endif
        return(-1);
}

#ifdef ATT7300

/*  A T T D I A L  --  Dial up the remote system using internal modem
 * Purpose: to open and dial a number on the internal modem available on the
 * ATT7300 UNIX PC.  Written by Joe Doupnik. Superceeds version written by
 * Richard E. Hill, Dickinson, TX. which employed dial(3c).
 * Uses information in <sys/phone.h> and our status int attmodem.
 */
attdial(ttname,speed,telnbr) char *ttname,*telnbr; long speed; {
    char *telnum;
    int ttclos();

    attmodem &= ~ISMODEM;                       /* modem not in use yet */
                    /* Ensure O_NDELAY is set, else i/o traffic hangs */
                    /* We turn this flag off once the dial is complete */
    fcntl(ttyfd, F_SETFL, fcntl(ttyfd, F_GETFL, 0) | O_NDELAY);

    /* Condition line, check availability & DATA mode, turn on speaker */
    if (ioctl(ttyfd,PIOCOFFHOOK, &dialer) == -1) {
        printf("cannot access phone\n");
        ttclos();
        return (-2);
    }
    ioctl(ttyfd,PIOCGETP,&dialer);      /* get phone dialer parameters */

    if (dialer.c_lineparam & VOICE) {	/* phone must be in DATA mode */
        printf(" Should not dial with modem in VOICE mode.\n");
        printf(" Exit Kermit, switch to DATA and retry call.\n");
        ttclos();
        return (-2);
    }
#ifdef ATTTONED				/* Old way, tone dialing only. */
    dialer.c_lineparam = DATA | DTMF;	/* Dial with tones, */
    dialer.c_lineparam &= ~PULSE;	/* not with pulses. */
#else
    /* Leave current pulse/tone state alone. */
    /* But what about DATA?  Add it back if you have trouble. */
    /* sys/phone says you get DATA automatically by opening device RDWR */
#endif
    dialer.c_waitdialtone = 5;                  /* wait 5 sec for dialtone */
#ifdef COMMENT
    dialer.c_feedback = SPEAKERON|NORMSPK|RINGON;  /* control speaker */
#else
    /* sys/phone says RINGON used only for incoming voice calls */
    dialer.c_feedback &= ~(SOFTSPK|LOUDSPK);
    dialer.c_feedback |= SPEAKERON|NORMSPK;
#endif
    dialer.c_waitflash = 500;                   /* 0.5 sec flash hook */
    if(ioctl(ttyfd,PIOCSETP,&dialer) == -1) {   /* set phone parameters */
        printf("Cannot set modem characteristics\n");
        ttclos();
        return (-2);
    }
    ioctl(ttyfd,PIOCRECONN,0);		/* Turns on speaker for pulse */

#ifdef COMMENT
    fprintf(stderr,"Phone line status. line_par:%o dialtone_wait:%o \
line_status:%o feedback:%o\n",
    dialer.c_lineparam, dialer.c_waitdialtone,
    dialer.c_linestatus, dialer.c_feedback);
#endif

    attmodem |= ISMODEM;                        /* modem is now in-use */
    sleep(1);
    for (telnum = telnbr; *telnum != '\0'; telnum++)    /* dial number */
#ifdef ATTTONED
      /* Tone dialing only */
      if (ioctl(ttyfd,PIOCDIAL,telnum) != 0) {
	  perror("Error in dialing");
	  ttclos();
	  return(-2);
      }
#else /* Allow Pulse or Tone dialing */
    switch (*telnum) {
      case 't': case 'T': case '%':	/* Tone dialing requested */
	dialer.c_lineparam |= DTMF;
	dialer.c_lineparam &= ~PULSE;
	if (ioctl(ttyfd,PIOCSETP,&dialer) == -1) {
	    printf("Cannot set modem to tone dialing\n");
	    ttclos();
	    return(-2);
	}
	break;
      case 'd': case 'D': case 'p': case 'P': case '^':
	dialer.c_lineparam |= PULSE;
	dialer.c_lineparam &= ~DTMF;
	if (ioctl(ttyfd,PIOCSETP,&dialer) == -1) {
	    printf("Cannot set modem to pulse dialing\n");
	    ttclos();
	    return(-2);
	}
	break;
      default:
        if (ioctl(ttyfd,PIOCDIAL,telnum) != 0) {
	    perror("Dialing error");
	    ttclos();
	    return(-2);
	}
	break;
    }
#endif

    ioctl(ttyfd,PIOCDIAL,"@");		/* terminator for data call */
    do {				/* wait for modems to Connect */
        if (ioctl(ttyfd,PIOCGETP,&dialer) != 0)	{ /* get params */
	    perror("Cannot get modems to connect");
	    ttclos();
	    return(-2);
	}
    } while ((dialer.c_linestatus & MODEMCONNECTED) == 0);
    /* Turn off O_NDELAY flag now. */
    fcntl(ttyfd, F_SETFL, fcntl(ttyfd, F_GETFL, 0) & ~O_NDELAY);
    signal(SIGHUP, ttclos);             /* hangup on loss of carrier */
    return(0);                          /* return success */
}

/*
  Offgetty, ongetty functions. These function get the 'getty(1m)' off
  and restore it to the indicated line.  Shell's return codes are:
    0: Can't do it.  Probably a user logged on.
    1: No need.  No getty on that line.
    2: Done, you should restore the getty when you're done.
  DOGETY System(3), however, returns them as 0, 256, 512, respectively.
  Thanks to Kevin O'Gorman, Anarm Software Systems.

   getoff.sh looks like:   geton.sh looks like:
     setgetty $1 0           setgetty $1 1
     err=$?                  exit $?
     sleep 2
     exit $err
*/

/*  O F F G E T T Y  --  Turn off getty(1m) for the communications tty line
 * and get status so it can be restarted after the line is hung up.
 */
offgetty(ttname) char *ttname; {
    char temp[30];
    while (*ttname != '\0') ttname++;       /* seek terminator of path */
    ttname -= 3;                            /* get last 3 chars of name */
    sprintf(temp,"/usr/bin/getoff.sh %s",ttname);
    return(zsyscmd(temp));
}

/*  O N G E T T Y  --  Turn on getty(1m) for the communications tty line */

ongetty(ttname) char *ttname; {
    char temp[30];
    while (*ttname != '\0') ttname++;       /* comms tty path name */
    ttname -= 3;
    sprintf(temp,"/usr/bin/geton.sh %s",ttname);
    return(zsyscmd(temp));
}
#endif /* ATT7300 */

/*  T T S C A R R  --  Set ttcarr variable, controlling carrier handling.
 *
 *  0 = Off: Always ignore carrier. E.g. you can connect without carrier.
 *  1 = On: Heed carrier, except during dialing. Carrier loss gives disconnect.
 *  2 = Auto: For "modem direct": The same as "Off".
 *            For real modem types: Heed carrier during connect, but ignore
 *                it anytime else.  Compatible with pre-5A C-Kermit versions.
 *
 * As you can see, this setting does not affect dialing, which always ignores
 * carrier (unless there is some special exception for some modem type).  It
 * does affect ttopen() if it is set before ttopen() is used.  This setting
 * takes effect on the next call to ttopen()/ttpkt()/ttvt().  And they are
 * (or should be) always called before any communications is tried, which
 * means that, practically speaking, the effect is immediate.
 *
 * Of course, nothing of this applies to remote mode (xlocal = 0).
 *
 * Someone has yet to uncover how to manipulate the carrier in the BSD
 * environment (or any non-termio using environment).  Until that time, this
 * will simply be a no-op for BSD.
 *
 * Note that in previous versions, the carrier was most often left unchanged
 * in ttpkt()/ttvt() unless they were called with DIALING or CONNECT.  This
 * has changed.  Now it is controlled by ttcarr in conjunction with these
 * modes.
 */
ttscarr(carrier) int carrier; {
    ttcarr = carrier;
    debug(F101, "ttscarr","",ttcarr);
    return(ttcarr);
}

/* C A R R C T L  --  Set tty modes for carrier treatment.
 *
 * Sets the appropriate bits in a termio or sgttyb struct for carrier control
 * (actually, there are no bits in sgttyb for that), or performs any other
 * operations needed to control this on the current system.  The function does
 * not do the actual TCSETA or stty, since often we want to set other bits too
 * first.  Don't call this function when xlocal is 0, or the tty is not opened.
 *
 * We don't know how to do anything like carrier control on non-UXIII systems,
 * except, apparently, ultrix.  See above.  It is also known that this doesn't
 * have much effect on a Xenix system.  For Xenix, one should switch back and
 * forth between the upper and lower case device files.  Maybe later. 
 * Presently, Xenix will stick to the mode it was opened with.
 *
 * carrier: 0 = ignore carrier, 1 = require carrier.
 * The current state is saved in curcarr, and checked to save labour.
 */
#ifdef UXIII
carrctl(ttpar, carrier)	struct termio *ttpar; int carrier; {
    debug(F101, "carrctl","",carrier);
    if (carrier)
      ttpar->c_cflag &= ~CLOCAL;
    else
      ttpar->c_cflag |= CLOCAL;
    return(0);
}
#else /* !UXIII */
carrctl(ttpar, carrier) struct sgttyb *ttpar; int carrier; {
#ifdef ultrix
    int temp = 0;
#endif
    debug(F101, "carrctl","",carrier);
    if (carrier == curcarr)
      return(0);
    curcarr = carrier;
#ifdef ultrix
    if (carrier) {
	ioctl(ttyfd, TIOCMODEM, &temp);
	ioctl(ttyfd, TIOCHPCL, 0);
    } else {
	/* (According to the manuals, TIOCNCAR should be preferred */
	/* over TIOCNMODEM...) */
	ioctl(ttyfd, TIOCNMODEM, &temp);
    }
#endif /* ultrix */
    return(0);
}
#endif /* !UXIII */

/* NETWORK SUPPORT */

#ifndef NETCONN
/*
  Network support not defined.  
  Put dummy functions here to reduce requirement for #ifdef's elsewhere.
*/
netopen(name, lcl, nett) char *name; int *lcl, nett; {
    netconn = 0;
    return(-1);
}
netclose() {
    netconn = 0;
    return(-1);
}
tnsndbrk() {
    netconn = 0;
    return(-1);
}

#else /* NETCONN is defined */
/* C-Kermit network open/close functions for BSD-based Unix systems */

/*
 Original author: Ken Yap (ken@cs.rochester.edu)
 Heavily modified by fdc.
 SunLink X.25 support added by Marcello Frutig (FRUTIG@BRLNCC.BITNET)
*/
#ifndef SUNX25
#include <sys/socket.h>
#endif /* SUNX25 */
#ifndef EXCELAN
#include <netdb.h>
#endif
#include <netinet/in.h>
#ifndef EXCELAN
#include <arpa/inet.h>
#endif
#include <arpa/telnet.h>

/*  N E T O P E N  --  Open a network connection.  */

/*  Returns 0 on success, -1 on failure.  */

#define	TELNET_PORT	23	   /* Should do lookup, but it won't change */

/* This symbol is not known to, e.g., Ultrix 2.0 */
#ifndef TELOPT_TTYPE
#define TELOPT_TTYPE    24
#endif /* TELOPT_TTYPE */

/*  N E T O P N  --  Open a network connection.  */
/*
  Call with:
    name of host (or host:service),
    lcl - local-mode flag to be set if this function succeeds,
    network type - value defined in ckunet.h.
*/

#ifdef EXCELAN

struct servent {
    unsigned short s_port;
};

struct hostent {
    short h_addrtype;
    struct in_addr h_addr;
    int h_length;
};

struct servent *getservbyname(service, connection) char *service,*connection; {
    static struct servent servrec;
    int port;

    port = 0;
    if (strcmp(service, "telnet") == 0) port = 23;
    else if (strcmp(service, "smtp") == 0) port = 25;
    else port = atoi(service);

    debug(F101,"getservbyname return port ","",port);

    if (port > 0) {
    	servrec.s_port = htons(port);
    	return( &servrec );
    }
    return( (struct servent *) NULL );
}

struct hostent *gethostbyname(hostname) char *hostname; {
    return( (struct hostent *) NULL );
}

unsigned long inet_addr(name) char *name; {
    unsigned long addr;

    addr = rhost(&name);
    debug(F111,"inet_addr ",name,(int)addr);
    return(addr);
}
#endif /* EXCELAN */

netopen(name, lcl, nett) char *name; int *lcl, nett; {
    char *p;
    int on = 1, i;
    struct servent *service, servrec;
    struct hostent *host;
    struct sockaddr_in saddr;
#ifdef EXCELAN
    struct sockaddr_in send_socket;
#endif

#ifdef SUNX25				/* Code for SunLink X.25 support */
#define X29PID 1			/* X.29 Protocol ID */
    void x25oobh(); 
    CONN_DB x25host;
    FACILITY_DB x25facil;
    static int needh = 1;
    int pid;
    extern int linkid, lcn, x25ver;
    extern int revcall, closgr;
 
    if (nett == NET_SX25) {
        netclos();                          /* Close any previous connection */
        ttnproto = NP_NONE;                 /* No protocol selected yet */

        /* Set up host structure */
        bzero ((char *)&x25host,sizeof(x25host));
        if ((x25host.hostlen = pkx121 (name,x25host.host)) < 0) {
            fprintf (stderr,"Invalid X.121 host address %s\n",name);
            errno = 0;
            return (-1);
        }
        x25host.datalen = 4;
        x25host.data[0] = X29PID;

        /* Open SunLink X.25 socket */
        if ((ttyfd = socket (AF_X25, SOCK_STREAM, 0)) < 0) {
	    debug(F101,"netopen socket error","",errno);
            perror ("X.25 connect socket error");
            return (-1);
        }

        /* Setting X.25 out-of-band data handler */
        pid = getpid ();
        if (ioctl(ttyfd,SIOCSPGRP,&pid)) {
            perror ("Setting process group id");
            return (-1);
        }    
        (void) signal (SIGURG,x25oobh);

        /* Set reverse charge call and closed user group if requested */
        bzero ((char *)&x25facil,sizeof(x25facil));
        if (revcall) x25facil.reverse_charge = revcall;
        if (closgr > -1) {
            x25facil.cug_req = 1;
            x25facil.cug_index = closgr;
        }
        if (ioctl(ttyfd,X25_WR_FACILITY,&x25facil) < 0) {
            perror ("Setting X.25 facilities");
            return (-1);
        }

        /*  Need X.25 header with bits Q and M */
        if (ioctl (ttyfd,X25_HEADER,&needh) < 0) {
            perror ("Setting X.25 header");
            return (-1);
        }

        /* Connects to remote host via SunLink X.25 */
        if (connect(ttyfd,&x25host,sizeof(x25host)) < 0) {
            debug(F101,"netopen connect errno","",errno);
            i = errno;
	    if (errno) {
                perror("netopen");
                x25diag();
            }
            (void) close (ttyfd);
            ttyfd = -1;
            errno = i;
            return (-1);
        }
        
        /* Get X.25 link identification used for the connection */
        if (ioctl(ttyfd,X25_GET_LINK,&linkid) < 0) {
            perror ("Getting X.25 link id");
            return (-1);
        }

        /* Get X.25 logical channel number used for the connection */
        if (ioctl(ttyfd,X25_RD_LCGN,&lcn) < 0) {
            perror ("Getting X.25 lcn");
            return (-1);
        }

        /* Get SunLink X.25 version */
        if (ioctl(ttyfd,X25_VERSION,&x25ver) < 0) {
            perror ("Getting SunLink X.25 version");
            return (-1);
        }

        netconn = 1;                    /* Network connection */
        ttnet = nett;                   /* Sunlink X.25 network */
        ttnproto = NP_X3;               /* PAD X.3, X.28, X.29 protocol */
        if (*lcl < 0) *lcl = 1;         /* Local mode */
        (void) strncpy (ttnmsv,name,sizeof(ttnmsv)); /* Save the name */
        return (0);
    }
#endif /* SUNX25 */

    if (nett != NET_TCPB) return(-1);	/* BSD socket support */

    netclos();				/* Close any previous connection. */
    strncpy(ttnmsv, name, sizeof(ttnmsv)); /* Copy the hostname. */
    ttnproto = NP_NONE;			/* No protocol selected yet. */

    if ((p = yindex(ttnmsv, ':')) == NULL) { /* Was a service was requested? */
	service = getservbyname("telnet", "tcp"); /* No, use telnet. */
    } else {				/* Yes */
	*p++ = '\0';
	if (isdigit(*p)) {		/* Use socket number without lookup. */
	    service = &servrec;
	    service->s_port = htons((unsigned short)atoi(p));
	} else {			/* Use service name. */
	    service = getservbyname(p, "tcp");
	}
    }
    if (service == NULL) {
	fprintf(stderr, "Cannot find port for service %s\n", p);
	errno = 0;			/* rather than mislead */
	return (-1);
    }

    /* Set up socket structure and get host address */

    bzero((char *)&saddr, sizeof(saddr));
    if ((host = gethostbyname(ttnmsv)) != NULL) {
	saddr.sin_family = host->h_addrtype;
	bcopy(host->h_addr, (caddr_t)&saddr.sin_addr, host->h_length);
    } else
      if ((saddr.sin_addr.s_addr = inet_addr(ttnmsv)) != ((unsigned long)-1))
	  saddr.sin_family = AF_INET;
      else {
	  fprintf(stderr, "Can't get address for %s\n", ttnmsv);
	  errno = 0;			/* rather than mislead */
	  return(-1);
    }

    /* Get a file descriptor for the connection. */

    saddr.sin_port = service->s_port;
#ifdef EXCELAN
    send_socket.sin_family = AF_INET;
    send_socket.sin_addr.s_addr = 0;
    send_socket.sin_port = 0;
    if ((ttyfd = socket(SOCK_STREAM, (struct sockproto *)0,
		&send_socket, SO_REUSEADDR)) < 0) {
#else
    if ((ttyfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
#endif /* EXCELAN */
	debug(F101,"netopen socket error","",errno);
#ifdef EXCELAN
	experror("TCP connect socket error");
#else
 	perror("TCP connect socket error");
#endif
	return (-1);
    }
    errno = 0;

    /* Now connect to the socket on the other end. */

#ifdef EXCELAN
    if (connect(ttyfd, &saddr) < 0) {
#else
#ifdef COMMENT
    /* This was how Ken Yap wrote it.  (caddr_t) == (char *). */
    /* But this causes gcc to complain.  connect() expects  */
    /* its second arg to be a (struct sockaddr *). */
    if (connect(ttyfd, (caddr_t)&saddr, sizeof(saddr)) < 0) {
#else
    if (connect(ttyfd, (struct sockaddr *)&saddr, sizeof(saddr)) < 0) {
#endif
#endif
	i = errno;			/* save error code */
	close(ttyfd);
	ttyfd = -1;
	errno = i;			/* and report this error */
	debug(F101,"netopen connect errno","",errno);
#ifdef EXCELAN
	if (errno) experror("netopen");
#else
	if (errno) perror("netopen");
#endif
	return(-1);
    }
    netconn = 1;
#ifdef SO_OOBINLINE
    setsockopt(ttyfd, SOL_SOCKET, SO_OOBINLINE, &on, sizeof on); /* (void) */
    /* the symbol SO_OOBINLINE is not known to Ultrix 2.0 */
    /* it means "leave out of band data inline" */
    /* normal value is 0x0100 */
    /* better not to try this on systems where the symbol is undefined. */
#endif /* SO_OOBINLINE */

    /* See if the service is telnet. */
    if (ntohs((unsigned short)service->s_port) == TELNET_PORT)
      ttnproto = NP_TELNET;		/* Yes, set global flag. */

    if (*lcl < 0) *lcl = 1;		/* Local mode. */

    (void) strncpy(ttnmsv, name, sizeof(ttnmsv)); /* Save the name */
    return(0);
}

/*  N E T C L O S  --  Close network connection.  */

netclos() {
    int x = 0;
    if (ttyfd < 0)
      return(0);			/* Wasn't open. */
    if (ttyfd > -1)
      x = close(ttyfd);
    ttyfd = -1;				/* Mark it as closed. */
    netconn = 0;
    return(x);
}

/* (added by fdc) -- function to send a Telnet BREAK */

tnsndbrk() {
    if (ttoc(IAC) < 0) return(-1);
    if (ttoc(BREAK) < 0) return(-1);
    debug(F101,"telnet BREAK","",BREAK);    
    return(0);
}

#ifdef SUNX25

/* X.25 support functions */

X25_CAUSE_DIAG diag;

/*
  Convert a null-terminated string representing an X.121 address
  to a packed BCD form.
*/

pkx121(str,bcd) char *str; u_char *bcd; {
    int i, j;
    u_char c;

    i = j = 0;
    while (str[i]) {
        if ( i >= 15 || str [i] < '0' || str [i] > '9' )
	  return (-1);
        c = str [i] - '0';
        if ( i & 1 )
	  bcd [j++] |= c;
        else
	  bcd [j] = c << 4;  
        i++;
    }
    return (i);
}

/* Reads and prints X.25 diagnostic */

x25diag () {
    int i;

    bzero ((char *)&diag,sizeof(diag));
    if (ioctl(ttyfd,X25_RD_CAUSE_DIAG,&diag)) {
        perror ("Reading X.25 diagnostic");
        return(-1); 
    }
    if (diag.datalen > 0) {
        printf ("X.25 Diagnostic :");
        for (i = 0; i < diag.datalen; i++) printf (" %02x",diag.data[i]);
        printf ("\r\n");
    }
    return(0);
}

/* X.25 Out-of-Band Signal Handler */

void x25oobh() {
    int oobtype;
    u_char oobdata;

    (void) signal(SIGURG,x25oobh);
    do {
        if (ioctl(ttyfd,X25_OOB_TYPE,&oobtype)) {
            perror ("Getting signal type");
            return;
        }
        switch (oobtype) {
	  case INT_DATA:
	    if (recv(ttyfd,oobdata,1,MSG_OOB) < 0) {
		perror ("Receiving X.25 interrupt data");
		return;
	    }
	    printf ("\r\nInterrupt received, data = %d\r\n", oobdata);
	    break;
	  case VC_RESET:
	    printf ("\r\nVirtual circuit reset\r\n");
	    x25diag ();
	    break;
	  case N_RESETS:
	    printf ("\r\nReset timeout\r\n");
	    break;
	  case N_CLEARS:
	    printf ("\r\nClear timeout\r\n");
	    break;
	  case MSG_TOO_LONG:
	    printf ("\r\nMessage discarded, too long\r\n");
	    break;
	  default:
	    if (oobtype) printf("\r\nUnknown oob type %d\r\n",oobtype);
	    break;
	}
    } while (oobtype);
}

/* Send a X.25 interrupt packet */

x25intr(intr) char intr; {
    if (send(ttyfd,&intr,1,MSG_OOB) < 0) return (-1);
    debug(F100,"X.25 intr","",0);
    return (0);
}

/* Reset X.25 virtual circuit */
x25reset(cause, diagn) char cause; char diagn; {
    bzero ((char *)&diag,sizeof(diag));
    diag.flags   = 0;
    diag.datalen = 2;
    diag.data[0] = cause;
    diag.data[1] = diagn;
    if (ioctl(ttyfd,X25_WR_CAUSE_DIAG,&diag) < 0) return (-1);
    debug(F100,"X.25 reset","",0);
    return (0);
}

/* Clear X.25 virtual circuit */
x25clear() {
    int i;
    debug(F100,"X.25 clear","",0);
    bzero ((char *)&diag,sizeof(diag));
    diag.flags = (1 << DIAG_TYPE);
    diag.datalen = 2;
    diag.data[0] = 0;
    diag.data[1] = 0;
    ioctl (ttyfd,X25_WR_CAUSE_DIAG,&diag);  /* Send Clear Request */
    return(netclos());                      /* Close socket */
}

/* X.25 status */
x25stat() {
    if (ttyfd < 0) return (-1);
    return (0);
}

/* Set Q_BIT on */
setqbit() {
    static int qbiton = 1 << Q_BIT;
    ioctl (ttyfd,X25_SEND_TYPE,&qbiton);
}

/* Set Q_BIT off */
resetqbit() {
    static int qbitoff = 0;
    ioctl (ttyfd,X25_SEND_TYPE,&qbitoff);
}
#endif /* SUNX25 */
#endif	/* NETCONN */

#ifdef COMMENT
/*  T T W M D M  --  Wait for modem signals  */

/*
  Wait up to timo seconds for all of the given modem signals to appear.
  mdmsig is a bit mask, in which:
   BM_CTS (bit 0) means wait for Clear To Send
   BM_DSR (bit 1) means wait for Data Set Ready
   BM_DCD (bit 2) means wait for Carrier Detect
   BM_RNG (bit 3) means wait for Ring Indicator
  Returns:
  -3 Not implemented.
  -2 This device does not have modem control.
  -1 Timeout: time limit exceeded before all signals were detected.
   1 Success.
*/
ttwmdm(mdmsig,timo) int mdmsig, timo; {
    int i, x;
    if (netconn) return(-2);
    for (i = 0; i < timo; i++) {
	x = ttgmdm();
	if (x < 0) return(x);
	if (x & mdmsig) return(1);
	sleep(1);
    }
    x = ttgmdm();
    if (x < 0) return(x);
    if (x & mdmsig) return(1);
    return(-1);
}
#endif

/*  T T G M D M  --  Get modem signals  */
/*
 Looks for the modem signals CTS, DSR, and CTS, and returns those that are
 on in as its return value, in a bit mask as described for ttwmdm.  Returns:
 -3 Not implemented
 -2 if the line does not have modem control
 -1 on error.
 >= 0 on success, with a bit mask containing the modem signals that are on.
*/

/*
  Define the symbol K_MDMCTL if we have Sys V R3 / 4.3 BSD style
  modem control, namely the TIOCMGET ioctl.
*/

#ifdef BSD43
#define K_MDMCTL
#endif

#ifdef SUNOS4
#define K_MDMCTL
#endif

#ifdef TIOCMGET
#define K_MDMCTL
#endif

ttgmdm() {

#ifdef HPUX				/* HPUX has its own way */

/*
  NOTE: I don't have an HPUX man page, and so I'm only guessing at the
  right names for these symbols.  Somebody with HPUX please let me know
  what corrections are needed.
*/

    int x, y, z;

    if (netconn) return(-2);		/* No modem signals for network */
    if (xlocal)				/* Get modem signals */
      x = ioctl(ttyfd,MCGETA,&y);
    else
      x = ioctl(0,MCGETA,&y);
    if (x < 0) return(-1);
    debug(F101,"ttgmdm","",y);

    z = 0;				/* Initialize return value */

/* Now set bits for each modem signal that is reported to be on. */

#ifdef MCTS
    /* Clear To Send */
    if (y & MCTS) z |= BM_CTS;
#endif
#ifdef MDSR
    /* Data Set Ready */
    if (y & MDSR) z |= BM_DSR;
#endif
#ifdef MDCD
    /* Carrier */
    if (y & MDCD) z |= BM_DCD;
#endif
#ifdef MRNG
    /* Ring Indicate */
    if (y & MRNG) z |= BM_RNG;
#endif
#ifdef MDTR
    /* Data Terminal Ready */
    if (y & MDTR) z |= BM_DTR;
#endif
#ifdef MRTS
    /* Request To Send */
    if (y & MRTS) z |= BM_RTS;
#endif
    return(z);

#else /* ! HPUX */

#ifdef K_MDMCTL
/*
  Note, <sys/ttycom> might have already been included by by <sys/ioctl.h>.
  Hence the following ifndef on a symbol which is defined there.
*/
#ifndef TIOCMGET
#include <sys/ttycom.h>
#endif 

    int x, y, z;

    if (netconn) return(-2);		/* Network, no modem signals. */
    if (xlocal)
      x = ioctl(ttyfd,TIOCMGET,&y);	/* Get modem signals. */
    else
      x = ioctl(0,TIOCMGET,&y);
    if (x < 0) return(-1);
    debug(F101,"ttgmdm","",y);

    z = 0;				/* Initialize return value. */
#ifdef MCTS
    /* Clear To Send */
    if (y & TIOCM_CTS) z |= BM_CTS;
#endif
#ifdef TIOCM_DSR
    /* Data Set Ready */
    if (y & TIOCM_DSR) z |= BM_DSR;
#endif
#ifdef TIOCM_CAR
    /* Carrier */
    if (y & TIOCM_CAR) z |= BM_DCD;
#endif
#ifdef TIOCM_RNG
    /* Ring Indicate */
    if (y & TIOCM_RNG) z |= BM_RNG;
#endif
#ifdef TIOCM_DTR
    /* Data Terminal Ready */
    if (y & TIOCM_DTR) z |= BM_DTR;
#endif
#ifdef TIOCM_RTS
    /* Request To Send */
    if (y & TIOCM_RTS) z |= BM_RTS;
#endif
    return(z);
#else
    if (netconn) return(-2);
    return(-3);

#endif /* K_MDMCTL */
#endif /* HPUX */
}


/*  Z S U S P E N D  --  Put this process in the background.  */

psuspend() {
#ifdef RTU
    extern int rtu_bug;
#endif

#ifdef SIGTSTP
#ifdef RTU
    rtu_bug = 1;
#endif
    debug(F100,"zsuspend suspending","",0);
    kill(0, SIGSTOP);			/* If job control, suspend the job */
    return(0);
#else
    return(-1);
#endif
}

/*
  setuid package, by Kristoffer Eriksson, with contributions from Dean
  Long and fdc.
*/

#ifndef AIX370
extern int getuid(), getgid(), geteuid(), getegid(), getreuid(), getregid();
#endif

/*
Subject: Set-user-id
To: fdc@watsun.cc.columbia.edu (Frank da Cruz)
Date: Sat, 21 Apr 90 4:48:25 MES
From: Kristoffer Eriksson <ske@pkmab.se>

This is a set of functions to be used in programs that may be run set-user-id
and/or set-group-id. They handle both the case where the program is not run
with such privileges (nothing special happens then), and the case where one
or both of these set-id modes are used.  The program is made to run with the
user's real user and group ids most of the time, except for when more
privileges are needed.  Don't set-user-id to "root".

This works on System V.  On BSD, it depends on the "saved-set-user-id" feature.
*/

#define UID_ROOT 0			/* Root user and group ids */
#define GID_ROOT 0

/*
  The following construction automatically defines the symbol SETREUID for
  Unix versions based on Berkeley Unix 4.2 or later.  If this symbol is 
  defined, then this program will use getreuid() and getregid() calls in
  preference to getuid() and getgid(), which in Berkeley-based Unixes do
  not allow arbitrary switching back and forth of real & effective uid.
  This construction also allows -DSETREUID to be put on the cc command line
  for any system that has and wants to use setre[ug]id().  It also prevents
  automatic definition of SETREUID if -DNOSETREU is included on the cc command 
  line (or otherwise defined).
*/
#ifdef ANYBSD
#ifndef BSD29
#ifndef BSD41
#ifndef SETREUID
#ifndef NOSETREUID
#define SETREUID
#endif /* NOSETREU */                   
#endif /* SETREUID */
#endif /* !BSD41 */
#endif /* !BSD29 */
#endif /* ANYBSD */

/* Variables for user and group IDs. */

static int realuid = -1, privuid = -1;
static int realgid = -1, privgid = -1;


/* P R I V _ I N I  --  Initialize privileges package  */

/* Called as early as possible in a set-uid or set-gid program to store the
 * set-to uid and/or gid and step down to the users real uid and gid. The
 * stored id's can be temporarily restored (allowed in System V) during
 * operations that require the privilege.  Most of the time, the program
 * should execute in unpriviliged state, to not impose any security threat.
 *
 * Note: Don't forget that access() always uses the real id:s to determine
 * file access, even with privileges restored.
 *
 * Returns an error mask, with error values or:ed together:
 *   1 if setuid() fails,
 *   2 if setgid() fails, and
 *   4 if the program is set-user-id to "root", which can't be handled.
 *
 * Only the return value 0 indicates real success. In case of failure,
 * those privileges that could be reduced have been, at least, but the
 * program should be aborted none-the-less.
 *
 * Also note that these functions do not expect the uid or gid to change
 * without their knowing. It may work if it is only done temporarily, but
 * you're on your own.
 */
priv_ini() {
    int err = 0;

    /* Save real ID:s. */
    realuid = getuid();
    realgid = getgid();

    /* Save current effective ID:s, those set to at program exec. */
    privuid = geteuid();
    privgid = getegid();

    /* If running set-uid, go down to real uid, otherwise remember that
     * no privileged uid is available.
     *
     * Exceptions:
     *
     * 1) If the real uid is already "root" and the set-uid uid (the
     * initial effective uid) is not "root", then we would have trouble
     * if we went "down" to "root" here, and then temporarily back to the
     * set-uid uid (not "root") and then again tried to become "root". I
     * think the "saved set-uid" is lost when changing uid from effective
     * uid "root", which changes all uid, not only the effective uid. But
     * in this situation, we can simply go to "root" and stay there all
     * the time. That should give sufficient privilege (understatement!),
     * and give the right uids for subprocesses.
     *
     * 2) If the set-uid (the initial effective uid) is "root", and we
     * change uid to the real uid, we can't change it back to "root" when
     * we need the privilege, for the same reason as in 1). Thus, we can't
     * handle programs that are set-user-id to "root" at all. The program
     * should be aborted. Use some other uid. "root" is probably to
     * privileged for such things, anyway. (The uid is reverted to the
     * real uid until abortion.)
     *
     * These two exceptions have the effect that the "root" uid will never
     * be one of the two uids that are being switched between, which also
     * means we don't have to check for such cases in the switching
     * functions.
     *
     * Note that exception 1) is handled by these routines (by constantly
     * running with uid "root", while exception 2) is a serious error, and
     * is not provided for at all in the switching functions.
     */
    if (realuid == privuid)
	privuid = -1;			/* Not running set-user-id. */

    /* If running set-gid, go down to real gid, otherwise remember that
     * no privileged gid is available.
     *
     * There are no exception like there is for the user id, since there
     * is no group id that is privileged in the manner of uid "root".
     * There could be equivalent problems for group changing if the
     * program sometimes ran with uid "root" and sometimes not, but
     * that is already avoided as explained above.
     *
     * Thus we can expect always to be able to switch to the "saved set-
     * gid" when we want, and back to the real gid again. You may also
     * draw the conclusion that set-gid provides for fewer hassles than
     * set-uid.
     */

    if (realgid == privgid)		/* If not running set-user-id, */
      privgid = -1;			/*  remember it this way. */

    err = priv_off();			/* Turn off setuid privilege. */

    if (privuid == UID_ROOT)		/* If setuid to root, */
      err |= 4;				/* return this error. */

    if (realuid == UID_ROOT)		/* If real id is root, */
      privuid = -1;			/* stay root at all times. */

    return(err);
}


/* Macros for hiding the differences in UID/GID setting between various Unix
 * systems. These macros should always be called with both the privileged ID
 * and the non-privileged ID. The one in the second argument, will become the
 * effective ID. The one in the first argument will be retained for later
 * retrieval.
 */
#ifdef SETREUID
#ifdef SAVEDUID
/* On BSD systems with the saved-UID feature, we just juggle the effective
 * UID back and forth, and leave the real UID at its true value.  The kernel
 * allows swithing to both the current real UID, the effective UID, and the
 * UID which the program is set-UID to.  The saved set-UID always holds the
 * privileged UID for us, and the real UID will always be the non-privileged,
 * and we can freely choose one of them for the effective UID at any time.
 */
#define switchuid(hidden,active)	setreuid(-1,active)
#define switchgid(hidden,active)	setregid(-1,active)

#else   /* SETREUID,!SAVEDUID */

/* On systems with setreXid() but without the saved-UID feature, notably
 * BSD 4.2, we swap the real and effective UIDs each time.  It's
 * the effective UID that we are interrested in, but we have to retain the
 * unused UID somewhere to enable us to restore it later, and that we do this
 * in the real UID.  The kernel only allows switching to either the current 
 * real or the effective UID, unless you're "root".
 */
#define switchuid(hidden,active)	setreuid(hidden,active)
#define switchgid(hidden,active)	setregid(hidden,active)
#endif

#else /* !SETREUID, !SAVEDUID */

/* On System V, the only thing we can change is the effective UID (unless
 * the current effective UID is "root", but initsuid() avoids that for us).
 * The kernel allows switching to the current real UID or to the saved
 * set-UID.  These are always set to the non-privileged UID and the privileged
 * UID, respectively, and we only change the effective UID.  This breaks if
 * the current effective UID is "root", though, because for "root" setuid/gid
 * becomes more powerful, which is why initsuid() treats "root" specially.
 * Note: That special treatment maybe could be ignored for BSD?
 * Note: For systems that don't fit any of these three cases, we simply can't
 * support set-UID.
 */
#define switchuid(hidden,active)	setuid(active)
#define switchgid(hidden,active)	setgid(active)
#endif /* SETREUID */
  

/* P R I V _ O N  --  Turn on the setuid and/or setgid */

/* Go to the privileged uid (gid) that the program is set-user-id
 * (set-group-id) to, unless the program is running unprivileged.
 * If setuid() fails, return value will be 1. If getuid() fails it
 * will be 2.  Return immediately after first failure, and the function
 * tries to restore any partial work done.  Returns 0 on success.
 * Group id is changed first, since it is less serious than user id.
 */
priv_on() {
    if (privgid != -1)
      if (switchgid(realgid,privgid))
        return(2);

    if (privuid != -1)
      if (switchuid(realuid,privuid)) {
	  if (privgid != -1)
	    switchgid(privgid,realgid);
	  return(1);
      }
    return(0);
}

/* P R I V _ O F F  --  Turn on the real uid and gid */

/* Return to the unprivileged uid (gid) after an temporary visit to
 * privileged status, unless the program is running without set-user-id
 * (set-group-id). Returns 1 for failure in setuid() and 2 for failure
 * in setgid() or:ed together. The functions tries to return both uid
 * and gid to unprivileged state, regardless of errors. Returns 0 on
 * success.
 */
priv_off() {
    int err = 0;

    if (privuid != -1)
       if (switchuid(privuid,realuid))
	  err |= 1;

    if (privgid != -1)
       if (switchgid(privgid,realgid))
	err |= 2;

    return(err);
}

/* Turn off privilege permanently.  No going back.  This is necessary before
 * a fork() on BSD43 machines that don't save the setUID or setGID, because
 * we swap the real and effective ids, and we don't want to let the forked
 * process swap them again and get the privilege back. It will work on other
 * machines too, such that you can rely on its effect always being the same,
 * for instance, even when you're in priv_on() state when this is called.
 * (Well, that part about "permanent" is on System V only true if you follow
 * this with a call to exec(), but that's what we want it for anyway.)
 * Added by Dean Long -- dlong@midgard.ucsc.edu
 */

priv_can() {

#ifdef SETREUID
    int err = 0;
    if (privuid != -1)
       if (setreuid(realuid,realuid))
	  err |= 1;

    if (privgid != -1)
        if (setregid(realgid,realgid))
 	  err |= 2;

    return(err);

#else
    /* Easy way of using setuid()/setgid() instead of setreuid()/setregid().*/
    return(priv_off());

#endif /* SETREUID */
}

/* P R I V _ O P N  --  For opening protected files or devices. */

priv_opn(name, modes) char *name; int modes; {
    int x;
    priv_on();				/* Turn privileges on */
    x = open(name, modes);		/* Try to open the device */
    priv_off();				/* Turn privileges off */
    return(x);				/* Return open's return code */
}

/*  P R I V _ C H K  --  Check privileges.  */

/*  Try to turn them off.  If turning them off did not succeed, cancel them */

priv_chk() {
    int x, y = 0;
    x = priv_off();			/* Turn off privs. */
    if (x != 0 || getuid() == privuid || geteuid() == privuid)
      y = priv_can();
    if (x != 0 || getgid() == privgid || getegid() == privgid)
      y = y | priv_can();
    return(y);
}

real_uid() {
    return(realuid);
}

ttimoff() {                           /* Turn off any timer interrupts */
    alarm(0);
    if (saval)
      signal(SIGALRM,saval);
    else
      signal(SIGALRM,SIG_DFL);
    saval = NULL;
}
