/* this is ChrList.  a program designed to decipher and print out
   certain parameters of a Borland Graphics Interface (BGI) Stroked
   Font file (*.chr).
   this info is to be shared freely, or at least as freely as Borland
   will let us!  all I ask is that if you use this info,
   credit Roy Green and Sam Denton  PROFUSELY!!
   Sam did the initial work on the BGI driver files...
   Roy Green went further with the font files...
   Sam has probably figured out some of the other fields in the header by now.
   Some credit should be given to William Barden, who taught me much about
     computers, via his books, during my TRS-80 Color Computer days.
     His article on the Hershey Fonts (a Public Domain Stroked
     Font library) in a recent issue of PCM Magazine sparked my curiosity
     about the *.CHR font format.... (note: they aren't quite the same,
     but still very similar)

   This particular program is Copyright 1988, by Roy Green,
   Vista Systems, Suite 455, 2444 Atlanta Highway, Athens, GA 30606
   (404) 548-9813
*/

#include <stdio.h>
/* #define ALL 1 */  /* define this if you want extra info printed out */

unsigned int pk, o_eight;
unsigned int startdata,datalength;
FILE *fontf,*outf;
char comment[200];                  /* holds the comment field */
char fontname[5];                   /* holds the four letter font tag */
char filename[80],outfilename[80];
char achar;
unsigned int fontptr[128];          /* table of offsets to characters within the file */
unsigned char fontwidth[128];       /* table of widths of individual characters (size 4) */
long fontloc;
struct fontstat_t {                 /* structure of the font statistics */
    unsigned char twobee;               /* always 0x2b */
    unsigned char n_entries;            /* number of entries in the file */
	unsigned char byte1;
	unsigned char byte2;
    unsigned char firstAscii;           /* value of first ascii char represented */
	unsigned char bigMystery_1;
	unsigned char bigMystery_2;
	unsigned char byte3;
    signed char leading1;
	unsigned char byte4;
	signed char leading2;
	unsigned char nothing[5];
} fontstat;

struct font_entry_t {
    x : 7;                          /* x value, signed */
    unsigned int valid : 1;         /* if 0, then not valid entry */
    y : 7;                          /* y value, signed */
    unsigned int draw : 1;          /* if 1, then draw from last point */
} font_entry;





void main(int argc, char *argv[])
{
	int i;

    /* get arguments */

	if ((argc < 2) || (argc > 3)) {
    	printf("\nusage:  chrlist <filename> [<outfile>]\n");
		printf(" where <filename> is a valid BGI font file\n");
		printf(" and <outfile> is an optional file to print to\n");
        printf(" This program lists the parameters of a\n");
        printf(" Borland Graphics Interface font file (*.chr)\n");
		printf(" then lists the actual instructions for drawing\n");
		printf(" the characters in Turbo Pascal 4.0 or \n");
		printf(" Turbo C 1.5 format.\n");
		printf(" Copyright 1988, Roy W. Green\n");
		exit(1);
	}
    strcpy(filename,argv[1]);
	if (argc == 3)
		strcpy(outfilename,argv[2]);
    if ((fontf = fopen(filename,"rb")) == NULL) {
		printf("\nError:  file %s not found!\n",filename);
		exit(1);
	}
	if (argc == 3) {
	    if ((outf = fopen(outfilename,"r")) != NULL) {
			printf("\nError:  output file %s exists!\n",outfilename);
			exit(1);
		}
		else
			outf = fopen(outfilename,"w");
	}
	else
		outf = stdout;
    pk = getw(fontf);           /* font files always begin with 'PK' and two eights */
	o_eight = getw(fontf);
	if ((pk != 0x4b50  ) || (o_eight != 0x0808)) {
		printf("\nError:  %s is NOT a valid font file.\n",filename);
		exit(1);
	}
	i = 0;
    do {
		if (((achar = getc(fontf))==0) && (feof(fontf) == 1)) {
			printf("\nError:  End of File reached in comment section\n");
			printf("        of %s!!  Not a valid font file. \n",filename);
			close(fontf);
			exit(1);
		}
        comment[i] = achar;
		i++;
		if (i == 199) {
			printf("\nError:  Comment field too big for this version\n");
			close(fontf);
			exit(1);
		}
	} while (achar != 0x1a);	/* get whole comment in... */
	comment[i] = '\0'; 			/* stuff a null character in, even though */
								/* borland files all have a null before   */
								/* the 0x1a character                     */
/* from here on we'll have to assume we got the correct values */

	startdata = getw(fontf);
	for (i=0; i<=3; i++)
		fontname[i] = getc(fontf);
	fontname[4] = '\0';
	datalength = getw(fontf);

	fseek(fontf,(long) startdata,SEEK_SET);
	fread(&fontstat,1,16,fontf);
	fread(fontptr,2,fontstat.n_entries,fontf);
	fread(fontwidth,1,fontstat.n_entries,fontf);
	fontloc = ftell(fontf);

	fprintf(outf,"chrlist : disassembles Borland .CHR files\n");
	fprintf(outf," 		  then lists the actual instructions for drawing\n");
	fprintf(outf," 		  the characters in Turbo Pascal 4.0 or \n");
	fprintf(outf," 		  Turbo C 1.5 format.\n");
	fprintf(outf,"Copyright 1988, Roy W. Green\n");
    fprintf(outf,"                Vista Systems\n");
    fprintf(outf,"                Suite 455\n");
    fprintf(outf,"                2444 Atlanta Highway\n");
    fprintf(outf,"                Athens, GA  30606\n\n");
	fprintf(outf,"Look soon for an explanation of how this is done...\n");
	fprintf(outf,"This program is provided to pique your interest!\n\n");

    fprintf(outf,"the comment field for this font file is :\n");
    fputs(comment,outf);
	fprintf(outf,"\n");
#ifdef ALL
	fprintf(outf,"start of data is at      : 0x%x\n",startdata);
	fprintf(outf,"fontname is              : %s\n",fontname);

	fprintf(outf,"data length is           : 0x%x\n",datalength);

	fprintf(outf,"twobee is                : 0x%x\n",fontstat.twobee);
#endif
    fprintf(outf,"number of entries        : %d\n",fontstat.n_entries);
#ifdef ALL
	fprintf(outf,"first ascii char         : 0x%x  -->%c<--\n",fontstat.firstAscii,
												fontstat.firstAscii);
#endif
	fprintf(outf,"(all parameters are based on CharSize of 4)\n");
	fprintf(outf,"height above baseline    : %d pixels\n", fontstat.leading1);
	fprintf(outf,"descender depth          : %d pixels\n", abs(fontstat.leading2));
	fprintf(outf,"text height              : %d pixels\n",fontstat.leading1+abs(fontstat.leading2));
	fprintf(outf,"font entries start at    : 0x%x\n\n", fontloc);

    for (i=0; i <= fontstat.n_entries-1; i++) {
		if (argc == 2) {
			printf("\n   (press 'enter' to continue)\n");
			getch();
		}
		fprintf(outf,"\ncharacter ->%c<- is at 0x%x and has a width of %d pixels at size 4\n",
												i+fontstat.firstAscii,
												fontptr[i]+fontloc,
												fontwidth[i]);

        fseek(fontf,fontptr[i]+fontloc,SEEK_SET);
		fread(&font_entry,2,1,fontf);
		while (font_entry.valid == 1) {
			if (font_entry.draw == 1)
				fprintf(outf,"    lineto(");
			else
				fprintf(outf,"    moveto(");
			fprintf(outf,"x+%d,y+%d);\n",font_entry.x,font_entry.y);
			fread(&font_entry,2,1,fontf);
		}
	}
	fclose(fontf);
	fclose(outf);


}
