// This program checks to see if your modem is turned on
// and returns the DOS errorlevel 0 upon success and 1 for error

// Usage is: CHECK <com port for modem>
// Example: C:\>check 1  { checks com port 1 for an active modem }

// Author: Alan R. Stubbs
// Date: 12/8/93

#include <stdio.h>
#include <stdlib.h>
#include <bios.h>
                     
void sport(port, c)
int port;
char c;

{
 union REGS r;
 r.x.dx=port;  // com port - COM1=0, COM2=1, COM3=2, COM4=3
 r.h.al=c;     // char to send to modem
 r.h.ah=1;     // send char function
 int86(0x14,&r,&r);
 if(r.h.ah & 128)
    {                              
      /* display error message to console */
      printf("**** Modem is not responding **** \n");
      
      /* return DOS errorlevel 1 */
      exit(1);
     }
 }


int main(int argc,char *argv[])
{       
 char a;
 int p;
 
  /* convert the command line param to integer */
  p=atoi(argv[1]);   
  
  /* convert the command line param to proper com port */       
  if (p==1)
    p=0;
  else if (p==2)
    p=1;
  else if (p==3)
    p=2;
  else if (p==4)
    p=3;  
  else                               
   {
     /* display proper syntax message to console */
     printf("\nUsage is: CHECK <com port>\n");  
     printf("\nValid COM Ports are 1 - 4\n");
     exit(0);
    } 
                  
  sport(p,a);
  
  /* return success */
  return(0);
}