
// Copyright 1992, David Perelman-Hall & Jamshid Afshar

#include "tree.h"
#include <string.h>
#include <assert.h>



ostream& operator << ( ostream& os, const Tree& tree )
{
   assert(tree.isvalid());
   if (tree._num_children > 0)
      os << "(";
   os << tree.cat();
   for(int i = 0; i<tree._num_children; i++)
      os <<  " " << *tree._children[i];
   if (tree._num_children > 0)
      os << ")";
   return os;
}


//constructor
Tree::Tree(const Category& cat)
   :_num_children(0), _cat(cat)
{
   for(int i=0; i<MAX_CHILDREN; i++)
      _children[i] = NULL;
}



//coppy constructor
Tree::Tree( const Tree &tree )
   :_num_children(0)
{
   assert(this != &tree);
   for(int i=0; i<MAX_CHILDREN; i++)
      _children[i] = NULL;

   *this = tree;
}



//operator =
void Tree::operator = ( const Tree &tree )
{
   assert(this != NULL);
   //empty current contents
   clear();

   _cat = tree._cat;
   _num_children = tree._num_children;
   for(int i = 0; i<_num_children; i++){
      assert(_children[i]==NULL);
      assert(tree._children[i]!=NULL);
      _children[i] = new Tree(*tree._children[i]);
   }

   assert(isvalid());
}
      
bool Tree::isvalid() const
{
   if (this == NULL)
      return FALSE;
    
   if (_num_children < 0 || _num_children >= MAX_CHILDREN)
      return FALSE;
/*
   if (strcmp(_cat, "") == 0)
      return FALSE;
*/
   {
   for(int i = 0; i<_num_children; i++){
      if (_children[i]==NULL)
         return FALSE;
   }
   }
   {
   for(int i = _num_children; i<MAX_CHILDREN; i++){
      if (_children[i]!=NULL)
         return FALSE;
   }
   }
   return TRUE;
}

//operator ==
bool Tree::operator == ( const Tree &tree ) const
{
   if( _cat != tree._cat )
      return FALSE;

   if( _num_children != tree._num_children )
      return FALSE;

   for(int i = 0; i<_num_children; i++){
      assert(_children[i]!=NULL);
      assert(tree._children[i]!=NULL);
      if( *_children[i] != *tree._children[i] )
         return FALSE;
   }

   return TRUE;
}

//destructor
Tree::~Tree()
{
   clear();
}


//clear
void Tree::clear()
{
   assert(isvalid());
   for(int i = 0; i<_num_children; i++){
      assert(_children[i]!=NULL);
      delete _children[i]; //free up whatever children[i] pointed to
      _children[i] = NULL;
   }
   _num_children = 0;
   _cat.clear();
}   


void Tree::add_child(const Tree &tree )
{
   assert( _num_children < MAX_CHILDREN );
   _children[_num_children] = new Tree( tree );
   _num_children++;
}


//get children in current tree
Category_Sequence Tree::get_children() const
{
   Category_Sequence CS;

   for(int i = 0; i<_num_children; i++) {
      assert(_children[i]!=NULL);
      CS += _children[i]->cat();
      }

   return CS;
}

