
// Copyright 1992, David Perelman-Hall & Jamshid Afshar

#ifndef CHART_H
#define CHART_H

#include "edge.h"

class Agenda;
class RuleList;


class Chart {
friend ostream& operator << ( ostream& os, const Chart& chart );
private:
   int last_pos;
   Edge_List *active_edges_arr;
   Edge_List *inactive_edges_arr;
public:
   // constructor
   Chart( const Category_Sequence& string );

   // coppy constructor
   Chart( const Chart& /*chart*/ )
      { assert(0); }

   // assignment operator
   void operator = ( const Chart& /*chart*/ )
      { assert(0); }

   // if can combine, then add newly-combined edge to chart
   void add( const Edge& edge, Agenda& agenda, const RuleList& rules );

   bool isIn( const Edge& edge ) const
      { if ( edge.isActive() )
         return active_edges_arr[edge.finish()].isMember( edge );
        else
         return inactive_edges_arr[edge.start()].isMember( edge );
      }

   bool success( const Category& goal, const Category_Sequence& str ) const;

   // destructor
   ~Chart();
};

#endif
