
// Copyright 1992, David Perelman-Hall & Jamshid Afshar


#ifndef AGENDA_H
#define AGENDA_H

#include "edge.h"

class Chart;

class Agenda {
private:
   Edge_List _edges;
public:
   //constructor
   Agenda() {}
   // copy constructor
   Agenda( const Agenda& agenda )
      : _edges(agenda._edges) {}

   //assignment operator
   void operator = ( const Agenda& agenda )
      { _edges = agenda._edges; }
   void add( const Edge& edge, const Chart& chart );
   Edge getNext()
      { return _edges.pop(); }

   bool isIn( const Edge& edge ) const
      { return _edges.isMember( edge ); }
   bool isEmpty() const
      { return _edges.isEmpty(); }
};

#endif



