/*  Project cfxdemo
    Software FX, Inc.
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    cfxdemo.exe Application
    FILE:         cfxdems7.cpp
    AUTHOR:       JC


    OVERVIEW
    ========
    Source file for implementation of cfxdemoS7 (TDialog).      
*/

#include <owl\owlpch.h>
#include "..\..\include\chart2fx.bch"

#pragma hdrstop

#include "cfxdems7.h"

extern cfxdems1_FillChart(TVbxChartFX20 *);

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE2(cfxdemoS7, TDialog, TVbxEventHandler)
//{{cfxdemoS7RSP_TBL_BEGIN}}
	EV_VBXEVENTNAME(IDC_CHART1, "Menu", Menu),
    EV_WM_DESTROY,
//{{cfxdemoS7RSP_TBL_END}}
END_RESPONSE_TABLE;


//{{cfxdemoS7 Implementation}}

extern TModule *Module;

cfxdemoS7::cfxdemoS7 (TWindow* parent, TResId resId, TModule* module):
    TDialog(parent, resId, module)
{
    // INSERT>> Your constructor code here.

	// Create the chart
	chart1 = new TVbxChartFX20(this, IDC_CHART1);
	menuRight = new TMenu(::Module->GetInstance(),IDR_MENURIGHT);
}

cfxdemoS7::~cfxdemoS7 ()
{
	delete menuRight;

	Destroy();
}

#define NUMVALUES 8

void user_SetAdvanced(TVbxChartFX20 *pChart,HMENU hMenu)
{
	char *sLeg[]= { "Peter Gabriel", "Phil Collins", "Bruce Springteen", "Tracy Chapman",
					"Big Mamma Thornton", "Paul Simon", "Louis Armstrong", "John Lennon"};
	char *sKey[]= {"PG", "PC", "BS", "TC", "BM", "PS", "LA", "JL"};
	int i;

	// read template	
	pChart->SetPropReadTemplate("OLDUSER.CHT");

	// Right Click
	pChart->SetPropRigClk((int) hMenu,CHART_MENUCLK);

	/* Set legends */
	pChart->SetPropYLeg("Really Bad",0);
	pChart->SetPropYLeg("Bad",1);
	pChart->SetPropYLeg("Regular",2);
	pChart->SetPropYLeg("Good",3);
	pChart->SetPropYLeg("Excellent",4);

	/* Tell CHART FX how use the legends (GAP) */
	pChart->SetPropAdm(20,CSA_YLEGGAP);

	/* LEGENDS */
	
	for(i=0;i<NUMVALUES;i++) {
		pChart->SetPropLegend(sLeg[i],i);
		pChart->SetPropKeyLeg(sKey[i],i);
	}

	pChart->SetPropSerLeg("First Test",0);
	pChart->SetPropSerLeg("Second Test",1);
}

BOOL cfxdemoS7::EvInitDialog (HWND hWndFocus)
{
	BOOL result;

	result = TDialog::EvInitDialog(hWndFocus);

	cfxdems1_FillChart(chart1);
	
	user_SetAdvanced(chart1,menuRight->GetSubMenu(0));

	return result;
}


void cfxdemoS7::Menu (VBXEVENT FAR *event)
{
	int nSerie,nPoint;
	UINT wParam;
	char s[100];

	nSerie = CNP_SERIE(event);
	nPoint = CNP_POINT(event);
	wParam = CNP_PARAM(event);
	
	wsprintf(s,"wParam %u nSerie %d nPoint %d",wParam,nSerie,nPoint);
	MessageBox(s);	
}


void cfxdemoS7::EvDestroy ()
{
    TDialog::EvDestroy();

	chart1->SetPropWriteTemplate("OLDUSER.CHT");
}

