/*  Project cfxdemo
    Software FX, Inc.
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    cfxdemo.exe Application
    FILE:         cfxdems5.cpp
    AUTHOR:       JC


    OVERVIEW
    ========
    Source file for implementation of cfxdemoS5 (TDialog).      
*/

#include <owl\owlpch.h>
#include "..\..\include\chart2fx.bch"

#pragma hdrstop

#include "cfxdems5.h"

extern cfxdems1_FillChart(TVbxChartFX20 *);

//{{cfxdemoS5 Implementation}}


cfxdemoS5::cfxdemoS5 (TWindow* parent, TResId resId, TModule* module):
    TDialog(parent, resId, module)
{
	// Create the chart
	chart1 = new TVbxChartFX20(this, IDC_CHART1);
}


cfxdemoS5::~cfxdemoS5 ()
{
	Destroy();
}

#define ID_TEXT1	300
#define ID_TEXT2	301
#define ID_TEXT3	302

void user_SetNewTools(TVbxChartFX20 *pChart)
{
	#define NITEMS 4

	CHART_STITEM stbItems[NITEMS] = {
		{ "Text 1", ID_TEXT1, TRUE, 100, 50, 4, CHART_STLEFT },
		{ "Text 2", ID_TEXT2, FALSE, 80, 80, 5, CHART_STCENTER },
		{ NULL,     NULL,      TRUE, 40, 40, 10, NULL } ,
		{ "Text 3", ID_TEXT3, TRUE,  50, 30, 4, CHART_STRIGHT }
	};

	// Create a StatusBar
	pChart->SetPropStatus(stbItems,NITEMS);

	// Show the StatusBar, ToolBar and PaletteBar
	pChart->SetPropShowStatus(TRUE);
	pChart->SetPropToolBar(TRUE);
	pChart->SetPropPaletteBar(TRUE);
}

BOOL cfxdemoS5::EvInitDialog (HWND hWndFocus)
{
	BOOL result;

	result = TDialog::EvInitDialog(hWndFocus);

	cfxdems1_FillChart(chart1);
	user_SetNewTools(chart1);

	return result;
}

