/*  Project cfxdemo
    Software FX, Inc.
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    cfxdemo.exe Application
    FILE:         cfxdems3.cpp
    AUTHOR:       JC


    OVERVIEW
    ========
    Source file for implementation of cfxdemoS3 (TDialog).      
*/

#include <owl\owlpch.h>
#include "..\..\include\chart2fx.bch"

#pragma hdrstop

#include "cfxdems3.h"

extern cfxdems1_FillChart(TVbxChartFX20 *);

//{{cfxdemoS3 Implementation}}


cfxdemoS3::cfxdemoS3 (TWindow* parent, TResId resId, TModule* module):
    TDialog(parent, resId, module)
{
	// Create the chart
	chart1 = new TVbxChartFX20(this, IDC_CHART1);
}


cfxdemoS3::~cfxdemoS3 ()
{
	Destroy();
}

#define NUMVALUES 8

void user_SetStrings(TVbxChartFX20 *pChart)
{
	char *sLeg[]= {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug"};
	int i;

	/* Titles */ 
	pChart->SetPropTitle("Sales",CHART_LEFTTIT);
	pChart->SetPropTitle("Months",CHART_BOTTOMTIT);

	/* Legends */

	for(i=0;i<NUMVALUES;i++)
		pChart->SetPropLegend(sLeg[i],i);

	pChart->SetPropSerLeg("Product A",0);
	pChart->SetPropSerLeg("Product B",1);
}

BOOL cfxdemoS3::EvInitDialog (HWND hWndFocus)
{
    BOOL result;

    result = TDialog::EvInitDialog(hWndFocus);

	cfxdems1_FillChart(chart1);
	user_SetStrings(chart1);

	return result;
}

