/*  Project cfxdemo
    Software FX, Inc.
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    cfxdemo.exe Application
    FILE:         cfxdems2.cpp
    AUTHOR:       JC


    OVERVIEW
    ========
    Source file for implementation of cfxdemoS2 (TDialog).      
*/

#include <owl\owlpch.h>
#include "..\..\include\chart2fx.bch"

#pragma hdrstop

#include "cfxdems2.h"

extern cfxdems1_FillChart(TVbxChartFX20 *);

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(cfxdemoS2, TDialog)
//{{cfxdemoS2RSP_TBL_BEGIN}}
    EV_BN_CLICKED(IDC_CHANGE, BNClickedChange),
//{{cfxdemoS2RSP_TBL_END}}
END_RESPONSE_TABLE;


//{{cfxdemoS2 Implementation}}


cfxdemoS2::cfxdemoS2 (TWindow* parent, TResId resId, TModule* module):
    TDialog(parent, resId, module)
{
	// Create the chart
	chart1 = new TVbxChartFX20(this, IDC_CHART1);
}


cfxdemoS2::~cfxdemoS2 ()
{
	Destroy();
}


BOOL cfxdemoS2::EvInitDialog (HWND hWndFocus)
{
	BOOL result;

	result = TDialog::EvInitDialog(hWndFocus);

	cfxdems1_FillChart(chart1);

	return result;
}

#define NUMVALUES 8

void cfxdemoS2::BNClickedChange ()
{
	int i;
	double dRand;

	srand(LOWORD(GetTickCount()));

	chart1->SetPropOpenData(MAKELONG(2,NUMVALUES),COD_VALUES);

	chart1->SetPropThisSerie(0);
	for(i=0;i<NUMVALUES;i++) {
		dRand = ( (double) rand() / (double) RAND_MAX) * (double) 80;
		chart1->SetPropValue((float) dRand,i);
	}

	chart1->SetPropThisSerie(1);
	for(i=0;i<NUMVALUES;i++) {
		dRand = ( (double) rand() / (double) RAND_MAX) * (double) 80;
		chart1->SetPropValue((float) dRand,i);
	}

	chart1->SetPropCloseData(MAKELONG(2,NUMVALUES),COD_VALUES);
}

