/*  Project cfxdemo
    Software FX, Inc.
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    cfxdemo.exe Application
    FILE:         cfxdmdic.cpp
    AUTHOR:       JC


    OVERVIEW
    ========
    Source file for implementation of cfxdemoMDIClient (TMDIClient).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <dir.h>

#include "cfxdmapp.h"
#include "cfxdmdic.h"
#include "cfxdmdi1.h"
#include "apxprint.h"
#include "apxprev.h"


//{{cfxdemoMDIClient Implementation}}


//
// Build a response table for all messages/commands handled
// by cfxdemoMDIClient derived from TMDIClient.
//
DEFINE_RESPONSE_TABLE1(cfxdemoMDIClient, TMDIClient)
//{{cfxdemoMDIClientRSP_TBL_BEGIN}}
    EV_COMMAND(CM_FILEPRINT, CmFilePrint),
    EV_COMMAND(CM_FILEPRINTERSETUP, CmFilePrintSetup),
    EV_COMMAND(CM_FILEPRINTPREVIEW, CmFilePrintPreview),
    EV_COMMAND_ENABLE(CM_FILEPRINT, CmPrintEnable),
    EV_COMMAND_ENABLE(CM_FILEPRINTERSETUP, CmPrintEnable),
    EV_COMMAND_ENABLE(CM_FILEPRINTPREVIEW, CmPrintEnable),
    EV_WM_DROPFILES,
//{{cfxdemoMDIClientRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// cfxdemoMDIClient
// ===========
// Construction/Destruction handling.
 cfxdemoMDIClient::cfxdemoMDIClient ()
 : TMDIClient ()
{
    // Change the window's background color
    SetBkgndColor(RGB(0xff, 0xff, 0xff));

    ChildCount = 0;

    // INSERT>> Your constructor code here.

}


 cfxdemoMDIClient::~cfxdemoMDIClient ()
{
    Destroy();

    // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// cfxdemoMDIClient
// ===========
// MDIClient site initialization.
void cfxdemoMDIClient::SetupWindow ()
{
    // Default SetUpWindow processing.
    TMDIClient::SetupWindow ();

    // Accept files via drag/drop in the client window.
    DragAcceptFiles(TRUE);
}


//////////////////////////////////////////////////////////
// cfxdemoMDIClient
// ==========
// Menu File Print command
void cfxdemoMDIClient::CmFilePrint ()
{
    //
    // Create Printer object if not already created.
    // 
    cfxdemoApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), cfxdemoApp);
    if (theApp) {
        if (!theApp->Printer)
            theApp->Printer = new TPrinter;

        //
        // Create Printout window and set characteristics.
        //
        APXPrintOut printout(theApp->Printer, Title, GetActiveMDIChild(), TRUE);

        theApp->Printing = TRUE;

        //
        // Bring up the Print dialog and print the document.
        //
        theApp->Printer->Print(GetActiveMDIChild()->GetClientWindow(), printout, TRUE);

        theApp->Printing = FALSE;
    }
}


//////////////////////////////////////////////////////////
// cfxdemoMDIClient
// ==========
// Menu File Print Setup command
void cfxdemoMDIClient::CmFilePrintSetup ()
{
    cfxdemoApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), cfxdemoApp);
    if (theApp) {
        if (!theApp->Printer)
            theApp->Printer = new TPrinter;

        //
        // Bring up the Print Setup dialog.
        //
        theApp->Printer->Setup(this);
    }
}


//////////////////////////////////////////////////////////
// cfxdemoMDIClient
// ==========
// Menu File Print Preview command
void cfxdemoMDIClient::CmFilePrintPreview ()
{
    cfxdemoApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), cfxdemoApp);
    if (theApp) {
        if (!theApp->Printer)
            theApp->Printer = new TPrinter;

        theApp->Printing = TRUE;

        PreviewWindow *prevW = new PreviewWindow(Parent, theApp->Printer, GetActiveMDIChild(), "Print Preview", new TLayoutWindow(0));
        prevW->Create();

        GetApplication()->BeginModal(GetApplication()->MainWindow);

        // We must destroy the preview window explicitly.  Otherwise, the window will not be destroyed until
        // it's parent the MainWindow is destroyed.
        prevW->Destroy();
        delete prevW;

        theApp->Printing = FALSE;
    }
}


//////////////////////////////////////////////////////////
// cfxdemoMDIClient
// ==========
// Menu enabler used by Print, Print Setup and Print Preview.
void cfxdemoMDIClient::CmPrintEnable (TCommandEnabler &tce)
{
    if (GetActiveMDIChild()) {
        cfxdemoApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), cfxdemoApp);
        if (theApp) {
            // If we have a Printer already created just test if all is okay.
            // Otherwise create a Printer object and make sure the printer
            // really exists and then delete the Printer object.
            if (!theApp->Printer) {
                theApp->Printer = new TPrinter;
                
                tce.Enable(theApp->Printer->GetSetup().Error == 0);
            } else
                tce.Enable(theApp->Printer->GetSetup().Error == 0);
        }
    } else
        tce.Enable(FALSE);
}


void cfxdemoMDIClient::EvDropFiles (TDropInfo)
{
    Parent->ForwardMessage();
}
