/*  Project cfxdemo
    Software FX, Inc.
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    cfxdemo.exe Application
    FILE:         cfxdems4.cpp
    AUTHOR:       JC


    OVERVIEW
    ========
    Source file for implementation of cfxdemoS4 (TDialog).      
*/

#include <owl\owlpch.h>
#include "..\..\include\chart2fx.bch"

#pragma hdrstop

#include "cfxdems4.h"

extern cfxdems1_FillChart(TVbxChartFX20 *);

//{{cfxdemoS4 Implementation}}


cfxdemoS4::cfxdemoS4 (TWindow* parent, TResId resId, TModule* module):
    TDialog(parent, resId, module)
{
	// Create the chart
	chart1 = new TVbxChartFX20(this, IDC_CHART1);
}


cfxdemoS4::~cfxdemoS4 ()
{
	Destroy();
}

void user_SetNewApp(TVbxChartFX20 *pChart)
{
	// to set 3D view
	pChart->SetPropView3D(TRUE);
	pChart->SetPropAngles3D(MAKELONG(30,60));

	// to set the grid
	pChart->SetPropGrid(CHART_HORZGRID);

	// to set the back colors
	pChart->SetPropRGBBk(RGB(0,0,255));
	pChart->SetPropRGB2DBk(RGB(200,20,90));
	pChart->SetPropRGB3DBk(RGB(200,20,90));

	// Set a title so we can see it
	pChart->SetPropTitle("Times Font",CHART_BOTTOMTIT);

	// to change the bottom title font

	pChart->SetPropFont(CF_TIMES | CF_BOLD | 12,CHART_BOTTOMFT);

	// to change the color use to draw that font
	// remember Windows will use the nearest solid color 
	pChart->SetPropRGBFont(RGB(255,0,0),CHART_BOTTOMFT);
}

BOOL cfxdemoS4::EvInitDialog (HWND hWndFocus)
{
	BOOL result;

	result = TDialog::EvInitDialog(hWndFocus);

	cfxdems1_FillChart(chart1);
	user_SetNewApp(chart1);

	return result;
}

