#if !defined(__cfxdmapp_h)              // Sentry, use file only if it's not already included.
#define __cfxdmapp_h

/*  Project cfxdemo
    Software FX, Inc.
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    cfxdemo.exe Application
    FILE:         cfxdmapp.h
    AUTHOR:       JC


    OVERVIEW
    ========
    Class definition for cfxdemoApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\statusba.h>
#include <owl\controlb.h>
#include <owl\buttonga.h>
#include <owl\editview.h>
#include <owl\listview.h>
#include <owl\docmanag.h>
#include <owl\filedoc.h>
#include <owl\printer.h>

#include <classlib\bags.h>


#include "cfxdmapp.rh"            // Definition of all resources.


// TFileDrop class Maintains information about a dropped file, its name, where it was dropped,
// and whether or not it was in the client area
class TFileDrop {
public:
    operator == (const TFileDrop& other) const {return this == &other;}

    char*   FileName;
    TPoint  Point;
    BOOL    InClientArea;

    HICON   Icon;
    BOOL    DefIcon;

    TFileDrop (char*, TPoint&, BOOL, TModule* module);
    ~TFileDrop ();

    const char* WhoAmI ();
private:
    //
    // hidden to prevent accidental copying or assignment
    //
    TFileDrop (const TFileDrop&);
    TFileDrop & operator = (const TFileDrop&);
};

typedef TIBagAsVector<TFileDrop> TFileList;
typedef TIBagAsVectorIterator<TFileDrop> TFileListIter;


//{{TApplication = cfxdemoApp}}
class cfxdemoApp : public TApplication {
private:

private:
    void SetupSpeedBar (TDecoratedMDIFrame *frame);
    void AddFiles (TFileList* files);

public:
    cfxdemoApp ();
    virtual ~cfxdemoApp ();

    // Public data members used by the print menu commands and Paint routine in MDIChild.
    TPrinter        *Printer;                           // Printer support.
    BOOL            Printing;                           // Printing in progress.

//{{cfxdemoAppVIRTUAL_BEGIN}}
public:
    virtual void InitMainWindow();
    virtual void InitInstance();
//{{cfxdemoAppVIRTUAL_END}}

//{{cfxdemoAppRSP_TBL_BEGIN}}
protected:
    void EvNewView (TView& view);
    void EvCloseView (TView& view);
    void CmHelpAbout ();
    void EvDropFiles (TDropInfo drop);
    void EvWinIniChange (char far* section);
    void Sample1 ();
    void Sample2 ();
    void Sample3 ();
    void Sample4 ();
    void Sample5 ();
    void Sample6 ();
    void Sample7 ();
//{{cfxdemoAppRSP_TBL_END}}
  DECLARE_RESPONSE_TABLE(cfxdemoApp);
};    //{{cfxdemoApp}}


#endif                                      // __cfxdmapp_h sentry.
