/*  Project cfxdemo
    Software FX, Inc.
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    cfxdemo.exe Application
    FILE:         cfxdems6.cpp
    AUTHOR:       JC


    OVERVIEW
    ========
    Source file for implementation of cfxdemoS6 (TDialog).      
*/

#include <owl\owlpch.h>
#include "..\..\include\chart2fx.bch"

#include <stdio.h>

#pragma hdrstop

#include "cfxdems6.h"

extern cfxdems1_FillChart(TVbxChartFX20 *);

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE2(cfxdemoS6, TDialog, TVbxEventHandler)
//{{cfxdemoS6RSP_TBL_BEGIN}}
	EV_VBXEVENTNAME(IDC_CHART1, "LButtonDblClk", LButtonDblClk),
	EV_VBXEVENTNAME(IDC_CHART1, "ChangeColor", ChangeColor),
	EV_VBXEVENTNAME(IDC_CHART1, "ChangeFont", ChangeFont),
	EV_VBXEVENTNAME(IDC_CHART1, "ChangePalette", ChangePalette),
	EV_VBXEVENTNAME(IDC_CHART1, "ChangePattPal", ChangePattPal),
	EV_VBXEVENTNAME(IDC_CHART1, "ChangePattern", ChangePattern),
	EV_VBXEVENTNAME(IDC_CHART1, "ChangeString", ChangeString),
	EV_VBXEVENTNAME(IDC_CHART1, "ChangeValue", ChangeValue),
	EV_VBXEVENTNAME(IDC_CHART1, "ReadFile", ReadFile),
	EV_VBXEVENTNAME(IDC_CHART1, "ReadTemplate", ReadTemplate),
//{{cfxdemoS6RSP_TBL_END}}
END_RESPONSE_TABLE;


//{{cfxdemoS6 Implementation}}


cfxdemoS6::cfxdemoS6 (TWindow* parent, TResId resId, TModule* module):
    TDialog(parent, resId, module)
{
	// Create the chart
	chart1 = new TVbxChartFX20(this, IDC_CHART1);
}


cfxdemoS6::~cfxdemoS6 ()
{
	Destroy();
}


BOOL cfxdemoS6::EvInitDialog (HWND hWndFocus)
{
	BOOL result;

	result = TDialog::EvInitDialog(hWndFocus);

	cfxdems1_FillChart(chart1);

	return result;
}


void cfxdemoS6::ChangeColor (VBXEVENT FAR *event)
{
	char s[100];

	wsprintf(s,"ChangeColor Type %d Index %d",CNP_TYPE(event),CNP_INDEX(event));
	MessageBox(s);
}

void cfxdemoS6::ChangeFont (VBXEVENT FAR *event)
{
	char s[100];

	wsprintf(s,"ChangeFont Index %d",CNP_INDEX(event));
	MessageBox(s);
}


void cfxdemoS6::ChangePalette (VBXEVENT FAR *event)
{
	char s[100];

	wsprintf(s,"ChangePalette Index %d",CNP_INDEX(event));
	MessageBox(s);
}


void cfxdemoS6::ChangePattPal (VBXEVENT FAR *event)
{
	char s[100];

	wsprintf(s,"ChangePattPal Index %d",CNP_INDEX(event));
	MessageBox(s);
}


void cfxdemoS6::ChangePattern (VBXEVENT FAR *event)
{
	char s[100];

	wsprintf(s,"ChangePattern Type %d Index %d",CNP_TYPE(event),CNP_INDEX(event));
	MessageBox(s);
}


void cfxdemoS6::ChangeString (VBXEVENT FAR *event)
{
	char s[100];

	wsprintf(s,"ChangeString Type %d Index %d",CNP_TYPE(event),CNP_INDEX(event));
	MessageBox(s);
}


void cfxdemoS6::ChangeValue (VBXEVENT FAR *event)
{
	char s[100];
	float f;

	f = CNP_VALUE(event);

	sprintf(s,"ChangeValue Serie %d Point %d NewValue %f",CNP_POINT(event),CNP_SERIE(event),f);
	MessageBox(s);
}

void cfxdemoS6::LButtonDblClk (VBXEVENT FAR *event)
{
	// INSERT>> Your code here.

	int nSerie,nPoint,x,y;
	float f;
	char sMess[] = "Value between 25 and 50";

	nSerie = CNP_SERIE(event);
	nPoint = CNP_POINT(event);
	x = CNP_XPOS(event);
	y = CNP_YPOS(event);

	if ((nSerie == (int) 0xFFFF) && (nPoint == (int) 0xFFFF)) {
		char s[100];
		wsprintf(s,"Empty Click (%d,%d)",x,y);
		MessageBox(s);
		return;
	}

	chart1->SetPropThisSerie(nSerie);
	chart1->GetPropValue(f,nPoint);

	// Write your own code here
	if (f < 25) {
		// Don't want a baloon
		CNP_RETURNVALUE(event,TRUE);
		return;
	} else
		if (f < 50)
			// Let's change the balloon/Dialog string
			chart1->SetPropHText(sMess);

	CNP_RETURNVALUE(event,NULL);
}


void cfxdemoS6::ReadFile (VBXEVENT FAR * /* event */ )
{
	MessageBox("ReadFile");
}


void cfxdemoS6::ReadTemplate (VBXEVENT FAR * /* event*/ )
{
	MessageBox("ReadTemplate");
}

