/*  Project cfxdemo
	Software FX, Inc.
	Copyright  1993. All Rights Reserved.

	SUBSYSTEM:    cfxdemo.exe Application
	FILE:         cfxdems1.cpp
	AUTHOR:       JC


	OVERVIEW
	========
	Source file for implementation of cfxdemoS1 (TDialog).
*/

#include <owl\owlpch.h>
#include "..\..\include\chart2fx.bch"

#pragma hdrstop

#include "cfxdems1.h"

//{{cfxdemoS1 Implementation}}

cfxdemoS1::cfxdemoS1 (TWindow* parent, TResId resId, TModule* module):
	TDialog(parent, resId, module)
{
	// Create the chart
	chart1 = new TVbxChartFX20(this, IDC_CHART1);
}


cfxdemoS1::~cfxdemoS1 ()
{
	Destroy();
}

#define NUMVALUES 8

void cfxdems1_FillChart(TVbxChartFX20 *pChart)
{
	int i;
	double d1[NUMVALUES] = { 30, 20, 40, 60, 50, 15, 24, 35 };
	double d2[NUMVALUES] = { 45, 60, 30, 60, 80, 45, 15, 45 };

	pChart->SetPropOpenData(MAKELONG(2,NUMVALUES),COD_VALUES);

	pChart->SetPropThisSerie(0);
	for(i=0;i<NUMVALUES;i++)
		pChart->SetPropValue((float) d1[i],i);

	pChart->SetPropThisSerie(1);
	for(i=0;i<NUMVALUES;i++)
		pChart->SetPropValue((float) d2[i],i);

	pChart->SetPropCloseData(MAKELONG(2,NUMVALUES),COD_VALUES);
}


BOOL cfxdemoS1::EvInitDialog (HWND hWndFocus)
{
	BOOL result;

	result = TDialog::EvInitDialog(hWndFocus);

	// Chart Data
	cfxdems1_FillChart(chart1);

	return result;
}

