#ifdef __cplusplus 
extern "C" { 
#endif 

#ifndef __CHARTFX20__

// Routines Provided
HWND WINAPI chart_Create(long,long,HWND,int,int,int,int,int,int,UINT,DWORD);
long WINAPI chart_Send(HWND,UINT,WPARAM,LPARAM);
long WINAPI chart_OpenData(HWND ,UINT , DWORD );
BOOL WINAPI chart_CloseData(HWND ,UINT );
long WINAPI chart_SetValue(HWND, int,int,double);
long WINAPI chart_SetIniValue(HWND , int ,int ,double );
long WINAPI chart_SetXvalue(HWND , int ,int ,double );
long WINAPI chart_SetConst(HWND,int,double);
long WINAPI chart_SetColor(HWND,int,DWORD,BOOL);
void WINAPI chart_SetAdm(HWND,int , double );
double WINAPI chart_Get(HWND,long,UINT);
long WINAPI chart_SetStripe(HWND,int,double,double,DWORD);
long WINAPI chart_SetStatusItem(HWND,int,BOOL,UINT,BOOL,int,int,int,DWORD);
double WINAPI chart_Get2(HWND,long,UINT,double far *); 
//

// Notification Codes
enum { CCC_SERIE, CCC_SERIEBK, CCC_ONE, CCC_ONEBK, CCC_BARHORZ, CCC_BKGND, CCC_2DBK, CCC_3DBK };
enum { CCS_LEGEND, CCS_SERLEGEND };
enum { CCP_SERIE, CCP_ONE };

// CONSTANTS

// Gallery Types
enum { LINE = 1, BAR, SPLINE, MARK, PIE, AREA, PARETO, SCATTER, HILOW };

// Chart Types 
#define CT_3D				0x00000100
#define CT_HORZ  			0x00000200
#define CT_TOOL				0x00000400
#define CT_PALETTE			0x00000800
#define CT_LEGEND			0x00001000
#define CT_TOGETHER			0x00002000
#define CT_POINTS			0x00004000
#define CT_SHOWZERO			0x00008000
#define CT_EACHBAR			0x00010000
#define CT_CLUSTER			0x00020000
#define CT_SHOWDATA			0x00040000
#define CT_DLGGRAY			0x00080000
#define CT_PATTERN			0x00100000
#define CT_SHOWVALUES		0x00200000
#define CT_MENU				0x00400000

// Chart Styles
#define CS_CHLINE			0x00000001
#define CS_CHBAR			0x00000002
#define CS_CHSPLINE			0x00000004
#define CS_CHMARK			0x00000008
#define CS_CHPIE			0x00000010
#define CS_CHAREA			0x00000020
#define CS_CHPARETO			0x00000040
#define CS_CHSCATTER		0x00000080
#define CS_CHHILOW			0x00000100
#define CS_CHDEFAULT		0x00000FFF
#define CS_MINMAX			0x00001000
#define CS_3D				0x00002000
#define CS_HORZ				0x00004000
#define CS_TOGETHER			0x00008000
#define CS_SHOWPOINT		0x00010000
#define CS_SCALE			0x00020000
#define CS_TITLES			0x00040000
#define CS_FONTS			0x00080000
#define CS_EDITABLE			0x00100000
#define CS_FILEEXPORT		0x00200000
#define CS_FILEIMPORT		0x00400000
#define CS_SCROLLABLE		0x00800000
#define CS_PRINTABLE		0x01000000
#define CS_3DVIEW			0x02000000
#define CS_GRID				0x04000000
#define CS_RESIZEABLE		0x08000000
#define CS_TEMPLATE			0x10000000
#define CS_COPY				0x20000000
#define CS_CLOSEABLE		0x40000000
#define CS_ALL				0xFFFFFFFF

// STYLE, TYPE
enum { CHART_ADD, CHART_SET, CHART_REMOVE };

// STACKED
enum { CHART_NOSTACKED, CHART_STACKED, CHART_STACKED100 };

// GRID
enum { CHART_NOGRID, CHART_HORZGRID, CHART_VERTGRID, CHART_BOTHGRID };

// POINTTYPE
enum { CHART_NONEMK, CHART_RECTMK, CHART_CIRCLEMK, CHART_TRIANGLEMK, CHART_MARBLEMK, CHART_CUBEMK, CHART_MANYMK };

// TITLES
enum { CHART_LEFTTIT, CHART_RIGHTTIT, CHART_TOPTIT, CHART_BOTTOMTIT };

// FONTS
enum { CHART_LEFTFT, CHART_RIGHTFT, CHART_TOPFT, CHART_BOTTOMFT, CHART_XLEGFT, CHART_YLEGFT, CHART_FIXEDFT, CHART_LEGENDFT };

// SETDBLCLK , RIGHTCLK
enum { CHART_BALLOONCLK, CHART_DIALOGCLK, CHART_NONECLK, CHART_MENUCLK };

// GAP
enum { CHART_LEFTGAP, CHART_RIGHTGAP, CHART_TOPGAP, CHART_BOTTOMGAP, CHART_ALLGAP };

// Colors
enum { CHART_WHITE=1, CHART_BLACK, CHART_LTGRAY, CHART_DKGRAY, CHART_RED, CHART_DKRED, CHART_BLUE,
	   CHART_DKBLUE, CHART_GREEN, CHART_DKGREEN, CHART_CYAN, CHART_DKCYAN, CHART_YELLOW,
	   CHART_DKYELLOW, CHART_VIOLET, CHART_DKVIOLET };

// Line Styles
enum { CHART_SOLID, CHART_DASH, CHART_DOT, CHART_DASHDOT, CHART_DASHDOTDOT };

// Color Schemes
enum { CHART_CSSOLID, CHART_CSBWPATTERN, CHART_CSPATTERN };

// Color Types
enum { CHART_FGROUND, CHART_BGROUND };

// graph_Get CONSTANTS
enum { CHART_GVALUES, CHART_GINIVALUES, CHART_GXVALUES };

// CM_GETSTATUS constants
#define CHART_GSVALUES		0x00000001
#define CHART_GSLEGENDS		0x00000002
#define CHART_GSCOLORS		0x00000004
#define CHART_GSPATTERNS	0x00000008
#define CHART_GSPALETTE		0x00000010
#define CHART_GSPATTPAL		0x00000020
#define CHART_GSREADTEMP	0x00000040
#define CHART_GSREADFILE	0x00000080
#define CHART_GSGALLERY		0x00000100
#define CHART_GSOPTIONS		0x00000200

// CustTool constants
#define CST_IMPORT			0x00000001
#define CST_EXPORT			0x00000002
#define CST_FILE			(CST_IMPORT | CST_EXPORT)
#define CST_COPYBITMAP		0x00000004
#define CST_COPYDATA		0x00000008
#define CST_COPY			(CST_COPYBITMAP | CST_COPYDATA)
#define CST_PRINT			0x00000010
#define CST_FILEEDIT		(CST_FILE | CST_COPY | CST_PRINT)
#define CST_SPACE1			0x00000020
#define CST_AREA			0x00000040
#define CST_BARHORZ			0x00000080
#define CST_BAR				0x00000100
#define CST_LINE			0x00000200
#define CST_MARK			0x00000400
#define CST_PIE				0x00000800
#define CST_SPLINE			0x00001000
#define CST_GALLERY			(CST_AREA | CST_BARHORZ | CST_BAR | CST_LINE | CST_MARK | CST_PIE | CST_SPLINE)
#define CST_PARETO			0x00002000
#define CST_SCATTER			0x00004000
#define CST_HILOW			0x00008000
#define CST_GALLERYEXT		(CST_GALLERY | CST_PARETO | CST_SCATTER | CST_HILOW)
#define CST_SPACE2			0x00010000
#define CST_3D				0x00020000
#define CST_ROTATE			0x00040000
#define CST_CLUSTER			0x00080000
#define CST_VIEW			(CST_3D | CST_ROTATE | CST_CLUSTER)
#define CST_SPACE3			0x00100000
#define CST_LEGEND			0x00200000
#define CST_VGRID			0x00400000
#define CST_HGRID			0x00800000
#define CST_LEGGRID			(CST_LEGEND | CST_VGRID | CST_HGRID)
#define CST_SPACE4			0x01000000
#define CST_TITLES			0x02000000
#define CST_FONTS			0x04000000
#define CST_TOOLS			0x08000000
#define CST_OPTIONS			0x10000000
#define CST_OTHER			(CST_TITLES | CST_FONTS | CST_TOOLS | CST_OPTIONS)

// FONTS
#define CF_BOLD				0x00000100
#define CF_ITALIC			0x00000200
#define CF_UNDERLINE		0x00000400
#define CF_STRIKEOUT		0x00000800
#define CF_FDONTCARE		0x00000000
#define CF_FROMAN			0x00001000
#define CF_FSWISS			0x00002000
#define CF_FMODERN			0x00003000
#define CF_FSCRIPT			0x00004000
#define CF_FDECORATIVE		0x00005000
#define CF_ARIAL			0x00000000
#define CF_COURIER			0x00010000
#define CF_COURIERNEW		0x00020000
#define CF_HELVETICA		0x00030000
#define CF_MODERN			0x00040000
#define CF_ROMAN			0x00050000
#define CF_SCRIPT			0x00060000
#define CF_SYMBOL			0x00070000
#define CF_TIMES			0x00080000
#define CF_TIMESNEWR		0x00090000
#define CF_WINGDINGS		0x000A0000

// graph_OpenData CONSTANTS
#define COD_VALUES				1
#define COD_CONSTANTS			2
#define COD_COLORS				3
#define COD_STRIPES				4
#define COD_INIVALUES			5
#define COD_XVALUES				6
#define COD_STATUSITEMS			7

// definiciones
#define COD_UNKNOWN				0xffff
#define COD_UNCHANGE			0

// graph_SetAdm CONSTANTS
enum { CSA_MIN, CSA_MAX, CSA_GAP, CSA_SCALE, CSA_YLEGGAP, CSA_PIXXVALUE, CSA_XMIN, CSA_XMAX }; 

// chart_OpenData - chart_SetValue, ... results
#define CR_OUTRANGE				-1
#define CR_NOOPEN				-2
#define CR_FAIL					-3
#define CR_INVALID				-4
#define CR_BADCODE				-5
#define CR_SUCCESS				0
#define CR_NEW					1
#define CR_KEEPALL				2
#define CR_LOSTLAST				3

// StatusBar Structure
typedef struct tagSTITEM {
	LPSTR sText;				// NULL -> no Text 
	WORD wIdm;
	BOOL bFrame;
	int nWidth;					// Width (pix)
	int nMin;					// Minimum width
	int nDesp;					// offset
	DWORD dwStyle;
} CHART_STITEM;

typedef CHART_STITEM far *CHART_STITEMP;

#define CHART_STLEFT		0x0000
#define CHART_STCENTER		0x0001
#define CHART_STRIGHT		0x0002

// HILOW Constants
enum { HLC_HIGH, HLC_CLOSE, HLC_LOW };
enum { OHLC_CLOSE, OHLC_HIGH, OHLC_OPEN, OHLC_LOW };

#define __CHARTFX20__
#endif

#ifndef __CHARTFX20VBXPARAMS__

// Definitions Needed to parse event params

#define AFX_NUM_EVENTPARAM(type, lpParams)	(type FAR&)(**(type FAR* FAR*)lpParams)
#define AFX_HLSTR_EVENTPARAM(lpParams)	(HLSTR FAR&)(*(HLSTR FAR*)lpParams)
#define AFX_NUM_EVENTPARAMINDEX(type, lpParams, index) (type FAR&)(**((type FAR* FAR*)(lpParams) + index))
#define AFX_HLSTR_EVENTPARAMINDEX(lpParams, index) (HLSTR FAR&)(*((HLSTR FAR*)(lpParams) + index))

// GN_LBUTTONDBLCLK , GN_RBUTTONDOWN
// POINT,SERIE, RESERVED
#define CNP_YPOS(l)		AFX_NUM_EVENTPARAMINDEX(int,l,3)
#define CNP_XPOS(l)		AFX_NUM_EVENTPARAMINDEX(int,l,4)

// GN_CHANGEVALUE
// POINT,SERIE, RESERVED
#define CNP_VALUE(l)	AFX_NUM_EVENTPARAMINDEX(int,l,3)

// GN_CHANGESTRING
// INDEX, TYPE , RESERVED

// GN_CHANGECOLOR, GN_CHANGEPATTERN
// INDEX, TYPE

// GN_CHANGEPALETTE, GN_CHANGEFONT, GN_CHANGEPATTPAL
// INDEX

// GN_MENU
// POINT,SERIE,RESERVED
#define CNP_PARAM(l)	AFX_NUM_EVENTPARAMINDEX(int,l,3)

// 
#define CNP_RESERVED(l)	AFX_NUM_EVENTPARAMINDEX(int,l,0)
#define CNP_POINT(l)	AFX_NUM_EVENTPARAMINDEX(int,l,1)
#define CNP_SERIE(l)	AFX_NUM_EVENTPARAMINDEX(int,l,2)

#define CNP_INDEX(l)	AFX_NUM_EVENTPARAMINDEX(int,l,1)
#define CNP_TYPE(l)		AFX_NUM_EVENTPARAMINDEX(int,l,2)

#define CNP_RETURNVALUE(lp,i)	(**(int FAR* FAR *) lp) = (int) (i)

#define __CHARTFX20VBXPARAMS__
#endif

#ifndef __CHARTFX20VBXPROP__

// PROPERTIES
#define CP_CTLNAME			0
#define CP_INDEX			1
#define CP_LEFT				2
#define CP_TOP				3
#define CP_WIDTH			4
#define CP_HEIGHT			5
#define CP_VISIBLE			6
#define CP_PARENT			7
#define CP_HWND				8
#define CP_BORDERSTYLEOFF	9
#define CP_ABOUT			10
#define CP_TYPE				11
#define CP_STYLE			12
#define CP_NSERIES          13
#define CP_NVALUES          14
#define CP_OPENDATA			15
#define CP_CLOSEDATA		16
#define CP_VALUE			17
#define CP_XVALUE			18
#define CP_INIVALUE			19
#define CP_CONST			20
#define CP_THISCOLOR		21
#define CP_COLOR			22
#define CP_THISBKCOLOR		23
#define CP_BKCOLOR			24
#define CP_ADM_DLG          25
#define CP_ADM				26
#define CP_LGAP				27
#define CP_RGAP				28
#define CP_TGAP				29
#define CP_BGAP				30
#define CP_DECIMALS			31
#define CP_POINTTYPE		32
#define CP_SCHEME			33
#define CP_STACKED			34
#define CP_GRID				35
#define CP_WALLWIDTH		36
#define CP_PATTERN			37
#define CP_BARHORZGAP		38
#define CP_VIEWROT3D		39
#define CP_VIEW3D			40
#define CP_ANGLES3D			41
#define CP_PIXFACTOR		42
#define CP_LINEWIDTH		43
#define CP_LINESTYLE		44
#define CP_LINECOLOR		45
#define CP_LINEBKCOLOR		46
#define CP_FIXEDWIDTH		47
#define CP_FIXEDSTYLE		48
#define CP_FIXEDCOLOR		49
#define CP_FIXEDBKCOLOR		50
#define CP_FIXEDGAP			51
#define CP_DBLCLK_DLG		52
#define CP_DBLCLK           53
#define CP_RIGCLK_DLG		54
#define CP_RIGCLK           55
#define CP_RGBBARHORZ		56
#define CP_RGBBK			57
#define CP_RGB2DBK			58
#define CP_RGB3DBK			59
#define CP_FONT_DLG         60
#define CP_FONT				61
#define CP_TITLE_DLG        62
#define CP_TITLE			63
#define CP_STATUS			64
#define CP_SHOWSTATUS		65
#define CP_LANGUAGE			66
#define CP_HTEXT			67
#define CP_LEGEND			68
#define CP_SERLEG			69
#define CP_KEYLEG			70
#define CP_FIXLEG			71
#define CP_YLEG				72
#define CP_KEYSER			73
#define CP_STATUSTEXT		74
#define CP_EXPORTFILE		75
#define CP_IMPORTFILE		76
#define CP_WRITETEMPLATE	77
#define CP_READTEMPLATE		78
#define CP_CHARTSTATUS		79
#define CP_RGBFONT			80
#define CP_EDIT				81
#define CP_COPYDATA			82
#define CP_COPYBITMAP		83
#define CP_PRINT			84
#define CP_HFONT			85
#define CP_THISSERIE		86
#define CP_CHARTTYPE		87
#define CP_CHART3D			88
#define CP_TOOLBAR			89
#define CP_PALETTEBAR		90
#define CP_PATTERNBAR		91
#define CP_THISPOINT		92
#define CP_CUSTTOOL			93
#define CP_HCTLWND			94
#define CP_RETURNVALUE		95
#define CP_ABOUT1			96
#define CP_ABOUT2			97
#define CP_ABOUT3			98
#define CP_AUTOINC			99
#define CP_THISVALUE		100

#define __CHARTFX20VBXPROP__
#endif

#ifdef __cplusplus 
} 
#endif 
