
//***************************************************************************
//
// Class:					CFileSystem
//
// Purpose:				To encapsulate access to the file system.
//
// Copyright:			Copyright 1993, 1994 Scott P. Leslie, All Rights Reserved.
//
// Version:				Version 1.1 for MS Windows 3.1 and MSVC 1.0.
//
// Important:			Read the README.TXT file included with this distribution
//								before using this class.
//
// Shareware:			This class is ShareWare.  If you use it, you should register
//								it with the author.  If you do not register it after 14 days
//								of use, you must discontinue using it.
//
//								Contact the author at ScotLeslie@aol.com for more info.
//
// Distribution:	You may distribute this class unmodified as long as all
//								accompanying documentation and notes are also distributed.
//								Object code generated from this class (or any derivation
//								of this class) can only be distributed by registered users.
//
// Disclaimer:		This class is provided as is with no implied or express
//								warranties.  You should test this class for your particular
//								use on non-critical data before using it in a production
//								system.
//
//***************************************************************************

#ifndef _CFileSystem_h_
#define _CFileSystem_h_


#include "dos.h"
#include "direct.h"

#include "stdafx.h"


//***************************************************************************
// Definitions
//***************************************************************************
#define DRIVE_UNDETERMINED 0


//***************************************************************************
// Enable backward compatibility mode if your code that used version 1.0
// of CFileSystem does not compile with the new version.  Two functions
// and a member variable were declared protected (instead of public) after
// version 1.0.  You should change your code to work without
// BACKWARD_COMPATIBLE defined since future versions of CFileSystem may not
// support the BACKWARD_COMPATIBLE flag.
//
// To enable backward compatibility, delete the two slashes before the
// #define below.
//***************************************************************************

//#define BACKWARD_COMPATIBLE


class CFileSystem : public CObject
{
public:
	CFileSystem();				// Constructor
	~CFileSystem();				// Destructor

	// File/Directory Attributes

	enum Attribute {
		normal		= CFile::normal,			// Normal Files
		readOnly	= CFile::readOnly,		// Read-Only Files
		hidden		= CFile::hidden,			// Hidden Files
		system		= CFile::system,			// System Files
		volume		= CFile::volume,			// Volume Label
		directory	= CFile::directory,		// Subdirectory Entry
		archive		= CFile::archive,			// Archive File

		allfiles	= CFile::normal		|		// All "files"
								CFile::readOnly	|		// Used to determine "size" of directory.
								CFile::hidden		|
								CFile::system		|
								CFile::archive,
	}; // Attribute


	// Directory Functions

	CString				GetCurrentDirectory();
	BOOL					ChangeDirectory(const CString& NewDirectory);
	BOOL					MakeDirectory(const CString& NewDirectory);
	BOOL					MakePath(const CString& NewDirectory);
	BOOL					DeleteDirectory(const CString& Directory, const BOOL bDeleteFilesAndDirs = FALSE);

	LONG					GetDirectorySize(const CString& Directory = "", const CString& WildCard = "*.*", const BOOL bRecurseSubdirs = FALSE);

	// FileSystem Functions

	CString				GetCurrentFileSystem();
	BOOL					ChangeFileSystem(const CString& FileSystem);
	CStringList *	GetFileSystemList();
	CString				GetVolumeLabel(const CString& FileSystem);
	LONG					GetFileSystemType(const CString& FileSystem);

	// File Functions

	BOOL					RenameFile(const CString& OldFileName, const CString& NewFileName);
	BOOL					DeleteFile(const CString& FileName);
	BOOL					DeleteFiles(const CString& FileSpec);

	BOOL					CopyFile(const CString& SourceFileName, const CString& DestFileName, const unsigned long lBuffSize = 10240);
	BOOL					CopyFiles(const CString& FileSpec, const CString& DestPath);
	BOOL					CompareFiles(const CString& FileName1, const CString& FileName2, const unsigned long lBuffSize = 10240);

	// File/Path Name Functions

	CString				GetFileName(const CString& PathAndFileName);
	CString				GetPath(const CString& PathAndFileName);

	// Directory Listing Functions

	CStringList	*	GetDirectory(const CString& SearchString, const Attribute eFileAttrib, const BOOL bRecurseSubDirs=FALSE, CStringList *pStringList = NULL);

	CStringList *	GetSubdirList(const CString& SearchDir, const BOOL bPathInName = TRUE);
	CStringList *	GetFileList(const CString& SearchString, const Attribute eFileAttrib);

	CString *			GetDirectoryEntry(const CString& Wildcard = "", const Attribute eFileAttrib = normal);


	// MFC StringList Functions

	static void		Sort(CStringList *pStringList);

	// MFC GUI Functions

	static void		LoadListBox(CListBox *pListBox, const CStringList * pStringList);
	static void		LoadComboBox(CComboBox *pComboBox, const CStringList * pStringList);


#ifndef BACKWARD_COMPATIBLE
protected:
#endif // BACKWARD_COMPATIBLE
	BOOL					ChangeFileSystem(const char cFileSystem);
	BOOL					CloseFile(CFile *pFile) const;

	int						MaxFileNameLength;


protected:
	CString				AppendWildcard(const CString& Path, const CString& Wildcard);

private:
	struct _find_t	m_FileInfo;

}; // CFileSystem

#endif // _CFileSystem_h_

