
//***************************************************************************
//
// Program:				FS_DEMO.EXE
//
// Purpose:				To demostrate the use of the CFileSystem class.
//
// Copyright:			Copyright 1993, 1994 Scott P. Leslie, All Rights Reserved.
//
// Version:				Version 1.1 for MS Windows 3.1 and MSVC 1.0.
//
// Important:			Read the README.TXT file included with this distribution
//								before using this code.
//
// Shareware:			This code is ShareWare.  If you use it, you should register
//								it with the author.  If you do not register it after 14 days
//								of use, you must discontinue using it.
//
//								Contact the author at ScotLeslie@aol.com for more info.
//
// Distribution:	You may distribute this code unmodified as long as all
//								accompanying documentation and notes are also distributed.
//
// Disclaimer:		This code is provided as is with no implied or express
//								warranties.  You should test this code for your particular
//								use on non-critical data before using it in a production
//								system.
//
//***************************************************************************


#include "stdio.h"

#include "filesys.h"


void
main()
{
	CFileSystem	fs;

	// Get the file system name

	CString FileSystemName = fs.GetCurrentFileSystem();
	CString VolLabel = fs.GetVolumeLabel(FileSystemName);
	printf("Volume Label for %s = %s\n", (const char *) FileSystemName, (const char *) VolLabel);

	// Get the current directory information

	CString CurrentDir = fs.GetCurrentDirectory();
	printf("Current Directory = %s\n", (const char *) CurrentDir);

	// Get the number of bytes under the current directory

	LONG lDirSize = fs.GetDirectorySize(CurrentDir, "*.*", TRUE);
	printf("Current Directory Size = %ld\n", lDirSize);

	// Print out a directory listing.
	CStringList *pDirList = fs.GetDirectory("*.*", CFileSystem::normal, TRUE);
	printf("\nDirectory Listing:\n");
	CFileSystem::Sort(pDirList);
	for (int i = 0; i < pDirList->GetCount(); i++)
	{
		CFileStatus Status;
		CString FileName = pDirList->GetAt(pDirList->FindIndex(i));

		if (CFile::GetStatus((const char *) FileName, Status))
		{
			printf("\t%s\t%ld\n", (const char *) FileName, Status.m_size);
		} // if
	} // for
	delete pDirList;
	pDirList = NULL;


	//**********************************************************************
	// Test Cases
	//**********************************************************************


	// Test making directories.
	VERIFY(fs.MakeDirectory("foo_test"));
	VERIFY(fs.MakeDirectory("foo_test\\subdir1"));
	VERIFY(fs.MakeDirectory("foo_test\\subdir2"));

	// Test making a path (ie. Multiple directories with one call).
	VERIFY(fs.MakePath("foo_test\\subdir3\\lower1"));
	VERIFY(fs.MakePath("foo_test\\subdir3\\lower2"));
	VERIFY(fs.MakePath("foo_test\\subdir3\\lower2") == FALSE);

	// Test file copying.
	VERIFY(fs.CopyFile("test1.dat", "foo_test\\test2.dat"));
	VERIFY(fs.CopyFile("test1.dat", "foo_test\\test2.dat") == FALSE);
	VERIFY(fs.CopyFile("test3.dat", "foo_test\\test3.dat") == FALSE);
	VERIFY(fs.CopyFile("test1.dat", "foo_test\\subdir1\\test2.dat"));
	VERIFY(fs.CopyFile("test1.dat", "foo_test\\subdir2\\test2.dat"));

	// Test file comparisons.
	VERIFY(fs.CompareFiles("test1.dat", "foo_test\\test2.dat", 20000) == TRUE);
	VERIFY(fs.CompareFiles("test1.dat", "foo_test\\test2.dat") == TRUE);
	VERIFY(fs.DeleteFile("foo_test\\test2.dat") == TRUE);
	VERIFY(fs.CompareFiles("test1.dat", "foo_test\\test2.dat") == FALSE);
	VERIFY(fs.CompareFiles("test3.dat", "foo_test\\test2.dat") == FALSE);

	// Test file renaming.
	VERIFY(fs.CopyFile("test1.dat", "foo_test\\test2.dat"));
	VERIFY(fs.RenameFile("foo_test\\test2.dat", "foo_test\\test3.dat") == TRUE);
	VERIFY(fs.CopyFile("test1.dat", "foo_test\\test2.dat"));
	VERIFY(fs.RenameFile("foo_test\\test2.dat", "foo_test\\test3.dat") == FALSE);
	VERIFY(fs.RenameFile("foo_test\\test4.dat", "foo_test\\test5.dat") == FALSE);

	// Test directory deletion.
	VERIFY(fs.DeleteDirectory("foo_test", TRUE) == TRUE);
	VERIFY(fs.DeleteDirectory("foo_test", TRUE) == FALSE);
	VERIFY(fs.DeleteDirectory("foo_test2", TRUE) == FALSE);
	VERIFY(fs.DeleteDirectory("foo_test2", FALSE) == FALSE);

	// Test Path Parsing.
	VERIFY(fs.GetPath("c:\\foo\\bar\\what.txt") == "c:\\foo\\bar\\");
	VERIFY(fs.GetPath("c:\\foo\\bar\\") == "c:\\foo\\bar\\");
	VERIFY(fs.GetPath("c:\\foo\\bar") == "c:\\foo\\");

	// Test FileName Parsing.
	VERIFY(fs.GetFileName("c:\\foo\\bar\\what.txt") == "what.txt");
	VERIFY(fs.GetFileName("what.txt") == "what.txt");
	VERIFY(fs.GetFileName("c:\\foo\\bar\\") == "");

	// Test FileSystem Volume information.
	CStringList *pFSList = fs.GetFileSystemList();
	for (POSITION pos = pFSList->GetHeadPosition(); pos != NULL; )
	{
		CString FSName = pFSList->GetNext(pos);

		CString VolLabel = fs.GetVolumeLabel(FSName);
		if (VolLabel != "")
		{
			printf("Volume Label for %s = %s\n", (const char *) FSName, (const char *) VolLabel);
		} // if
		else
		{
			printf("Volume Label for %s = << Not Available >>\n", (const char *) FSName);
		} // else

		printf("FileSystem Type = %ld\n", fs.GetFileSystemType(FSName));

	} // for
	delete pFSList;
	pFSList = NULL;

} // main 

