 
/* qfloor - largest integer not greater than x
 * qround - nearest integer to x
 */

#include "mconf.h"
#include "qhead.h"
#ifdef DEC
#define void int
#endif

extern short qone[], qhalf[];

static short bmask[] = {
0xffff,
0xfffe,
0xfffc,
0xfff8,
0xfff0,
0xffe0,
0xffc0,
0xff80,
0xff00,
0xfe00,
0xfc00,
0xf800,
0xf000,
0xe000,
0xc000,
0x8000,
0x0000,
};


void qfloor( x, y )
short x[], y[];
{
short t[NQ];
register unsigned short *p;
short e, i;

qmov( x, t );
if( t[1] == 0 )
	{
	qclear( y );
	return;
	}
e = t[1] - 0x4000;

if( e <= 0 )
	{
	if( t[0] < 0 )
		{
		qmov( qone, y );
		qneg( y );
		}
	else
		{
		qclear( y );
		}
	return;
	}

/* number of bits to clear out */
e = NBITS - e;

qmov( t, y );
p = (unsigned short *)&y[NQ-1];

while( e >= 16 )
	{
	*p-- = 0;
	e -= 16;
	}

/* clear the remaining bits */
*p &= bmask[e];

/* truncate negatives toward minus infinity */
if( t[0] < 0 )
	{
	if( qcmp( t, y ) != 0 )
		qsub( qone, y, y );
	}
}





double qround(x, y)
short *x, *y;
{
short z[NQ], f[NQ];
int r;

qfloor( x, z );
qsub( z, x, f );
r = qcmp( f, qhalf );
if( r > 0 )
	goto rndup;
if( r == 0 )
	{
/* round to even */
	z[1] -= 1;
	qfloor( z, f );
	z[1] += 1;
	f[1] += 1;
	if( qcmp(z,f) != 0 )
		{
rndup:		qadd( qone, z, z );
		}
	}
qmov( z, y );
}
