/*							ellik.c
 *
 *	Incomplete elliptic integral of the first kind
 *
 *
 *
 * SYNOPSIS:
 *
 * double phi, m, y, ellik();
 *
 * y = ellik( phi, m );
 *
 *
 *
 * DESCRIPTION:
 *
 * Approximates the integral
 *
 *
 *
 *                phi
 *                 -
 *                | |
 *                |           dt
 * F(phi_\m)  =    |    ------------------
 *                |                   2
 *              | |    sqrt( 1 - m sin t )
 *               -
 *                0
 *
 * of amplitude phi and modulus m, using the arithmetic -
 * geometric mean algorithm.
 *
 *
 *
 *
 * ACCURACY:
 *
 * Tested at random points with phi in [0, 2] and m in
 * [0, 1].
 *                      Relative error:
 * arithmetic   domain     # trials      peak         rms
 *    DEC       0,2          3700       8.1e-17     2.5e-17
 *    IEEE      0,2         10000       6.0e-16     1.4e-16
 *
 *
 */


/*
Cephes Math Library Release 2.0:  April, 1987
Copyright 1984, 1987 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

/*	Incomplete elliptic integral of first kind	*/

extern double PI, PIO2, MACHEP;

double ellik( phi, m )
double phi, m;
{
double a, b, c, temp;
double t, step;
double sqrt(), fabs(), log(), tan(), atan();
int d, mod, sign;

if( m == 0.0 )
	return( phi );
if( phi < 0.0 )
	{
	phi = -phi;
	sign = -1;
	}
else
	sign = 0;
a = 1.0;
b = 1.0 - m;
if( b == 0.0 )
	return(  log(  tan( (PIO2 + phi)/2.0 )  )   );
b = sqrt(b);
c = sqrt(m);
d = 1;
t = tan( phi );
mod = (phi + PIO2)/PI;

while( fabs(c/a) > MACHEP )
	{
	temp = b/a;
	phi = phi + atan(t*temp) + mod * PI;
	mod = (phi + PIO2)/PI;
	t = t * ( 1.0 + temp )/( 1.0 - temp * t * t );
	c = ( a - b )/2.0;
	temp = sqrt( a * b );
	a = ( a + b )/2.0;
	b = temp;
	d += d;
	}

temp = (atan(t) + mod * PI)/(d * a);
if( sign < 0 )
	temp = -temp;
return( temp );
}
