@echo OFF
REM *******************************************************************
REM *** OneADay.bat - Execute operations, but only if they have not ***
REM *** ver.1         already been executed today.  This program    ***
REM ***               uses CEnvi and the Cmm programming language   ***
REM ***               to save commands and their execution dates    ***
REM ***               in the file: C:\OneADay.dat.                  ***
REM *******************************************************************

REM *****************************************************************
REM *** Use shift to build the entire command into one big string ***
REM *****************************************************************
set THIS_BAT_NAME=%0
set ONEADAY_COMMAND=
:BUILD_COMMAND
   if a%1z==az GOTO END_BUILD_COMMAND
   set ONEADAY_COMMAND=%ONEADAY_COMMAND% %1%
   SHIFT
   GOTO BUILD_COMMAND
:END_BUILD_COMMAND

REM *************************************************************************
REM *** CEnvi will execute the following text, and return errorlevel 1 if ***
REM *** the ONEADAY_COMMAND has not already been executed today           ***
REM *************************************************************************
cenvi %THIS_BAT_NAME%.bat
if errorlevel 1 %ONEADAY_COMMAND%
GOTO CENVI_EXIT

DataFile = "C:\\OneADay.dat"

// check if a command was entered; show instructions and return if not entered
if ( !defined(ONEADAY_COMMAND)  ||  0 == strlen(ONEADAY_COMMAND) ) {
   printf("\a\n")
   printf("OneADay.bat - Execute a command with its parameters, but not if it has already\n")
   printf("              been executed today.\n")
   printf("\n")
   printf("SYNTAX: OneADay [Command] <parameters...>\n")
   printf("\n")
   printf("EXAMPLE: If you want to run a batch file that does virus checks and disk\n")
   printf("         checks, called DISKCHCK.BAT, on hard drives C: and D: from your\n")
   printf("         AUTOEXEC.BAT file when you reboot the computer, but not if you've\n")
   printf("         already run AUTOEXEC.BAT today, then you may want the following\n")
   printf("         lines in your AUTOEXEC.BAT:\n")
   printf("\n")
   printf("               CALL OneADay call DISKCHCK.BAT C:\n")
   printf("               CALL OneADay call DISKCHCK.BAT D:\n")
   printf("\n")
   return(0)
}
 
#define  RELEVANT_DATE_LEN    10  // only care about first ten digits of date

// Get command line, which is date followed by command
(DateCommand = ctime(time()))[RELEVANT_DATE_LEN] = 0
strcat(DateCommand,":")
strcat(DateCommand,ONEADAY_COMMAND)

// open DataFile and TempFile, and copy each line to TempFile, always comparing
// for a line with this command
if NULL == (fp = fopen(DataFile,"r+"))  &&  NULL == (fp = fopen(DataFile,"w+")) {
   printf("\aUnable to open file %s for writing.\n",DataFile)
   return(0)
}

// read in each line from data file, if it matches this exactly then the command
// has already been run today.  If only the date is wrong then it hasn't run today
// and so substitute this line in.  If no such file is found then write this new
// command at the end of the file.
for ( LineCount = 0; FilePosition = ftell(fp), NULL != (line = fgets(fp)); LineCount++ ) {
   // get rid of newline character which may be at end of the line just read
   if ( EndInNewLine = ('\n' == line[strlen(line)-1]) )
      line[strlen(line)-1] = 0
   // does this line compare, in part, to DateCommand
   if ( RELEVANT_DATE_LEN < strlen(line) + 2
     && 0 == strcmpi(DateCommand+RELEVANT_DATE_LEN+1,line+RELEVANT_DATE_LEN+1) ) {
      // the command portions of these line are the same, so compare the date portion
      if ( 0 == memicmp(DateCommand,line,10) ) {
         // this line already exists, and so return not to run command
         fclose(fp)
         return(0)
      } else {
         // the date has changed, and so go back to the beginning of this line and
         // write in this new data date
         fseek(fp,FilePosition)
         fprintf(fp,"%.*s",RELEVANT_DATE_LEN,DateCommand)
         fclose(fp)
         return(1)
      }
   }
}

// if did not exit in the above for loop, then write this new command at the end
// of the file.  If previous line did not end in newline, then add newline before
// this command.
if ( LineCount  &&  !EndInNewLine )
   fprintf(fp,"\n")
fprintf(fp,"%s",DateCommand)
fclose(fp)
return(1)

:CENVI_EXIT
set ONEADAY_COMMAND=
set THIS_BAT_NAME=
