@echo OFF
REM **************************************************************************
REM *** ValidDir.bat   Check if the specified directory is valid.  Return  ***
REM *** ver.1          errorlevel 0 if it's OK, else ERRORLEVEL 1.  If two ***
REM ***                parameters are given then print error if problem.   ***
REM **************************************************************************
CEnvi %0.bat %1 %2
GOTO CENVI_EXIT

main(argc,argv)
{
   RetCode = 1; // assume failure
   if ( 1 == argc  ||  !strcmpi(argv[1],"/?")  ||  !stricmp(argv[1],"/help") ) {
      Instructions();
   } else {
      RetCode = ( ValidSubDirectoryName(argv[1],argc==3) ) ? 0 : 1 ;
   }
   return( RetCode );
}

ValidSubDirectoryName(DirName,PrintMessageIfInvalid)
   // test if DirName is a valid directory name.  If it is then return TRUE, else
   // print message if PrintMessageIfInvalid is True and return FALSE.  ?This does
   // not work, by the way, on the root directory
{
   // append "\." to name to check for directory
   sprintf(TestDir,"%s\\.",FullPath(DirName));
   if ( 0 == DirName[0]
     || '\\' == DirName[strlen(DirName)-1]
     || NULL == Directory(TestDir,FALSE,0xFFFF,FATTR_SUBDIR) ) {
      if ( PrintMessageIfInvalid )
         fprintf(stderr,"\"%s\" is not a valid sub-directory name.\a\n",DirName);
      return FALSE;
   }
   return TRUE;
}

Instructions()
{
   printf("\n")
   printf("   ValidDir.bat - Test if a subdirectory name is valid\n")
   printf("\n")
   printf("   USAGE: ValidDir SubdirSpec [PrintError]\n")
   printf("\n")
   printf("          Check if subdirectory name is valid, and return ERRORLEVEL 0 if it is\n")
   printf("          and ERRORLEVEL 1 if it is not.  If PrintError is supplied then a\n")
   printf("          message will be printed if directory is invalid.\n")
   printf("\n")
}

:CENVI_EXIT
