EXTPROC CEnvi
//****************************************************************
//*** ClipSort - Perform an alphabetic sort on the data in the ***
//*** ver.1      clipboard.  Sort each line, then replace the  ***
//***            clipboard text with the sorted text.          ***
//***                                                          ***
//*** You might use this tool be selecting text in some        ***
//*** application, copy to clipboard, then execute ClipSort    ***
//*** either explicitly or via a hot-key association.  Then    ***
//*** you can paste immediately back to the selected text to   ***
//*** replace it with a sorted version.                        ***
//****************************************************************

#include <ClipBrd.lib>

if ( data = GetClipboardData(CF_TEXT) ) {

   // determine if the last character is line-feed, so we'll
   // know whether to add line-feed in the sorted list
   AddFinalLineFeed = ( NULL != strchr("\r\n",data[strlen(data)-1]) );

   // build array of each line of text in the clipboard
   LineCount = 0;
   Line = strtok(data,"\r\n");
   while ( Line ) {
      strcpy(List[LineCount++],Line);
      Line = strtok(NULL,"\r\n");
   }

   // sort this array of text alphabetically, case-insensitive
   qsort(List,LineCount,"stricmp");

   // build one long string to put data back into the clipboard
   data[0] = '\0';
   for ( i = 0; i < LineCount; i++ ) {
      strcat(data,List[i]);
      strcat(data,"\r\n");
   }

   // if there wasn't supposed to be a line-feed at the end, then remove it
   if ( !AddFinalLineFeed )
      data[strlen(data)-2] = '\0';

   // put this new data string in clipboard, replacing old
   PutClipboardData(data,1+strlen(data),CF_TEXT);
}

