#include <ctype.h>
#include <string.h>
#include "global.h"
#include "error.h"
#include "table.h"

typedef enum {START_STATE, IDENTIFIER_STATE, IN_IDENTIFIER_STATE, EOF_STATE,
				  INTEGER_STATE, IN_INTEGER_STATE, FLOAT_STATE, IN_FLOAT_STATE,
				  EOL_STATE, OTHER_STATE} state;

static char curchar;
static char nextchar;
static char *p;
static int c = 0;


void getch (void)
{
  static int firsttime = 1;

  if (firsttime)
  {
	 firsttime--;
	 if ((p = fgets (yyline, BUFSIZ, yyin)) != NULL)
	 {
		c = 1;
		nextchar = *(p+1);
		curchar = *p;
		return;
	 }
	 else error ("null input file", PANIC);
  }
  if (nextchar == '\0')
  {
	 curchar = nextchar = '\0';
	 return;
  }
  c++;
  nextchar = *(p+2);
  curchar = *++p;
}

int yygettoken (void)
{
  static int firsttime = 1;
  state curstate;
  int done;
  int dummy;

  if (firsttime)
  {
	 getch();
	 firsttime--;
  }
  curstate = START_STATE;
  yytext[0] = '\0';
  done = 0;

  while (!done)
  {
	 switch (curstate)
	 {
		case START_STATE :
		  yycolumn = c;
		  if (curchar == ' ' || curchar == '\t') ;
		  else if (curchar == '\0')
		  {
			 curstate = EOF_STATE;
			 done++;
		  }
		  else if (curchar == '\n')
		  {
			 curstate = EOL_STATE;
			 strncat (yytext, &curchar, 1);
			 getch ();
			 done++;
		  }
		  else if (isalpha (curchar))
		  {
			 strncat (yytext, &curchar, 1);
			 curstate =  IN_IDENTIFIER_STATE;
		  }
		  else if (isdigit (curchar))
		  {
			 strncat (yytext, &curchar, 1);
			 curstate = IN_INTEGER_STATE;
		  }
		  else
		  {
			 strncat (yytext, &curchar, 1);
			 getch();
			 curstate = OTHER_STATE;
			 done++;
		  }
		  break;
		case IN_IDENTIFIER_STATE :
		  if (isalnum (curchar))
		  {
			 strncat (yytext, &curchar, 1);
			 break;
		  }
		  curstate = IDENTIFIER_STATE;
		  done++;
		  break;
		case IN_INTEGER_STATE :
		  if (isdigit (curchar))
		  {
			 strncat (yytext, &curchar, 1);
			 break;
		  }
		  curstate = INTEGER_STATE;
		  done++;
		  break;
	 }
	 if (!done) getch ();
  }

  switch (curstate)
  {
	 case EOF_STATE        : return END_OF_FILE;
	 case EOL_STATE        :
	 case OTHER_STATE      : return yytext[0];
	 case IDENTIFIER_STATE : if (lookup (yytext) == -1)
										dummy = insert (yytext, NOTLITERAL);
									 return IDENTIFIER;
	 case INTEGER_STATE    : if (lookup (yytext) == -1)
										dummy = insert (yytext, LITERAL);
									 return INTEGER;
	 default               : return -1;
  }
}