#if !defined(__global_h) /* Sentry, use file only if it's not already included. */
#define __global_h

#include <stdio.h>

typedef enum {PANIC} strategy;

#define IDENTIFIER  256
#define INTEGER     257
#define FLOAT       258
#define END_OF_FILE 259

#define NOTLITERAL 0
#define LITERAL    1

typedef enum {SUB, ADD, DIV, MULT, END, TEXT, ASSIGN, EXIT, DATA} Topcodes;

#define BLANK     -1

extern Topcodes opcodes;
extern char     yytext[BUFSIZ];
extern FILE     *yyin;
extern int      yycolumn;
extern char     yyline[BUFSIZ];

#define TABSIZE 100

typedef struct
{
  char  *key;
  int   literal;
  int   value;
} entry;


extern entry table[TABSIZE];
extern int tabsize;

#define NOTFOUND -1
#endif /* __global_h sentry. */
