#include "global.h"
#include "error.h"
#include "lex.h"
#include "table.h"
#include "code.h"

#define STACK 100

Topcodes opcodes;
char     yytext[BUFSIZ];
FILE     *yyin;
int      yycolumn;
char     yyline[BUFSIZ];

entry    table[TABSIZE];


int opandstk[STACK], optorstk[STACK];
int topoptor = -1, topopand = -1;
int curtoken;
int dummy;

int stmts (void);
int stmt (void);
int express (void);
int expresses (void);
int term (void);
int terms (void);
int factor (void);
void pushopand (int i);
int popopand (void);
int popoptor (void);
void pushoptor (int i);
int mktmp (void);

void main (int argc, char *argv[])
{
  char msg[BUFSIZ];
  char *sp;

  if (argc != 2) {
	 sprintf (msg, "usage: %s filename", argv[0]);
	 error (msg, PANIC);
  }
  sp = argv[1];
  if ((yyin = fopen (argv[1], "r")) == NULL) {
	 sprintf (msg, "cannot open %s", sp);
	 error (msg, PANIC);
  }
  emit (TEXT, BLANK, BLANK);

  curtoken = yygettoken ();

  if (stmts ())
  {
	 if ( (curtoken == '\n') || (curtoken == END_OF_FILE) )
	 {
		curtoken = yygettoken ();
		if (curtoken == END_OF_FILE)
		{
		  emit (EXIT, insert("0", dummy), BLANK);
		  data ();
		}
		else error ("end of file or end of line expected.", PANIC);
	 }
  }
}

int stmts (void)
{
  if (curtoken == '\n' || curtoken == END_OF_FILE) return 1;
  if (curtoken == IDENTIFIER)
  {
	 if (stmt())
		if (stmts()) return 1;
  }
  error ("end of line, end of file, or identifier expected", PANIC);
  return 0;
}

int stmt (void)
{
  int rhs;

  if (curtoken == IDENTIFIER)
  {
	 pushopand (lookup (yytext));
	 curtoken = yygettoken ();
	 if (curtoken == '=')
	 {
		pushoptor (ASSIGN);
		curtoken = yygettoken ();
		if (express () )
		{
		  if (curtoken == ';')
		  {
			 curtoken = yygettoken ();
			 rhs = popopand ();
			 emit (popoptor(), popopand(), rhs);
			 return 1;
		  }
		  error ("';' expected", PANIC);
		}
	 }
	 error ("'=' expected.", PANIC);
  }
  error ("identifier expected.", PANIC);
  return 0;
}

int express (void)
{
  if (curtoken == IDENTIFIER || curtoken == INTEGER || curtoken == '(')
  {
	 if (term () && expresses()) return 1;
  }
  error ("identifier, integer, or '(' expected.", PANIC);
  return 0;
}

int expresses (void)
{
  int lhs, rhs, temp;

  if (curtoken == ')' || curtoken == ';') return 1;
  if (curtoken == '-' || curtoken == '+')
  {
	 if (curtoken == '-') pushoptor (SUB);
	 else pushoptor (ADD);
	 curtoken = yygettoken ();
	 if (term ())
	 {
		rhs = popopand ();
		lhs = popopand ();
		temp = mktmp ();
		emit (ASSIGN, temp, lhs);
		emit (popoptor(), temp , rhs);
		pushopand (temp);
		if (expresses ()) return 1;
	 }
  }
  error ("')', ';', '-', or '+' expected.", PANIC);
  return 0;
}

int term (void)
{
  if (curtoken == IDENTIFIER || curtoken == INTEGER || curtoken == '(')
	 if (factor() && terms()) return 1;
  error ("identifier, integer, or '(' expected.", PANIC);
  return 0;
}

int terms (void)
{
  int lhs, rhs, temp;

  if (curtoken == '/' || curtoken == '*')
  {
	 if (curtoken == '/') pushoptor (DIV);
	 else pushoptor (MULT);
	 curtoken = yygettoken ();
	 if (factor ())
	 {
		rhs = popopand ();
		lhs = popopand ();
		temp = mktmp ();
		emit (ASSIGN, temp, lhs);
		emit (popoptor (), temp, rhs);
		pushopand (temp);
		if (terms ()) return 1;
	 }
  }
  else if (curtoken == '+' || curtoken == '-' ||
			  curtoken == ')' || curtoken == ';') return 1;
  error ("'/', '*', '+', '-', ')' or ';' extected.", PANIC);
  return 0;
}

int factor (void)
{
  if (curtoken == '(')
  {
	 curtoken = yygettoken ();
	 if (express ())
	 {
		if (curtoken == ')')
		{
		  curtoken = yygettoken ();
		  return 1;
		}
		error ("')' expected.", PANIC);
	 }
  }
  if (curtoken == INTEGER || curtoken == IDENTIFIER)
  {
	 pushopand (lookup (yytext));
	 curtoken = yygettoken ();
	 return 1;
  }
  error ("'(', integer, or identifier ecpected.", PANIC);
  return 0;
}


void pushopand (int i)
{
  if (++topopand == STACK)
	 error ("internal error: operand stack overflow.", PANIC);
  opandstk[topopand] = i;
}

int popopand (void)
{
  if (topopand == -1)
	 error ("internal error: operand stack underflow.", PANIC);
  return (opandstk[topopand--]);
}


void pushoptor (int i)
{
  if (++topoptor == STACK)
	 error ("internal error: operator stack overflow.", PANIC);
  optorstk[topoptor] = i;
}


int popoptor (void)
{
  if (topoptor == -1)
	 error ("internal error: operator stack underflow,", PANIC);
  return (optorstk[topoptor--]);
}

int mktmp (void)
{
 static int seed = 0;
 char name[BUFSIZ];
 sprintf (name, "_xxx%d", seed++);
 return (insert (name, NOTLITERAL));
}