#include <stdlib.h>
#include "global.h"

void emit (int opcode, int op1, int op2)
{
  switch (opcode)
  {
	 case SUB    :
						printf ("%-6s  %-6s  %-6s  %-6s\n", "", "SUB",
								  op1==-1?"":table[op1].key,
								  op2==-1?"":table[op2].key);
						if (table[op2].literal == LITERAL) table[op2].value = atoi (table[op2].key);
						table[op1].value = table[op1].value - table[op2].value;
						printf ("%d\n", table[op1].value);
						break;
	 case ADD    :
						printf ("%-6s  %-6s  %-6s  %-6s\n", "", "ADD",
								  op1==-1?"":table[op1].key,
								  op2==-1?"":table[op2].key);
						if (table[op2].literal == LITERAL) table[op2].value = atoi (table[op2].key);
						table[op1].value = table[op1].value + table[op2].value;
						printf ("%d\n", table[op1].value);
						break;
	 case DIV    :
						printf ("%-6s  %-6s  %-6s  %-6s\n", "", "DIV",
								  op1==-1?"":table[op1].key,
								  op2==-1?"":table[op2].key);
						if (table[op2].literal == LITERAL) table[op2].value = atoi (table[op2].key);
						table[op1].value = table[op1].value / table[op2].value;
						printf ("%d\n", table[op1].value);
						break;
	 case MULT   :
						printf ("%-6s  %-6s  %-6s  %-6s\n", "", "MULT",
								  op1==-1?"":table[op1].key,
								  op2==-1?"":table[op2].key);
						if (table[op2].literal == LITERAL) table[op2].value = atoi (table[op2].key);
						table[op1].value = table[op1].value * table[op2].value;
						printf ("%d\n", table[op1].value);
						break;
	 case END    :
						printf ("%-6s  %-6s  %-6s  %-6s\n", "", "END",
								  op1==-1?"":table[op1].key,
								  op2==-1?"":table[op2].key);
						break;
	 case TEXT   :
						printf ("%-6s  %-6s  %-6s  %-6s\n", "", "TEXT",
								  op1==-1?"":table[op1].key,
								  op2==-1?"":table[op2].key);
						break;
	 case ASSIGN :
						printf ("%-6s  %-6s  %-6s  %-6s\n", "", "ASSIGN",
								  op1==-1?"":table[op1].key,
								  op2==-1?"":table[op2].key);
						if (table[op2].literal == LITERAL) table[op2].value = atoi (table[op2].key);
						table[op1].value = table[op2].value;
						printf ("%d\n", table[op1].value);
						break;
	 case EXIT   :
						printf ("%-6s  %-6s  %-6s  %-6s\n", "", "EXIT",
								  op1==-1?"":table[op1].key,
								  op2==-1?"":table[op2].key);
						break;
	 case DATA   :
						printf ("%-6s  %-6s  %-6s  %-6s\n", "", "DATA",
								  op1==-1?"":table[op1].key,
								  op2==-1?"":table[op2].key);
						break;
  }

}

void data (void)
{
  int i;

  emit (DATA, BLANK, BLANK);

  for (i = 0; i < tabsize; i++)
	 if (!table[i].literal) printf ("%-6s  %-6s\n", table[i].key, "int");

  emit (END, BLANK, BLANK);

}