/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Copyright (c) 1992, 1993, 1994 by R C Computer Systems *
 *  All rights reserved.                                   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* ceasy1.h */

#define ZERO_SUPPRESS_OFF  0 /* not necessary */

#define ERROR             -1
#define CUP               -1
#define CDOWN             +1
#define CLEFT             -1
#define CRIGHT            +1
#define CEXIT             98
#define MUST_ENTER_OFF     0
#define MUST_FILL_OFF      0
#define PROTECT_OFF        0
#define ZERO_FILL_OFF      0
#define FLOAT_LINE_OFF     0
#define PRE_EDIT_OFF       0
#define AUTO_HELP_OFF      0
#define IGNORE_OFF         0
#define MUST_ENTER_ON      1
#define MUST_FILL_ON       1
#define PROTECT_ON         1
#define ZERO_FILL_ON       1
#define FLOAT_LINE_ON      1
#define PRE_EDIT_ON        1
#define AUTO_HELP_ON       1
#define IGNORE_ON          1
#define ENTRY_EXIT         1
#define FORM_EXIT         98
#define FORM_CONTINUE     99
#define FIELD_REPEAT       0

#define SINGLE_LINE        1
#define DOUBLE_LINE        2
#define NONE               0
#define LEFT_SHADOW        1
#define RIGHT_SHADOW       2
#define YES                1
#define NO                 0
#define ON                 1
#define OFF                0
#define LEFT_BUTTON         0
#define RIGHT_BUTTON        1
#define PIXEL_BLACK         0
#define PIXEL_BLUE          1
#define PIXEL_GREEN         2
#define PIXEL_CYAN          3
#define PIXEL_RED           4
#define PIXEL_MAGENTA       5
#define PIXEL_BROWN         6
#define PIXEL_GRAY          7
#define PIXEL_DARK_GRAY     8
#define PIXEL_LIGHT_BLUE    9
#define PIXEL_LIGHT_GREEN   10
#define PIXEL_LIGHT_CYAN    11
#define PIXEL_LIGHT_RED     12
#define PIXEL_LIGHT_MAGENTA 13
#define PIXEL_YELLOW        14
#define PIXEL_WHITE         15

#define FGND_BLACK         30
#define FGND_BLUE          31
#define FGND_GREEN         32
#define FGND_CYAN          33
#define FGND_RED           34
#define FGND_MAGENTA       35
#define FGND_BROWN         36
#define FGND_GRAY          37
#define FGND_DARK_GRAY     40
#define FGND_LIGHT_BLUE    41
#define FGND_LIGHT_GREEN   42
#define FGND_LIGHT_CYAN    43
#define FGND_LIGHT_RED     44
#define FGND_LIGHT_MAGENTA 45
#define FGND_YELLOW        46
#define FGND_WHITE         47
#define BKGND_BLACK        50
#define BKGND_BLUE         51
#define BKGND_GREEN        52
#define BKGND_CYAN         53
#define BKGND_RED          54
#define BKGND_MAGENTA      55
#define BKGND_BROWN        56
#define BKGND_GRAY         57
#define BKGND_WHITE        57

#define PAGE               58*80
#define FORM_PTR PAGE_1
#define APTR               string_ptr(0)
#define BPTR               string_ptr(1)
#define ZERO               48
#define SPACE              32
#define AL                 var[2]
#define AC                 var[3]
#define BL                 var[4]
#define BC                 var[5]
#define SIZE               var[14]
#define EQUAL              (RESULT==0)
#define NOT_EQUAL          (RESULT!=0)
#define GREATER            (RESULT>0)
#define LESS               (RESULT<0)
#define MISSING            (RESULT!=0)
#define UP                 (ARROW=='A')
#define DOWN               (ARROW=='B')
#define FORWARD            (ARROW=='C')
#define BACK               (ARROW=='D')
#define PAGE_DOWN          (ARROW=='N')
#define PAGE_UP            (ARROW=='P')
#define ENTER              (ARROW=='R')
#define RETURN             (ARROW=='R')
#define TAB                (ARROW=='T')
#define FILLED             (ARROW=='F')
#define HOME               (ARROW=='H') /* if w=1 and h=1 */
#define END                (ARROW=='E') /* if w=1 and h=1 */
#define INSERT_LINE        (ARROW=='i')
#define DELETE_LINE        (ARROW=='d')

#define AND    &&
#define OR     ||
#define NOT    !

#define HELP_KEY           (FUNC==1)
#define F1                 (FUNC==1)
#define F2                 (FUNC==2)
#define F3                 (FUNC==3)
#define F4                 (FUNC==4)
#define F5                 (FUNC==5)
#define F6                 (FUNC==6)
#define F7                 (FUNC==7)
#define F8                 (FUNC==8)
#define F9                 (FUNC==9)
#define F10                (FUNC==10)
#define F11                (FUNC==11)
#define F12                (FUNC==12)
#define EDIT_FUNCTION_NONE 0L

#define beep() bell()
#define display_form() display(PAGE_1)
#define complement compl_
#define add_literal(i,j) add_subr(9,j,i+sizeof(i)-2,sizeof(i)-1)
#define add(i,j,d) add_subr(9,j,i,d)
#define add_one(i) add_subr(9,i,"1",1)
#define subtract_literal(i,j) add_subr(11,j,i+sizeof(i)-2,sizeof(i)-1)
#define subtract_one(i) add_subr(11,i,"1",1)
#define subtract(i,j,d) add_subr(11,j,i,d)
#define shift_left shift
#define protect_float prefix_float
#define set_scroll(i,j) setscr(i,j)
#define see(i) see_string(i)
#define cvt_atoi _dtoi_
#define cvt_atol _dtol_
#define zero_suppress(i,d) prefix(i,d,' ')
#define move_edit_right  move_edit
#define scroll_up scrl
#define scroll_down rscrl
#define make_window_frame make_pretty_window
#define select_across enter_command
#define select_down select_command
#define text_length len
#define next_A next_field
#define find_token(i) finds(1,i)
#define next_token() next_field
#define find_string(i)  finds(1,i)
#define find_nonstring(i)  finds(2,i)

extern unsigned char *PAGE_1;
extern unsigned char *mem;
extern int TOKEN_WIDTH, TOKEN_HEIGHT, TOKEN_ROW, TOKEN_COLUMN;
extern int BEGIN_SELECT;
extern int PRE_EDIT;
extern int AUTO_HELP;
extern int EXIT_FORM_NOW;
extern int CHAR_ONLY;
extern int AUTO_COMMAND;
extern int WRAP_COMMAND;
extern char TODAY[14];
extern char DEFAULT_DAY[2];
extern char DEFAULT_MONTH[3];
extern char DEFAULT_YEAR[2];
extern char ARROW;
extern int FUNC;
extern int ESCAPE_KEY;
extern int RESULT;
extern char LAST_LINE_ARRAY[80];
extern int LAST_LINE, LAST_COLUMN;
extern int LAST_ITEM; /* 'selected' line in window buffer */
extern int UPPERCASE;
extern int DISABLE_INSERT, DISABLE_WRAP, DISABLE_PAGE; /* for edit modes */
extern int DISABLE_DELETE; /* disables both Delete and Insert Keys */
extern int SL;
extern int BKGND_GRAPHIC;
extern int BKGND_COLOR, FGND_COLOR, BKGND_WINDOW, FGND_WINDOW;
extern int BKGND_FRAME, FGND_FRAME, BKGND_SHADOW, FGND_SHADOW;
extern int BKGND_BAR, FGND_BAR;
extern int BKGND_COMMAND, FGND_COMMAND;
extern int BKGND_FIRST, FGND_FIRST;
extern int BKGND_TIME, FGND_TIME;
extern int BKGND_DATE, FGND_DATE;
extern int BKGND_FORM, FGND_FORM;
extern int BKGND_ENTRY, FGND_ENTRY;
extern int FRAME_TYPE, SHADOW_TYPE, DRAW_LINE_TYPE;
extern int BKGND_HELP, FGND_HELP;
extern int IGNORE_BLACK;
extern int BKGND_CURSOR, FGND_CURSOR;
extern int VERTICAL_ONLY;
extern int MOUSE_PRESENT;
extern int MOUSE_BUTTONS;
extern int MOUSE_ROW;
extern int MOUSE_COLUMN;
extern int TOKEN_WIDTH, TOKEN_HEIGHT, TOKEN_ROW, TOKEN_COLUMN;
extern int MOUSE_RATE, HORIZ_DELAY, VERT_DELAY;
extern int MAXPIXROWS, MAXPIXCOLS;
extern int FORM_EDIT;
extern unsigned int var[60];
extern int WINDOW_OFFSET;
extern int WINDOW_OFFSET_COLUMN;
extern unsigned int BROWSE_OFFSET;
extern unsigned int LAST_OFFSET;
extern unsigned char *LAST_PTR;
extern unsigned char *LAST_LINE_PTR;
extern unsigned char LAST_CHAR;
extern int MAX_FIELDS;
extern int FAST_DISPLAY;
extern char *START_FIELD;
extern char *DEFAULT_FORM_PTR;
extern int GRAPHICS_MODE;
extern int INHIBIT_MSG;
extern int OVERRIDE_TABLE_COLORS;
extern unsigned char CHECK_CHAR;
extern int BKGND_CHECK_LINE, FGND_CHECK_LINE;
extern int BKGND_GUAGE, FGND_GUAGE;
extern int OUTHANDLE;

/*** COMMENT OUT THE FOLLOWING IF YOU ARE USING SYSTEM INCLUDE FILES ***/

#define NULL              0L

typedef struct
 {
  int            level;
  unsigned       flags;
  char           fd;
  unsigned char  hold;
  int            bsize;
  unsigned char  *buffer;
  unsigned char  *curp;
  unsigned       istemp;
  short          token;
} FILE;

struct WORDREGS {
    unsigned int    ax, bx, cx, dx, si, di, cflag, flags;
};

struct BYTEREGS {
    unsigned char   al, ah, bl, bh, cl, ch, dl, dh;
};

union   REGS    {
    struct  WORDREGS x;
    struct  BYTEREGS h;
};

extern char *sys_errlist[];

/*** END OF AREA TO COMMENT OUT ***/


FILE *xopen();
char *getenv();
char *enter_command();
char *process_menu();
char *_today();
char *get_time();
char *get_today();
long cvt_atol();
char *string_ptr();
char *page_ptr();
char *normalize_ptr();
long _dtol_();
unsigned int julian_date();
unsigned int _dtoi_();
unsigned int len();
unsigned char *Malloc();
unsigned char far *read_token();
unsigned char far *get_token();
unsigned char far *read_token();
unsigned char far *read_image();
unsigned char far *get_image();
unsigned char *keep_form();
unsigned char *new_form();
char *fld_str();
char *make_string();
char *process_menu();

#define DBF_EOF       -20
#define DBF_BOF       -21
#define DBF_DUP       -22
#define DBF_NOKEY     -23
#define DBF_NONEXT    -24

unsigned long  dbf_record_count();
unsigned long  dbf_delete_count();
unsigned int   dbf_record_length();
int            dbf_field_count();

typedef struct
 {
  char           name[11];
  unsigned char  type;
  unsigned int   displacement;
  int            reserved;
  unsigned char  length;
  unsigned char  decpt;
  char           notused[14];
 } dbf_fld;

#define MAX_FILES 12

extern dbf_fld *RPTR[MAX_FILES];
extern char    *RECORD[MAX_FILES];

dbf_fld       *define_dbf_fields();
dbf_fld       *define_record();

typedef struct
 {
           char *name;
  unsigned char type;
           int  line;
           int  column;
           int  size;
  unsigned char bkgnd_color;
  unsigned char fgnd_color;
           int  up;
           int  down;
           int  left;
           int  right;
  struct
   {
    unsigned int must_enter    : 1;
    unsigned int must_fill     : 1;
    unsigned int protect       : 1;
    unsigned int zero_fill     : 1;
    unsigned int floatline     : 1;
    unsigned int pre_edit      : 1;
    unsigned int auto_help     : 1;
    unsigned int ignore        : 1;
    unsigned int flag1         : 1;
    unsigned int flag2         : 1;
    unsigned int flag3         : 1;
    unsigned int flag4         : 1;
    unsigned int flag5         : 1;
    unsigned int flag6         : 1;
    unsigned int flag7         : 1;
    unsigned int flag8         : 1;
   } edit;
  int      (*edit_function)();
  char     *help;
 } form_entry;

form_entry *make_form_table();

extern form_entry *LAST_FIELD_PTR;
extern form_entry *TPTR;
#define FPTR TPTR

form_entry *locate_field();

struct function_event
 {
  int (*function)();
 };

extern unsigned char far *WINDOW_SAVE_PTR[12];
extern struct function_event event_F[13];
form_entry FIELD[]={
