#define data_type    int
#define name_of_list list_of_ints

#include "list.h"
#include <stdio.h>

/***************************************************************************
*  Procedure name : get_node                                               *
*         Purpose : allocate storage for new nodes                         *
*          Inputs : -                                                      *
* Outputs/Returns : pointer to the new node                                *
*       Called by : insert_before_cur, insert_after_cur                    *
*           Calls : malloc, sizeof, printf                                 *
*         Globals :                                                        *
*                                                                          *
***************************************************************************/
struct node *get_node()
{
	char *malloc(); struct node *p;

	p=(struct node *)malloc(sizeof(struct node));   /*allocate space*/
	if (p==NULL) {printf("Not enough memory"); exit(1);}
	return(p);             /*return new node*/
}

/***************************************************************************
*  Procedure name : goto_head                                              *
*         Purpose : move current pointer to head of list                   *
*          Inputs : list to use                                            *
* Outputs/Returns : new current_pos pointer                                *
*       Called by : initialize_list                                        *
*           Calls : -                                                      *
*         Globals :                                                        *
*                                                                          *
***************************************************************************/
void goto_head(name_of_list *a)
{
	a->current_pos=a->head;       /*set current pointer to head */
}

/***************************************************************************
*  Procedure name : goto_tail                                              *
*         Purpose : move current pointer to tail of list                   *
*          Inputs : list to be used                                        *
* Outputs/Returns : new current_pos pointer                                *
*       Called by : -                                                      *
*           Calls : -                                                      *
*         Globals :                                                        *
*                                                                          *
***************************************************************************/
void goto_tail(name_of_list *a)
{
	a->current_pos=a->tail;      /*set current pointer to tail*/
}

/***************************************************************************
*  Procedure name : goto_left                                              *
*         Purpose : move current_position one node to the left             *
*          Inputs : list to be traversed                                   *
* Outputs/Returns : new current_pos pointer                                *
*       Called by : -                                                      *
*           Calls : -                                                      *
*         Globals :                                                        *
*                                                                          *
***************************************************************************/
void goto_left(name_of_list *a)
{
	if (a->current_pos!=NULL)    /*if there is a node move to its left*/
		a->current_pos=a->current_pos->left;
}

/***************************************************************************
*  Procedure name : goto_right                                             *
*         Purpose : move current_position one node to the right            *
*          Inputs : list to be traversed                                   *
* Outputs/Returns : new current_pos pointer                                *
*       Called by : position                                               *
*           Calls : -                                                      *
*         Globals :                                                        *
*                                                                          *
***************************************************************************/
void goto_right(name_of_list *a)
{
	if (a->current_pos!=NULL)   /*if there is a node move to its right*/
		a->current_pos=a->current_pos->right;
}

/***************************************************************************
*  Procedure name : retrieve_current                                       *
*         Purpose : retrieve value held in node pointed to by current_pos  *
*          Inputs : list to retrieve value from                            *
* Outputs/Returns : value held in data of current_pos node                 *
*       Called by : -                                                      *
*           Calls : -                                                      *
*         Globals :                                                        *
*                                                                          *
***************************************************************************/
data_type retrieve_current(name_of_list *a)
{
	if (a->current_pos!=NULL)     /*if there is a node */
		return(a->current_pos->data);      /* return its data*/
}

/***************************************************************************
*  Procedure name : size                                                   *
*         Purpose : count how many nodes are in the list *a                *
*          Inputs : list to be counted                                     *
* Outputs/Returns : size of list in integer                                *
*       Called by : delete_at_current                                      *
*           Calls : -                                                      *
*         Globals :                                                        *
*                                                                          *
***************************************************************************/
int size(name_of_list *a)
{
	struct node *temp=a->head;       /*start counting from the head*/
	int count=1;

	while ((temp!=NULL)&&(temp->right!=a->head))
		{                    /*increment counter until tail is*/
		count++;             /*reached*/
		temp=temp->right;
		}
	if (a->head==NULL) count=0;   /*if list is empty return 0*/

	return(count);
}

/***************************************************************************
*  Procedure name : insert_before_cur                                      *
*         Purpose : insert a new node, with data b, before current_pos     *
*          Inputs : list in which to insert *a, data element b             *
* Outputs/Returns : new list with new node inserted                        *
*       Called by : -                                                      *
*           Calls : get_node                                               *
*         Globals :                                                        *
*                                                                          *
***************************************************************************/
void insert_before_cur(name_of_list *a,data_type b)
{
	struct node *new;

	new=get_node();       /*get new node and place data into it*/
	new->data=b;
	if (a->head==NULL)        /*if list is empty*/
		{
		a->head=a->tail=a->current_pos=new;
		new->right=new;
		new->left=new;         /*make new only node in list*/
		}
	else
		{
		new->left=a->current_pos->left;
		new->right=a->current_pos;   /*insert new node to left of*/
		new->left->right=new;        /*current_pos*/
		new->right->left=new;
		if (a->current_pos==a->head)
			a->head=a->current_pos->left;
		}
}

/***************************************************************************
*  Procedure name : insert_after_cur                                       *
*         Purpose : insert a new node, with data b, after current_pos      *
*          Inputs : list to insert into *a, data element b                 *
* Outputs/Returns : list with new node inserted into it                    *
*       Called by : -                                                      *
*           Calls : get_node                                               *
*         Globals :                                                        *
*                                                                          *
***************************************************************************/
void insert_after_cur(name_of_list *a,data_type b)
{
	struct node *new;

	new=get_node();        /*get new node and place data into it*/
	new->data=b;
	if (a->head==NULL)        /*if list is empty*/
		{
		a->head=a->tail=a->current_pos=new;
		new->right=new;
		new->left=new;       /*make new node only node in list*/
		}
	else
		{
		new->left=a->current_pos;
		new->right=a->current_pos->right;
		new->left->right=new;      /*place new node to right of*/
		new->right->left=new;      /*current_pos*/
		if (a->current_pos==a->tail)
			a->tail=a->current_pos->right;
		}
}

/***************************************************************************
*  Procedure name : position                                               *
*         Purpose : find the next occurence of b, beginning search at      *
*                   current_pos                                            *
*          Inputs : list to search through *a, key element b               *
* Outputs/Returns : offset number of nodes from current that contains key  *
*       Called by : -                                                       *
*           Calls : -                                                       *
*         Globals :                                                        *
*                                                                          *
***************************************************************************/
int position(name_of_list *a,data_type b)
{
	int count=0;
	struct node *temp;

	temp=a->current_pos;     /*start searching at current_pos*/
	while ((temp->data!=b)&&(temp!=a->tail)&&(temp!=NULL))
		{                      /*traverse list until end is reached*/
		temp=temp->right;      /*or key is found*/
		count++;
		}
	if (temp->data!=b)      /*if the key wasn't found*/
		count=-1;             /*set count to unique value*/
	return(count);
}

/***************************************************************************
*  Procedure name : delete_at_current                                      *
*         Purpose : delete and free node pointed to by current_pos         *
*          Inputs : list to delete from                                    *
* Outputs/Returns : new list sans one node                                 *
*       Called by : initialize_list                                        *
*           Calls : printf, free                                           *
*         Globals :                                                        *
*                                                                          *
***************************************************************************/
void delete_at_current(name_of_list *a)
{
	struct node *temp;

	if (size(a)==1)          /*if list contains 1 element*/
		{
		free(a->current_pos);            /*remove the element*/
		a->head=a->tail=a->current_pos=NULL;
		}
	else if (size(a)>1)          /*if list contains more than 1 element*/
		{
		if (a->current_pos==a->head)      /*check if head is to be*/
			{                         /*deleted*/
			a->head=a->head->right;
			a->head->left=a->tail;     /*delete head and update*/
			a->tail->right=a->head;    /*head pointer*/
			free(a->current_pos);
			a->current_pos=a->head;
			}
		else if (a->current_pos==a->tail) /*check if tail is to be*/
			{                         /*deleted*/
			a->tail=a->tail->left;
			a->tail->right=a->head;  /*delete tail and update*/
			a->head->left=a->tail;   /*tail pointer*/
			free(a->current_pos);
			a->current_pos=a->tail;
			}
		else       /*otherwise node to be deleted is in the middle*/
			{
			temp=a->current_pos->right;   /*delete it &*/
			a->current_pos->left->right=a->current_pos->right;
			a->current_pos->right->left=a->current_pos->left;
			free(a->current_pos);         /*update pointers*/
			a->current_pos=temp;
			}
		}
	else
		printf("List has no nodes to delete! No deletion done.");
}                            /*return error message if no nodes exist*/

/***************************************************************************
*  Procedure name : initialize_list                                        *
*         Purpose : prepare list for use                                   *
*          Inputs : list to be prepared                                    *
* Outputs/Returns : empty list with pointers in tact                       *
*       Called by : -                                                      *
*           Calls : goto_head, delete_at_current                           *
*         Globals :                                                        *
*                                                                          *
***************************************************************************/
void initialize_list(name_of_list *a)
{
	if ( ((a->head->left)==(a->tail)) && ((a->tail->right)==(a->head)) )
		{              /*if list pointers are complete then*/
		do{
			goto_head(a);      /*delete all the nodes contained*/
			delete_at_current(a);}
		while(a->head!=NULL);
		}
	else                /*if list pointers aren't complete then*/
		{
		a->head=a->tail=a->current_pos=NULL;
		}                     /* make them all NULL*/
}

